/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.volume;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Volume;
import com.aliyun.odps.VolumeException;
import com.aliyun.odps.VolumeFSFile;
import com.aliyun.odps.Volumes;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.VolumeFSTunnel;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.VolumeOutputStream;
import com.aliyun.odps.volume.VolumeFSJobRunnerProxy;
import com.aliyun.odps.volume.VolumeFSUtil;
import com.aliyun.odps.volume.protocol.VolumeFSErrorMessageGenerator;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;

public class VolumeFSClient {
    private Odps odps;
    private String tunnelEndpoint;
    private Configuration conf;

    public VolumeFSClient(Odps odps, String project, String serviceEndpoint, String tunnelEndpoint, Configuration conf) {
        this.odps = odps;
        this.odps.setDefaultProject(project);
        this.odps.setEndpoint(serviceEndpoint);
        this.tunnelEndpoint = tunnelEndpoint;
        this.conf = conf;
    }

    public VolumeFSFile getFileInfo(String path) throws VolumeException {
        return (VolumeFSFile)new VolumeFSJobRunnerProxy<VolumeFSFile>(){

            @Override
            public VolumeFSFile doJob(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path)).getVolumeFSFile(path);
                try {
                    file.reload();
                }
                catch (OdpsException e) {
                    throw new VolumeException((Throwable)e);
                }
                return file;
            }

            @Override
            public VolumeFSFile onVolumeMissing(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSFile.getRoot((String)VolumeFSClient.this.odps.getDefaultProject(), (Odps)VolumeFSClient.this.odps);
                return file;
            }

            @Override
            public VolumeFSFile onNoSuchVolume(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
            }

            @Override
            public VolumeFSFile onInvalidPath(String path, Map<String, Object> params) throws VolumeException {
                if (VolumeFSUtil.checkPathIsJustVolume(path)) {
                    try {
                        if (!VolumeFSClient.this.odps.volumes().exists(VolumeFSUtil.getVolumeFromPath(path))) {
                            throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
                        }
                    }
                    catch (OdpsException e) {
                        throw new VolumeException((Throwable)e);
                    }
                    Volume v = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path));
                    if (VolumeFSClient.this.isNewVolume(v)) {
                        return VolumeFSFile.transferVolumeToVolumeFSFile((String)VolumeFSClient.this.odps.getDefaultProject(), (Volume)v, (RestClient)VolumeFSClient.this.odps.getRestClient());
                    }
                    throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.oldVolumeAlert(VolumeFSUtil.getVolumeFromPath(path)));
                }
                throw (VolumeException)((Object)params.get("volume_job_cur_exception"));
            }
        }.run(path, null);
    }

    public boolean mkdirs(String path) throws VolumeException {
        return (Boolean)new VolumeFSJobRunnerProxy<Boolean>(){

            @Override
            public Boolean doJob(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile.create((String)VolumeFSClient.this.odps.getDefaultProject(), (String)path, (boolean)true, (RestClient)VolumeFSClient.this.odps.getRestClient());
                return true;
            }

            @Override
            public Boolean onVolumeMissing(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("PathAlreadyExists", VolumeFSErrorMessageGenerator.fileExists(path));
            }

            @Override
            public Boolean onNoSuchVolume(String path, Map<String, Object> params) throws VolumeException {
                try {
                    VolumeFSClient.this.odps.volumes().create(VolumeFSUtil.getVolumeFromPath(path), "This volume created by VolumeClient automatically", Volume.Type.NEW);
                }
                catch (Exception e) {
                    throw new VolumeException((Throwable)e);
                }
                if (VolumeFSUtil.checkPathIsJustVolume(path)) {
                    return true;
                }
                return this.doJob(path, (Map)params);
            }

            @Override
            public Boolean onInvalidPath(String path, Map<String, Object> params) throws VolumeException {
                if (VolumeFSUtil.checkPathIsJustVolume(path)) {
                    try {
                        if (!VolumeFSClient.this.odps.volumes().exists(VolumeFSUtil.getVolumeFromPath(path))) {
                            VolumeFSClient.this.odps.volumes().create(VolumeFSUtil.getVolumeFromPath(path), "This volume created by VolumeClient automatically", Volume.Type.NEW);
                        }
                    }
                    catch (OdpsException e) {
                        throw new VolumeException((Throwable)e);
                    }
                    return true;
                }
                throw (VolumeException)((Object)params.get("volume_job_cur_exception"));
            }

            @Override
            public Boolean onPathAlreadyExists(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path)).getVolumeFSFile(path);
                try {
                    file.reload();
                }
                catch (OdpsException oe) {
                    throw new VolumeException((Throwable)oe);
                }
                if (Boolean.TRUE.equals(file.getIsdir())) {
                    return Boolean.TRUE;
                }
                throw (VolumeException)((Object)params.get("volume_job_cur_exception"));
            }
        }.run(path, null);
    }

    public boolean setReplication(String path, short replication) throws VolumeException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> innerParams = new HashMap<String, String>();
        innerParams.put(VolumeFSFile.ParamKey.REPLICATION.name().toLowerCase(), String.valueOf(replication));
        params.put("params", innerParams);
        return (Boolean)new VolumeFSJobRunnerProxy<Boolean>(){

            @Override
            public Boolean doJob(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path)).getVolumeFSFile(path);
                file.update((Map)params.get("params"));
                return true;
            }

            @Override
            public Boolean onVolumeMissing(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("NotAcceptableOperation", VolumeFSErrorMessageGenerator.isADirectory(path));
            }

            @Override
            public Boolean onNoSuchVolume(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
            }
        }.run(path, params);
    }

    public VolumeFSFile[] getFileInfosByPath(String path) throws VolumeException {
        return (VolumeFSFile[])new VolumeFSJobRunnerProxy<VolumeFSFile[]>(){

            @Override
            public VolumeFSFile[] doJob(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path)).getVolumeFSFile(path);
                Iterator iterator = file.iterator();
                ArrayList files = new ArrayList();
                try {
                    while (iterator.hasNext()) {
                        files.add(iterator.next());
                    }
                }
                catch (RuntimeException e) {
                    if (e.getCause() instanceof VolumeException) {
                        throw (VolumeException)e.getCause();
                    }
                    throw new VolumeException((Throwable)e);
                }
                return files.toArray(new VolumeFSFile[0]);
            }

            @Override
            public VolumeFSFile[] onVolumeMissing(String path, Map<String, Object> params) throws VolumeException {
                ArrayList<VolumeFSFile> files = new ArrayList<VolumeFSFile>();
                Volumes volumes = VolumeFSClient.this.odps.volumes();
                for (Volume v : volumes) {
                    if (!VolumeFSClient.this.isNewVolume(v)) continue;
                    files.add(VolumeFSFile.transferVolumeToVolumeFSFile((String)VolumeFSClient.this.odps.getDefaultProject(), (Volume)v, (RestClient)VolumeFSClient.this.odps.getRestClient()));
                }
                return files.toArray(new VolumeFSFile[0]);
            }

            @Override
            public VolumeFSFile[] onNoSuchVolume(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
            }

            @Override
            public VolumeFSFile[] onInvalidPath(String path, Map<String, Object> params) throws VolumeException {
                if (VolumeFSUtil.checkPathIsJustVolume(path)) {
                    return this.doJob(path, params);
                }
                throw (VolumeException)((Object)params.get("volume_job_cur_exception"));
            }
        }.run(path, null);
    }

    public boolean rename(String src, String dst) throws VolumeException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, String> innerParams = new HashMap<String, String>();
        innerParams.put(VolumeFSFile.ParamKey.PATH.name().toLowerCase(), dst);
        params.put("params", innerParams);
        return (Boolean)new VolumeFSJobRunnerProxy<Boolean>(){

            @Override
            public Boolean doJob(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path)).getVolumeFSFile(path);
                file.update((Map)params.get("params"));
                return true;
            }

            @Override
            public Boolean onVolumeMissing(String path, Map<String, Object> params) throws VolumeException {
                return false;
            }

            @Override
            public Boolean onNoSuchVolume(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
            }

            @Override
            public Boolean onInvalidPath(String path, Map<String, Object> params) throws VolumeException {
                if (VolumeFSUtil.checkPathIsJustVolume(path)) {
                    throw new VolumeException("NotAcceptableOperation", VolumeFSErrorMessageGenerator.theOpreationIsNotAllowed("mv volume (The first level directory)"));
                }
                throw (VolumeException)((Object)params.get("volume_job_cur_exception"));
            }
        }.run(src, params);
    }

    public boolean delete(String path, boolean recursive) throws VolumeException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(VolumeFSFile.ParamKey.RECURSIVE.name().toLowerCase(), recursive);
        return (Boolean)new VolumeFSJobRunnerProxy<Boolean>(){

            @Override
            public Boolean doJob(String path, Map<String, Object> params) throws VolumeException {
                VolumeFSFile file = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path)).getVolumeFSFile(path);
                file.delete(((Boolean)params.get(VolumeFSFile.ParamKey.RECURSIVE.name().toLowerCase())).booleanValue());
                return true;
            }

            @Override
            public Boolean onVolumeMissing(String path, Map<String, Object> params) throws VolumeException {
                return false;
            }

            @Override
            public Boolean onNoSuchVolume(String path, Map<String, Object> params) throws VolumeException {
                throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.noSuchFileOrDirectory(path));
            }

            @Override
            public Boolean onInvalidPath(String path, Map<String, Object> params) throws VolumeException {
                if (VolumeFSUtil.checkPathIsJustVolume(path)) {
                    try {
                        Volume v = VolumeFSClient.this.odps.volumes().get(VolumeFSUtil.getVolumeFromPath(path));
                        if (VolumeFSClient.this.isNewVolume(v)) {
                            VolumeFSClient.this.odps.volumes().delete(VolumeFSUtil.getVolumeFromPath(path));
                            return true;
                        }
                        throw new VolumeException("NoSuchPath", VolumeFSErrorMessageGenerator.oldVolumeAlert(VolumeFSUtil.getVolumeFromPath(path)));
                    }
                    catch (OdpsException e) {
                        throw new VolumeException((Throwable)e);
                    }
                }
                throw (VolumeException)((Object)params.get("volume_job_cur_exception"));
            }
        }.run(path, params);
    }

    public void downloadFile(String path, Long start, Long end, File targetFile, boolean append) throws VolumeException {
        VolumeFSUtil.checkPath(path);
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(targetFile, append);
        }
        catch (FileNotFoundException e) {
            throw new VolumeException((Throwable)e);
        }
        InputStream inputStream = null;
        try {
            inputStream = this.openInputStream(path, start, end);
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new VolumeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public InputStream openInputStream(String path, Long start, Long end) throws VolumeException {
        VolumeFSUtil.checkPath(path);
        boolean compress = this.conf.getBoolean("odps.volume.transfer.compress.enabled", false);
        CompressOption compressOption = null;
        if (compress) {
            CompressOption.CompressAlgorithm a = CompressOption.CompressAlgorithm.valueOf((String)this.conf.get("odps.volume.transfer.compress.algorithm", "ODPS_ZLIB"));
            compressOption = new CompressOption(a, 1, 0);
        }
        InputStream in = null;
        try {
            in = this.getVolumeTunnel().openInputStream(this.odps.getDefaultProject(), path, start, end, compressOption);
        }
        catch (TunnelException e) {
            throw new VolumeException((Throwable)e);
        }
        return in;
    }

    public OutputStream openOutputStream(String path, boolean overwrite, short replication) throws VolumeException {
        VolumeFSFile file;
        block12: {
            VolumeFSUtil.checkPath(path);
            file = null;
            try {
                if (!this.odps.volumes().exists(VolumeFSUtil.getVolumeFromPath(path))) {
                    this.odps.volumes().create(VolumeFSUtil.getVolumeFromPath(path), "This volume created by VolumeClient automatically", Volume.Type.NEW);
                }
            }
            catch (OdpsException oe) {
                throw new VolumeException((Throwable)oe);
            }
            try {
                file = this.getFileInfo(path);
            }
            catch (VolumeException e) {
                if ("NoSuchPath".equalsIgnoreCase(e.getErrCode())) break block12;
                throw e;
            }
        }
        if (file != null) {
            if (overwrite) {
                if (file.getIsdir().booleanValue()) {
                    throw new VolumeException("PathAlreadyExists", VolumeFSErrorMessageGenerator.fileExists(path));
                }
                this.delete(path, true);
            } else {
                throw new VolumeException("PathAlreadyExists", VolumeFSErrorMessageGenerator.fileExists(path));
            }
        }
        VolumeFSTunnel tunnel = this.getVolumeTunnel();
        this.createZeroByteFile(path, replication, tunnel);
        boolean compress = this.conf.getBoolean("odps.volume.transfer.compress.enabled", false);
        CompressOption compressOption = null;
        if (compress) {
            CompressOption.CompressAlgorithm a = CompressOption.CompressAlgorithm.valueOf((String)this.conf.get("odps.volume.transfer.compress.algorithm", "ODPS_ZLIB"));
            compressOption = new CompressOption(a, 1, 0);
        }
        OutputStream out = null;
        try {
            out = tunnel.openOutputStream(this.odps.getDefaultProject(), path, new Integer(replication), compressOption);
        }
        catch (TunnelException e) {
            throw new VolumeException((Throwable)e);
        }
        return out;
    }

    public void createZeroByteFile(String path, short replication, VolumeFSTunnel tunnel) throws VolumeException {
        VolumeFSUtil.checkPath(path);
        OutputStream o = null;
        try {
            o = tunnel.openOutputStream(this.odps.getDefaultProject(), path, new Integer(replication), new CompressOption());
            String sessionId = VolumeFSTunnel.getUploadSessionId((VolumeOutputStream)((VolumeOutputStream)o));
            tunnel.commit(this.odps.getDefaultProject(), path, sessionId);
        }
        catch (TunnelException e) {
            throw new VolumeException((Throwable)e);
        }
    }

    public void commitUploadSession(String path, VolumeOutputStream out, boolean overwrite) throws VolumeException {
        VolumeFSUtil.checkPath(path);
        try {
            out.close();
            String sessionId = VolumeFSTunnel.getUploadSessionId((VolumeOutputStream)out);
            VolumeFSFile file = null;
            try {
                file = this.getFileInfo(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (file != null) {
                if (overwrite) {
                    if (file.getIsdir().booleanValue()) {
                        throw new VolumeException("PathAlreadyExists", VolumeFSErrorMessageGenerator.fileExists(path));
                    }
                    file.delete(true);
                } else if (file.getLength() == 0L) {
                    file.delete(true);
                } else {
                    throw new VolumeException("PathAlreadyExists", VolumeFSErrorMessageGenerator.fileExists(path));
                }
            }
            this.getVolumeTunnel().commit(this.odps.getDefaultProject(), path, sessionId);
        }
        catch (Exception e) {
            throw new VolumeException((Throwable)e);
        }
    }

    private VolumeFSTunnel getVolumeTunnel() {
        VolumeFSTunnel tunnelFS = new VolumeFSTunnel(this.odps.clone());
        if (this.tunnelEndpoint != null) {
            tunnelFS.setEndpoint(this.tunnelEndpoint);
        }
        return tunnelFS;
    }

    private boolean isNewVolume(Volume v) {
        return Volume.Type.NEW.equals((Object)v.getType());
    }
}

