/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.Pipeline;
import org.apache.spark.ml.PipelineModel;
import org.apache.spark.ml.PipelineStage;
import org.apache.spark.ml.evaluation.RegressionEvaluator;
import org.apache.spark.ml.feature.MinMaxScaler;
import org.apache.spark.ml.feature.MinMaxScalerModel;
import org.apache.spark.ml.regression.FMRegressionModel;
import org.apache.spark.ml.regression.FMRegressor;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.SeqLike;

public final class FMRegressorExample$ {
    public static FMRegressorExample$ MODULE$;

    static {
        new FMRegressorExample$();
    }

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("FMRegressorExample").getOrCreate();
        Dataset data = spark.read().format("libsvm").load("data/mllib/sample_libsvm_data.txt");
        MinMaxScalerModel featureScaler = new MinMaxScaler().setInputCol("features").setOutputCol("scaledFeatures").fit(data);
        Dataset[] datasetArray = data.randomSplit(new double[]{0.7, 0.3});
        Option option = Array$.MODULE$.unapplySeq((Object)datasetArray);
        if (option.isEmpty() || option.get() == null || ((SeqLike)option.get()).lengthCompare(2) != 0) {
            throw new MatchError((Object)datasetArray);
        }
        Dataset trainingData = (Dataset)((SeqLike)option.get()).apply(0);
        Dataset testData = (Dataset)((SeqLike)option.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)trainingData, (Object)testData);
        Tuple2 tuple22 = tuple2;
        Dataset trainingData2 = (Dataset)tuple22._1();
        Dataset testData2 = (Dataset)tuple22._2();
        FMRegressor fm = ((FMRegressor)new FMRegressor().setLabelCol("label").setFeaturesCol("scaledFeatures")).setStepSize(0.001);
        Pipeline pipeline = new Pipeline().setStages((PipelineStage[])((Object[])new PipelineStage[]{featureScaler, fm}));
        PipelineModel model = pipeline.fit(trainingData2);
        Dataset predictions = model.transform(testData2);
        predictions.select("prediction", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"label", "features"})).show(5);
        RegressionEvaluator evaluator = new RegressionEvaluator().setLabelCol("label").setPredictionCol("prediction").setMetricName("rmse");
        double rmse = evaluator.evaluate(predictions);
        Predef$.MODULE$.println((Object)new StringBuilder(46).append("Root Mean Squared Error (RMSE) on test data = ").append(rmse).toString());
        FMRegressionModel fmModel = (FMRegressionModel)model.stages()[1];
        Predef$.MODULE$.println((Object)new StringBuilder(30).append("Factors: ").append(fmModel.factors()).append(" Linear: ").append(fmModel.linear()).append(" ").append("Intercept: ").append(fmModel.intercept()).toString());
        spark.stop();
    }

    private FMRegressorExample$() {
        MODULE$ = this;
    }
}

