/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.volume.abstractfsimpl;

import com.aliyun.odps.fs.VolumeFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.ParentNotDirectoryException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.UnresolvedLinkException;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.aliyun.volume.CommonVolumeFileSystem;
import org.apache.hadoop.fs.aliyun.volume.InternalVolumeFileSystem;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.util.Progressable;

public class OdpsVolumeFs
extends AbstractFileSystem {
    private static final String SCHEME = "odps";
    private FileSystem fs;

    public OdpsVolumeFs(URI uri, String supportedScheme, boolean authorityNeeded, int defaultPort) throws URISyntaxException {
        super(uri, supportedScheme, authorityNeeded, defaultPort);
    }

    public OdpsVolumeFs(URI theUri, Configuration conf) throws URISyntaxException, IOException {
        super(new URI("odps:///"), SCHEME, false, -1);
        if (!theUri.getScheme().equalsIgnoreCase(SCHEME)) {
            throw new IllegalArgumentException("Passed URI's scheme is not for odps");
        }
        boolean isInternal = conf.getBoolean("volume.internal", false);
        boolean isCommonFileSystem = conf.getBoolean("odps.volume.common.filesystem", false);
        this.fs = isInternal ? (isCommonFileSystem ? new CommonVolumeFileSystem() : new InternalVolumeFileSystem()) : new VolumeFileSystem();
        this.fs.initialize(theUri, conf);
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public int getUriDefaultPort() {
        return -1;
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fs.getServerDefaults();
    }

    public FSDataOutputStream createInternal(Path f, EnumSet<CreateFlag> flag, FsPermission absolutePermission, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnsupportedFileSystemException, UnresolvedLinkException, IOException {
        return this.fs.create(f, null, flag.contains(CreateFlag.OVERWRITE), bufferSize, replication, blockSize, progress);
    }

    public void mkdir(Path dir, FsPermission permission, boolean createParent) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, UnresolvedLinkException, IOException {
        this.fs.mkdirs(dir, permission);
    }

    public boolean delete(Path f, boolean recursive) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.fs.delete(f, recursive);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.fs.open(f, bufferSize);
    }

    public boolean setReplication(Path f, short replication) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.fs.setReplication(f, replication);
    }

    public void renameInternal(Path src, Path dst) throws AccessControlException, FileAlreadyExistsException, FileNotFoundException, ParentNotDirectoryException, UnresolvedLinkException, IOException {
        this.fs.rename(src, dst);
    }

    public void setPermission(Path f, FsPermission permission) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
    }

    public void setOwner(Path f, String username, String groupname) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
    }

    public void setTimes(Path f, long mtime, long atime) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
    }

    public FileChecksum getFileChecksum(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return null;
    }

    public FileStatus getFileStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.fs.getFileStatus(f);
    }

    public BlockLocation[] getFileBlockLocations(Path f, long start, long len) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return new BlockLocation[0];
    }

    public FsStatus getFsStatus() throws AccessControlException, FileNotFoundException, IOException {
        return null;
    }

    public FileStatus[] listStatus(Path f) throws AccessControlException, FileNotFoundException, UnresolvedLinkException, IOException {
        return this.fs.listStatus(f);
    }

    public void setVerifyChecksum(boolean verifyChecksum) throws AccessControlException, IOException {
    }
}

