/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.volume;

import com.aliyun.odps.fs.VolumeFileSystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.NoSuchElementException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.aliyun.volume.CommonVolumeFileSystem;
import org.apache.hadoop.fs.aliyun.volume.InternalVolumeFileSystem;

public class OdpsVolumeFileSystem
extends FilterFileSystem {
    private static final Log LOG = LogFactory.getLog(OdpsVolumeFileSystem.class);

    public void initialize(URI uri, Configuration conf) throws IOException {
        conf.addResource("odpsfs-site.xml");
        boolean isInternal = conf.getBoolean("volume.internal", false);
        boolean isCommonFileSystem = conf.getBoolean("odps.volume.common.filesystem", false);
        LOG.info((Object)("OdpsVolumeFileSystem initializing, volume.internal=" + isInternal + ", volume.common.filesystem=" + isCommonFileSystem));
        this.fs = isInternal ? (isCommonFileSystem ? new CommonVolumeFileSystem() : new InternalVolumeFileSystem()) : new VolumeFileSystem();
        this.fs.initialize(uri, conf);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        try {
            return this.fs.setReplication(src, replication);
        }
        catch (FileNotFoundException fnfe) {
            return false;
        }
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        FileStatus fileStatus = this.fs.getFileStatus(f);
        if (fileStatus == null) {
            return null;
        }
        return new FileStatus(fileStatus.getLen(), fileStatus.isDirectory(), (int)fileStatus.getReplication(), fileStatus.getBlockSize(), fileStatus.getModificationTime(), fileStatus.getAccessTime(), fileStatus.getPermission(), "Odps", fileStatus.getGroup(), fileStatus.isSymlink() ? fileStatus.getSymlink() : null, fileStatus.getPath());
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(final Path f) throws FileNotFoundException, IOException {
        return new RemoteIterator<LocatedFileStatus>(){
            private final FileStatus[] stats;
            private int i;
            {
                this.stats = OdpsVolumeFileSystem.this.listStatus(f);
                this.i = 0;
            }

            public boolean hasNext() {
                return this.i < this.stats.length;
            }

            public LocatedFileStatus next() throws IOException {
                FileStatus result;
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more entry in " + f);
                }
                BlockLocation[] locs = (result = this.stats[this.i++]).isFile() ? OdpsVolumeFileSystem.this.getFileBlockLocations(result, 0L, result.getLen()) : null;
                return new LocatedFileStatus(result, locs);
            }
        };
    }
}

