/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.volume;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.aliyun.volume.contract.DefaultGeneratorImpl;
import org.apache.hadoop.fs.aliyun.volume.contract.VolumePanguPathGenerator;
import org.apache.hadoop.fs.aliyun.volume.utils.VolumeFSUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class InternalVolumeFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(InternalVolumeFileSystem.class);
    private static final String HADOOP_PANGU_IMPL = "org.apache.hadoop.fs.aliyun.pangu.HadoopPanguFileSystem";
    private static final String DEFAULT_VOLUME_PANTU_MAP_FILE = "volume_pangu_map.conf";
    private static final String MAP_SEPERATOR = "\t";
    private Map<String, String> volumePathMap;
    private String project;
    private String homeVolume;
    private URI uri;
    private Path workingDir;
    private short defaultReplication;
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return "odps";
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        conf.set("fs.pangu.impl", HADOOP_PANGU_IMPL);
        this.volumePathMap = this.initialPathMap(conf.get("volume.pangu.map.file", DEFAULT_VOLUME_PANTU_MAP_FILE));
        this.homeVolume = conf.get("odps.home.volume", "user");
        this.workingDir = this.getHomeDirectory();
        this.project = name.getAuthority();
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/" + this.homeVolume, System.getProperty("user.name")));
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path new_dir) {
        Path dir = this.fixRelativePart(new_dir);
        String result = dir.toUri().getPath();
        if (!VolumeFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid Volume directory name " + result);
        }
        this.workingDir = dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map initialPathMap(String pathMapFileName) throws IOException {
        LOG.info((Object)("Initializing volume to pangu map, using file: " + pathMapFileName));
        HashMap<String, String> map = new HashMap<String, String>();
        try (BufferedReader br = null;){
            String lineStr;
            br = new BufferedReader(new FileReader(pathMapFileName));
            while ((lineStr = br.readLine()) != null) {
                String[] mapStr = lineStr.split(MAP_SEPERATOR);
                if (mapStr.length != 2) continue;
                map.put(mapStr[0], mapStr[1]);
            }
        }
        return map;
    }

    public Path volumeToPanguPath(Path volumePath) throws IOException {
        return this.volumeToPanguPath(volumePath, this.volumePathMap);
    }

    private Path volumeToPanguPath(Path volumePath, Map<String, String> map) throws IOException {
        String volumePathStr = this.makeQualified(new Path(volumePath.toUri().getPath())).toString();
        String volumePrefix = this.getFsPrefix(volumePathStr);
        String panguPrefix = map.get(volumePrefix);
        if (panguPrefix == null) {
            Class volumePathGenClass = this.getConf().getClass("volume.pangu.path.generator.class", DefaultGeneratorImpl.class, VolumePanguPathGenerator.class);
            try {
                VolumePanguPathGenerator volumePanguPathGenerator = (VolumePanguPathGenerator)volumePathGenClass.newInstance();
                panguPrefix = volumePanguPathGenerator.getPanguPath(volumePrefix, this.getConf());
                if (panguPrefix == null || !panguPrefix.startsWith("pangu://")) {
                    throw new IOException("Not a valid pangu prefix: " + panguPrefix);
                }
            }
            catch (Exception e) {
                throw new IOException("Volume not exist. Input Path: " + volumePath + ". Resolved path: " + volumePathStr, e);
            }
        }
        panguPrefix = panguPrefix.replaceAll("/+$", "");
        map.put(volumePrefix, panguPrefix);
        return new Path(panguPrefix + volumePathStr.substring(volumePrefix.length()));
    }

    private String getPathName(Path file) {
        this.checkPath(file);
        String result = file.toUri().getPath();
        if (!VolumeFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Pathname " + result + " from " + file + " is not a valid VolumeFS filename.");
        }
        return result;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return fs.open(panguPath, bufferSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return new FSDataOutputStream((OutputStream)fs.append(panguPath, bufferSize, progress), this.statistics);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return new FSDataOutputStream((OutputStream)fs.create(panguPath, permission, overwrite, bufferSize, replication, blockSize, progress), this.statistics);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path panguPath = this.volumeToPanguPath(src, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return fs.setReplication(panguPath, replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path srcPanguPath = this.volumeToPanguPath(src, this.volumePathMap);
        Path dstPanguPath = this.volumeToPanguPath(dst, this.volumePathMap);
        FileSystem fs_src = srcPanguPath.getFileSystem(this.getConf());
        FileSystem fs_dst = dstPanguPath.getFileSystem(this.getConf());
        if (!fs_src.getUri().equals(fs_dst.getUri())) {
            throw new IOException("Cannot rename file between different cluster.");
        }
        return fs_src.rename(srcPanguPath, dstPanguPath);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return fs.delete(panguPath, recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        FileStatus[] statuses = fs.listStatus(panguPath);
        if (statuses == null) {
            return null;
        }
        String volumePathstr = this.makeQualified(f).toString();
        String volumePrefix = this.getFsPrefix(volumePathstr);
        String panguPrefix = this.volumePathMap.get(volumePrefix);
        for (FileStatus status : statuses) {
            String panguPathStr = status.getPath().toString();
            status.setPath(new Path(volumePrefix + panguPathStr.substring(panguPrefix.length())));
        }
        return statuses;
    }

    private String getFsPrefix(String pathStr) {
        int prefixEndIdx = InternalVolumeFileSystem.getCharIdx(pathStr, '/', 4);
        if (prefixEndIdx == -1) {
            prefixEndIdx = pathStr.length();
        }
        return pathStr.substring(0, prefixEndIdx);
    }

    private static int getCharIdx(String s, char c, int n) {
        if (n <= 0) {
            return -1;
        }
        int count = 0;
        char[] chars = s.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != c || ++count != n) continue;
            return i;
        }
        return -1;
    }

    public FsStatus getStatus(Path p) throws IOException {
        Path panguPath = this.volumeToPanguPath(p, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return fs.getStatus(panguPath);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        return fs.mkdirs(panguPath, permission);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        Path panguPath = this.volumeToPanguPath(f, this.volumePathMap);
        FileSystem fs = panguPath.getFileSystem(this.getConf());
        FileStatus status = fs.getFileStatus(panguPath);
        if (status != null) {
            String volumePathstr = this.makeQualified(f).toString();
            String volumePrefix = this.getFsPrefix(volumePathstr);
            String panguPrefix = this.volumePathMap.get(volumePrefix);
            String panguPathStr = status.getPath().toString();
            status.setPath(new Path(volumePrefix + panguPathStr.substring(panguPrefix.length())));
        }
        return status;
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, DEFAULT_FILTER);
    }
}

