/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.volume;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.HadoopInputStream;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.OdpsConfiguration;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.OdpsPath;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.OdpsProgress;
import org.apache.hadoop.fs.aliyun.volume.utils.VolumeFSUtil;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class CommonVolumeFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(CommonVolumeFileSystem.class);
    private String homeVolume;
    private URI uri;
    private Path workingDir;
    private short defaultReplication;
    private com.aliyun.odps.fs.FileSystem proxyFileSystem;
    public static final String PROXY_WRAPPER_DEFAULT_IMPL = "com.aliyun.odps.fs.proxyclient.ProxyClientFileSystem";
    private static final PathFilter DEFAULT_FILTER = new PathFilter(){

        public boolean accept(Path file) {
            return true;
        }
    };

    public URI getUri() {
        return this.uri;
    }

    public String getScheme() {
        return "odps";
    }

    public void initialize(URI name, org.apache.hadoop.conf.Configuration conf) throws IOException {
        super.initialize(name, conf);
        this.setConf(conf);
        OdpsConfiguration odpsConf = new OdpsConfiguration(conf);
        if (System.getenv("META_LOOKUP_NAME") == null) {
            return;
        }
        String volumeImpl = odpsConf.get("volume.wrapper.impl", PROXY_WRAPPER_DEFAULT_IMPL);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(volumeImpl);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Volume impl class " + volumeImpl + " not found."), (Throwable)e);
            throw new RuntimeException("No FileSystem for volume wrapper", e);
        }
        this.uri = URI.create(name.getScheme() + "://" + name.getAuthority());
        this.proxyFileSystem = (com.aliyun.odps.fs.FileSystem)ReflectionUtils.newInstance(clazz, (Configuration)odpsConf);
        this.proxyFileSystem.initialize(this.uri, (Configuration)odpsConf);
        this.homeVolume = conf.get("odps.home.volume", "user");
        this.workingDir = this.getHomeDirectory();
        this.defaultReplication = (short)conf.getInt("dfs.replication", 3);
    }

    public Path getHomeDirectory() {
        return this.makeQualified(new Path("/" + this.homeVolume, System.getProperty("user.name")));
    }

    public short getDefaultReplication() {
        return this.defaultReplication;
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public void setWorkingDirectory(Path new_dir) {
        Path dir = this.fixRelativePart(new_dir);
        String result = dir.toUri().getPath();
        if (!VolumeFSUtil.isValidName(result)) {
            throw new IllegalArgumentException("Invalid Volume directory name " + result);
        }
        this.workingDir = dir;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)((Object)new HadoopInputStream((InputStream)this.proxyFileSystem.open((com.aliyun.odps.fs.Path)new OdpsPath(f), bufferSize))));
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return new FSDataOutputStream((OutputStream)this.proxyFileSystem.append((com.aliyun.odps.fs.Path)new OdpsPath(f), bufferSize, (com.aliyun.odps.util.Progressable)new OdpsProgress(progress)), this.statistics);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream((OutputStream)this.proxyFileSystem.create((com.aliyun.odps.fs.Path)new OdpsPath(f), overwrite, bufferSize, replication, blockSize, (com.aliyun.odps.util.Progressable)new OdpsProgress(progress)), this.statistics);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.proxyFileSystem.setReplication((com.aliyun.odps.fs.Path)new OdpsPath(src), replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.proxyFileSystem.rename((com.aliyun.odps.fs.Path)new OdpsPath(src), (com.aliyun.odps.fs.Path)new OdpsPath(dst));
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.proxyFileSystem.delete((com.aliyun.odps.fs.Path)new OdpsPath(f), recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        com.aliyun.odps.fs.FileStatus[] odpsFileStatuses = this.proxyFileSystem.listStatus((com.aliyun.odps.fs.Path)new OdpsPath(f));
        if (odpsFileStatuses == null) {
            return null;
        }
        FileStatus[] fileStatus = new FileStatus[odpsFileStatuses.length];
        for (int i = 0; i < odpsFileStatuses.length; ++i) {
            fileStatus[i] = this.getHadoopFileStatus(odpsFileStatuses[i]);
        }
        return fileStatus;
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        this.statistics.incrementWriteOps(1);
        return this.proxyFileSystem.mkdirs((com.aliyun.odps.fs.Path)new OdpsPath(f));
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        this.statistics.incrementReadOps(1);
        return this.getHadoopFileStatus(this.proxyFileSystem.getFileStatus((com.aliyun.odps.fs.Path)new OdpsPath(f)));
    }

    private FileStatus getHadoopFileStatus(com.aliyun.odps.fs.FileStatus odpsFileStatus) {
        return new FileStatus(odpsFileStatus.getLen(), odpsFileStatus.isDir(), (int)odpsFileStatus.getReplication(), odpsFileStatus.getBlockSize(), odpsFileStatus.getModificationTime(), odpsFileStatus.getAccessTime(), null, "admin", odpsFileStatus.getGroup(), null, new Path(odpsFileStatus.getPath().toString()));
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws FileNotFoundException, IOException {
        return this.listLocatedStatus(f, DEFAULT_FILTER);
    }
}

