/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.tempresource;

import com.aliyun.odps.FileResource;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.Resources;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.fs.TempResourceMapper;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.aliyun.tempresource.CallbackByteArrayOutputStream;
import org.apache.hadoop.fs.aliyun.tempresource.EmptyOutputStream;
import org.apache.hadoop.fs.aliyun.tempresource.OnCloseCallback;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class HadoopTempResourceFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(HadoopTempResourceFileSystem.class);
    public static final String TRFS_SCHEME = "trfs";
    private static HashSet<String> dirCache = new HashSet();
    private URI uri;
    private CupidConf cupidConf = new CupidConf();
    private Path workingDir;
    private CupidSession cupidSession;

    public void initialize(URI uri, Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        TempResourceMapper.load();
        try {
            this.uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        LOG.info((Object)("Begin initializing trfs fs. Input URI: " + uri.toString()));
        for (Map.Entry confItem : conf) {
            this.cupidConf.set((String)confItem.getKey(), (String)confItem.getValue());
        }
        this.cupidSession = new CupidSession(this.cupidConf);
        this.workingDir = new Path(this.getScheme() + ":///");
    }

    public URI getUri() {
        return this.uri;
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        throw new NotImplementedException();
    }

    public String getScheme() {
        return TRFS_SCHEME;
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        String flinkVersion;
        String publicTargetLibs;
        String sparkVersion;
        String scheme = f.toUri().getScheme();
        if (!scheme.equals(TRFS_SCHEME)) {
            throw new IOException("Scheme not supported! scheme: " + scheme);
        }
        final String originPath = f.toString();
        final String encryptedFileName = TempResourceMapper.get((String)originPath);
        LOG.info((Object)("originPath: " + originPath + ", encryptedFileName: " + encryptedFileName));
        if (originPath.contains("__spark_libs__") && this.cupidSession.conf.getBoolean("odps.spark.libs.public.enable", false) && (sparkVersion = this.cupidSession.conf.get("odps.spark.version", "spark-3.1.1-odps0.34.0")).startsWith("spark-")) {
            sparkVersion = sparkVersion.substring(6);
            publicTargetLibs = "__spark_libs__" + sparkVersion + ".zip";
            LOG.info((Object)("find public target lib: " + publicTargetLibs));
            if (this.findPublicLibs(originPath, publicTargetLibs)) {
                return new FSDataOutputStream((OutputStream)new EmptyOutputStream());
            }
        }
        if (originPath.contains("pyspark.zip") && this.cupidSession.conf.getBoolean("odps.spark.libs.public.enable", false) && (sparkVersion = this.cupidSession.conf.get("odps.spark.version", "spark-3.1.1-odps0.34.0")).startsWith("spark-")) {
            sparkVersion = sparkVersion.substring(6, 11);
            publicTargetLibs = "pyspark-" + sparkVersion + ".zip";
            LOG.info((Object)("find public target pyspark: " + publicTargetLibs));
            if (this.findPublicLibs(originPath, publicTargetLibs)) {
                return new FSDataOutputStream((OutputStream)new EmptyOutputStream());
            }
        }
        if (originPath.contains("py4j-") && this.cupidSession.conf.getBoolean("odps.spark.libs.public.enable", false) && (sparkVersion = this.cupidSession.conf.get("odps.spark.version", "spark-3.1.1-odps0.34.0")).startsWith("spark-")) {
            sparkVersion = sparkVersion.substring(6, 11);
            publicTargetLibs = "py4j-" + sparkVersion + ".zip";
            LOG.info((Object)("find public target py4j: " + publicTargetLibs));
            if (this.findPublicLibs(originPath, publicTargetLibs)) {
                return new FSDataOutputStream((OutputStream)new EmptyOutputStream());
            }
        }
        if (originPath.contains("flink-dist_2.11-") && this.cupidSession.conf.getBoolean("odps.flink.libs.public.enable", false) && (flinkVersion = this.cupidSession.conf.get("odps.flink.version", "flink-1.11.0")).startsWith("flink-")) {
            flinkVersion = flinkVersion.substring(6);
            publicTargetLibs = "flink-dist_2.11-" + flinkVersion + ".jar";
            LOG.info((Object)("find public target lib: " + publicTargetLibs));
            if (this.findPublicLibs(originPath, publicTargetLibs)) {
                return new FSDataOutputStream((OutputStream)new EmptyOutputStream());
            }
        }
        if (originPath.contains("blink-dist_2.11-") && this.cupidSession.conf.getBoolean("odps.flink.libs.public.enable", false) && (flinkVersion = this.cupidSession.conf.get("odps.flink.version", "blink-3.7.2")).startsWith("blink-")) {
            publicTargetLibs = "blink-dist_2.11-" + flinkVersion + "-SNAPSHOT.jar";
            LOG.info((Object)("find public target lib: " + publicTargetLibs));
            if (this.findPublicLibs(originPath, publicTargetLibs)) {
                return new FSDataOutputStream((OutputStream)new EmptyOutputStream());
            }
        }
        CallbackByteArrayOutputStream memoryOutputStream = new CallbackByteArrayOutputStream(new OnCloseCallback(){

            @Override
            public void onClose(byte[] byteBuffer) throws OdpsException {
                Resources resources;
                String contentMd5String;
                block9: {
                    contentMd5String = DigestUtils.md5Hex((byte[])byteBuffer);
                    resources = HadoopTempResourceFileSystem.this.cupidSession.odps().resources();
                    try {
                        if (!resources.exists(contentMd5String)) break block9;
                        LOG.info((Object)("originPath: " + originPath + ", encryptedFileName: " + encryptedFileName + ", contentMd5String: " + contentMd5String + " hits. tempResource already existed no need to upload again"));
                        String targetResName = resources.get(contentMd5String).getComment();
                        if (!resources.exists(targetResName)) {
                            resources.delete(contentMd5String);
                            LOG.warn((Object)("targetRes: " + targetResName + " does not exists, delete md5File: " + contentMd5String + " and do upload again"));
                            break block9;
                        }
                        String targetResInfo = targetResName + "," + byteBuffer.length + "," + System.currentTimeMillis();
                        TempResourceMapper.put((String)originPath, (String)targetResInfo);
                        return;
                    }
                    catch (Exception ex) {
                        String badClusterErr = "Bad cluster name:";
                        if (!ex.getMessage().contains(badClusterErr)) break block9;
                        try {
                            LOG.warn((Object)"Try Cleanup Resource Meta for resource", (Throwable)ex);
                            resources.delete(contentMd5String);
                        }
                        catch (Exception possibleEx) {
                            LOG.warn((Object)String.format("Cleanup Resource Meta for resource %s", contentMd5String), (Throwable)possibleEx);
                        }
                    }
                }
                FileResource res = new FileResource();
                res.setName(encryptedFileName);
                res.setIsTempResource(true);
                FileResource md5ContentRes = new FileResource();
                md5ContentRes.setName(contentMd5String);
                md5ContentRes.setIsTempResource(true);
                md5ContentRes.setComment(encryptedFileName);
                try {
                    if (!resources.exists(res.getName())) {
                        this.createResourceIfNotExisted(resources, res, byteBuffer);
                        this.createResourceIfNotExisted(resources, md5ContentRes, encryptedFileName.getBytes());
                        LOG.info((Object)("md5 mapping file: " + contentMd5String + " mapped to " + encryptedFileName + " created!"));
                        String targetResInfo = encryptedFileName + "," + byteBuffer.length + "," + System.currentTimeMillis();
                        TempResourceMapper.put((String)originPath, (String)targetResInfo);
                    } else {
                        LOG.info((Object)("encryptedFileName: " + encryptedFileName + " hits. tempResource existed: " + originPath));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    LOG.error((Object)("trfs: " + originPath + " create failed with: " + ex));
                }
            }

            private void createResourceIfNotExisted(Resources resources, FileResource res, byte[] byteBuffer) throws OdpsException {
                try {
                    resources.create(res, (InputStream)new ByteArrayInputStream(byteBuffer));
                }
                catch (OdpsException ex) {
                    if (ex.getMessage().contains("The resource has already existed")) {
                        LOG.info((Object)("Resource: " + res.getName() + " already existed!"));
                    }
                    throw ex;
                }
            }
        });
        return new FSDataOutputStream((OutputStream)memoryOutputStream);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new NotImplementedException();
    }

    public boolean rename(Path src, Path dst) throws IOException {
        throw new NotImplementedException();
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return false;
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        FileStatus[] fileStatuses = new FileStatus[]{this.getFileStatus(f)};
        return fileStatuses;
    }

    public void setWorkingDirectory(Path new_dir) {
        throw new NotImplementedException();
    }

    public Path getWorkingDirectory() {
        return this.workingDir;
    }

    public Path getHomeDirectory() {
        return this.getWorkingDirectory();
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return false;
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        Path fullPath = f;
        if (f.isAbsoluteAndSchemeAuthorityNull()) {
            fullPath = new Path("trfs://" + f);
        } else if (!f.isAbsolute()) {
            fullPath = new Path("trfs:///" + f);
        }
        String originPath = fullPath.toString();
        if (this.isDir(fullPath)) {
            return new FileStatus(0L, true, 1, 0x3C00000L, System.currentTimeMillis(), System.currentTimeMillis(), FsPermission.getDefault(), "tempResourceDirMockOwner", "tempResourceDirMockGroup", f);
        }
        String resourceInfo = TempResourceMapper.getResourceInfo((String)originPath);
        if (resourceInfo != null) {
            String encryptedFileName = TempResourceMapper.getResourceName((String)resourceInfo);
            LOG.debug((Object)("getFileStatus originPath: " + originPath + ", encryptedFileName: " + encryptedFileName));
            this.cacheParents(fullPath);
            return new FileStatus(TempResourceMapper.getResourceSize((String)resourceInfo), false, 1, 0x3C00000L, TempResourceMapper.getResourceLastModifiedTime((String)resourceInfo), TempResourceMapper.getResourceLastModifiedTime((String)resourceInfo), FsPermission.getDefault(), "tempResourceDirMockOwner", "tempResourceDirMockGroup", f);
        }
        return null;
    }

    private boolean isDir(Path path) {
        return dirCache.contains(path.toUri().getPath());
    }

    private void cacheParents(Path path) {
        for (Path curPath = new Path(path.toUri().getPath()).getParent(); curPath != null; curPath = curPath.getParent()) {
            dirCache.add(curPath.toString());
        }
    }

    private boolean findPublicLibs(String originPath, String publicTargetLibs) {
        try {
            Resource resource = this.cupidSession.odps().resources().get("public", publicTargetLibs);
            resource.reload();
            LOG.info((Object)"find public target lib success!");
            String targetResInfo = "public-" + publicTargetLibs + ",0," + System.currentTimeMillis();
            TempResourceMapper.put((String)originPath, (String)targetResInfo);
            return true;
        }
        catch (OdpsException e) {
            if (e.getMessage().contains("ODPS-0421111: Resource not found")) {
                LOG.info((Object)("target lib " + publicTargetLibs + " is not exist in public project"));
                return false;
            }
            if (e.getMessage().contains("ODPS-0420095: Access Denied - Authorization Failed")) {
                LOG.info((Object)"find public target lib success!");
                String targetResInfo = "public-" + publicTargetLibs + ",0," + System.currentTimeMillis();
                TempResourceMapper.put((String)originPath, (String)targetResInfo);
                return true;
            }
            LOG.info((Object)("target lib " + publicTargetLibs + " is not exist in public project"));
            return false;
        }
    }
}

