/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.tempresource;

import com.aliyun.odps.OdpsException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.hadoop.fs.aliyun.tempresource.OnCloseCallback;

public class CallbackByteArrayOutputStream
extends ByteArrayOutputStream {
    private OnCloseCallback callback;

    public CallbackByteArrayOutputStream(OnCloseCallback callback) {
        this(32, callback);
    }

    public CallbackByteArrayOutputStream(int size, OnCloseCallback callback) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        this.buf = new byte[size];
        this.callback = callback;
    }

    @Override
    public void close() throws IOException {
        try {
            this.callback.onClose(this.toByteArray());
        }
        catch (OdpsException e) {
            e.printStackTrace();
        }
        super.close();
    }
}

