/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.aliyun.pangu;

import com.aliyun.odps.conf.Configuration;
import com.aliyun.odps.utils.ReflectionUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.HadoopInputStream;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.OdpsConfiguration;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.OdpsPath;
import org.apache.hadoop.fs.aliyun.pangu.wrappers.OdpsProgress;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class HadoopPanguFileSystem
extends FileSystem {
    private static final Log LOG = LogFactory.getLog(HadoopPanguFileSystem.class);
    public static final String PANGU_WRAPPER_DEFAULT_IMPL = "com.aliyun.odps.fs.proxyclient.ProxyClientFileSystem";
    private com.aliyun.odps.fs.FileSystem panguFileSystem;

    public void initialize(URI uri, org.apache.hadoop.conf.Configuration conf) throws IOException {
        super.initialize(uri, conf);
        this.setConf(conf);
        OdpsConfiguration odpsConf = new OdpsConfiguration(conf);
        if (System.getenv("META_LOOKUP_NAME") == null) {
            return;
        }
        String panguImpl = odpsConf.get("pangu.wrapper.impl", PANGU_WRAPPER_DEFAULT_IMPL);
        Class<?> clazz = null;
        try {
            clazz = Class.forName(panguImpl);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Pangu impl class " + panguImpl + " not found."), (Throwable)e);
            throw new RuntimeException("No FileSystem for pangu wrapper", e);
        }
        this.panguFileSystem = (com.aliyun.odps.fs.FileSystem)ReflectionUtils.newInstance(clazz, (Configuration)odpsConf);
        LOG.info((Object)("Begin initializing pangu fs. Input URI: " + uri.toString()));
        this.panguFileSystem.initialize(uri, (Configuration)odpsConf);
    }

    public URI getUri() {
        return this.panguFileSystem.getUri();
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return new FSDataInputStream((InputStream)((Object)new HadoopInputStream((InputStream)this.panguFileSystem.open((com.aliyun.odps.fs.Path)new OdpsPath(f), bufferSize))));
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return new FSDataOutputStream((OutputStream)this.panguFileSystem.create((com.aliyun.odps.fs.Path)new OdpsPath(f), overwrite, bufferSize, replication, blockSize, (com.aliyun.odps.util.Progressable)new OdpsProgress(progress)), this.statistics);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return new FSDataOutputStream((OutputStream)this.panguFileSystem.append((com.aliyun.odps.fs.Path)new OdpsPath(f), bufferSize, (com.aliyun.odps.util.Progressable)new OdpsProgress(progress)), this.statistics);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.panguFileSystem.rename((com.aliyun.odps.fs.Path)new OdpsPath(src), (com.aliyun.odps.fs.Path)new OdpsPath(dst));
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.panguFileSystem.delete((com.aliyun.odps.fs.Path)new OdpsPath(f), recursive);
    }

    public FileStatus[] listStatus(Path f) throws FileNotFoundException, IOException {
        com.aliyun.odps.fs.FileStatus[] odpsFileStatuses = this.panguFileSystem.listStatus((com.aliyun.odps.fs.Path)new OdpsPath(f));
        if (odpsFileStatuses == null) {
            return null;
        }
        FileStatus[] fileStatus = new FileStatus[odpsFileStatuses.length];
        for (int i = 0; i < odpsFileStatuses.length; ++i) {
            fileStatus[i] = this.getHadoopFileStatus(odpsFileStatuses[i]);
        }
        return fileStatus;
    }

    public Path getHomeDirectory() {
        return new Path(this.panguFileSystem.getHomeDirectory().toString());
    }

    public short getDefaultReplication() {
        return this.panguFileSystem.getDefaultReplication();
    }

    public long getDefaultBlockSize() {
        return this.panguFileSystem.getDefaultBlockSize();
    }

    private FileStatus getHadoopFileStatus(com.aliyun.odps.fs.FileStatus odpsFileStatus) {
        return new FileStatus(odpsFileStatus.getLen(), odpsFileStatus.isDir(), (int)odpsFileStatus.getReplication(), odpsFileStatus.getBlockSize(), odpsFileStatus.getModificationTime(), odpsFileStatus.getAccessTime(), null, "admin", odpsFileStatus.getGroup(), null, new Path(odpsFileStatus.getPath().toString()));
    }

    public void setWorkingDirectory(Path new_dir) {
        this.panguFileSystem.setWorkingDirectory((com.aliyun.odps.fs.Path)new OdpsPath(new_dir));
    }

    public Path getWorkingDirectory() {
        return new Path(this.panguFileSystem.getWorkingDirectory().toString());
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        if (System.getenv("META_LOOKUP_NAME") == null) {
            return false;
        }
        return this.panguFileSystem.mkdirs((com.aliyun.odps.fs.Path)new OdpsPath(f));
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.getHadoopFileStatus(this.panguFileSystem.getFileStatus((com.aliyun.odps.fs.Path)new OdpsPath(f)));
    }

    public String getScheme() {
        return "pangu";
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.panguFileSystem.setReplication((com.aliyun.odps.fs.Path)new OdpsPath(src), replication);
    }
}

