/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.kerby.has.client.HasClientUtil;
import org.apache.kerby.has.common.HasConfig;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasInitClient {
    public static final Logger LOG = LoggerFactory.getLogger(HasInitClient.class);
    private HasConfig hasConfig;
    private File confDir;

    public HasInitClient(HasConfig hasConfig, File confDir) {
        this.hasConfig = hasConfig;
        this.confDir = confDir;
    }

    public File getConfDir() {
        return this.confDir;
    }

    private String getInitBaseURL() throws KrbException {
        return HasClientUtil.getBaseUrl(this.hasConfig, "init");
    }

    private String getConfigBaseURL() throws KrbException {
        return HasClientUtil.getBaseUrl(this.hasConfig, "conf");
    }

    public String startKdc() throws KrbException {
        URL url;
        try {
            url = new URL(this.getInitBaseURL() + "kdcstart");
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                String response = HasClientUtil.getResponse(httpConn);
                LOG.info(response);
                return response;
            }
            throw new KrbException(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public void initKdc(File keytab, String password) throws KrbException {
        URL url;
        try {
            url = password == null ? new URL(this.getInitBaseURL() + "kdcinit") : new URL(this.getInitBaseURL() + "kdcinit?password=" + password);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try (FileOutputStream fos = new FileOutputStream(keytab);
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[3072];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public void getKrb5conf(File file) throws KrbException {
        URL url;
        try {
            url = new URL(this.getConfigBaseURL() + "getkrb5conf");
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try (FileOutputStream fos = new FileOutputStream(file);
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[3072];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public void getKrb5conf(File file, String realm, String port, String kdcs, String config) throws KrbException {
        URL url;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("realm", realm);
            params.put("port", port);
            params.put("kdcs", kdcs);
            params.put("config", config);
            url = new URL(this.getConfigBaseURL() + "getkrb5conf?" + this.getPostDataString(params));
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try (FileOutputStream fos = new FileOutputStream(file);
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[3072];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public void getHasClientConf(File file, String host) throws KrbException {
        URL url;
        try {
            url = host == null ? new URL(this.getConfigBaseURL() + "gethasclientconf") : new URL(this.getConfigBaseURL() + "gethasclientconf?host=" + host);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "GET", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new KrbException(HasClientUtil.getResponse(httpConn));
            }
            try (FileOutputStream fos = new FileOutputStream(file);
                 InputStream in = httpConn.getInputStream();){
                int read;
                byte[] buffer = new byte[3072];
                while ((read = in.read(buffer)) > 0) {
                    fos.write(buffer, 0, read);
                }
            }
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public String setPlugin(String plugin) throws KrbException {
        URL url;
        try {
            url = new URL(this.getConfigBaseURL() + "setplugin?plugin=" + plugin);
        }
        catch (MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                String response = HasClientUtil.getResponse(httpConn);
                LOG.info(response);
                return response;
            }
            throw new KrbException(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public String configKdc(String port, String realm, String host, String extraConfig) throws KrbException {
        URL url;
        try {
            if (extraConfig == null) {
                url = new URL(this.getConfigBaseURL() + "configkdc?port=" + port + "&realm=" + realm + "&host=" + host);
            } else {
                String[] config = extraConfig.trim().split("=");
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("port", port);
                params.put("realm", realm);
                params.put("host", host);
                params.put("configKey", config[0]);
                params.put("configValue", config[1]);
                url = new URL(this.getConfigBaseURL() + "configkdc?" + this.getPostDataString(params));
            }
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                String response = HasClientUtil.getResponse(httpConn);
                LOG.info(response);
                return response;
            }
            throw new KrbException(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public String configBackend(String backendType, String dir, String mysqlUrl, String user, String password) throws KrbException {
        URL url;
        if (backendType.equals("json")) {
            try {
                url = new URL(this.getConfigBaseURL() + "configbackend?backendType=" + backendType + "&dir=" + dir);
            }
            catch (MalformedURLException e) {
                throw new KrbException("Failed to create a URL object.", (Throwable)e);
            }
        } else if (backendType.equals("mysql")) {
            try {
                url = new URL(this.getConfigBaseURL() + "configbackend?backendType=" + backendType + "&url=" + mysqlUrl + "&user=" + user + "&password=" + password);
            }
            catch (MalformedURLException e) {
                throw new KrbException("Failed to create a URL object.", (Throwable)e);
            }
        } else {
            throw new KrbException("Unsupported backend: " + backendType);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                String response = HasClientUtil.getResponse(httpConn);
                LOG.info(response);
                return response;
            }
            throw new KrbException(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    public String configOpenLdapBackend(String adminDn, String adminPw, String baseDn, String port, String host) throws KrbException {
        URL url;
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("backendType", "openldap");
            params.put("adminDn", adminDn);
            params.put("adminPw", adminPw);
            params.put("baseDn", baseDn);
            params.put("port", port);
            params.put("host", host);
            url = new URL(this.getConfigBaseURL() + "configbackend?" + this.getPostDataString(params));
        }
        catch (UnsupportedEncodingException | MalformedURLException e) {
            throw new KrbException("Failed to create a URL object.", (Throwable)e);
        }
        HttpURLConnection httpConn = HasClientUtil.createConnection(this.hasConfig, url, "PUT", false);
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() == 200) {
                String response = HasClientUtil.getResponse(httpConn);
                LOG.info(response);
                return response;
            }
            throw new KrbException(HasClientUtil.getResponse(httpConn));
        }
        catch (IOException e) {
            throw new KrbException("IO error occurred. " + e.getMessage());
        }
    }

    private String getPostDataString(HashMap<String, String> params) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (first) {
                first = false;
            } else {
                result.append("&");
            }
            result.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
            result.append("=");
            result.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
        }
        return result.toString();
    }
}

