/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.client;

import java.util.Collections;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kerby.has.client.HasClientPlugin;
import org.apache.kerby.has.common.HasException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasClientPluginRegistry {
    static final Logger LOG = LoggerFactory.getLogger(HasClientPluginRegistry.class);
    private static Map<String, Class> allPlugins = new ConcurrentHashMap<String, Class>();

    public static Set<String> registeredPlugins() {
        return Collections.unmodifiableSet(allPlugins.keySet());
    }

    public static boolean registeredPlugin(String name) {
        return allPlugins.containsKey(name);
    }

    public static HasClientPlugin createPlugin(String name) throws HasException {
        if (!HasClientPluginRegistry.registeredPlugin(name)) {
            throw new HasException("Unregistered plugin " + name);
        }
        try {
            return (HasClientPlugin)allPlugins.get(name).newInstance();
        }
        catch (Exception e) {
            LOG.error("Create {} plugin failed", (Object)name, (Object)e);
            throw new HasException(e.getMessage());
        }
    }

    static {
        ServiceLoader<HasClientPlugin> plugins = ServiceLoader.load(HasClientPlugin.class);
        for (HasClientPlugin plugin : plugins) {
            allPlugins.put(plugin.getLoginType(), plugin.getClass());
        }
    }
}

