/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.has.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.text.CharacterPredicate;
import org.apache.commons.text.CharacterPredicates;
import org.apache.commons.text.RandomStringGenerator;
import org.apache.kerby.config.ConfigKey;
import org.apache.kerby.has.client.HasClientPlugin;
import org.apache.kerby.has.client.HasClientPluginRegistry;
import org.apache.kerby.has.client.HasClientUtil;
import org.apache.kerby.has.client.HasLoginException;
import org.apache.kerby.has.common.HasConfig;
import org.apache.kerby.has.common.HasConfigKey;
import org.apache.kerby.has.common.HasException;
import org.apache.kerby.has.common.util.HasUtil;
import org.apache.kerby.has.common.util.URLConnectionFactory;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.KrbRuntime;
import org.apache.kerby.kerberos.kerb.ccache.CredentialCache;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.provider.TokenEncoder;
import org.apache.kerby.kerberos.kerb.type.base.AuthToken;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionKey;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.base.KrbError;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessage;
import org.apache.kerby.kerberos.kerb.type.base.KrbMessageType;
import org.apache.kerby.kerberos.kerb.type.base.PrincipalName;
import org.apache.kerby.kerberos.kerb.type.kdc.EncAsRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.EncKdcRepPart;
import org.apache.kerby.kerberos.kerb.type.kdc.KdcRep;
import org.apache.kerby.kerberos.kerb.type.ticket.TgtTicket;
import org.apache.kerby.util.IOUtil;
import org.apache.kerby.util.SysUtil;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HasClient {
    public static final Logger LOG = LoggerFactory.getLogger(HasClient.class);
    public static final String JAVA_SECURITY_KRB5_CONF = "java.security.krb5.conf";
    public static final String HAS_HTTP_PORT_DEFAULT = "9870";
    public static final String HAS_CONFIG = "/etc/has/";
    public static final String HAS_CONFIG_DEFAULT = "/etc/has/has-client.conf";
    public static final String CA_ROOT_DEFAULT = "/etc/has/ca-root.pem";
    private String hadoopSecurityHas = null;
    private String type;
    private File clientConfigFolder;

    public HasClient() {
    }

    public HasClient(String hadoopSecurityHas) {
        this.hadoopSecurityHas = hadoopSecurityHas;
    }

    public TgtTicket requestTgt() throws HasException {
        AuthToken authToken;
        HasClientPlugin plugin;
        HasConfig config;
        if (this.hadoopSecurityHas == null) {
            String confDir = System.getenv("HAS_CONF_DIR");
            if (confDir == null) {
                confDir = HAS_CONFIG;
            }
            String pathName = confDir + "/has-client.conf";
            LOG.debug("has-client conf path: " + pathName);
            File confFile = new File(pathName);
            if (!confFile.exists()) {
                LOG.warn("The HAS client config file: " + pathName + " does not exist.");
                throw new HasException("The HAS client config file: " + pathName + " does not exist.");
            }
            try {
                config = HasUtil.getHasConfig((File)confFile);
            }
            catch (HasException e) {
                LOG.error("Failed to get has client config: " + e.getMessage());
                throw new HasException("Failed to get has client config: " + e.getMessage());
            }
        }
        config = new HasConfig();
        String[] urls = this.hadoopSecurityHas.split(";");
        StringBuilder host = new StringBuilder();
        int port = 0;
        try {
            for (String url : urls) {
                URI uri = new URI(url.trim());
                host.append(uri.getHost()).append(",");
                if (port == 0) {
                    port = uri.getPort();
                } else if (port != uri.getPort()) {
                    throw new HasException("Invalid port: not even.");
                }
                this.type = System.getenv("auth_type");
                if (this.type != null) continue;
                String[] strs = uri.getQuery().split("=");
                if (strs[0].equals("auth_type")) {
                    this.type = strs[1];
                    continue;
                }
                LOG.warn("No auth type in conf.");
            }
            if (host.length() == 0 || port == 0) {
                throw new HasException("host is null.");
            }
            config.setString((ConfigKey)HasConfigKey.HTTPS_HOST, host.subSequence(0, host.length() - 1).toString());
            config.setInt((ConfigKey)HasConfigKey.HTTPS_PORT, Integer.valueOf(port));
            config.setString((ConfigKey)HasConfigKey.AUTH_TYPE, this.type);
        }
        catch (URISyntaxException e) {
            LOG.error("Errors occurred when getting web url. " + e.getMessage());
            throw new HasException("Errors occurred when getting web url. " + e.getMessage());
        }
        if (config == null) {
            throw new HasException("Failed to get HAS client config.");
        }
        try {
            plugin = this.getClientTokenPlugin(config);
        }
        catch (HasException e) {
            LOG.error("Failed to get client token plugin from config: " + e.getMessage());
            throw new HasException("Failed to get client token plugin from config: " + e.getMessage());
        }
        try {
            authToken = plugin.login(config);
        }
        catch (HasLoginException e) {
            LOG.error(e.getMessage());
            throw new HasException(e.getMessage());
        }
        this.type = plugin.getLoginType();
        LOG.info("The plugin type is: " + this.type);
        return this.requestTgt(authToken, this.type, config);
    }

    private HasClientPlugin getClientTokenPlugin(HasConfig config) throws HasException {
        String pluginName = config.getPluginName();
        if (pluginName == null) {
            LOG.debug("Please set the plugin name in has client conf");
            throw new HasException("Please set the plugin name in has client conf");
        }
        HasClientPlugin clientPlugin = HasClientPluginRegistry.createPlugin(pluginName);
        return clientPlugin;
    }

    public TgtTicket requestTgt(AuthToken authToken, String type, HasConfig config) throws HasException {
        String tokenString;
        TokenEncoder tokenEncoder = KrbRuntime.getTokenProvider((String)"JWT").createTokenEncoder();
        try {
            tokenString = tokenEncoder.encodeAsString(authToken);
        }
        catch (KrbException e) {
            LOG.debug("Failed to decode the auth token. " + e.getMessage());
            throw new HasException("Failed to decode the auth token. " + e.getMessage());
        }
        JSONObject json = null;
        int responseStatus = 0;
        boolean success = false;
        if (config.getHttpsPort() != null && config.getHttpsHost() != null) {
            String[] hosts;
            String sslClientConfPath = config.getSslClientConf();
            config.setString("hadoop.ssl.hostname.verifier", "ALLOW_ALL");
            config.setString("hadoop.ssl.client.conf", sslClientConfPath);
            config.setBoolean("hadoop.ssl.require.client.CERT", Boolean.valueOf(false));
            URLConnectionFactory connectionFactory = URLConnectionFactory.newDefaultURLConnectionFactory((HasConfig)config);
            for (String host : hosts = config.getHttpsHost().split(",")) {
                HttpURLConnection conn;
                URL url;
                try {
                    url = new URL("https://" + host.trim() + ":" + config.getHttpsPort() + "/has/v1?type=" + type + "&authToken=" + tokenString);
                }
                catch (MalformedURLException e) {
                    LOG.warn("Failed to get url. " + e.toString());
                    continue;
                }
                try {
                    conn = (HttpURLConnection)connectionFactory.openConnection(url);
                }
                catch (IOException e) {
                    LOG.warn("Failed to open connection. " + e.toString());
                    continue;
                }
                conn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                try {
                    conn.setRequestMethod("PUT");
                }
                catch (ProtocolException e) {
                    LOG.warn("Failed to set request method. " + e.toString());
                    continue;
                }
                conn.setDoOutput(true);
                conn.setDoInput(true);
                try {
                    conn.connect();
                    responseStatus = conn.getResponseCode();
                    switch (responseStatus) {
                        case 200: 
                        case 201: {
                            String line;
                            BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                            StringBuilder sb = new StringBuilder();
                            while ((line = br.readLine()) != null) {
                                sb.append(line + "\n");
                            }
                            br.close();
                            json = new JSONObject(sb.toString());
                        }
                    }
                }
                catch (IOException | JSONException e) {
                    LOG.warn("ERROR! " + e.toString());
                    continue;
                }
                if (responseStatus != 200 && responseStatus != 201) continue;
                success = true;
                break;
            }
            if (!success) {
                throw new HasException("Failed: HTTP error code : " + responseStatus);
            }
        } else {
            throw new HasException("Please set https host and port.");
        }
        try {
            return this.handleResponse(json, (String)authToken.getAttributes().get("passPhrase"));
        }
        catch (HasException e) {
            LOG.debug("Failed to handle response when requesting tgt ticket in client." + e.getMessage());
            throw new HasException(e.getMessage());
        }
    }

    private File loadSslClientConf(HasConfig config, String sslClientConfPath) throws HasException {
        File sslClientConf = new File(sslClientConfPath);
        if (!sslClientConf.exists()) {
            X509Certificate certificate;
            String httpHost = config.getHttpHost();
            String httpPort = config.getHttpPort();
            if (httpHost == null) {
                httpHost = config.getHttpsHost();
            }
            if (httpPort == null) {
                httpPort = HAS_HTTP_PORT_DEFAULT;
            }
            if (this.verifyCertificate(certificate = this.getCertificate(httpHost, httpPort))) {
                String password = this.createTrustStore(config.getHttpsHost(), certificate);
                this.createClientSSLConfig(password);
            } else {
                throw new HasException("The certificate from HAS server is invalid.");
            }
        }
        return sslClientConf;
    }

    public KrbMessage getKrbMessage(JSONObject json) throws HasException {
        String typeString;
        try {
            boolean success = json.getBoolean("success");
            if (!success) {
                String message = json.getString("krbMessage");
                LOG.debug(message);
                throw new HasException(message);
            }
        }
        catch (JSONException e) {
            LOG.debug("Failed to get message. " + e.getMessage());
            throw new HasException("Failed to get message." + e.getMessage());
        }
        try {
            typeString = json.getString("type");
        }
        catch (JSONException e) {
            LOG.debug("Failed to get message." + e.getMessage());
            throw new HasException("Failed to get message." + e.getMessage());
        }
        if (typeString != null && typeString.equals(this.type)) {
            KrbMessage kdcRep;
            String krbMessageString;
            try {
                krbMessageString = json.getString("krbMessage");
            }
            catch (JSONException e) {
                LOG.debug("Failed to get the krbMessage. " + e.getMessage());
                throw new HasException("Failed to get the krbMessage. " + e.getMessage());
            }
            Base64 base64 = new Base64(0);
            byte[] krbMessage = base64.decode(krbMessageString);
            ByteBuffer byteBuffer = ByteBuffer.wrap(krbMessage);
            try {
                kdcRep = KrbCodec.decodeMessage((ByteBuffer)byteBuffer);
            }
            catch (IOException e) {
                LOG.debug("Krb decoding message failed. " + e.getMessage());
                throw new HasException("Krb decoding message failed. " + e.getMessage());
            }
            return kdcRep;
        }
        throw new HasException("Can't get the right message from server.");
    }

    public TgtTicket handleResponse(JSONObject json, String passPhrase) throws HasException {
        KrbMessage kdcRep = this.getKrbMessage(json);
        KrbMessageType messageType = kdcRep.getMsgType();
        if (messageType == KrbMessageType.AS_REP) {
            return this.processResponse((KdcRep)kdcRep, passPhrase);
        }
        if (messageType == KrbMessageType.KRB_ERROR) {
            KrbError error = (KrbError)kdcRep;
            LOG.error("HAS server response with message: " + error.getErrorCode().getMessage());
            throw new HasException(error.getEtext());
        }
        return null;
    }

    public TgtTicket processResponse(KdcRep kdcRep, String passPhrase) throws HasException {
        PrincipalName clientPrincipal = kdcRep.getCname();
        String clientRealm = kdcRep.getCrealm();
        clientPrincipal.setRealm(clientRealm);
        EncryptionKey clientKey = null;
        try {
            clientKey = HasUtil.getClientKey((String)clientPrincipal.getName(), (String)passPhrase, (EncryptionType)kdcRep.getEncryptedEncPart().getEType());
        }
        catch (KrbException e) {
            throw new HasException("Could not generate key. " + e.getMessage());
        }
        byte[] decryptedData = this.decryptWithClientKey(kdcRep.getEncryptedEncPart(), KeyUsage.AS_REP_ENCPART, clientKey);
        if ((decryptedData[0] & 0x1F) == 26) {
            decryptedData[0] = (byte)(decryptedData[0] - 1);
        }
        EncAsRepPart encKdcRepPart = new EncAsRepPart();
        try {
            encKdcRepPart.decode(decryptedData);
        }
        catch (IOException e) {
            throw new HasException("Failed to decode EncAsRepPart. " + e.getMessage());
        }
        kdcRep.setEncPart((EncKdcRepPart)encKdcRepPart);
        TgtTicket tgtTicket = this.getTicket(kdcRep);
        LOG.debug("Ticket expire time: " + tgtTicket.getEncKdcRepPart().getEndTime());
        this.storeTgtTicket(tgtTicket);
        return tgtTicket;
    }

    private void storeTgtTicket(TgtTicket tgtTicket) throws HasException {
        String ccacheName = this.getCcacheName();
        File ccacheFile = new File(ccacheName);
        LOG.debug("Storing the tgt to the credential cache file.");
        if (!ccacheFile.exists()) {
            this.createCacheFile(ccacheFile);
        }
        if (ccacheFile.exists() && ccacheFile.canWrite()) {
            CredentialCache cCache = new CredentialCache(tgtTicket);
            try {
                cCache.store(ccacheFile);
            }
            catch (IOException e) {
                throw new HasException("Failed to store tgt. " + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Invalid ccache file, not exist or writable: " + ccacheFile.getAbsolutePath());
        }
    }

    private void createCacheFile(File ccacheFile) throws HasException {
        try {
            if (!ccacheFile.createNewFile()) {
                throw new HasException("Failed to create ccache file " + ccacheFile.getAbsolutePath());
            }
            ccacheFile.setReadable(true, true);
            if (!ccacheFile.setWritable(true, true)) {
                throw new HasException("Cache file is not readable.");
            }
        }
        catch (IOException e) {
            throw new HasException("Failed to create ccache file " + ccacheFile.getAbsolutePath() + ". " + e.getMessage());
        }
    }

    private String getCcacheName() {
        String ccacheName;
        String ccacheNameEnv = System.getenv("KRB5CCNAME");
        if (ccacheNameEnv != null) {
            ccacheName = ccacheNameEnv;
        } else {
            StringBuilder uid = new StringBuilder();
            try {
                int c;
                String command = "id -u";
                Process child = Runtime.getRuntime().exec(command);
                InputStream in = child.getInputStream();
                while ((c = in.read()) != -1) {
                    uid.append((char)c);
                }
                in.close();
            }
            catch (IOException e) {
                System.err.println("Failed to get UID.");
                System.exit(1);
            }
            ccacheName = "krb5cc_" + uid.toString().trim();
            ccacheName = SysUtil.getTempDir().toString() + "/" + ccacheName;
        }
        return ccacheName;
    }

    protected byte[] decryptWithClientKey(EncryptedData data, KeyUsage usage, EncryptionKey clientKey) throws HasException {
        if (clientKey == null) {
            throw new HasException("Client key isn't available");
        }
        try {
            return EncryptionHandler.decrypt((EncryptedData)data, (EncryptionKey)clientKey, (KeyUsage)usage);
        }
        catch (KrbException e) {
            throw new HasException("Errors occurred when decrypting the data." + e.getMessage());
        }
    }

    public TgtTicket getTicket(KdcRep kdcRep) {
        TgtTicket tgtTicket = new TgtTicket(kdcRep.getTicket(), (EncAsRepPart)kdcRep.getEncPart(), kdcRep.getCname());
        return tgtTicket;
    }

    private X509Certificate getCertificate(String host, String port) throws HasException {
        X509Certificate certificate;
        URL url;
        HttpURLConnection httpConn = null;
        try {
            url = new URL("http://" + host + ":" + port + "/has/v1/conf/getcert");
        }
        catch (MalformedURLException e) {
            throw new HasException("Failed to create a URL object." + e.getMessage());
        }
        try {
            httpConn = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        httpConn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        try {
            httpConn.setRequestMethod("GET");
        }
        catch (ProtocolException e) {
            LOG.error("Failed to add principal. " + e);
            throw new HasException("Failed to set the method for URL request. " + e.getMessage());
        }
        try {
            httpConn.connect();
            if (httpConn.getResponseCode() != 200) {
                throw new HasException(HasClientUtil.getResponse(httpConn));
            }
            try {
                CertificateFactory factory = CertificateFactory.getInstance("X.509");
                InputStream in = HasClientUtil.getInputStream(httpConn);
                certificate = (X509Certificate)factory.generateCertificate(in);
            }
            catch (CertificateException e) {
                throw new HasException("Failed to get certificate from HAS server. " + e.getMessage());
            }
        }
        catch (IOException e) {
            throw new HasException("IO error occurred. " + e.getMessage());
        }
        return certificate;
    }

    private boolean verifyCertificate(X509Certificate certificate) throws HasException {
        X509Certificate caRoot;
        try {
            Date date = new Date();
            certificate.checkValidity(date);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        try {
            File caRootFile;
            String caRootPath = System.getenv("CA_ROOT");
            if (caRootPath == null) {
                caRootPath = CA_ROOT_DEFAULT;
            }
            if (caRootPath != null) {
                caRootFile = new File(caRootPath);
                if (!caRootFile.exists()) {
                    LOG.debug("CA_ROOT: " + caRootPath + " not exist.");
                    throw new HasException("CA_ROOT: " + caRootPath + " not exist.");
                }
            } else {
                throw new HasException("Please set the CA_ROOT.");
            }
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            try (FileInputStream in = new FileInputStream(caRootFile);){
                caRoot = (X509Certificate)factory.generateCertificate(in);
            }
        }
        catch (IOException | CertificateException e) {
            throw new HasException("Failed to get certificate from ca root file. " + e.getMessage());
        }
        try {
            PublicKey publicKey = caRoot.getPublicKey();
            if (publicKey == null) {
                throw new HasException("Failed to get public key in ca root.");
            }
            certificate.verify(publicKey);
        }
        catch (GeneralSecurityException e) {
            return false;
        }
        return true;
    }

    private String createTrustStore(String host, X509Certificate certificate) throws HasException {
        RandomStringGenerator generator = new RandomStringGenerator.Builder().withinRange(97, 122).filteredBy(new CharacterPredicate[]{CharacterPredicates.LETTERS, CharacterPredicates.DIGITS}).build();
        String password = generator.generate(15);
        File trustStoreFile = new File(this.clientConfigFolder + "/truststore.jks");
        try {
            KeyStore trustStore = KeyStore.getInstance("jks");
            trustStore.load(null, null);
            trustStore.setCertificateEntry(host, certificate);
            try (FileOutputStream out = new FileOutputStream(trustStoreFile);){
                trustStore.store(out, password.toCharArray());
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new HasException("Failed to create and save truststore file. " + e.getMessage());
        }
        return password;
    }

    private void createClientSSLConfig(String password) throws HasException {
        String resourcePath = "/ssl-client.conf.template";
        try (InputStream templateResource = this.getClass().getResourceAsStream(resourcePath);){
            String content = IOUtil.readInput((InputStream)templateResource);
            content = content.replaceAll("_location_", this.clientConfigFolder.getAbsolutePath() + "/truststore.jks");
            content = content.replaceAll("_password_", password);
            IOUtil.writeFile((String)content, (File)new File(this.clientConfigFolder + "/ssl-client.conf"));
        }
        catch (IOException e) {
            throw new HasException("Failed to create client ssl configuration file. " + e.getMessage());
        }
    }
}

