/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.tunnel.impl;

import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class Util {
    public static final String WRITER_COMPRESS_ENABLE = "odps.cupid.writer.compress.enable";
    public static final String WRITER_BUFFER_ENABLE = "odps.cupid.writer.buffer.enable";
    public static final String WRITER_BUFFER_SHARES = "odps.cupid.writer.buffer.shares";
    public static final String WRITER_BUFFER_SIZE = "odps.cupid.writer.buffer.size";

    public static PartitionSpec toOdpsPartitionSpec(Map<String, String> partitionSpec) {
        PartitionSpec odpsPartitionSpec = new PartitionSpec();
        for (String key : partitionSpec.keySet()) {
            odpsPartitionSpec.set(key, partitionSpec.get(key));
        }
        return odpsPartitionSpec;
    }

    public static Map<String, String> fromOdpsPartitionSpec(PartitionSpec odpsPartitionSpec) {
        HashMap<String, String> partitionSpec = new HashMap<String, String>();
        for (String key : odpsPartitionSpec.keys()) {
            partitionSpec.put(key, odpsPartitionSpec.get(key));
        }
        return partitionSpec;
    }

    public static TableTunnel getTableTunnel(String project) throws IOException {
        CupidConf cupidConf;
        Odps odps = Util.getOdps(project);
        try {
            cupidConf = CupidSession.getConf();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        TableTunnel tunnel = new TableTunnel(odps);
        if (!cupidConf.get("odps.tunnel.end.point", "").isEmpty()) {
            tunnel.setEndpoint(cupidConf.get("odps.tunnel.end.point", ""));
        }
        return tunnel;
    }

    public static Odps getOdps(String project) {
        Odps odps = CupidSession.get().odps();
        odps.setDefaultProject(project);
        return odps;
    }

    public static void createPartition(String project, String table, PartitionSpec partitionSpec) throws IOException {
        int retry = 0;
        long sleep = 2000L;
        Odps odps = Util.getOdps(project);
        while (true) {
            try {
                odps.tables().get(table).createPartition(partitionSpec, true);
            }
            catch (OdpsException e) {
                if (++retry > 5) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(sleep + ThreadLocalRandom.current().nextLong(3000L));
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                sleep *= 2L;
                continue;
            }
            break;
        }
    }

    public static TableTunnel.UploadSession createUploadSession(String project, String table, PartitionSpec partitionSpec, boolean isOverwrite) throws IOException {
        TableTunnel.UploadSession uploadSession;
        int retry = 0;
        long sleep = 2000L;
        TableTunnel tunnel = Util.getTableTunnel(project);
        while (true) {
            try {
                if (partitionSpec == null || partitionSpec.isEmpty()) {
                    uploadSession = tunnel.createUploadSession(project, table, isOverwrite);
                    break;
                }
                uploadSession = tunnel.createUploadSession(project, table, partitionSpec, isOverwrite);
            }
            catch (TunnelException e) {
                if (++retry > 5) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(sleep + ThreadLocalRandom.current().nextLong(3000L));
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                sleep *= 2L;
                continue;
            }
            break;
        }
        return uploadSession;
    }
}

