/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.tunnel.impl;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelDynamicWriteMsg;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelWriteMsg;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelWriteSessionInfo;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.Util;
import com.aliyun.odps.cupid.table.v1.writer.FileWriter;
import com.aliyun.odps.cupid.table.v1.writer.WriterCommitMessage;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordWriter;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordWriter;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.Map;

public class TunnelWriter
implements FileWriter<ArrayRecord> {
    protected TunnelWriteSessionInfo sessionInfo;
    protected long blockId;
    protected TableTunnel.UploadSession session;
    protected RecordWriter writer;
    private long rowsWritten;
    private boolean isClosed;
    private String uploadId;
    private boolean isDynamicWriter;
    private final Map<String, String> partitionSpec;

    TunnelWriter(TunnelWriteSessionInfo sessionInfo, long blockId, Map<String, String> partitionSpec) {
        this.sessionInfo = sessionInfo;
        this.blockId = blockId;
        this.isClosed = false;
        this.isDynamicWriter = false;
        this.partitionSpec = partitionSpec;
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void init() throws IOException {
        String project = this.sessionInfo.getProject();
        String table = this.sessionInfo.getTable();
        this.uploadId = this.sessionInfo.getUploadId();
        try {
            if (StringUtils.isNullOrEmpty((String)this.uploadId)) {
                if (this.sessionInfo.isOverwrite()) {
                    throw new UnsupportedOperationException("Overwrite is not unsupported by tunnel dynamic partition");
                }
                if (this.partitionSpec == null || this.partitionSpec.isEmpty()) {
                    throw new InvalidParameterException("Tunnel dynamic partition is empty");
                }
                PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(this.partitionSpec);
                Util.createPartition(project, table, odpsPartitionSpec);
                this.session = Util.createUploadSession(project, table, odpsPartitionSpec, this.sessionInfo.isOverwrite());
                this.uploadId = this.session.getId();
                this.isDynamicWriter = true;
                boolean compress = CupidSession.getConf().getBoolean("odps.cupid.writer.compress.enable", true);
                this.writer = this.session.openRecordWriter(0L, compress);
            } else {
                TableTunnel tunnel = Util.getTableTunnel(project);
                Map partitionSpec = this.sessionInfo.getPartitionSpec();
                if (partitionSpec == null || partitionSpec.isEmpty()) {
                    this.session = tunnel.getUploadSession(project, table, this.uploadId);
                } else {
                    PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(partitionSpec);
                    this.session = tunnel.getUploadSession(project, table, odpsPartitionSpec, this.uploadId);
                }
                boolean compress = CupidSession.getConf().getBoolean("odps.cupid.writer.compress.enable", true);
                this.writer = this.session.openRecordWriter(this.blockId, compress);
            }
        }
        catch (TunnelException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void write(ArrayRecord data) throws IOException {
        this.writer.write((Record)data);
        ++this.rowsWritten;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.writer.close();
        this.isClosed = true;
    }

    public void commit() throws IOException {
        this.close();
    }

    public WriterCommitMessage commitWithResult() throws IOException {
        this.close();
        if (this.isDynamicWriter) {
            return new TunnelDynamicWriteMsg(this.sessionInfo.getProject(), this.sessionInfo.getTable(), this.partitionSpec, this.uploadId);
        }
        return new TunnelWriteMsg();
    }

    public long getBytesWritten() {
        return ((TunnelRecordWriter)this.writer).getTotalBytes();
    }

    public long getRowsWritten() {
        return this.rowsWritten;
    }
}

