/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelDynamicWriteMsg;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelWriteMsg;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelWriteSessionInfo;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.Util;
import com.aliyun.odps.cupid.table.v1.util.TableUtils;
import com.aliyun.odps.cupid.table.v1.writer.BucketFileInfo;
import com.aliyun.odps.cupid.table.v1.writer.TableWriteSession;
import com.aliyun.odps.cupid.table.v1.writer.WriteSessionInfo;
import com.aliyun.odps.cupid.table.v1.writer.WriterCommitMessage;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TunnelWriteSession
extends TableWriteSession {
    private WriteSessionInfo sessionInfo;
    private List<Attribute> dataColumns;
    private List<Attribute> partitionColumns;
    private TableTunnel.UploadSession session;

    TunnelWriteSession(String project, String table, TableSchema tableSchema, Map<String, String> partitionSpec, boolean overwrite) {
        super(project, table, tableSchema, partitionSpec, overwrite);
    }

    TunnelWriteSession(WriteSessionInfo writeSessionInfo) {
        super(writeSessionInfo.getProject(), writeSessionInfo.getTable(), TableUtils.toTableSchema((WriteSessionInfo)writeSessionInfo), writeSessionInfo.getPartitionSpec(), writeSessionInfo.isOverwrite());
        this.sessionInfo = writeSessionInfo;
        this.rebuildTunnelSession();
    }

    private void rebuildTunnelSession() {
        if (this.sessionInfo == null || !(this.sessionInfo instanceof TunnelWriteSessionInfo)) {
            throw new RuntimeException("Session info error");
        }
        if (StringUtils.isNullOrEmpty((String)((TunnelWriteSessionInfo)this.sessionInfo).getUploadId())) {
            return;
        }
        try {
            TableTunnel tunnel = Util.getTableTunnel(this.project);
            if (this.partitionSpec.isEmpty()) {
                this.session = tunnel.getUploadSession(this.project, this.table, ((TunnelWriteSessionInfo)this.sessionInfo).getUploadId());
            } else {
                PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(this.partitionSpec);
                this.session = tunnel.getUploadSession(this.project, this.table, odpsPartitionSpec, ((TunnelWriteSessionInfo)this.sessionInfo).getUploadId());
            }
        }
        catch (TunnelException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TableSchema getTableSchema() {
        if (this.tableSchema == null) {
            Odps odps = CupidSession.get().odps();
            odps.setDefaultProject(this.project);
            this.tableSchema = odps.tables().get(this.table).getSchema();
        }
        return this.tableSchema;
    }

    public WriteSessionInfo getOrCreateSessionInfo() throws IOException {
        WriteSessionInfo sessionInfo;
        if (this.sessionInfo != null) {
            return this.sessionInfo;
        }
        this.init();
        if (this.partitionSpec.isEmpty()) {
            this.session = Util.createUploadSession(this.project, this.table, null, this.overwrite);
            sessionInfo = this.getSessionInfoInternal(this.session, this.partitionSpec);
        } else if (this.partitionSpec.values().stream().anyMatch(Objects::isNull)) {
            sessionInfo = new TunnelWriteSessionInfo(this.project, this.table, this.dataColumns, this.partitionColumns, this.partitionSpec, "", this.overwrite);
        } else {
            PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(this.partitionSpec);
            this.session = Util.createUploadSession(this.project, this.table, odpsPartitionSpec, this.overwrite);
            sessionInfo = this.getSessionInfoInternal(this.session, this.partitionSpec);
        }
        this.sessionInfo = sessionInfo;
        return this.sessionInfo;
    }

    private void init() {
        String type;
        if (this.tableSchema == null) {
            this.tableSchema = this.getTableSchema();
        }
        this.dataColumns = new ArrayList<Attribute>();
        for (Column c : this.tableSchema.getColumns()) {
            type = c.getTypeInfo().getTypeName();
            this.dataColumns.add(new Attribute(c.getName(), type));
        }
        this.partitionColumns = new ArrayList<Attribute>();
        for (Column c : this.tableSchema.getPartitionColumns()) {
            type = c.getTypeInfo().getTypeName();
            this.partitionColumns.add(new Attribute(c.getName(), type));
        }
    }

    private WriteSessionInfo getSessionInfoInternal(TableTunnel.UploadSession session, Map<String, String> partitionSpec) {
        return new TunnelWriteSessionInfo(this.project, this.table, this.dataColumns, this.partitionColumns, partitionSpec, session.getId(), this.overwrite);
    }

    public void commitTable() throws IOException {
        if (this.session == null) {
            throw new UnsupportedOperationException("Dynamic partition not support commit table");
        }
        try {
            this.session.commit();
        }
        catch (TunnelException e) {
            throw new IOException(e);
        }
    }

    public void commitTableWithPartitions(List<Map<String, String>> partitionSpecs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void commitClusteredTable(List<BucketFileInfo> partitionSpecs) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void commitTableWithMessage(List<WriterCommitMessage> commitMessages) throws IOException {
        TableTunnel tunnel = Util.getTableTunnel(this.project);
        for (WriterCommitMessage commitMessage : commitMessages) {
            if (commitMessage instanceof TunnelDynamicWriteMsg) {
                TunnelDynamicWriteMsg msg = (TunnelDynamicWriteMsg)commitMessage;
                try {
                    if (msg.getPartitionSpec().isEmpty()) {
                        throw new InvalidParameterException("Tunnel dynamic partition is empty");
                    }
                    PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(msg.getPartitionSpec());
                    this.session = tunnel.getUploadSession(this.project, this.table, odpsPartitionSpec, msg.getUploadId());
                }
                catch (TunnelException e) {
                    throw new RuntimeException(e);
                }
                this.commitTable();
                continue;
            }
            if (commitMessage instanceof TunnelWriteMsg) {
                this.commitTable();
                return;
            }
            throw new UnsupportedOperationException("commit message must be tunnel writer commit message");
        }
    }

    public void cleanup() throws IOException {
    }
}

