/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.reader.SplitReader;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelInputSplit;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.Util;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.type.TypeInfoParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TunnelReader
implements SplitReader<ArrayRecord> {
    private TunnelInputSplit inputSplit;
    private TunnelRecordReader reader;
    private Record currentRecord = null;
    private long rowsRead = 0L;
    private boolean isClosed;

    TunnelReader(TunnelInputSplit inputSplit) {
        this.inputSplit = inputSplit;
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void init() throws IOException {
        TableTunnel.DownloadSession session;
        String project = this.inputSplit.getProject();
        String table = this.inputSplit.getTable();
        Map partitionSpec = this.inputSplit.getPartitionSpec();
        String downloadId = this.inputSplit.getDownloadId();
        long startIndex = this.inputSplit.getStartIndex();
        long numRecord = this.inputSplit.getNumRecord();
        List requiredColumns = this.inputSplit.getReadDataColumns();
        TableTunnel tunnel = Util.getTableTunnel(project);
        if (partitionSpec == null || partitionSpec.isEmpty()) {
            try {
                session = tunnel.getDownloadSession(project, table, downloadId);
            }
            catch (TunnelException e) {
                throw new IOException(e);
            }
        }
        try {
            PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(partitionSpec);
            session = tunnel.getDownloadSession(project, table, odpsPartitionSpec, downloadId);
        }
        catch (TunnelException e) {
            throw new IOException(e);
        }
        ArrayList<Column> readDataColumns = new ArrayList<Column>();
        for (Attribute c : requiredColumns) {
            readDataColumns.add(new Column(c.getName(), TypeInfoParser.getTypeInfoFromTypeString((String)c.getType())));
        }
        if (requiredColumns.isEmpty()) {
            List dataColumns = this.inputSplit.getDataColumns();
            if (!dataColumns.isEmpty()) {
                readDataColumns.add(new Column(((Attribute)dataColumns.get(0)).getName(), TypeInfoParser.getTypeInfoFromTypeString((String)((Attribute)dataColumns.get(0)).getType())));
            } else {
                throw new RuntimeException("Empty column is not supported by tunnel table provider");
            }
        }
        try {
            this.reader = session.openRecordReader(startIndex, numRecord, true, readDataColumns);
        }
        catch (TunnelException e) {
            throw new IOException(e);
        }
        this.isClosed = false;
    }

    public void close() throws IOException {
        if (this.isClosed) {
            return;
        }
        this.reader.close();
        this.isClosed = true;
    }

    public long getBytesRead() {
        return this.reader.getTotalBytes();
    }

    public long getRowsRead() {
        return this.rowsRead;
    }

    public boolean hasNext() {
        return this.rowsRead < this.inputSplit.getNumRecord();
    }

    public ArrayRecord next() {
        try {
            this.currentRecord = this.reader.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ++this.rowsRead;
        return (ArrayRecord)this.currentRecord;
    }
}

