/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.tunnel.impl;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.table.v1.Attribute;
import com.aliyun.odps.cupid.table.v1.reader.InputSplit;
import com.aliyun.odps.cupid.table.v1.reader.RequiredSchema;
import com.aliyun.odps.cupid.table.v1.reader.TableReadSession;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelInputSplit;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.Util;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TunnelReadSession
extends TableReadSession {
    private static final long DEFAULT_AVERAGE_RECORD_SIZE = 1024L;
    private static final long MIN_AVERAGE_RECORD_SIZE = 256L;
    private InputSplit[] inputSplits = null;
    private List<Attribute> dataColumns;
    private List<Attribute> partitionColumns;
    private List<Attribute> requiredColumns;

    TunnelReadSession(String project, String table, TableSchema tableSchema, RequiredSchema readDataColumns, List<Map<String, String>> partitionSpecs) {
        super(project, table, tableSchema, readDataColumns, partitionSpecs);
    }

    public TableSchema getTableSchema() {
        if (this.tableSchema == null) {
            Odps odps = CupidSession.get().odps();
            odps.setDefaultProject(this.project);
            this.tableSchema = odps.tables().get(this.table).getSchema();
        }
        return this.tableSchema;
    }

    public InputSplit[] getOrCreateInputSplits(int splitSizeInMB) throws IOException {
        if (splitSizeInMB <= 0) {
            throw new IllegalArgumentException("Expect positive split size, got: " + splitSizeInMB);
        }
        if (this.inputSplits != null) {
            return this.inputSplits;
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        Odps odps = CupidSession.get().odps();
        odps.setDefaultProject(this.project);
        TableTunnel tunnel = new TableTunnel(odps);
        this.init();
        if (this.partitionSpecs == null || this.partitionSpecs.isEmpty()) {
            long size = odps.tables().get(this.table).getSize();
            try {
                TableTunnel.DownloadSession session = tunnel.createDownloadSession(this.project, this.table);
                splits.addAll(this.getInputSplitsInternal(session, size, splitSizeInMB, null));
            }
            catch (TunnelException e) {
                throw new IOException(e);
            }
        } else {
            for (Map partitionSpec : this.partitionSpecs) {
                PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(partitionSpec);
                long size = odps.tables().get(this.table).getPartition(odpsPartitionSpec).getSize();
                try {
                    TableTunnel.DownloadSession session = tunnel.createDownloadSession(this.project, this.table, odpsPartitionSpec);
                    splits.addAll(this.getInputSplitsInternal(session, size, splitSizeInMB, partitionSpec));
                }
                catch (TunnelException e) {
                    throw new IOException(e);
                }
            }
        }
        this.inputSplits = splits.toArray(new InputSplit[0]);
        return this.inputSplits;
    }

    private void init() {
        String type;
        if (this.tableSchema == null) {
            this.tableSchema = this.getTableSchema();
        }
        this.dataColumns = new ArrayList<Attribute>();
        for (Column c : this.tableSchema.getColumns()) {
            type = c.getTypeInfo().getTypeName();
            this.dataColumns.add(new Attribute(c.getName(), type));
        }
        this.partitionColumns = new ArrayList<Attribute>();
        for (Column c : this.tableSchema.getPartitionColumns()) {
            type = c.getTypeInfo().getTypeName();
            this.partitionColumns.add(new Attribute(c.getName(), type));
        }
        this.requiredColumns = new ArrayList<Attribute>();
        if (this.readDataColumns.getType().equals((Object)RequiredSchema.Type.COLUMNS_SPECIFIED)) {
            Set readColumnsName = this.readDataColumns.toList().stream().map(Attribute::getName).collect(Collectors.toSet());
            this.requiredColumns = this.dataColumns.stream().filter(attr -> readColumnsName.contains(attr.getName())).collect(Collectors.toList());
        } else {
            this.requiredColumns.addAll(this.dataColumns);
        }
    }

    private List<InputSplit> getInputSplitsInternal(TableTunnel.DownloadSession session, long size, int splitSizeInMB, Map<String, String> partitionSpec) {
        long numRecordPerSplit;
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        String downloadId = session.getId();
        long recordCount = session.getRecordCount();
        long averageRecordSize = recordCount == 0L ? 1024L : size / recordCount;
        if (averageRecordSize == 0L) {
            averageRecordSize = 256L;
        }
        if ((numRecordPerSplit = (long)(splitSizeInMB * 1024 * 1024) / averageRecordSize) == 0L) {
            throw new IllegalArgumentException("Expect larger split size, got: " + splitSizeInMB);
        }
        long numSplits = recordCount / numRecordPerSplit;
        long remainder = recordCount % numRecordPerSplit;
        for (long i = 0L; i < numSplits; ++i) {
            long startIndex = i * numRecordPerSplit;
            TunnelInputSplit split = new TunnelInputSplit(this.project, this.table, this.dataColumns, this.partitionColumns, this.requiredColumns, partitionSpec, downloadId, startIndex, numRecordPerSplit);
            splits.add(split);
        }
        if (remainder != 0L) {
            long startIndex = numSplits * numRecordPerSplit;
            TunnelInputSplit lastSplit = new TunnelInputSplit(this.project, this.table, this.dataColumns, this.partitionColumns, this.requiredColumns, partitionSpec, downloadId, startIndex, remainder);
            splits.add(lastSplit);
        }
        return splits;
    }
}

