/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.cupid.table.v1.tunnel.impl;

import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelWriteSessionInfo;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.TunnelWriter;
import com.aliyun.odps.cupid.table.v1.tunnel.impl.Util;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelBufferedWriter;
import java.io.IOException;
import java.util.Map;

public class TunnelBufferWriter
extends TunnelWriter {
    private final long writerShares;

    public TunnelBufferWriter(TunnelWriteSessionInfo sessionInfo, long blockId, int writerShares) {
        super(sessionInfo, blockId, null);
        this.writerShares = writerShares;
    }

    @Override
    protected void init() throws IOException {
        String project = this.sessionInfo.getProject();
        String table = this.sessionInfo.getTable();
        Map partitionSpec = this.sessionInfo.getPartitionSpec();
        String uploadId = this.sessionInfo.getUploadId();
        TableTunnel tunnel = Util.getTableTunnel(project);
        if (partitionSpec == null || partitionSpec.isEmpty()) {
            try {
                this.session = tunnel.getUploadSession(project, table, uploadId, this.writerShares, this.blockId);
            }
            catch (TunnelException e) {
                throw new IOException(e);
            }
        }
        try {
            PartitionSpec odpsPartitionSpec = Util.toOdpsPartitionSpec(partitionSpec);
            this.session = tunnel.getUploadSession(project, table, odpsPartitionSpec, uploadId, this.writerShares, this.blockId);
        }
        catch (TunnelException e) {
            throw new IOException(e);
        }
        try {
            boolean compress = CupidSession.getConf().getBoolean("odps.cupid.writer.compress.enable", true);
            this.writer = this.session.openBufferedWriter(compress);
            long bufferSize = CupidSession.getConf().getLong("odps.cupid.writer.buffer.size", 0x8000000L);
            ((TunnelBufferedWriter)this.writer).setBufferSize(bufferSize);
        }
        catch (TunnelException | InterruptedException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getBytesWritten() {
        try {
            return ((TunnelBufferedWriter)this.writer).getTotalBytes();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

