/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkHadoopUtil;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkHadoopUtil$
implements Logging {
    public static SparkHadoopUtil$ MODULE$;
    private SparkHadoopUtil instance;
    private Seq<Map.Entry<String, String>> hiveConfKeys;
    private final String SPARK_YARN_CREDS_TEMP_EXTENSION;
    private final String SPARK_YARN_CREDS_COUNTER_DELIM;
    private final int UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    private final String SPARK_HADOOP_CONF_FILE;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    static {
        new SparkHadoopUtil$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkHadoopUtil instance$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.instance = new SparkHadoopUtil();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.instance;
    }

    private SparkHadoopUtil instance() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.instance$lzycompute() : this.instance;
    }

    public String SPARK_YARN_CREDS_TEMP_EXTENSION() {
        return this.SPARK_YARN_CREDS_TEMP_EXTENSION;
    }

    public String SPARK_YARN_CREDS_COUNTER_DELIM() {
        return this.SPARK_YARN_CREDS_COUNTER_DELIM;
    }

    public int UPDATE_INPUT_METRICS_INTERVAL_RECORDS() {
        return this.UPDATE_INPUT_METRICS_INTERVAL_RECORDS;
    }

    public String SPARK_HADOOP_CONF_FILE() {
        return this.SPARK_HADOOP_CONF_FILE;
    }

    public SparkHadoopUtil get() {
        return this.instance();
    }

    /*
     * WARNING - void declaration
     */
    public Configuration newConfiguration(SparkConf conf) {
        void var2_2;
        Configuration hadoopConf = new Configuration();
        this.org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(conf, hadoopConf);
        this.appendODPSAndUpdateSparkHadoopConfigurations(conf, hadoopConf);
        return var2_2;
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendS3AndSparkHadoopHiveConfigurations(SparkConf conf, Configuration hadoopConf) {
        block2: {
            if (conf == null) break block2;
            String keyId = System.getenv("AWS_ACCESS_KEY_ID");
            String accessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
            if (keyId != null && accessKey != null) {
                hadoopConf.set("fs.s3.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3n.awsAccessKeyId", keyId);
                hadoopConf.set("fs.s3a.access.key", keyId);
                hadoopConf.set("fs.s3.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3n.awsSecretAccessKey", accessKey);
                hadoopConf.set("fs.s3a.secret.key", accessKey);
                String sessionToken = System.getenv("AWS_SESSION_TOKEN");
                if (sessionToken != null) {
                    hadoopConf.set("fs.s3a.session.token", sessionToken);
                }
            }
            this.appendHiveConfigs(hadoopConf);
            this.org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(conf, hadoopConf);
            this.appendSparkHiveConfigs(conf, hadoopConf);
            String bufferSize = conf.get(package$.MODULE$.BUFFER_SIZE()).toString();
            hadoopConf.set("io.file.buffer.size", bufferSize);
        }
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys$lzycompute() {
        SparkHadoopUtil$ sparkHadoopUtil$ = this;
        synchronized (sparkHadoopUtil$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                Nil$ nil$;
                URL configFile = Utils$.MODULE$.getContextOrSparkClassLoader().getResource("hive-site.xml");
                if (configFile != null) {
                    Configuration conf = new Configuration(false);
                    conf.addResource(configFile);
                    nil$ = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(conf.iterator()).asScala()).toSeq();
                } else {
                    nil$ = Nil$.MODULE$;
                }
                this.hiveConfKeys = nil$;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.hiveConfKeys;
    }

    private Seq<Map.Entry<String, String>> hiveConfKeys() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.hiveConfKeys$lzycompute() : this.hiveConfKeys;
    }

    private void appendHiveConfigs(Configuration hadoopConf) {
        this.hiveConfKeys().foreach((Function1 & Serializable & scala.Serializable)kv -> {
            hadoopConf.set((String)kv.getKey(), (String)kv.getValue());
            return BoxedUnit.UNIT;
        });
    }

    public void org$apache$spark$deploy$SparkHadoopUtil$$appendSparkHadoopConfigs(SparkConf conf, Configuration hadoopConf) {
        block0: {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$4(check$ifrefutable$3))).withFilter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$5(x$13))).foreach((Function1 & Serializable & scala.Serializable)x$14 -> {
                SparkHadoopUtil$.$anonfun$appendSparkHadoopConfigs$6(hadoopConf, x$14);
                return BoxedUnit.UNIT;
            });
            if (!conf.getOption("spark.hadoop.mapreduce.fileoutputcommitter.algorithm.version").isEmpty()) break block0;
            hadoopConf.set("mapreduce.fileoutputcommitter.algorithm.version", "1");
        }
    }

    private void appendSparkHiveConfigs(SparkConf conf, Configuration hadoopConf) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$4(check$ifrefutable$4))).withFilter((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$5(x$15))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            SparkHadoopUtil$.$anonfun$appendSparkHiveConfigs$6(hadoopConf, x$16);
            return BoxedUnit.UNIT;
        });
    }

    private void appendODPSAndUpdateSparkHadoopConfigurations(SparkConf conf, Configuration hadoopConf) {
        block0: {
            this.validateConf(conf);
            if (conf == null) break block0;
            Object object = System.getenv("META_LOOKUP_NAME") == null ? (conf.get("spark.master", "").contains("yarn") ? (conf.getBoolean("spark.dynamicAllocation.enabled", false) ? conf.set("spark.hadoop.odps.cupid.vnet.capacity", ((Object)BoxesRunTime.boxToInteger((int)(conf.getInt("spark.dynamicAllocation.maxExecutors", 800) + 2))).toString()) : conf.set("spark.hadoop.odps.cupid.vnet.capacity", ((Object)BoxesRunTime.boxToInteger((int)(conf.getInt("spark.executor.instances", 1) + 2))).toString())) : BoxedUnit.UNIT) : BoxedUnit.UNIT;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])conf.getAll())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String value;
                String key;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    key = (String)tuple2._1();
                    value = (String)tuple2._2();
                    if (key.startsWith("spark.hadoop.")) {
                        hadoopConf.set(key.substring("spark.hadoop.".length()), value);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit = key.startsWith("spark.hadoop.odps") ? conf.set(key.substring("spark.hadoop.".length()), value) : BoxedUnit.UNIT;
                return boxedUnit;
            });
        }
    }

    private void validateConf(SparkConf conf) {
        if (conf != null) {
            if (conf.getSizeAsMb("spark.driver.memory", "1g") <= 0L || conf.getSizeAsMb("spark.driver.memory", "1g") > 204800L) {
                throw new SparkException("required driver memory exceeds 200g");
            }
            if (conf.getSizeAsMb("spark.driver.memoryOverhead", "1g") <= 0L || conf.getSizeAsMb("spark.driver.memoryOverhead", "1g") > 204800L) {
                throw new SparkException("required spark.driver.memoryOverhead exceeds 200g");
            }
            if (conf.getSizeAsMb("spark.yarn.am.memory", "1g") <= 0L || conf.getSizeAsMb("spark.yarn.am.memory", "1g") > 204800L) {
                throw new SparkException("required spark.yarn.am.memory exceeds 200g");
            }
            if (conf.getSizeAsMb("spark.yarn.am.memoryOverhead", "1g") <= 0L || conf.getSizeAsMb("spark.yarn.am.memoryOverhead", "1g") > 204800L) {
                throw new SparkException("required spark.yarn.am.memoryOverhead exceeds 200g");
            }
            if (conf.getSizeAsMb("spark.executor.memory", "1g") <= 0L || conf.getSizeAsMb("spark.executor.memory", "1g") > 204800L) {
                throw new SparkException("required executor memory exceeds 200g");
            }
            if (conf.getInt("spark.driver.cores", 1) <= 0 || conf.getInt("spark.driver.cores", 1) > 48) {
                throw new SparkException("required driver cores exceeds 48");
            }
            if (conf.getInt("spark.yarn.am.cores", 1) <= 0 || conf.getInt("spark.yarn.am.cores", 1) > 48) {
                throw new SparkException("required spark.yarn.am.cores exceeds 48");
            }
            if (conf.getInt("spark.executor.cores", 1) <= 0 || conf.getInt("spark.executor.cores", 1) > 48) {
                throw new SparkException("required executor cores exceeds 48");
            }
            if (conf.getInt("spark.executor.instances", 1) < 0 || conf.getInt("spark.executor.instances", 1) > 5000) {
                throw new SparkException("required executor instances exceeds 5000");
            }
            if (conf.getBoolean("spark.dynamicAllocation.enabled", false)) {
                if (conf.getInt("spark.dynamicAllocation.minExecutors", 0) < 0 || conf.getInt("spark.dynamicAllocation.minExecutors", 0) > 5000) {
                    throw new SparkException("required dynamic allocation min executors exceeds 5000");
                }
                if (conf.getInt("spark.dynamicAllocation.initialExecutors", 0) < 0 || conf.getInt("spark.dynamicAllocation.initialExecutors", 0) > 5000) {
                    throw new SparkException("required dynamic allocation initial executors exceeds 5000");
                }
                if (conf.getInt("spark.dynamicAllocation.maxExecutors", Integer.MAX_VALUE) < 0 || conf.getInt("spark.dynamicAllocation.maxExecutors", Integer.MAX_VALUE) > 5000) {
                    throw new SparkException("required dynamic allocation max executors exceeds 5000");
                }
            }
        }
    }

    public FSDataOutputStream createFile(FileSystem fs, Path path, boolean allowEC) {
        FSDataOutputStream fSDataOutputStream;
        if (allowEC) {
            fSDataOutputStream = fs.create(path);
        } else {
            try {
                Method builderMethod = fs.getClass().getMethod("createFile", Path.class);
                if (!fs.mkdirs(path.getParent())) {
                    throw new IOException(new StringBuilder(28).append("Failed to create parents of ").append(path).toString());
                }
                Path qualifiedPath = fs.makeQualified(path);
                Object builder = builderMethod.invoke((Object)fs, qualifiedPath);
                Class<?> builderCls = builder.getClass();
                Method replicateMethod = builderCls.getMethod("replicate", new Class[0]);
                Method buildMethod = builderCls.getMethod("build", new Class[0]);
                Object b2 = replicateMethod.invoke(builder, new Object[0]);
                fSDataOutputStream = (FSDataOutputStream)buildMethod.invoke(b2, new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                fSDataOutputStream = fs.create(path);
            }
        }
        return fSDataOutputStream;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$4(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHadoopConfigs$5(Tuple2 x$13) {
        Tuple2 tuple2 = x$13;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hadoop.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHadoopConfigs$6(Configuration hadoopConf$2, Tuple2 x$14) {
        Tuple2 tuple2 = x$14;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$2.set(key.substring("spark.hadoop.".length()), value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$4(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$appendSparkHiveConfigs$5(Tuple2 x$15) {
        Tuple2 tuple2 = x$15;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = key.startsWith("spark.hive.");
        return bl;
    }

    public static final /* synthetic */ void $anonfun$appendSparkHiveConfigs$6(Configuration hadoopConf$3, Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        String value = (String)tuple2._2();
        hadoopConf$3.set(key.substring("spark.".length()), value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private SparkHadoopUtil$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.SPARK_YARN_CREDS_TEMP_EXTENSION = ".tmp";
        this.SPARK_YARN_CREDS_COUNTER_DELIM = "-";
        this.UPDATE_INPUT_METRICS_INTERVAL_RECORDS = 1000;
        this.SPARK_HADOOP_CONF_FILE = "__spark_hadoop_conf__.xml";
    }
}

