/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.proto.ProtobufRecordStreamReader;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.RawTunnelRecordReader;
import com.aliyun.odps.tunnel.io.TunnelRecordReader$AjcClosure1;
import com.aliyun.odps.tunnel.io.TunnelRecordReader$AjcClosure3;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TunnelRecordReader
extends ProtobufRecordStreamReader {
    public static final int DEFAULT_CONNECT_TIMEOUT = 30;
    public static final int DEFAULT_CONNECT_RETRYTIMES = 4;
    private int retryTimes;
    private int retryCount;
    private long start;
    private long count;
    private long offset;
    private long sizeLimit;
    private long bytesReaded;
    private boolean isClosed;
    private List<Column> columnList;
    private CompressOption option;
    private RestClient tunnelServiceClient;
    private TableTunnel.DownloadSession tableSession;
    private InstanceTunnel.DownloadSession instanceSession;
    private RawTunnelRecordReader reader;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    @Deprecated
    public TunnelRecordReader(TableSchema schema, Connection conn, CompressOption option) throws IOException {
        super(schema, conn.getInputStream(), option);
        TunnelRecordReader ajc$this;
        TableSchema tableSchema = schema;
        Connection connection = conn;
        CompressOption compressOption = option;
        Object[] objectArray = new Object[]{tableSchema, connection, compressOption};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)ajc$this, (Object)ajc$this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{ajc$this, tableSchema, connection, compressOption, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new TunnelRecordReader$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @Deprecated
    public TunnelRecordReader(TableSchema schema, List<Column> columns, Connection conn, CompressOption option) throws IOException {
        super(schema, columns, conn.getInputStream(), option);
        TunnelRecordReader ajc$this;
        TableSchema tableSchema = schema;
        List<Column> list = columns;
        Connection connection = conn;
        CompressOption compressOption = option;
        Object[] objectArray = new Object[]{tableSchema, list, connection, compressOption};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)ajc$this, (Object)ajc$this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{ajc$this, tableSchema, list, connection, compressOption, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new TunnelRecordReader$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public TunnelRecordReader(long start, long count, List<Column> columns, CompressOption option, RestClient tunnelRestClient, TableTunnel.DownloadSession session) throws TunnelException, IOException {
        this.retryTimes = 4;
        this.retryCount = 0;
        this.start = 0L;
        this.count = 0L;
        this.offset = 0L;
        this.sizeLimit = 0L;
        this.bytesReaded = 0L;
        this.isClosed = false;
        this.start = start;
        this.count = count;
        this.offset = 0L;
        this.option = option;
        this.columnList = columns;
        this.tableSession = session;
        this.reader = null;
        this.instanceSession = null;
        this.tunnelServiceClient = tunnelRestClient;
        this.createNewReader();
    }

    @Override
    public void setTransform(boolean shouldTransform) {
        this.shouldTransform = shouldTransform;
        this.reader.setTransform(shouldTransform);
    }

    public TunnelRecordReader(long start, long count, List<Column> columns, CompressOption option, RestClient tunnelRestClient, InstanceTunnel.DownloadSession session) throws TunnelException, IOException {
        this.retryTimes = 4;
        this.retryCount = 0;
        this.start = 0L;
        this.count = 0L;
        this.offset = 0L;
        this.sizeLimit = 0L;
        this.bytesReaded = 0L;
        this.isClosed = false;
        this.start = start;
        this.count = count;
        this.offset = 0L;
        this.option = option;
        this.columnList = columns;
        this.tableSession = null;
        this.instanceSession = session;
        this.reader = null;
        this.tunnelServiceClient = tunnelRestClient;
        this.createNewReader();
    }

    public TunnelRecordReader(long start, long count, long sizeLimit, List<Column> columns, CompressOption option, RestClient tunnelRestClient, InstanceTunnel.DownloadSession session) throws TunnelException, IOException {
        this.retryTimes = 4;
        this.retryCount = 0;
        this.start = 0L;
        this.count = 0L;
        this.offset = 0L;
        this.sizeLimit = 0L;
        this.bytesReaded = 0L;
        this.isClosed = false;
        this.start = start;
        this.count = count;
        this.sizeLimit = sizeLimit;
        this.offset = 0L;
        this.option = option;
        this.columnList = columns;
        this.tableSession = null;
        this.instanceSession = session;
        this.reader = null;
        this.tunnelServiceClient = tunnelRestClient;
        this.createNewReader();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
        this.isClosed = true;
    }

    @Override
    public Record read() throws IOException {
        return this.read(null);
    }

    @Override
    public Record read(Record reusedRecord) throws IOException {
        if (this.isClosed) {
            throw new IOException("Reader has been closed");
        }
        try {
            return this.readWithRetry(reusedRecord);
        }
        catch (TunnelException e) {
            throw new IOException(e);
        }
    }

    @Override
    public long getTotalBytes() {
        return this.bytesReaded + this.reader.getTotalBytes();
    }

    private boolean needRetry() {
        if (this.instanceSession == null) {
            return true;
        }
        return StringUtils.isNullOrEmpty((String)this.instanceSession.getTaskName());
    }

    private Record readWithRetry(Record reusedRecord) throws TunnelException, IOException {
        try {
            Record record = this.reader.read(reusedRecord);
            ++this.offset;
            return record;
        }
        catch (IOException e) {
            if (++this.retryCount > this.retryTimes || this.offset > this.count || !this.needRetry()) {
                throw e;
            }
            this.createNewReader();
            return this.readWithRetry(reusedRecord);
        }
    }

    private void createNewReader() throws TunnelException, IOException {
        while (this.retryCount <= this.retryTimes) {
            try {
                if (this.reader != null) {
                    this.bytesReaded += this.reader.getTotalBytes();
                    this.reader.close();
                }
                if (this.tableSession != null) {
                    this.reader = RawTunnelRecordReader.createTableTunnelReader(this.start + this.offset, this.count - this.offset, this.option, this.columnList, this.tunnelServiceClient, this.tableSession);
                    this.reader.setTransform(this.shouldTransform);
                }
                if (this.instanceSession != null) {
                    this.reader = RawTunnelRecordReader.createInstanceTunnelReader(this.start + this.offset, this.count - this.offset, this.sizeLimit, this.option, this.columnList, this.tunnelServiceClient, this.instanceSession, this.instanceSession.getIsLongPolling());
                    this.reader.setTransform(this.shouldTransform);
                }
                return;
            }
            catch (TunnelException e) {
                if (++this.retryCount == this.retryTimes || !this.needRetry()) {
                    throw e;
                }
                this.sleep(30L);
            }
            catch (IOException e) {
                if (++this.retryCount == this.retryTimes || !this.needRetry()) {
                    throw e;
                }
                this.sleep(30L);
            }
        }
    }

    private void sleep(long time) {
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static {
        TunnelRecordReader.ajc$preClinit();
    }

    static /* synthetic */ void init$_aroundBody0(TunnelRecordReader ajc$this, TableSchema schema, Connection conn, CompressOption option, JoinPoint joinPoint) {
        ajc$this.retryTimes = 4;
        ajc$this.retryCount = 0;
        ajc$this.start = 0L;
        ajc$this.count = 0L;
        ajc$this.offset = 0L;
        ajc$this.sizeLimit = 0L;
        ajc$this.bytesReaded = 0L;
        ajc$this.isClosed = false;
    }

    static /* synthetic */ void init$_aroundBody2(TunnelRecordReader ajc$this, TableSchema schema, List columns, Connection conn, CompressOption option, JoinPoint joinPoint) {
        ajc$this.retryTimes = 4;
        ajc$this.retryCount = 0;
        ajc$this.start = 0L;
        ajc$this.count = 0L;
        ajc$this.offset = 0L;
        ajc$this.sizeLimit = 0L;
        ajc$this.bytesReaded = 0L;
        ajc$this.isClosed = false;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TunnelRecordReader.java", TunnelRecordReader.class);
        ajc$tjp_0 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.aliyun.odps.tunnel.io.TunnelRecordReader", "com.aliyun.odps.TableSchema:com.aliyun.odps.commons.transport.Connection:com.aliyun.odps.tunnel.io.CompressOption", "schema:conn:option", "java.io.IOException"), 53);
        ajc$tjp_1 = factory.makeSJP("constructor-execution", (Signature)factory.makeConstructorSig("1", "com.aliyun.odps.tunnel.io.TunnelRecordReader", "com.aliyun.odps.TableSchema:java.util.List:com.aliyun.odps.commons.transport.Connection:com.aliyun.odps.tunnel.io.CompressOption", "schema:columns:conn:option", "java.io.IOException"), 53);
    }
}

