/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel.io;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.data.ArrowRecordWriter;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.ArrowHttpOutputStream;
import com.aliyun.odps.tunnel.io.ArrowTunnelRecordWriter$AjcClosure1;
import com.aliyun.odps.tunnel.io.CompressOption;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.WritableByteChannel;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.xerial.snappy.SnappyFramedOutputStream;

public class ArrowTunnelRecordWriter
implements ArrowRecordWriter {
    private TableTunnel.UploadSession tableSession;
    private ArrowHttpOutputStream outputStream;
    private Connection connection;
    private boolean isClosed;
    private CompressOption compress;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ArrowTunnelRecordWriter(TableTunnel.UploadSession tableSession, Connection connection, CompressOption option) {
        this.tableSession = tableSession;
        this.connection = connection;
        this.isClosed = false;
        this.compress = option;
    }

    @Override
    public void write(VectorSchemaRoot root) throws IOException {
        if (this.isClosed) {
            throw new IOException("Arrow writer is closed");
        }
        if (this.outputStream == null) {
            OutputStream wr = this.connection.getOutputStream();
            if (this.compress != null && !this.compress.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_RAW)) {
                if (this.compress.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_ZLIB)) {
                    Deflater def = new Deflater();
                    def.setLevel(this.compress.level);
                    def.setStrategy(this.compress.strategy);
                    wr = new DeflaterOutputStream(wr, def);
                } else if (this.compress.algorithm.equals((Object)CompressOption.CompressAlgorithm.ODPS_SNAPPY)) {
                    wr = new SnappyFramedOutputStream(wr);
                } else {
                    throw new IOException("invalid compression option.");
                }
            }
            this.outputStream = new ArrowHttpOutputStream(wr);
        }
        if (root.getRowCount() == 0) {
            return;
        }
        WriteChannel writeChannel = new WriteChannel((WritableByteChannel)this.outputStream);
        VectorUnloader loader = new VectorUnloader(root);
        ArrowRecordBatch recordBatch = loader.getRecordBatch();
        try {
            MessageSerializer.serialize((WriteChannel)writeChannel, (ArrowRecordBatch)recordBatch);
        }
        catch (IOException e) {
            throw new IOException("ArrowHttpOutputStream Serialize Exception", e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.isClosed) {
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                Connection connection = this.connection;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
                Object[] objectArray = new Object[]{this, connection, joinPoint};
                Response response = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new ArrowTunnelRecordWriter$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
                if (!response.isOK()) {
                    TunnelException exception = new TunnelException(response.getHeader("x-odps-request-id"), this.connection.getInputStream(), response.getStatus());
                    throw new IOException(exception.getMessage(), exception);
                }
            }
            finally {
                this.connection.disconnect();
                this.isClosed = true;
            }
        }
    }

    static {
        ArrowTunnelRecordWriter.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(ArrowTunnelRecordWriter arrowTunnelRecordWriter, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ArrowTunnelRecordWriter.java", ArrowTunnelRecordWriter.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 97);
    }
}

