/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.StreamUploadSessionImpl$AjcClosure1;
import com.aliyun.odps.tunnel.StreamUploadSessionImpl$AjcClosure3;
import com.aliyun.odps.tunnel.StreamUploadSessionImpl$AjcClosure5;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.ProtobufRecordPack;
import com.aliyun.odps.tunnel.io.StreamRecordPackImpl;
import com.aliyun.odps.utils.ConnectionWatcher;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class StreamUploadSessionImpl
implements TableTunnel.StreamUploadSession {
    private String id;
    private Configuration conf;
    private TableSchema schema = new TableSchema();
    private String projectName;
    private String tableName;
    private String partitionSpec;
    private RestClient tunnelServiceClient;
    private Slots slots;
    private boolean p2pMode = false;
    private List<Column> columns;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    StreamUploadSessionImpl(String projectName, String tableName, String partitionSpec, Configuration config, long slotNum, boolean createPartition, List<Column> columns) throws TunnelException {
        this.conf = config;
        this.projectName = projectName;
        this.tableName = tableName;
        this.partitionSpec = partitionSpec;
        this.columns = columns;
        this.tunnelServiceClient = this.conf.newRestClient(projectName);
        this.initiate(slotNum, createPartition);
    }

    private void initiate(long slotNum, boolean createPartition) throws TunnelException {
        block17: {
            HashMap<String, String> params = new HashMap<String, String>();
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            if (createPartition) {
                params.put("create_partition", "");
            }
            if (this.columns != null && this.columns.size() != 0) {
                params.put("zorder_columns", this.getColumnString());
            }
            HashMap<String, String> headers = TableTunnel.getCommonHeader();
            if (slotNum > 0L) {
                headers.put("odps-tunnel-slot-num", String.valueOf(slotNum));
            }
            String requestId = null;
            Connection conn = null;
            try {
                Connection connection = conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
                Object[] objectArray = new Object[]{this, connection, joinPoint};
                Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamUploadSessionImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
                requestId = resp.getHeader("x-odps-request-id");
                if (resp.isOK()) {
                    this.loadFromJson(requestId, conn.getInputStream(), false);
                    break block17;
                }
                throw new TunnelException(requestId, conn.getInputStream(), resp.getStatus());
            }
            catch (IOException e) {
                throw new TunnelException(requestId, "Failed to create upload session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(requestId, e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void reload(String server) throws TunnelException {
        block14: {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("uploadid", this.id);
            if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
                params.put("partition", this.partitionSpec);
            }
            HashMap<String, String> headers = TableTunnel.getCommonHeader();
            Connection conn = null;
            String requestId = null;
            try {
                Connection connection = conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection);
                Object[] objectArray = new Object[]{this, connection, joinPoint};
                Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamUploadSessionImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
                requestId = resp.getHeader("x-odps-request-id");
                if (resp.isOK()) {
                    this.loadFromJson(requestId, conn.getInputStream(), true);
                    break block14;
                }
                throw new TunnelException(requestId, conn.getInputStream(), resp.getStatus());
            }
            catch (IOException e) {
                throw new TunnelException(requestId, "Failed to reload upload session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
            }
            catch (TunnelException e) {
                throw e;
            }
            catch (OdpsException e) {
                throw new TunnelException(requestId, e.getMessage(), e);
            }
            finally {
                if (conn != null) {
                    try {
                        conn.disconnect();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void loadFromJson(String requestId, InputStream is, boolean reload) throws TunnelException {
        String json = "";
        try {
            json = IOUtils.readStreamAsString(is);
            JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
            if (!reload) {
                if (tree.has("session_name") && tree.has("schema")) {
                    this.id = tree.get("session_name").getAsString();
                    JsonObject tunnelTableSchema = tree.get("schema").getAsJsonObject();
                    this.schema = new TunnelTableSchema(tunnelTableSchema);
                } else {
                    throw new TunnelException(requestId, "Incomplete session info: '" + json + "'");
                }
            }
            if (tree.has("slots") && tree.has("status")) {
                String status = tree.get("status").getAsString();
                if (status.equals("init")) {
                    throw new TunnelException(requestId, "Session is initiating. Session name: " + this.id);
                }
            } else {
                throw new TunnelException(requestId, "Incomplete session info: '" + json + "'");
            }
            this.slots = new Slots(tree.getAsJsonArray("slots"), reload);
        }
        catch (TunnelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TunnelException(requestId, "Invalid json content: '" + json + "'", e);
        }
    }

    public void reloadSlots(Slot slot, String server, int slotNum) throws TunnelException {
        if (this.slots.getSlotNum() != slotNum) {
            this.reload(slot.getServer());
        } else if (!slot.getServer().equals(server)) {
            slot.setServer(server, false);
        }
    }

    private Connection getConnection(CompressOption compress, Slot slot, long size, long reocrdCount) throws OdpsException, IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uploadid", this.id);
        params.put("slotid", slot.getSlot());
        if (this.partitionSpec != null && this.partitionSpec.length() > 0) {
            params.put("partition", this.partitionSpec);
        }
        if (reocrdCount > 0L) {
            params.put("record_count", String.valueOf(reocrdCount));
        }
        if (this.columns != null && this.columns.size() != 0) {
            params.put("zorder_columns", this.getColumnString());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (size < 0L) {
            headers.put("Transfer-Encoding", "chunked");
        } else {
            headers.put("Content-Length", String.valueOf(size));
        }
        headers.put("Content-Type", "application/octet-stream");
        headers.put("x-odps-tunnel-version", String.valueOf(4));
        headers.put("odps-tunnel-slot-num", String.valueOf(this.slots.getSlotNum()));
        switch (compress.algorithm) {
            case ODPS_RAW: {
                break;
            }
            case ODPS_ZLIB: {
                headers.put("Content-Encoding", "deflate");
                break;
            }
            case ODPS_SNAPPY: {
                headers.put("Content-Encoding", "x-snappy-framed");
                break;
            }
            default: {
                throw new TunnelException("unsupported compression option.");
            }
        }
        headers.put("odps-tunnel-routed-server", slot.getServer());
        if (this.p2pMode) {
            try {
                URI u = new URI(this.tunnelServiceClient.getEndpoint());
                return this.tunnelServiceClient.connect(this.getResource(), "PUT", params, headers, u.getScheme() + "://" + slot.getIp());
            }
            catch (URISyntaxException e) {
                throw new TunnelException("Invalid endpoint: " + this.tunnelServiceClient.getEndpoint());
            }
        }
        return this.tunnelServiceClient.connect(this.getResource(), "PUT", params, headers);
    }

    private String getResource() {
        return this.conf.getResource(this.projectName, this.tableName) + "/" + "streams";
    }

    public String writeBlock(ProtobufRecordPack pack) throws IOException {
        return this.writeBlock(pack, 0L);
    }

    public String writeBlock(ProtobufRecordPack pack, long timeout) throws IOException {
        Connection conn = null;
        try {
            Slot slot = this.slots.iterator().next();
            conn = this.getConnection(pack.getCompressOption(), slot, pack.getTotalBytes(), pack.getSize());
            String string = this.sendBlock(pack, conn, slot, timeout);
            return string;
        }
        catch (OdpsException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            if (null != conn) {
                conn.disconnect();
            }
        }
    }

    private String sendBlock(ProtobufRecordPack pack, Connection conn, Slot slot, long timeout) throws IOException, TunnelException {
        if (null == conn) {
            throw new IOException("Invalid connection");
        }
        ByteArrayOutputStream baos = pack.getProtobufStream();
        if (timeout > 0L) {
            ConnectionWatcher.getInstance().mark(conn, timeout);
        }
        Response response = null;
        try {
            baos.writeTo(conn.getOutputStream());
            conn.getOutputStream().close();
            baos.close();
            Connection connection = conn;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)connection);
            Object[] objectArray = new Object[]{this, connection, joinPoint};
            response = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new StreamUploadSessionImpl$AjcClosure5(objectArray).linkClosureAndJoinPoint(4112));
        }
        catch (Throwable tr) {
            if (timeout > 0L && ConnectionWatcher.getInstance().checkTimedOut(conn)) {
                throw new SocketTimeoutException("Flush time exceeded timeout user set: " + timeout + "ms");
            }
            throw tr;
        }
        finally {
            if (timeout > 0L) {
                ConnectionWatcher.getInstance().release(conn);
            }
        }
        if (!response.isOK()) {
            TunnelException exception = new TunnelException(response.getHeader("x-odps-request-id"), conn.getInputStream(), response.getStatus());
            throw new IOException(exception.getMessage(), exception);
        }
        this.reloadSlots(slot, response.getHeader("odps-tunnel-routed-server"), Integer.valueOf(response.getHeader("odps-tunnel-slot-num")));
        return response.getHeader("x-odps-request-id");
    }

    private String getColumnString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.columns.size(); ++i) {
            sb.append(this.columns.get(i).getName());
            if (i == this.columns.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setP2pMode(boolean mode) {
        this.p2pMode = mode;
    }

    @Override
    public TableSchema getSchema() {
        return this.schema;
    }

    @Override
    public TableTunnel.StreamRecordPack newRecordPack() throws IOException {
        return new StreamRecordPackImpl(this, new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0));
    }

    @Override
    public TableTunnel.StreamRecordPack newRecordPack(CompressOption option) throws IOException {
        return new StreamRecordPackImpl(this, option);
    }

    @Override
    public Record newRecord() {
        return new ArrayRecord(this.schema.getColumns().toArray(new Column[0]));
    }

    static {
        StreamUploadSessionImpl.ajc$preClinit();
    }

    static /* synthetic */ Response getResponse_aroundBody0(StreamUploadSessionImpl streamUploadSessionImpl, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody2(StreamUploadSessionImpl streamUploadSessionImpl, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    static /* synthetic */ Response getResponse_aroundBody4(StreamUploadSessionImpl streamUploadSessionImpl, Connection connection, JoinPoint joinPoint) {
        return connection.getResponse();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StreamUploadSessionImpl.java", StreamUploadSessionImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 80);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 123);
        ajc$tjp_2 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 427);
    }

    private class Slots
    implements Iterable<Slot> {
        private Random rand = new Random();
        private final List<Slot> slots = new ArrayList<Slot>();
        private int curSlotIndex = -1;
        private Iterator<Slot> iter;

        public Slots(JsonArray slotElements, boolean reload) throws TunnelException {
            for (JsonElement slot : slotElements) {
                if (!slot.isJsonArray()) {
                    throw new TunnelException("Invalid slot routes");
                }
                JsonArray slotInfo = slot.getAsJsonArray();
                if (slotInfo.size() != 2) {
                    throw new TunnelException("Invalid slot routes");
                }
                this.slots.add(new Slot(slotInfo.get(0).getAsString(), slotInfo.get(1).getAsString(), reload));
            }
            if (this.slots.size() > 0) {
                this.curSlotIndex = this.rand.nextInt(this.slots.size());
            }
            this.iter = new Iterator<Slot>(){

                @Override
                public boolean hasNext() {
                    return Slots.this.curSlotIndex >= 0;
                }

                @Override
                public synchronized Slot next() {
                    if (this.hasNext()) {
                        if (Slots.this.curSlotIndex >= Slots.this.slots.size()) {
                            Slots.this.curSlotIndex = 0;
                        }
                        return (Slot)Slots.this.slots.get(Slots.this.curSlotIndex++);
                    }
                    return null;
                }
            };
        }

        @Override
        public Iterator<Slot> iterator() {
            return this.iter;
        }

        public int getSlotNum() {
            return this.slots.size();
        }
    }

    public class Slot {
        private String slot;
        private String ip;
        private int port;

        public Slot(String slot, String server, boolean reload) throws TunnelException {
            if (slot.isEmpty() || server.isEmpty()) {
                throw new TunnelException("Slot or Routed server is empty");
            }
            this.slot = slot;
            this.setServer(server, !reload);
        }

        public String getSlot() {
            return this.slot;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }

        public String getServer() {
            return this.ip + ":" + this.port;
        }

        public boolean equals(Slot slot) {
            return this.slot == slot.slot && this.ip == slot.ip && this.port == slot.port;
        }

        public void setServer(String server, boolean checkEmptyIp) throws TunnelException {
            String[] segs = server.split(":");
            if (segs.length != 2) {
                throw new TunnelException("Invalid slot format: " + server);
            }
            if (segs[0].isEmpty()) {
                if (checkEmptyIp) {
                    throw new TunnelException("Empty server ip: " + server);
                }
            } else {
                this.ip = segs[0];
            }
            this.port = Integer.valueOf(segs[1]);
        }
    }
}

