/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.tunnel;

import com.aliyun.odps.Column;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.commons.transport.Connection;
import com.aliyun.odps.commons.transport.Response;
import com.aliyun.odps.commons.util.IOUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.tunnel.Configuration;
import com.aliyun.odps.tunnel.InstanceTunnel$AjcClosure1;
import com.aliyun.odps.tunnel.InstanceTunnel$DownloadSession$AjcClosure1;
import com.aliyun.odps.tunnel.InstanceTunnel$DownloadSession$AjcClosure3;
import com.aliyun.odps.tunnel.TableTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.TunnelTableSchema;
import com.aliyun.odps.tunnel.io.CompressOption;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class InstanceTunnel {
    private Configuration config;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public InstanceTunnel(Odps odps) {
        this.config = new Configuration(odps);
    }

    public DownloadSession createDownloadSession(String projectName, String instanceID) throws TunnelException {
        return new DownloadSession(projectName, instanceID, null);
    }

    public DownloadSession createDownloadSession(String projectName, String instanceID, boolean limitEnabled) throws TunnelException {
        return new DownloadSession(projectName, instanceID, null, limitEnabled);
    }

    public DownloadSession createDirectDownloadSession(String projectName, String instanceID, String taskName, int queryId, boolean limitEnabled) throws TunnelException {
        if (limitEnabled) {
            return new DownloadSession(projectName, instanceID, true, taskName, queryId);
        }
        return new DownloadSession(projectName, instanceID, false, taskName, queryId);
    }

    @Deprecated
    public DownloadSession createDirectDownloadSession(String projectName, String instanceID, String taskName, int queryId) throws TunnelException {
        String string = projectName;
        String string2 = instanceID;
        String string3 = taskName;
        int n = queryId;
        Object[] objectArray = new Object[]{string, string2, string3, Conversions.intObject((int)n)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, string3, Conversions.intObject((int)n), joinPoint};
        return (DownloadSession)OdpsDeprecatedLogger.aspectOf().around(new InstanceTunnel$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private String getResource(String projectName, String instanceID) {
        return ResourceBuilder.buildInstanceResource(projectName, instanceID);
    }

    public void setEndpoint(String endpoint) {
        try {
            URI u = new URI(endpoint);
            this.config.setEndpoint(u);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid endpoint.");
        }
    }

    static {
        InstanceTunnel.ajc$preClinit();
    }

    static /* synthetic */ DownloadSession createDirectDownloadSession_aroundBody0(InstanceTunnel ajc$this, String projectName, String instanceID, String taskName, int queryId, JoinPoint joinPoint) {
        return ajc$this.new DownloadSession(projectName, instanceID, true, taskName, queryId);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("InstanceTunnel.java", InstanceTunnel.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "createDirectDownloadSession", "com.aliyun.odps.tunnel.InstanceTunnel", "java.lang.String:java.lang.String:java.lang.String:int", "projectName:instanceID:taskName:queryId", "com.aliyun.odps.tunnel.TunnelException", "com.aliyun.odps.tunnel.InstanceTunnel$DownloadSession"), 152);
    }

    public class DownloadSession {
        private final String instanceID;
        private String id;
        private String projectName;
        private long count;
        private boolean limitEnabled;
        private TableSchema schema = new TableSchema();
        private DownloadStatus status = DownloadStatus.UNKNOWN;
        private Configuration conf;
        private boolean shouldTransform = false;
        private RestClient tunnelServiceClient;
        private String taskName;
        private int queryId = -1;
        private boolean isLongPolling = false;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        public DownloadSession(String projectName, String instanceID, String downloadId) throws TunnelException {
            this(projectName, instanceID, downloadId, false);
        }

        private DownloadSession(String projectName, String instanceID, String downloadId, boolean limitEnabled) throws TunnelException {
            this.conf = InstanceTunnel.this.config;
            this.projectName = projectName;
            this.instanceID = instanceID;
            this.id = downloadId;
            this.limitEnabled = limitEnabled;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
            if (this.id == null) {
                this.initiate();
            } else {
                this.reload();
            }
        }

        private DownloadSession(String projectName, String instanceID, boolean limitEnabled, String taskName, int queryId) throws TunnelException {
            this.conf = InstanceTunnel.this.config;
            this.projectName = projectName;
            this.instanceID = instanceID;
            this.limitEnabled = limitEnabled;
            this.taskName = taskName;
            this.queryId = queryId;
            this.isLongPolling = true;
            this.tunnelServiceClient = this.conf.newRestClient(projectName);
        }

        public TunnelRecordReader openRecordReader(long start, long count) throws TunnelException, IOException {
            return this.openRecordReader(start, count, false);
        }

        public TunnelRecordReader openRecordReader(long start, long count, long sizeLimit) throws TunnelException, IOException {
            return this.openRecordReader(start, count, sizeLimit, false);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, long sizeLimit, boolean compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, sizeLimit, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress) throws TunnelException, IOException {
            return this.openRecordReader(start, count, compress, null);
        }

        public TunnelRecordReader openRecordReader(long start, long count, boolean compress, List<Column> columns) throws TunnelException, IOException {
            CompressOption option = compress ? this.conf.getCompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordReader(start, count, option, columns);
        }

        public TunnelRecordReader openRecordReader(long start, long count, long sizeLimit, boolean compress, List<Column> columns) throws TunnelException, IOException {
            CompressOption option = compress ? this.conf.getCompressOption() : new CompressOption(CompressOption.CompressAlgorithm.ODPS_RAW, 0, 0);
            return this.openRecordReader(start, count, sizeLimit, option, columns);
        }

        public TunnelRecordReader openRecordReader(long start, long count, CompressOption compress, List<Column> columns) throws TunnelException, IOException {
            TunnelRecordReader reader = new TunnelRecordReader(start, count, columns, compress, this.tunnelServiceClient, this);
            reader.setTransform(this.shouldTransform);
            return reader;
        }

        public TunnelRecordReader openRecordReader(long start, long count, long sizeLimit, CompressOption compress, List<Column> columns) throws TunnelException, IOException {
            TunnelRecordReader reader = new TunnelRecordReader(start, count, sizeLimit, columns, compress, this.tunnelServiceClient, this);
            reader.setTransform(this.shouldTransform);
            return reader;
        }

        private void initiate() throws TunnelException {
            block16: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = TableTunnel.getCommonHeader();
                params.put("downloads", null);
                if (this.limitEnabled) {
                    params.put("instance_tunnel_limit_enabled", null);
                }
                if (this.taskName != null) {
                    params.put("cached", null);
                    params.put("taskname", this.taskName);
                    if (this.queryId != -1) {
                        params.put("queryid", String.valueOf(this.queryId));
                    }
                }
                Connection conn = null;
                try {
                    Connection connection = conn = this.tunnelServiceClient.connect(this.getResource(), "POST", params, headers);
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)connection);
                    Object[] objectArray = new Object[]{this, connection, joinPoint};
                    Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new InstanceTunnel$DownloadSession$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        this.shouldTransform = StringUtils.equals((String)resp.getHeader("odps-tunnel-date-transform"), (String)"true");
                        break block16;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException("Failed to create download session with tunnel endpoint " + this.tunnelServiceClient.getEndpoint(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        private void reload() throws TunnelException {
            block13: {
                HashMap<String, String> params = new HashMap<String, String>();
                HashMap<String, String> headers = TableTunnel.getCommonHeader();
                params.put("downloadid", this.id);
                Connection conn = null;
                try {
                    Connection connection = conn = this.tunnelServiceClient.connect(this.getResource(), "GET", params, headers);
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)connection);
                    Object[] objectArray = new Object[]{this, connection, joinPoint};
                    Response resp = (Response)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new InstanceTunnel$DownloadSession$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112));
                    if (resp.isOK()) {
                        this.loadFromJson(conn.getInputStream());
                        this.shouldTransform = StringUtils.equals((String)resp.getHeader("odps-tunnel-date-transform"), (String)"true");
                        break block13;
                    }
                    TunnelException e = new TunnelException(conn.getInputStream());
                    e.setRequestId(resp.getHeader("x-odps-request-id"));
                    throw e;
                }
                catch (IOException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                catch (TunnelException e) {
                    throw e;
                }
                catch (OdpsException e) {
                    throw new TunnelException(e.getMessage(), e);
                }
                finally {
                    if (conn != null) {
                        try {
                            conn.disconnect();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }

        public TableSchema getSchema() {
            return this.schema;
        }

        public void setSchema(TableSchema schema) {
            this.schema = schema;
        }

        public long getRecordCount() {
            return this.count;
        }

        public void setRecordCount(long count) {
            this.count = count;
        }

        public String getProjectName() {
            return this.projectName;
        }

        public String getInstanceID() {
            return this.instanceID;
        }

        public String getTaskName() {
            return this.taskName;
        }

        public int getQueryId() {
            return this.queryId;
        }

        public boolean getIsLongPolling() {
            return this.isLongPolling;
        }

        public String getId() {
            return this.id;
        }

        public DownloadStatus getStatus() throws TunnelException, IOException {
            this.reload();
            return this.status;
        }

        public boolean getEnableLimit() {
            return this.limitEnabled;
        }

        private String getResource() {
            return InstanceTunnel.this.getResource(this.projectName, this.instanceID);
        }

        private void loadFromJson(InputStream is) throws TunnelException {
            try {
                String json = IOUtils.readStreamAsString(is);
                JsonObject tree = new JsonParser().parse(json).getAsJsonObject();
                if (tree.has("DownloadID")) {
                    this.id = tree.get("DownloadID").getAsString();
                }
                if (tree.has("Status")) {
                    String downloadStatus = tree.get("Status").getAsString().toUpperCase();
                    this.status = DownloadStatus.valueOf(downloadStatus);
                }
                if (tree.has("RecordCount")) {
                    this.count = tree.get("RecordCount").getAsLong();
                }
                if (tree.has("Schema")) {
                    JsonObject tunnelTableSchema = tree.get("Schema").getAsJsonObject();
                    this.schema = new TunnelTableSchema(tunnelTableSchema);
                }
            }
            catch (Exception e) {
                throw new TunnelException("Invalid json content.", e);
            }
        }

        static {
            DownloadSession.ajc$preClinit();
        }

        static /* synthetic */ Response getResponse_aroundBody0(DownloadSession downloadSession, Connection connection, JoinPoint joinPoint) {
            return connection.getResponse();
        }

        static /* synthetic */ Response getResponse_aroundBody2(DownloadSession downloadSession, Connection connection, JoinPoint joinPoint) {
            return connection.getResponse();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("InstanceTunnel.java", DownloadSession.class);
            ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 500);
            ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("401", "getResponse", "com.aliyun.odps.commons.transport.Connection", "", "", "java.io.IOException", "com.aliyun.odps.commons.transport.Response"), 539);
        }
    }

    public static enum DownloadStatus {
        UNKNOWN,
        NORMAL,
        CLOSED,
        EXPIRED,
        INITIATING,
        FAILED;

    }
}

