/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Instance;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Survey;
import com.aliyun.odps.Task;
import com.aliyun.odps.commons.util.EmptyIterator;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.task.RecordSetIterator;
import com.aliyun.odps.task.SQLTask$AjcClosure1;
import com.aliyun.odps.task.SQLTask$AjcClosure11;
import com.aliyun.odps.task.SQLTask$AjcClosure13;
import com.aliyun.odps.task.SQLTask$AjcClosure3;
import com.aliyun.odps.task.SQLTask$AjcClosure5;
import com.aliyun.odps.task.SQLTask$AjcClosure7;
import com.aliyun.odps.task.SQLTask$AjcClosure9;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.CSVRecordParser;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

@Root(name="SQL", strict=false)
public class SQLTask
extends Task {
    @Element(name="Query", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String query;
    private static Map<String, String> defaultHints;
    private static final String AnonymousSQLTaskName = "AnonymousSQLTask";
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public String getQuery() {
        return this.query;
    }

    public static void setDefaultHints(Map<String, String> hints) {
        defaultHints = hints;
    }

    public static void removeDefaultHints() {
        defaultHints = null;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public static List<Record> parseCsvRecord(String csvResult) throws OdpsException {
        return CSVRecordParser.parse(csvResult).getRecords();
    }

    public static List<Record> getResult(Instance instance, String taskName) throws OdpsException {
        Map<String, String> results = instance.getTaskResults();
        String selectResult = results.get(taskName);
        if (selectResult != null) {
            return SQLTask.parseCsvRecord(selectResult);
        }
        return null;
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, String taskName, Long limit) throws OdpsException, IOException {
        Instance instance2 = instance;
        String string = taskName;
        Long l = limit;
        Object[] objectArray = new Object[]{instance2, string, l};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{instance2, string, l, joinPoint};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure1(objectArray2).linkClosureAndJoinPoint(65536));
    }

    private static List<Record> getResultByInstanceTunnel(Instance instance, String taskName, Long limit, boolean limitEnabled) throws OdpsException, IOException {
        Record record;
        SQLTask.checkTaskName(instance, taskName);
        InstanceTunnel tunnel = new InstanceTunnel(instance.getOdps());
        InstanceTunnel.DownloadSession session = tunnel.createDownloadSession(instance.getProject(), instance.getId(), limitEnabled);
        long recordCount = session.getRecordCount();
        ArrayList<Record> records = new ArrayList<Record>();
        if (recordCount == 0L) {
            return records;
        }
        if (limit != null && limit < recordCount) {
            recordCount = limit;
        }
        TunnelRecordReader reader = session.openRecordReader(0L, recordCount);
        while ((record = reader.read()) != null) {
            records.add(record);
        }
        return records;
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, Long limit) throws OdpsException, IOException {
        Instance instance2 = instance;
        Long l = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)instance2, (Object)l);
        Object[] objectArray = new Object[]{instance2, l, joinPoint};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance, String taskName) throws OdpsException, IOException {
        Instance instance2 = instance;
        String string = taskName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object)instance2, (Object)string);
        Object[] objectArray = new Object[]{instance2, string, joinPoint};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure9(objectArray).linkClosureAndJoinPoint(65536));
    }

    @Survey
    public static List<Record> getResultByInstanceTunnel(Instance instance) throws OdpsException, IOException {
        Instance instance2 = instance;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)instance2);
        Object[] objectArray = new Object[]{instance2, joinPoint};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure13(objectArray).linkClosureAndJoinPoint(65536));
    }

    public static List<Record> getResult(Instance instance) throws OdpsException {
        return SQLTask.getResult(instance, AnonymousSQLTaskName);
    }

    public static ResultSet getResultSet(Instance instance) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, AnonymousSQLTaskName);
    }

    public static ResultSet getResultSet(Instance instance, String taskName) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, taskName, null);
    }

    public static ResultSet getResultSet(Instance instance, Long limit) throws OdpsException, IOException {
        return SQLTask.getResultSet(instance, AnonymousSQLTaskName, limit);
    }

    public static ResultSet getResultSet(Instance instance, String taskName, Long limit) throws OdpsException {
        return SQLTask.getResultSet(instance, taskName, limit, false);
    }

    public static ResultSet getResultSet(Instance instance, String taskName, Long limit, boolean limitHint) throws OdpsException {
        return SQLTask.getResultSet(instance, taskName, limit, limitHint, null);
    }

    public static ResultSet getResultSet(Instance instance, String taskName, Long limit, boolean limitHint, URI tunnelEndpoint) throws OdpsException {
        InstanceTunnel.DownloadSession session;
        long recordCount;
        SQLTask.checkTaskName(instance, taskName);
        InstanceTunnel tunnel = new InstanceTunnel(instance.getOdps());
        if (tunnelEndpoint != null) {
            tunnel.setEndpoint(tunnelEndpoint.toString());
        }
        if ((recordCount = (session = tunnel.createDownloadSession(instance.getProject(), instance.getId(), limitHint)).getRecordCount()) == 0L) {
            return new ResultSet(EmptyIterator.emptyIterator(), session.getSchema(), recordCount);
        }
        if (limit != null && limit < recordCount) {
            recordCount = limit;
        }
        return new ResultSet(new RecordSetIterator(session, recordCount), session.getSchema(), recordCount);
    }

    private static void checkTaskName(Instance instance, String taskName) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)taskName)) {
            throw new OdpsException("Invalid task name.");
        }
        boolean findTask = false;
        for (String n : instance.getTaskNames()) {
            if (!taskName.equals(n)) continue;
            findTask = true;
            break;
        }
        if (!findTask) {
            throw new OdpsException("Invalid task: " + taskName);
        }
    }

    @Override
    public String getCommandText() {
        return this.query;
    }

    public static List<String> getSqlWarning(Instance instance) throws OdpsException {
        return SQLTask.getSqlWarning(instance, AnonymousSQLTaskName);
    }

    public static List<String> getSqlWarning(Instance instance, String taskName) throws OdpsException {
        String warnings = instance.getTaskInfo(taskName, "warnings");
        try {
            LinkedList<String> warningList = new LinkedList<String>();
            JsonObject jsonObject = new JsonParser().parse(warnings).getAsJsonObject();
            if (!jsonObject.has("warnings")) {
                return null;
            }
            JsonArray array = jsonObject.get("warnings").getAsJsonArray();
            for (JsonElement element : array) {
                warningList.add(element.getAsString());
            }
            return warningList;
        }
        catch (JsonParseException e) {
            return null;
        }
    }

    public static Instance run(Odps odps, String sql) throws OdpsException {
        String project = odps.getDefaultProject();
        if (project == null) {
            throw new OdpsException("default project required.");
        }
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, null, null, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, AnonymousSQLTaskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, "sql");
    }

    public static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, int priority) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, priority, "sql");
    }

    private static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, Integer priority, String type) throws OdpsException {
        String json;
        SQLTask task = new SQLTask();
        task.setQuery(sql);
        task.setName(taskName);
        task.setProperty("type", type);
        if (hints == null) {
            hints = defaultHints;
        }
        if (hints != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (priority != null) {
            return odps.instances().create(project, task, priority);
        }
        return odps.instances().create(project, task);
    }

    static Instance run(Odps odps, String project, String sql, String taskName, Map<String, String> hints, Map<String, String> aliases, String type) throws OdpsException {
        return SQLTask.run(odps, project, sql, taskName, hints, aliases, null, type);
    }

    static {
        SQLTask.ajc$preClinit();
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody0(Instance instance, String taskName, Long limit, JoinPoint joinPoint) {
        return SQLTask.getResultByInstanceTunnel(instance, taskName, limit, true);
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody2(Instance instance, String string, Long l, JoinPoint joinPoint) {
        return SQLTask.getResultByInstanceTunnel(instance, string, l);
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody4(Instance instance, Long limit, JoinPoint joinPoint) {
        Long l = limit;
        String string = AnonymousSQLTaskName;
        Instance instance2 = instance;
        Object[] objectArray = new Object[]{instance2, string, l};
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{instance2, string, l, joinPoint2};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure3(objectArray2).linkClosureAndJoinPoint(0));
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody6(Instance instance, String string, Long l, JoinPoint joinPoint) {
        return SQLTask.getResultByInstanceTunnel(instance, string, l);
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody8(Instance instance, String taskName, JoinPoint joinPoint) {
        Object var3_3 = null;
        String string = taskName;
        Instance instance2 = instance;
        Object[] objectArray = new Object[]{instance2, string, var3_3};
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{instance2, string, var3_3, joinPoint2};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure7(objectArray2).linkClosureAndJoinPoint(0));
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody10(Instance instance, String string, JoinPoint joinPoint) {
        return SQLTask.getResultByInstanceTunnel(instance, string);
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody12(Instance instance, JoinPoint joinPoint) {
        String string = AnonymousSQLTaskName;
        Instance instance2 = instance;
        JoinPoint joinPoint2 = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)instance2, (Object)string);
        Object[] objectArray = new Object[]{instance2, string, joinPoint2};
        return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLTask$AjcClosure11(objectArray).linkClosureAndJoinPoint(0));
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SQLTask.java", SQLTask.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String:java.lang.Long", "instance:taskName:limit", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 183);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String:java.lang.Long", "instance:taskName:limit", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 234);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.Long", "instance:limit", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 234);
        ajc$tjp_3 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String:java.lang.Long", "instance:taskName:limit", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 256);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String", "instance:taskName", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 256);
        ajc$tjp_5 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String", "instance:taskName", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 274);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance", "instance", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 274);
    }
}

