/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.task;

import com.aliyun.odps.Odps;
import com.aliyun.odps.Task;
import com.aliyun.odps.account.Account;
import com.aliyun.odps.account.AliyunRequestSigner;
import com.aliyun.odps.account.RequestSigner;
import com.aliyun.odps.commons.transport.Request;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.task.copy.LocalDatasource;
import com.aliyun.odps.task.copy.MappingItem;
import com.aliyun.odps.task.copy.TunnelDatasource;
import java.util.ArrayList;
import java.util.List;

@Root(name="COPY", strict=false)
public class CopyTask
extends Task {
    @Element(name="Local", required=false)
    private LocalDatasource local;
    @Element(name="Tunnel", required=false)
    private TunnelDatasource tunnel;
    @ElementList(name="MappingItems", entry="MappingItem", required=false)
    private List<MappingItem> mappingItems;
    @Element(name="Mode", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String mode;
    @Element(name="JobInstanceNumber", required=false)
    @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
    private String jobInstanceNumber;

    CopyTask() {
    }

    public CopyTask(String name) {
        this.setName(name);
    }

    public void SetTunnelInfo(TunnelDatasource tunnel) {
        this.tunnel = tunnel;
    }

    public TunnelDatasource getTunnelInfo() {
        return this.tunnel;
    }

    public void setLocalInfo(LocalDatasource local) {
        this.local = local;
    }

    public LocalDatasource getLocalInfo() {
        return this.local;
    }

    public void setMappings(List<MappingItem> items) {
        this.mappingItems = items;
    }

    public List<MappingItem> getMappings() {
        if (this.mappingItems == null) {
            this.mappingItems = new ArrayList<MappingItem>();
        }
        return this.mappingItems;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setJobInstanceNumber(String number) {
        this.jobInstanceNumber = number;
    }

    public String getJobInstanceNumber() {
        return this.jobInstanceNumber;
    }

    public static Odps getOdpsWithGroupAccount(Odps odps, String gid, String gkey) {
        Odps ret = odps.clone();
        ret.setAccount(new GroupAccount(odps.getAccount(), gid, gkey));
        return ret;
    }

    static class GroupSigner
    extends AliyunRequestSigner {
        Account userAccount;

        GroupSigner(Account userAccount, String gid, String gkey) {
            super(gid, gkey);
            this.userAccount = userAccount;
        }

        @Override
        public void sign(String resource, Request req) {
            this.userAccount.getRequestSigner().sign(resource, req);
            req.getHeaders().put("Group-Authorization", this.getSignature(resource, req));
        }
    }

    static class GroupAccount
    implements Account {
        private GroupSigner signer;

        GroupAccount(Account userAccount, String gid, String gkey) {
            this.signer = new GroupSigner(userAccount, gid, gkey);
        }

        @Override
        public Account.AccountProvider getType() {
            return Account.AccountProvider.ALIYUN;
        }

        @Override
        public RequestSigner getRequestSigner() {
            return this.signer;
        }
    }
}

