/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.sqa;

import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Session;
import com.aliyun.odps.TunnelEndpointLocalCache;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.sqa.ExecuteMode;
import com.aliyun.odps.sqa.FallbackPolicy;
import com.aliyun.odps.sqa.QueryInfo;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.sqa.SQLExecutorConstants;
import com.aliyun.odps.sqa.SQLExecutorImpl$AjcClosure1;
import com.aliyun.odps.sqa.SQLExecutorPool;
import com.aliyun.odps.sqa.SessionRecordSetIterator;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.tunnel.io.TunnelRecordReader;
import com.aliyun.odps.utils.CSVRecordParser;
import com.aliyun.odps.utils.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

class SQLExecutorImpl
implements SQLExecutor {
    private String id = null;
    private Odps odps = null;
    private ExecuteMode executeMode = ExecuteMode.INTERACTIVE;
    private FallbackPolicy fallbackPolicy = null;
    private boolean enableReattach = true;
    private boolean useInstanceTunnel = true;
    private boolean useOdpsWorker = false;
    private boolean attachSuccess = false;
    private Map<String, String> properties = new HashMap<String, String>();
    private String serviceName;
    private String taskName;
    private String runningCluster;
    private int tunnelGetResultMaxRetryTime;
    private int tunnelGetResultRetryCount = 0;
    private static final long cacheSize = 1000L;
    private static final int durationSeconds = 900;
    private static TunnelEndpointLocalCache cache;
    private InstanceTunnel instanceTunnel = null;
    private SQLExecutorPool pool = null;
    Session session = null;
    QueryInfo queryInfo = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    /*
     * Unable to fully structure code
     */
    SQLExecutorImpl(Odps odps, String serviceName, String taskName, String tunnelEndpoint, Map<String, String> properties, ExecuteMode executeMode, FallbackPolicy fallbackPolicy, boolean enableReattach, boolean useInstanceTunnel, boolean useOdpsWorker, SQLExecutorPool pool, Instance recoverInstance, String runningCluster, int tunnelGetResultMaxRetryTime) throws OdpsException {
        super();
        this.properties.putAll(properties);
        this.serviceName = serviceName;
        this.taskName = taskName;
        this.odps = odps;
        this.executeMode = executeMode;
        this.fallbackPolicy = fallbackPolicy;
        this.enableReattach = enableReattach;
        this.useInstanceTunnel = useInstanceTunnel;
        this.useOdpsWorker = useOdpsWorker;
        this.pool = pool;
        this.runningCluster = runningCluster;
        this.tunnelGetResultMaxRetryTime = tunnelGetResultMaxRetryTime;
        if (executeMode.equals((Object)ExecuteMode.INTERACTIVE)) {
            if (recoverInstance != null && recoverInstance.getStatus() == Instance.Status.RUNNING) {
                this.session = new Session(odps, recoverInstance);
                this.attachSuccess = true;
            }
            try {
                if (this.session != null) ** GOTO lbl44
                this.session = Session.attach(odps, serviceName, properties, SQLExecutorConstants.DEFAULT_ATTACH_TIMEOUT, runningCluster, taskName);
                this.attachSuccess = true;
            }
            catch (OdpsException e) {
                if (fallbackPolicy.isAlwaysFallBack()) {
                    if (!e.getMessage().contains("ODPS-1820002")) ** GOTO lbl44
                    throw e;
                }
                throw e;
            }
        } else if (!executeMode.equals((Object)ExecuteMode.OFFLINE)) {
            throw new OdpsException("Invalid execution mode, can not init with NONE.");
        }
lbl44:
        // 5 sources

        this.id = UUID.randomUUID().toString();
        if (useInstanceTunnel) {
            this.instanceTunnel = new InstanceTunnel(odps);
            if (StringUtils.isNullOrEmpty((String)tunnelEndpoint)) {
                try {
                    tunnelEndpoint = SQLExecutorImpl.cache.getTunnelEndpointFromLocalCache(odps);
                }
                catch (ExecutionException e) {
                    throw new OdpsException("Get tunnel endpoint from localCache exception:" + e.getMessage());
                }
                this.instanceTunnel.setEndpoint(tunnelEndpoint);
            } else {
                this.instanceTunnel.setEndpoint(tunnelEndpoint);
            }
        }
    }

    @Override
    public void close() {
        if (this.pool != null) {
            this.pool.releaseExecutor(this);
        } else {
            try {
                if (this.session != null) {
                    this.session.stop();
                }
            }
            catch (OdpsException odpsException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public int getSubqueryId() {
        if (this.queryInfo != null && this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE)) {
            return this.queryInfo.getId();
        }
        return -1;
    }

    public String getQueryId() {
        if (this.queryInfo != null && this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE)) {
            return this.queryInfo.getInstance().getId() + "_" + this.queryInfo.getId();
        }
        return null;
    }

    @Override
    public String getLogView() {
        if (this.queryInfo != null) {
            try {
                if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.INTERACTIVE)) {
                    return new LogView(this.odps).generateSubQueryLogView(this.queryInfo.getInstance(), this.queryInfo.getId(), 168L);
                }
                return new LogView(this.odps).generateLogView(this.queryInfo.getInstance(), 168L);
            }
            catch (OdpsException e) {
                return null;
            }
        }
        if (this.session != null) {
            return this.session.getLogView();
        }
        return null;
    }

    @Override
    public boolean isActive() {
        if (this.session != null) {
            return this.session.getInstance().getStatus().equals((Object)Instance.Status.RUNNING);
        }
        return false;
    }

    @Override
    public void cancel() throws OdpsException {
        if (this.queryInfo != null) {
            if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.OFFLINE)) {
                this.queryInfo.getInstance().stop();
            } else {
                this.session.cancelQuery(this.queryInfo.getId());
            }
        }
    }

    @Override
    public Instance getInstance() {
        if (this.queryInfo != null) {
            return this.queryInfo.getInstance();
        }
        if (this.session != null) {
            return this.session.getInstance();
        }
        return null;
    }

    @Override
    public List<Instance.StageProgress> getProgress() throws OdpsException {
        if (this.queryInfo == null) {
            return null;
        }
        if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.OFFLINE)) {
            return this.queryInfo.getInstance().getTaskProgress("sqlrt_fallback_task");
        }
        return this.session.getInstance().getTaskProgress(this.taskName);
    }

    @Override
    public String getSummary() throws OdpsException {
        if (this.queryInfo == null) {
            return null;
        }
        if (this.queryInfo.getExecuteMode().equals((Object)ExecuteMode.OFFLINE)) {
            Instance.TaskSummary summary = this.queryInfo.getInstance().getTaskSummary("sqlrt_fallback_task");
            if (summary == null) {
                return null;
            }
            return summary.getSummaryText();
        }
        return this.session.getQueryStats(this.queryInfo.getId());
    }

    @Override
    public List<String> getExecutionLog() {
        if (this.queryInfo == null) {
            return null;
        }
        return this.queryInfo.getAndCleanExecutionLog();
    }

    @Override
    public List<Record> getResult() throws OdpsException, IOException {
        return this.getResult(null);
    }

    @Override
    public ResultSet getResultSet() throws OdpsException, IOException {
        return this.getResultSet(null);
    }

    @Override
    public List<Record> getResult(Long countLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(null, countLimit, null, false);
        return list;
    }

    @Override
    public List<Record> getResult(Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(null, countLimit, sizeLimit, false);
        return list;
    }

    @Override
    public List<Record> getResult(Long offset, Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(offset, countLimit, sizeLimit, false);
        return list;
    }

    @Override
    public List<Record> getResult(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        List<Record> list = this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
        return list;
    }

    @Override
    public ResultSet getResultSet(Long countLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(null, countLimit, null, false);
        return resultSet;
    }

    @Override
    public ResultSet getResultSet(Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(null, countLimit, sizeLimit, false);
        return resultSet;
    }

    @Override
    public ResultSet getResultSet(Long offset, Long countLimit, Long sizeLimit) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(offset, countLimit, sizeLimit, false);
        return resultSet;
    }

    @Override
    public ResultSet getResultSet(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.queryInfo == null) {
            throw new OdpsException("No query running now.");
        }
        if (!this.useInstanceTunnel && offset != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && countLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        if (!this.useInstanceTunnel && sizeLimit != null) {
            throw new OdpsException("Please enable instance tunnel if you want to get limited result.");
        }
        ResultSet resultSet = this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
        return resultSet;
    }

    @Override
    public void run(String sql, Map<String, String> hint) throws OdpsException {
        this.queryInfo = new QueryInfo(sql, hint, this.executeMode);
        this.tunnelGetResultRetryCount = 0;
        this.runQueryInternal(this.executeMode, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reattach(String errorMessage) throws OdpsException {
        if (!this.enableReattach) throw new OdpsException(errorMessage);
        try {
            this.attachSuccess = false;
            this.session = Session.attach(this.odps, this.serviceName, this.properties, SQLExecutorConstants.DEFAULT_ATTACH_TIMEOUT, this.runningCluster, this.taskName);
            this.attachSuccess = true;
            return;
        }
        catch (OdpsException e) {
            if (this.fallbackPolicy.isAlwaysFallBack()) return;
            throw new OdpsException(errorMessage);
        }
    }

    private ExecuteMode handleSessionException(String errorMessage) throws OdpsException {
        if (errorMessage.indexOf("ODPS-181") != -1) {
            this.reattach(errorMessage);
            return ExecuteMode.INTERACTIVE;
        }
        if (this.fallbackPolicy.isFallback4UnsupportedFeature() && errorMessage.indexOf("ODPS-185") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4Upgrading() && errorMessage.indexOf("ODPS-184") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4Upgrading() && errorMessage.indexOf("ODPS-182") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4ResourceNotEnough() && errorMessage.indexOf("ODPS-183") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4RunningTimeout() && errorMessage.indexOf("ODPS-186") != -1) {
            return ExecuteMode.OFFLINE;
        }
        if (this.fallbackPolicy.isFallback4UnknownError() && errorMessage.indexOf("ODPS-180") != -1) {
            return ExecuteMode.OFFLINE;
        }
        throw new OdpsException(errorMessage);
    }

    private boolean checkIsSelect(String errorCode, String errorMessage) throws OdpsException {
        if (errorCode.equals("InstanceTypeNotSupported") || errorMessage.indexOf("Non select query not supported") != -1) {
            this.queryInfo.setSelect(false);
            return false;
        }
        return true;
    }

    private TunnelRetryInfo handleTunnelException(String errorCode, String errorMessage) throws OdpsException {
        boolean isSelect = this.checkIsSelect(errorCode, errorMessage);
        TunnelRetryInfo info = new TunnelRetryInfo();
        info.errCode = errorCode;
        info.errMsg = errorMessage;
        if (!isSelect) {
            try {
                this.session.getSubQueryResult(this.queryInfo.getId());
                info.status = TunnelRetryStatus.NON_SELECT_QUERY;
                return info;
            }
            catch (OdpsException e) {
                info.status = TunnelRetryStatus.QUERY_FAILED;
                info.errCode = e.getErrorCode();
                info.errMsg = e.getMessage();
                return info;
            }
        }
        if (errorCode.equals("OdpsTaskTimeout") || errorMessage.indexOf("Wait for cache data timeout") != -1) {
            ++this.tunnelGetResultRetryCount;
            if (this.tunnelGetResultRetryCount >= this.tunnelGetResultMaxRetryTime) {
                throw new OdpsException(errorCode + ":" + errorMessage);
            }
            info.status = TunnelRetryStatus.NEED_RETRY;
            return info;
        }
        info.status = TunnelRetryStatus.QUERY_FAILED;
        return info;
    }

    private ResultSet newEmptyResultSet() {
        return new ResultSet(new SessionRecordSetIterator(new ArrayList<Record>()), null, 0L);
    }

    private List<Record> getResultInternal(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.useInstanceTunnel) {
            if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
                return this.getSessionResultByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
            }
            return this.getOfflineResultByInstanceTunnel(countLimit);
        }
        if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
            return this.getSessionResult();
        }
        return this.getOfflineResult();
    }

    private ResultSet getResultSetInternal(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        if (this.useInstanceTunnel) {
            if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
                return this.getSessionResultSetByInstanceTunnel(offset, countLimit, sizeLimit, limitEnabled);
            }
            return this.getOfflineResultSetByInstanceTunnel(countLimit);
        }
        if (this.queryInfo.getExecuteMode() == ExecuteMode.INTERACTIVE && this.attachSuccess) {
            return this.getSessionResultSet();
        }
        return this.getOfflineResultSet();
    }

    private List<Record> getSessionResult() throws OdpsException, IOException {
        Session.SubQueryResult result = null;
        try {
            result = !this.useOdpsWorker ? this.session.getSubQueryResult(this.queryInfo.getId()) : this.session.getSubQueryResultFromWorker(this.queryInfo.getId());
        }
        catch (OdpsException e) {
            ExecuteMode executeMode = this.handleSessionException(e.getMessage());
            this.runQueryInternal(executeMode, e.getMessage());
            return this.getResultInternal(null, null, null, true);
        }
        return result.getRecords();
    }

    private List<Record> getSessionResultByInstanceTunnel(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        Instance instance = this.queryInfo.getInstance();
        ArrayList<Record> records = new ArrayList<Record>();
        try {
            Record record;
            InstanceTunnel.DownloadSession downloadSession = this.instanceTunnel.createDirectDownloadSession(instance.getProject(), instance.getId(), this.taskName, this.queryInfo.getId(), limitEnabled);
            TunnelRecordReader reader = downloadSession.openRecordReader(offset == null ? 0L : offset, countLimit == null ? -1L : countLimit, sizeLimit == null ? -1L : sizeLimit);
            while ((record = reader.read()) != null) {
                records.add(record);
            }
        }
        catch (TunnelException e) {
            TunnelRetryInfo retryInfo = this.handleTunnelException(e.getErrorCode(), e.getMessage());
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NEED_RETRY)) {
                return this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
            }
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NON_SELECT_QUERY)) {
                return records;
            }
            ExecuteMode executeMode = this.handleSessionException(retryInfo.errMsg);
            this.runQueryInternal(executeMode, retryInfo.errMsg);
            return this.getResultInternal(offset, countLimit, sizeLimit, limitEnabled);
        }
        return records;
    }

    private List<Record> getOfflineResult() throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        return SQLTask.getResult(this.queryInfo.getInstance(), "sqlrt_fallback_task");
    }

    private List<Record> getOfflineResultByInstanceTunnel(Long limit) throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        if (this.queryInfo.isSelect()) {
            Long l = limit;
            String string = "sqlrt_fallback_task";
            Instance instance = this.queryInfo.getInstance();
            Object[] objectArray = new Object[]{instance, string, l};
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, null, (Object[])objectArray);
            Object[] objectArray2 = new Object[]{this, instance, string, l, joinPoint};
            return (List)OdpsDeprecatedLogger.aspectOf().aroundOdpsImpl(new SQLExecutorImpl$AjcClosure1(objectArray2).linkClosureAndJoinPoint(4096));
        }
        return SQLTask.getResult(this.queryInfo.getInstance(), "sqlrt_fallback_task");
    }

    private ResultSet getSessionResultSet() throws OdpsException, IOException {
        Session.SubQueryResult result = null;
        try {
            result = !this.useOdpsWorker ? this.session.getSubQueryResult(this.queryInfo.getId()) : this.session.getSubQueryResultFromWorker(this.queryInfo.getId());
        }
        catch (OdpsException e) {
            ExecuteMode executeMode = this.handleSessionException(e.getMessage());
            this.runQueryInternal(executeMode, e.getMessage());
            return this.getResultSetInternal(null, null, null, true);
        }
        return new ResultSet(new SessionRecordSetIterator(result.getRecords()), result.getSchema(), result.getRecords().size());
    }

    private ResultSet getSessionResultSetByInstanceTunnel(Long offset, Long countLimit, Long sizeLimit, boolean limitEnabled) throws OdpsException, IOException {
        Instance instance = this.queryInfo.getInstance();
        InstanceTunnel.DownloadSession downloadSession = null;
        TunnelRecordReader reader = null;
        try {
            downloadSession = this.instanceTunnel.createDirectDownloadSession(instance.getProject(), instance.getId(), this.taskName, this.queryInfo.getId(), limitEnabled);
            reader = downloadSession.openRecordReader(offset == null ? 0L : offset, countLimit == null ? -1L : countLimit, sizeLimit == null ? -1L : sizeLimit);
        }
        catch (TunnelException e) {
            TunnelRetryInfo retryInfo = this.handleTunnelException(e.getErrorCode(), e.getMessage());
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NEED_RETRY)) {
                return this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
            }
            if (retryInfo.status.equals((Object)TunnelRetryStatus.NON_SELECT_QUERY)) {
                return this.newEmptyResultSet();
            }
            ExecuteMode executeMode = this.handleSessionException(retryInfo.errMsg);
            this.runQueryInternal(executeMode, retryInfo.errMsg);
            return this.getResultSetInternal(offset, countLimit, sizeLimit, limitEnabled);
        }
        return new ResultSet(new SessionRecordSetIterator(reader), downloadSession.getSchema(), downloadSession.getRecordCount());
    }

    private ResultSet getOfflineResultSet() throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        Map<String, String> results = this.queryInfo.getInstance().getTaskResults();
        String selectResult = results.get("sqlrt_fallback_task");
        if (!StringUtils.isNullOrEmpty((String)selectResult)) {
            CSVRecordParser.ParseResult parseResult = CSVRecordParser.parse(selectResult);
            List<Record> records = parseResult.getRecords();
            return new ResultSet(new SessionRecordSetIterator(records), parseResult.getSchema(), records.size());
        }
        return this.newEmptyResultSet();
    }

    private ResultSet getOfflineResultSetByInstanceTunnel(Long limit) throws OdpsException, IOException {
        this.queryInfo.getInstance().waitForSuccess();
        if (this.queryInfo.isSelect()) {
            return SQLTask.getResultSet(this.queryInfo.getInstance(), "sqlrt_fallback_task", limit);
        }
        return this.newEmptyResultSet();
    }

    private void runInSessionWithRetry(String rerunMsg) throws OdpsException {
        Session.SubQueryInfo subQueryInfo = this.session.runSubQuery(this.queryInfo.getSql(), this.queryInfo.getHint());
        if (subQueryInfo.status.equals("ok")) {
            if (subQueryInfo.queryId == -1) {
                ExecuteMode executeMode = this.handleSessionException(subQueryInfo.result);
                this.runQueryInternal(executeMode, subQueryInfo.result);
            } else {
                this.queryInfo.setId(subQueryInfo.queryId);
                this.queryInfo.setInstance(this.session.getInstance(), ExecuteMode.INTERACTIVE, new LogView(this.odps).generateSubQueryLogView(this.session.getInstance(), subQueryInfo.queryId, 168L), rerunMsg);
            }
        } else if (subQueryInfo.status.equals("NotFound")) {
            String taskTerminateMsg = this.session.getInstance().getTaskResults().get(this.taskName);
            this.reattach("Submit query failed:" + taskTerminateMsg);
            this.runQueryInternal(ExecuteMode.INTERACTIVE, taskTerminateMsg);
        } else {
            throw new OdpsException("Submit query failed:" + subQueryInfo.result);
        }
    }

    private void runInOffline(String rerunMsg) throws OdpsException {
        Instance instance = SQLTask.run(this.odps, this.odps.getDefaultProject(), this.queryInfo.getSql(), "sqlrt_fallback_task", this.queryInfo.getHint(), null);
        this.queryInfo.setInstance(instance, ExecuteMode.OFFLINE, new LogView(this.odps).generateLogView(instance, 168L), rerunMsg);
    }

    private void runQueryInternal(ExecuteMode executeMode, String rerunMsg) throws OdpsException {
        boolean fallbackForAttachFailed = false;
        if (this.queryInfo.getRetry() < 1) {
            this.queryInfo.incRetry();
            if (executeMode == ExecuteMode.INTERACTIVE && !this.attachSuccess && this.fallbackPolicy.isAlwaysFallBack()) {
                try {
                    this.session = Session.attach(this.odps, this.serviceName, this.properties, SQLExecutorConstants.DEFAULT_ATTACH_TIMEOUT, this.runningCluster, this.taskName);
                    this.attachSuccess = true;
                }
                catch (OdpsException e) {
                    fallbackForAttachFailed = true;
                }
            }
            if (executeMode == ExecuteMode.OFFLINE || fallbackForAttachFailed) {
                this.queryInfo.setExecuteMode(ExecuteMode.OFFLINE);
                if (this.queryInfo != null && this.queryInfo.getInstance() != null) {
                    if (this.queryInfo.getHint() == null) {
                        this.queryInfo.setHint(new HashMap<String, String>());
                    }
                    this.queryInfo.getHint().put("odps.task.sql.sqa.enable", "false");
                    this.queryInfo.getHint().put("odps.sql.session.fallback.instance", this.queryInfo.getInstance().getId() + "_" + this.queryInfo.getId());
                }
                this.runInOffline(rerunMsg);
            } else {
                this.runInSessionWithRetry(rerunMsg);
            }
        } else {
            throw new OdpsException(rerunMsg);
        }
    }

    static {
        SQLExecutorImpl.ajc$preClinit();
        cache = new TunnelEndpointLocalCache(1000L, 900);
    }

    static /* synthetic */ List getResultByInstanceTunnel_aroundBody0(SQLExecutorImpl sQLExecutorImpl, Instance instance, String string, Long l, JoinPoint joinPoint) {
        return SQLTask.getResultByInstanceTunnel(instance, string, l);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SQLExecutorImpl.java", SQLExecutorImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("9", "getResultByInstanceTunnel", "com.aliyun.odps.task.SQLTask", "com.aliyun.odps.Instance:java.lang.String:java.lang.Long", "instance:taskName:limit", "com.aliyun.odps.OdpsException:java.io.IOException", "java.util.List"), 887);
    }

    private class TunnelRetryInfo {
        public TunnelRetryStatus status;
        public String errCode;
        public String errMsg;

        private TunnelRetryInfo() {
        }
    }

    static enum TunnelRetryStatus {
        NEED_RETRY,
        NON_SELECT_QUERY,
        QUERY_FAILED;

    }
}

