/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.filter;

import com.aliyun.odps.filter.AdvancedFilter;
import com.aliyun.odps.filter.AdvancedFilterCondition;
import com.aliyun.odps.filter.ResultSorter;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Attribute;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.List;

public class AdvancedFilterUtils {
    public static void getCriteria(AdvancedFilter filter, List<Criterion> criteria) {
        if (filter == null) {
            return;
        }
        if (filter.getCondition() != null) {
            AdvancedFilterCondition condition = filter.getCondition();
            Criterion criterion = new Criterion();
            switch (condition.getProperty()) {
                case TABLE_NAME: {
                    criterion.property = "name";
                    break;
                }
                case TABLE_OWNER_ID: {
                    criterion.property = "owner_id";
                    break;
                }
                case TABLE_COMMENT: {
                    criterion.property = "comment";
                    break;
                }
                case TABLE_COL_NAME: {
                    criterion.property = "column.name";
                    break;
                }
                case TABLE_COL_COMMENT: {
                    criterion.property = "column.comment";
                    break;
                }
                case PARTITION_NAME: {
                    criterion.property = "Name";
                    break;
                }
                case PARTITION_LAST_MODIFIED_TIME: {
                    criterion.property = "LastModifiedTime";
                    break;
                }
                case PARTITION_SIZE: {
                    criterion.property = "PartitionSize";
                    break;
                }
                case PARTITION_RECORD_COUNT: {
                    criterion.property = "PartitionRecordCount";
                    break;
                }
                case PARTITION_CREATION_TIME: {
                    criterion.property = "CreationTime";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property: " + (Object)((Object)condition.getProperty()));
                }
            }
            switch (condition.getPredicate()) {
                case EQUALS: {
                    criterion.operator = "eq";
                    break;
                }
                case CONTAINS: {
                    criterion.operator = "contains";
                    break;
                }
                case GREATER_THAN: {
                    criterion.operator = "gt";
                    break;
                }
                case LESS_THAN: {
                    criterion.operator = "lt";
                    break;
                }
                case LESS_THAN_OR_EQUALS: {
                    criterion.operator = "lte";
                    break;
                }
                case GREATER_THAN_OR_EQUALS: {
                    criterion.operator = "gte";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown predicate: " + (Object)((Object)condition.getPredicate()));
                }
            }
            criterion.value = condition.getValue();
            criteria.add(criterion);
            return;
        }
        if (filter.getRight() != null) {
            AdvancedFilterUtils.getCriteria(filter.getRight(), criteria);
        }
        if (filter.getLeft() != null) {
            AdvancedFilterUtils.getCriteria(filter.getLeft(), criteria);
        }
    }

    public static void getSortModels(List<ResultSorter> sorters, List<SortModel> sortModels) {
        for (ResultSorter sorter : sorters) {
            SortModel sortModel = new SortModel();
            switch (sorter.getProperty()) {
                case PARTITION_LAST_MODIFIED_TIME: {
                    sortModel.name = "LastModifiedTime";
                    break;
                }
                case PARTITION_SIZE: {
                    sortModel.name = "PartitionSize";
                    break;
                }
                case PARTITION_RECORD_COUNT: {
                    sortModel.name = "PartitionRecordCount";
                    break;
                }
                case PARTITION_CREATION_TIME: {
                    sortModel.name = "CreationTime";
                    break;
                }
                case PARTITION_NAME: {
                    sortModel.name = "Name";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property: " + (Object)((Object)sorter.getProperty()));
                }
            }
            switch (sorter.getOrder()) {
                case ASC: {
                    sortModel.order = "asc";
                    break;
                }
                case DESC: {
                    sortModel.order = "desc";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown order: " + (Object)((Object)sorter.getOrder()));
                }
            }
            sortModels.add(sortModel);
        }
    }

    @Root(name="SortBy", strict=false)
    public static class SortModel {
        @Attribute(name="Name")
        String name;
        @Attribute(name="Order")
        String order;
    }

    @Root(name="Criterion", strict=false)
    public static class Criterion {
        @Element(name="Property", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String property;
        @Element(name="Operator", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String operator;
        @Element(name="Value", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String value;
    }
}

