/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.filter;

import com.aliyun.odps.filter.AdvancedFilter;

public class AdvancedFilterBuilder {
    private AdvancedFilter filter;
    private boolean built = false;

    public AdvancedFilterBuilder(AdvancedFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Argument 'filter' cannot be null");
        }
        this.filter = filter;
    }

    public AdvancedFilterBuilder and(AdvancedFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        AdvancedFilter parent = new AdvancedFilter();
        parent.setOperator(AdvancedFilter.OPERATOR.AND);
        parent.setLeft(this.filter);
        parent.setRight(filter);
        this.filter = parent;
        return this;
    }

    public AdvancedFilterBuilder or(AdvancedFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        AdvancedFilter parent = new AdvancedFilter();
        parent.setOperator(AdvancedFilter.OPERATOR.OR);
        parent.setLeft(this.filter);
        parent.setRight(filter);
        this.filter = parent;
        return this;
    }

    public AdvancedFilterBuilder not() {
        AdvancedFilter parent = new AdvancedFilter();
        parent.setOperator(AdvancedFilter.OPERATOR.NOT);
        parent.setLeft(this.filter);
        this.filter = parent;
        return this;
    }

    public AdvancedFilter build() {
        if (!this.built) {
            this.built = true;
            return this.filter;
        }
        throw new IllegalStateException("Method build() can only be called once");
    }
}

