/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.data;

import com.aliyun.odps.Column;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsType;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.data.ArrayRecord;
import com.aliyun.odps.data.Binary;
import com.aliyun.odps.data.Char;
import com.aliyun.odps.data.DefaultRecordReader$AjcClosure1;
import com.aliyun.odps.data.DefaultRecordReader$AjcClosure3;
import com.aliyun.odps.data.Record;
import com.aliyun.odps.data.RecordReader;
import com.aliyun.odps.data.Varchar;
import com.csvreader.CsvReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class DefaultRecordReader
implements RecordReader {
    private static char QUOTE;
    private static String NULL_TOKEN;
    private CsvReader reader;
    private static final String CHARSET = "utf-8";
    private TableSchema tableSchema;
    private Column[] schemaColumns = null;
    private InputStream is;
    private DateFormat dateTimeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public DefaultRecordReader(InputStream is, TableSchema tableSchema) {
        try {
            this.is = is;
            this.reader = new CsvReader((Reader)new InputStreamReader(is, CHARSET), ',');
            this.reader.setSafetySwitch(false);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.tableSchema = tableSchema;
    }

    public InputStream getRawStream() {
        return this.is;
    }

    public Column[] getSchema() throws IOException {
        if (this.schemaColumns == null) {
            this.loadSchema();
        }
        return this.schemaColumns;
    }

    @Override
    public Record read() throws IOException {
        if (this.schemaColumns == null) {
            this.loadSchema();
        }
        ArrayRecord ret = new ArrayRecord(this.schemaColumns);
        String[] data = this.load();
        if (data == null) {
            return null;
        }
        for (int i = 0; i < data.length; ++i) {
            try {
                this.setStringByType(ret, i, data[i]);
                continue;
            }
            catch (Exception e) {
                throw new IOException("Parse Error while trans value", e);
            }
        }
        return ret;
    }

    public List<String> readRaw() throws IOException {
        String[] data;
        if (this.schemaColumns == null) {
            this.loadSchema();
        }
        if ((data = this.load()) == null) {
            return null;
        }
        return Arrays.asList(data);
    }

    private void setStringByType(ArrayRecord ret, int idx, String st) throws ParseException {
        if (st == null) {
            ret.set(idx, null);
            return;
        }
        switch (ret.getColumns()[idx].getTypeInfo().getOdpsType()) {
            case BIGINT: {
                ret.setBigint(idx, Long.valueOf(st));
                break;
            }
            case DOUBLE: {
                if ("nan".equals(st)) {
                    ret.setDouble(idx, Double.valueOf(Double.NaN));
                    break;
                }
                if ("inf".equals(st)) {
                    ret.setDouble(idx, Double.valueOf(Double.POSITIVE_INFINITY));
                    break;
                }
                if ("-inf".equals(st)) {
                    ret.setDouble(idx, Double.valueOf(Double.NEGATIVE_INFINITY));
                    break;
                }
                ret.setDouble(idx, Double.valueOf(st));
                break;
            }
            case BOOLEAN: {
                ret.setBoolean(idx, Boolean.valueOf(st));
                break;
            }
            case DATETIME: {
                ret.setDatetime(idx, this.dateTimeFormat.parse(st));
                break;
            }
            case STRING: {
                ret.setString(idx, st);
                break;
            }
            case DECIMAL: {
                ret.setDecimal(idx, new BigDecimal(st));
                break;
            }
            case MAP: {
                ret.set(idx, null);
                break;
            }
            case ARRAY: {
                ret.set(idx, null);
                break;
            }
            case VOID: {
                ret.set(idx, null);
                break;
            }
            case TINYINT: {
                ret.set(idx, (Object)Byte.valueOf(st));
                break;
            }
            case SMALLINT: {
                ret.set(idx, (Object)Short.valueOf(st));
                break;
            }
            case INT: {
                ret.set(idx, (Object)Integer.valueOf(st));
                break;
            }
            case FLOAT: {
                ret.set(idx, (Object)Float.valueOf(st));
                break;
            }
            case CHAR: {
                ret.set(idx, (Object)new Char(st));
                break;
            }
            case VARCHAR: {
                ret.set(idx, (Object)new Varchar(st));
                break;
            }
            case DATE: {
                Date date = new Date(this.dateFormat.parse(st).getTime());
                int n = idx;
                ArrayRecord arrayRecord = ret;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)arrayRecord, (Object)Conversions.intObject((int)n), (Object)date);
                Object[] objectArray = new Object[]{this, arrayRecord, Conversions.intObject((int)n), date, joinPoint};
                OdpsDeprecatedLogger.aspectOf().around(new DefaultRecordReader$AjcClosure1(objectArray).linkClosureAndJoinPoint(4112));
                break;
            }
            case TIMESTAMP: {
                String[] splits = st.split("\\.");
                if (splits.length > 2) {
                    throw new ParseException("Invalid timestamp value", st.lastIndexOf("."));
                }
                Timestamp timestamp = new Timestamp(this.dateTimeFormat.parse(splits[0]).getTime());
                if (splits.length == 2 && !splits[1].isEmpty()) {
                    String nanoValueStr = splits[1];
                    if (nanoValueStr.length() > 9) {
                        nanoValueStr = nanoValueStr.substring(0, 9);
                    } else if (nanoValueStr.length() < 9) {
                        StringBuilder nanoValueStrBuilder = new StringBuilder();
                        nanoValueStrBuilder.append(nanoValueStr);
                        while (nanoValueStrBuilder.length() < 9) {
                            nanoValueStrBuilder.append("0");
                        }
                        nanoValueStr = nanoValueStrBuilder.toString();
                    }
                    timestamp.setNanos(Integer.parseInt(nanoValueStr));
                }
                ret.setTimestamp(idx, timestamp);
                break;
            }
            case BINARY: {
                ret.set(idx, (Object)new Binary(st.getBytes()));
                break;
            }
            case INTERVAL_DAY_TIME: {
                ret.set(idx, null);
                break;
            }
            case INTERVAL_YEAR_MONTH: {
                ret.set(idx, null);
                break;
            }
            case STRUCT: {
                ret.set(idx, null);
                break;
            }
            default: {
                Column column = ret.getColumns()[idx];
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)column);
                Object[] objectArray = new Object[]{this, column, joinPoint};
                throw new RuntimeException("Unsupported type " + (OdpsType)OdpsDeprecatedLogger.aspectOf().around(new DefaultRecordReader$AjcClosure3(objectArray).linkClosureAndJoinPoint(4112)));
            }
        }
    }

    private void loadSchema() throws IOException {
        String[] schema = this.load();
        this.schemaColumns = new Column[schema.length];
        for (int i = 0; i < this.schemaColumns.length; ++i) {
            String name = schema[i];
            this.schemaColumns[i] = this.tableSchema.containsPartitionColumn(name) ? this.tableSchema.getPartitionColumn(name) : this.tableSchema.getColumn(schema[i]);
        }
    }

    private String[] load() throws IOException {
        String[] nextLine = null;
        if (this.reader.readRecord()) {
            nextLine = this.reader.getValues();
            for (int i = 0; i < nextLine.length; ++i) {
                if (nextLine[i].equals(NULL_TOKEN)) {
                    nextLine[i] = null;
                    continue;
                }
                if (!DefaultRecordReader.trimStringQuotes(nextLine[i]).equals(NULL_TOKEN)) continue;
                nextLine[i] = nextLine[i].substring(1, nextLine[i].length() - 1);
            }
            return nextLine;
        }
        return null;
    }

    private static String trimStringQuotes(String str) {
        int i;
        int len = str.length();
        for (i = 0; i < len / 2 && str.charAt(i) == QUOTE && str.charAt(len - i - 1) == QUOTE; ++i) {
        }
        return str.substring(i, str.length() - i);
    }

    @Override
    public void close() {
        this.reader.close();
    }

    static {
        DefaultRecordReader.ajc$preClinit();
        QUOTE = (char)34;
        NULL_TOKEN = "\\N";
    }

    static /* synthetic */ void setDate_aroundBody0(DefaultRecordReader defaultRecordReader, ArrayRecord arrayRecord, int n, Date date, JoinPoint joinPoint) {
        arrayRecord.setDate(n, date);
    }

    static /* synthetic */ OdpsType getType_aroundBody2(DefaultRecordReader defaultRecordReader, Column column, JoinPoint joinPoint) {
        return column.getType();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DefaultRecordReader.java", DefaultRecordReader.class);
        ajc$tjp_0 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "setDate", "com.aliyun.odps.data.ArrayRecord", "int:java.sql.Date", "idx:value", "", "void"), 182);
        ajc$tjp_1 = factory.makeSJP("method-call", (Signature)factory.makeMethodSig("1", "getType", "com.aliyun.odps.Column", "", "", "", "com.aliyun.odps.OdpsType"), 222);
    }
}

