/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.commons.util;

import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.commons.util.RetryExceedLimitException;
import com.aliyun.odps.commons.util.RetryStrategy$BackoffStrategy$AjcClosure1;
import com.aliyun.odps.commons.util.backoff.BackOffStrategy;
import com.aliyun.odps.commons.util.backoff.ConstantBackOffStrategy;
import com.aliyun.odps.commons.util.backoff.ExponentialBackOffStrategy;
import com.aliyun.odps.commons.util.backoff.LinearBackOffStrategy;
import com.aliyun.odps.rest.RestClient;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class RetryStrategy {
    private static final Logger LOG = Logger.getLogger(RetryStrategy.class.getName());
    private static final int DEFAULT_ATTEMPTS = 10;
    private static final int DEFAULT_BACKOFF_INTERVAL = 1;
    protected BackOffStrategy strategy;
    protected int attempts;
    protected int limit;
    protected int totalBackoffTime;

    private BackOffStrategy transform(BackoffStrategy strategy, long initInterval) {
        switch (strategy) {
            case CONSTANT_BACKOFF: {
                return new ConstantBackOffStrategy(initInterval);
            }
            case LINEAR_BACKOFF: {
                return new LinearBackOffStrategy(initInterval);
            }
            case EXPONENTIAL_BACKOFF: {
                return new ExponentialBackOffStrategy(initInterval);
            }
        }
        throw new IllegalArgumentException("Invalid retry strategy: " + strategy.name());
    }

    private void init(int limit, BackOffStrategy strategy) {
        if (limit < 0) {
            throw new IllegalArgumentException("Retry limit must >= 0");
        }
        this.limit = limit;
        this.strategy = strategy;
        this.totalBackoffTime = 0;
        this.attempts = 0;
    }

    public RetryStrategy(int limit, BackOffStrategy strategy) {
        this.init(limit, strategy);
    }

    public RetryStrategy(int limit, int interval, BackoffStrategy strategy) {
        this.init(limit, this.transform(strategy, interval));
    }

    public RetryStrategy(int attempts, int interval) {
        this(attempts, interval, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public RetryStrategy(int attempts) {
        this(attempts, 1, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public RetryStrategy() {
        this(10, 1, BackoffStrategy.CONSTANT_BACKOFF);
    }

    public void reset() {
        this.attempts = 0;
        this.strategy.reset();
    }

    protected boolean needRetry(Exception e) {
        return true;
    }

    public void onFailure(Exception err) throws RetryExceedLimitException, InterruptedException {
        this.onFailure(err, null);
    }

    public void onFailure(Exception err, RestClient.RetryLogger logger) throws RetryExceedLimitException, InterruptedException {
        if (!this.needRetry(err)) {
            throw new RetryExceedLimitException(0, (Throwable)err);
        }
        if (this.attempts++ >= this.limit) {
            throw new RetryExceedLimitException(this.attempts, (Throwable)err);
        }
        long millis = this.strategy.next();
        if (logger != null) {
            logger.onRetryLog(err, this.attempts, millis / 1000L);
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Start to retry, retryCount: %d, will retry in %d seconds.", this.attempts, millis / 1000L));
        }
        Thread.sleep(millis);
        this.totalBackoffTime = (int)((long)this.totalBackoffTime + millis / 1000L);
    }

    public int getAttempts() {
        return this.attempts;
    }

    public int getTotalBackupTime() {
        return this.totalBackoffTime;
    }

    @Deprecated
    public static final class BackoffStrategy
    extends Enum<BackoffStrategy> {
        public static final /* enum */ BackoffStrategy EXPONENTIAL_BACKOFF;
        public static final /* enum */ BackoffStrategy LINEAR_BACKOFF;
        public static final /* enum */ BackoffStrategy CONSTANT_BACKOFF;
        private static final /* synthetic */ BackoffStrategy[] $VALUES;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public static BackoffStrategy[] values() {
            return (BackoffStrategy[])$VALUES.clone();
        }

        public static BackoffStrategy valueOf(String name) {
            return Enum.valueOf(BackoffStrategy.class, name);
        }

        static {
            BackoffStrategy.ajc$preClinit();
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
            Object[] objectArray = new Object[]{joinPoint};
            OdpsDeprecatedLogger.aspectOf().around(new RetryStrategy$BackoffStrategy$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }

        static /* synthetic */ void clinit$_aroundBody0(JoinPoint joinPoint) {
            EXPONENTIAL_BACKOFF = new BackoffStrategy();
            LINEAR_BACKOFF = new BackoffStrategy();
            CONSTANT_BACKOFF = new BackoffStrategy();
            $VALUES = new BackoffStrategy[]{EXPONENTIAL_BACKOFF, LINEAR_BACKOFF, CONSTANT_BACKOFF};
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("RetryStrategy.java", BackoffStrategy.class);
            ajc$tjp_0 = factory.makeSJP("staticinitialization", (Signature)factory.makeInitializerSig("8", "com.aliyun.odps.commons.util.RetryStrategy$BackoffStrategy"), 51);
        }
    }
}

