/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.Instances;
import com.aliyun.odps.ListIterator;
import com.aliyun.odps.NoSuchObjectException;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Table;
import com.aliyun.odps.TableFilter;
import com.aliyun.odps.TableSchema;
import com.aliyun.odps.filter.AdvancedFilter;
import com.aliyun.odps.filter.AdvancedFilterUtils;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.utils.StringUtils;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Tables
implements Iterable<Table> {
    private RestClient client;
    private Odps odps;

    Tables(Odps odps) {
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public Table get(String tableName) {
        return this.get(this.getDefaultProjectName(), tableName);
    }

    public Table get(String projectName, String tableName) {
        Table.TableModel model = new Table.TableModel();
        model.name = tableName;
        Table t = new Table(model, projectName, this.odps);
        return t;
    }

    public boolean exists(String tableName) throws OdpsException {
        return this.exists(this.getDefaultProjectName(), tableName);
    }

    public boolean exists(String projectName, String tableName) throws OdpsException {
        try {
            Table t = this.get(projectName, tableName);
            t.reload();
            return true;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public Iterator<Table> searchTable(String executeProject, List<String> projects, AdvancedFilter filter) {
        return this.searchTable(executeProject, projects, filter, 0L, 100, Integer.MAX_VALUE);
    }

    public Iterator<Table> searchTable(String executeProject, List<String> projects, AdvancedFilter filter, long offset, int batchSize) {
        return this.searchTable(executeProject, projects, filter, offset, batchSize, Integer.MAX_VALUE);
    }

    public Iterator<Table> searchTable(String executeProject, List<String> projects, AdvancedFilter filter, long offset, int batchSize, int limit) {
        return new TableIterator(executeProject, projects, filter, offset, batchSize, limit);
    }

    @Override
    public Iterator<Table> iterator() {
        return this.iterator(this.getDefaultProjectName(), null);
    }

    public Iterator<Table> iterator(String projectName) {
        return this.iterator(projectName, null);
    }

    public Iterator<Table> iterator(TableFilter filter) {
        return this.iterator(this.getDefaultProjectName(), filter);
    }

    public Iterator<Table> iterator(String projectName, TableFilter filter) {
        return new TableListIterator(projectName, filter, false);
    }

    public Iterator<Table> iterator(String projectName, TableFilter filter, boolean extended) {
        return new TableListIterator(projectName, filter, extended);
    }

    public Iterable<Table> iterable() {
        return this.iterable(this.getDefaultProjectName());
    }

    public Iterable<Table> iterable(String projectName) {
        return this.iterable(projectName, null);
    }

    public Iterable<Table> iterable(TableFilter filter) {
        return this.iterable(this.getDefaultProjectName(), filter);
    }

    public Iterable<Table> iterable(String projectName, TableFilter filter) {
        return this.iterable(projectName, filter, false);
    }

    public Iterable<Table> iterable(String projectName, TableFilter filter, boolean extended) {
        return () -> new TableListIterator(projectName, filter, extended);
    }

    public void create(String tableName, TableSchema schema) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema);
    }

    public void create(String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(this.client.getDefaultProject(), tableName, schema, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists, Long shardNum, Long hubLifecycle) throws OdpsException {
        this.create(projectName, tableName, schema, null, ifNotExists, shardNum, hubLifecycle);
    }

    public void create(String projectName, String tableName, TableSchema schema) throws OdpsException {
        this.create(projectName, tableName, schema, false);
    }

    public void create(String projectName, String tableName, TableSchema schema, boolean ifNotExists) throws OdpsException {
        this.create(projectName, tableName, schema, null, ifNotExists);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long shardNum, Long hubLifecycle) throws OdpsException {
        String taskName = "SQLCreateTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(this.getHubString(projectName, tableName, schema, comment, ifNotExists, shardNum, hubLifecycle));
        this.submitCreateAndWait(task, null, null);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists) throws OdpsException {
        this.createTableWithLifeCycle(projectName, tableName, schema, comment, ifNotExists, null);
    }

    public void createTableWithLifeCycle(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle) throws OdpsException {
        this.create(projectName, tableName, schema, comment, ifNotExists, lifeCycle, null, null);
    }

    public void create(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        String taskName = "SQLCreateTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(this.getSQLString(projectName, tableName, schema, comment, ifNotExists, lifeCycle));
        this.submitCreateAndWait(task, hints, aliases);
    }

    public void createExternal(String projectName, String tableName, TableSchema schema, String location, String storedBy, List<String> usingJars, Map<String, String> serdeProperties, String comment, boolean ifNotExists, Long lifeCycle, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        SQLTask task = new SQLTask();
        task.setName("SQLCreateExternalTableTask");
        task.setQuery(this.getExternalSQLStringStoredBy(projectName, tableName, schema, comment, ifNotExists, lifeCycle, storedBy, location, usingJars, serdeProperties));
        this.submitCreateAndWait(task, hints, aliases);
    }

    public void delete(String tableName) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName);
    }

    public void delete(String tableName, boolean ifExists) throws OdpsException {
        this.delete(this.client.getDefaultProject(), tableName, ifExists);
    }

    public void delete(String projectName, String tableName) throws OdpsException {
        this.delete(projectName, tableName, false);
    }

    public void delete(String projectName, String tableName, boolean ifExists) throws OdpsException {
        if (projectName == null || tableName == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("DROP TABLE ");
        if (ifExists) {
            sb.append(" IF EXISTS ");
        }
        sb.append(projectName).append(".").append(tableName).append(";");
        String taskName = "SQLDropTableTask";
        SQLTask task = new SQLTask();
        task.setName(taskName);
        task.setQuery(sb.toString());
        Instances instances = new Instances(this.odps);
        Instance instance = instances.create(task);
        instance.waitForSuccess();
    }

    public List<Table> loadTables(Collection<String> tableNames) throws OdpsException {
        return this.loadTables(this.getDefaultProjectName(), tableNames);
    }

    public List<Table> loadTables(String projectName, Collection<String> tableNames) throws OdpsException {
        if (StringUtils.isNullOrEmpty((String)projectName)) {
            throw new IllegalArgumentException("Invalid project name.");
        }
        if (tableNames == null) {
            throw new IllegalArgumentException("Invalid table names.");
        }
        QueryTables queryTables = new QueryTables();
        for (String name : tableNames) {
            queryTables.tables.add(new QueryTables.QueryTable(projectName, name));
        }
        return this.loadTablesInternal(queryTables);
    }

    public List<Table> reloadTables(Collection<Table> tables) throws OdpsException {
        if (tables == null) {
            throw new IllegalArgumentException("Invalid tables.");
        }
        return this.reloadTables(tables.iterator());
    }

    public List<Table> reloadTables(Iterator<Table> tables) throws OdpsException {
        if (tables == null) {
            throw new IllegalArgumentException("Invalid tables.");
        }
        ArrayList<Table> loadedTables = new ArrayList<Table>();
        if (!tables.hasNext()) {
            return loadedTables;
        }
        QueryTables queryTables = new QueryTables();
        while (tables.hasNext()) {
            Table t = tables.next();
            if (t.isLoaded()) {
                loadedTables.add(t);
                continue;
            }
            queryTables.tables.add(new QueryTables.QueryTable(t.getProject(), t.getName()));
        }
        if (!queryTables.tables.isEmpty()) {
            loadedTables.addAll(this.loadTablesInternal(queryTables));
        }
        return loadedTables;
    }

    private List<Table> loadTablesInternal(QueryTables queryTables) throws OdpsException {
        ArrayList<Table> reloadTables = new ArrayList<Table>();
        if (queryTables.tables.isEmpty()) {
            return reloadTables;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("query", null);
        String resource = ResourceBuilder.buildTablesResource(this.getDefaultProjectName());
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/xml");
        String xml = null;
        try {
            xml = SimpleXmlUtils.marshal(queryTables);
        }
        catch (Exception e) {
            throw new OdpsException(e.getMessage(), e);
        }
        ListTablesResponse resp = this.client.stringRequest(ListTablesResponse.class, resource, "POST", params, headers, xml);
        for (Table.TableModel model : resp.tables) {
            Table t = new Table(model, model.projectName, this.odps);
            t.reload(model);
            reloadTables.add(t);
        }
        return reloadTables;
    }

    private String getDefaultProjectName() {
        String project = this.client.getDefaultProject();
        if (project == null || project.length() == 0) {
            throw new RuntimeException("No default project specified.");
        }
        return project;
    }

    private void submitCreateAndWait(SQLTask task, Map<String, String> hints, Map<String, String> aliases) throws OdpsException {
        String json;
        if (hints != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(hints);
                task.setProperty("settings", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        if (aliases != null) {
            try {
                json = new GsonBuilder().disableHtmlEscaping().create().toJson(aliases);
                task.setProperty("aliases", json);
            }
            catch (Exception e) {
                throw new OdpsException(e.getMessage(), e);
            }
        }
        Instances instances = new Instances(this.odps);
        Instance instance = instances.create(task);
        instance.waitForSuccess();
    }

    private String getHubString(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long shardNum, Long hubLifecycle) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSQLString(projectName, tableName, schema, comment, ifNotExists, null));
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (null != shardNum) {
            sb.append(" INTO " + String.valueOf(shardNum) + " SHARDS");
        }
        if (null != hubLifecycle) {
            sb.append(" HUBLIFECYCLE " + String.valueOf(hubLifecycle));
        }
        sb.append(';');
        return sb.toString();
    }

    private String getExternalSQLStringStoredBy(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle, String storedBy, String location, List<String> jars, Map<String, String> properties) {
        int index;
        String plainString = this.getSQLString(projectName, tableName, schema, comment, ifNotExists, lifeCycle);
        if (!plainString.startsWith("CREATE TABLE ")) {
            throw new RuntimeException("Plain sql table creation must start with CREATE TABLE .");
        }
        plainString = new StringBuilder(plainString).insert("CREATE".length(), " EXTERNAL").toString();
        if (storedBy == null || location == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" STORED BY '").append(storedBy.trim()).append("'");
        if (properties != null && !properties.isEmpty()) {
            sb.append(" WITH SERDEPROPERTIES(");
            index = 0;
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                sb.append("'").append(entry.getKey()).append("' = '").append(entry.getValue()).append("'");
                if (++index == properties.size()) continue;
                sb.append(" , ");
            }
            sb.append(")");
        }
        sb.append(" LOCATION '").append(location).append("'");
        if (jars != null && !jars.isEmpty()) {
            sb.append(" USING '");
            index = 0;
            for (String jar : jars) {
                sb.append(jar);
                if (++index == jars.size()) continue;
                sb.append(",");
            }
            sb.append("'");
        }
        if (lifeCycle != null) {
            index = plainString.lastIndexOf(" LIFECYCLE ");
            if (index < 0) {
                throw new IllegalArgumentException();
            }
            plainString = plainString.substring(0, index);
            sb.append(" LIFECYCLE ").append(lifeCycle).append(";");
        } else {
            plainString = plainString.substring(0, plainString.length() - 1);
            sb.append(";");
        }
        return plainString + sb.toString();
    }

    private String getSQLString(String projectName, String tableName, TableSchema schema, String comment, boolean ifNotExists, Long lifeCycle) {
        List pcolumns;
        if (projectName == null || tableName == null || schema == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        if (ifNotExists) {
            sb.append(" IF NOT EXISTS ");
        }
        sb.append(projectName).append(".`").append(tableName).append("` (");
        List columns = schema.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            Column c = (Column)columns.get(i);
            sb.append("`").append(c.getName()).append("` ").append(c.getTypeInfo().getTypeName());
            if (c.getComment() != null) {
                sb.append(" COMMENT '").append(c.getComment()).append("'");
            }
            if (i + 1 >= columns.size()) continue;
            sb.append(',');
        }
        sb.append(')');
        if (comment != null) {
            sb.append(" COMMENT '" + comment + "' ");
        }
        if ((pcolumns = schema.getPartitionColumns()).size() > 0) {
            sb.append(" PARTITIONED BY (");
            for (int i = 0; i < pcolumns.size(); ++i) {
                Column c = (Column)pcolumns.get(i);
                sb.append(c.getName()).append(" ").append(c.getTypeInfo().getTypeName());
                if (c.getComment() != null) {
                    sb.append(" COMMENT '").append(c.getComment()).append("'");
                }
                if (i + 1 >= pcolumns.size()) continue;
                sb.append(',');
            }
            sb.append(')');
        }
        if (lifeCycle != null) {
            sb.append(" LIFECYCLE ").append(lifeCycle);
        }
        sb.append(';');
        return sb.toString();
    }

    private class TableListIterator
    extends ListIterator<Table> {
        Map<String, String> params = new HashMap<String, String>();
        private TableFilter filter;
        private String projectName;
        private boolean extended;

        TableListIterator(String projectName, TableFilter filter, boolean extended) {
            this.filter = filter;
            this.projectName = projectName;
            this.extended = extended;
        }

        @Override
        protected List<Table> list() {
            ArrayList<Table> tables = new ArrayList<Table>();
            this.params.put("expectmarker", "true");
            String lastMarker = this.params.get("marker");
            if (this.params.containsKey("marker") && lastMarker.length() == 0) {
                return null;
            }
            if (this.filter != null) {
                if (this.filter.getName() != null) {
                    this.params.put("name", this.filter.getName());
                }
                if (this.filter.getOwner() != null) {
                    this.params.put("owner", this.filter.getOwner());
                }
            }
            if (this.extended) {
                this.params.put("extended", null);
            }
            String resource = ResourceBuilder.buildTablesResource(this.projectName);
            try {
                ListTablesResponse resp = Tables.this.client.request(ListTablesResponse.class, resource, "GET", this.params);
                for (Table.TableModel model : resp.tables) {
                    Table t = new Table(model, this.projectName, Tables.this.odps);
                    tables.add(t);
                }
                this.params.put("marker", resp.marker);
            }
            catch (OdpsException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return tables;
        }
    }

    private class TableIterator
    extends ListIterator<Table> {
        private String executeProject;
        private TableFilterModel reusedTableFilterModel;
        private int limit;
        private int numCachedEntries = 0;

        TableIterator(String executeProject, List<String> projects, AdvancedFilter filter, long offset, int batchSize, int limit) {
            if (executeProject == null) {
                throw new IllegalArgumentException("Argument 'executeProject' cannot be null");
            }
            if (filter == null) {
                throw new IllegalArgumentException("Argument 'filter' cannot be null");
            }
            if (offset < 0L || batchSize < 0 || limit < 0) {
                throw new IllegalArgumentException("Argument 'offset', 'batchSize', 'limit' cannot be negative");
            }
            if (projects == null) {
                projects = new ArrayList<String>();
            }
            this.executeProject = executeProject;
            this.limit = limit;
            this.reusedTableFilterModel = new TableFilterModel();
            this.reusedTableFilterModel.marker = Long.toString(offset);
            this.reusedTableFilterModel.maxItems = batchSize;
            this.reusedTableFilterModel.projects = projects;
            this.reusedTableFilterModel.propertyFilter = new TableFilterModel.PropertyFilter();
            ArrayList<AdvancedFilterUtils.Criterion> criteria = new ArrayList<AdvancedFilterUtils.Criterion>();
            AdvancedFilterUtils.getCriteria(filter, criteria);
            this.reusedTableFilterModel.propertyFilter.criteria = criteria;
            this.reusedTableFilterModel.propertyFilter.condition = "AND";
        }

        @Override
        protected List<Table> list() {
            try {
                if (this.numCachedEntries == this.limit) {
                    return null;
                }
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("Content-Type", "application/xml");
                String xml = SimpleXmlUtils.marshal(this.reusedTableFilterModel);
                TableFilterResponse tableFilterResponse = Tables.this.odps.getRestClient().stringRequest(TableFilterResponse.class, "/projects/" + this.executeProject + "/meta/tables", "POST", null, header, xml);
                if (tableFilterResponse.tables == null) {
                    return null;
                }
                LinkedList<Table> tables = new LinkedList<Table>();
                for (TableFilterResponse.TableFilterResponseEntry entry : tableFilterResponse.tables) {
                    Table table = Tables.this.odps.tables().get(entry.project, entry.name);
                    table.setLoaded(true);
                    tables.add(table);
                    ++this.numCachedEntries;
                    if (this.numCachedEntries != this.limit) continue;
                    break;
                }
                this.reusedTableFilterModel.marker = tableFilterResponse.marker;
                return tables;
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    @Root(name="Tables", strict=false)
    private static class TableFilterResponse {
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        Integer maxItems;
        @ElementList(entry="Table", inline=true, required=false)
        List<TableFilterResponseEntry> tables;

        private TableFilterResponse() {
        }

        @Root(name="Table", strict=false)
        private static class TableFilterResponseEntry {
            @Element(name="Project")
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String project;
            @Element(name="Name")
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String name;
            @Element(name="Schema")
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            String schema;

            private TableFilterResponseEntry() {
            }
        }
    }

    @Root(name="Search", strict=false)
    private static class TableFilterModel {
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String marker;
        @Element(name="MaxItems", required=false)
        Integer maxItems;
        @ElementList(name="Projects", entry="Project", required=false)
        List<String> projects;
        @Element(name="PropertyFilter", required=false)
        PropertyFilter propertyFilter;

        private TableFilterModel() {
        }

        @Root(name="PropertyFilter", strict=false)
        private static class PropertyFilter {
            @Element(name="Condition", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String condition;
            @ElementList(name="Criterions", entry="Criterion", required=false)
            List<AdvancedFilterUtils.Criterion> criteria;

            private PropertyFilter() {
            }
        }
    }

    @Root(name="Tables", strict=false)
    private static class QueryTables {
        @ElementList(entry="Table", inline=true, required=false)
        private List<QueryTable> tables = new ArrayList<QueryTable>();

        private QueryTables() {
        }

        @Root(name="Table", strict=false)
        private static class QueryTable {
            @Element(name="Project", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String projectName;
            @Element(name="Name", required=false)
            @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
            private String tableName;

            QueryTable() {
            }

            QueryTable(String projectName, String tableName) {
                this.projectName = projectName;
                this.tableName = tableName;
            }
        }
    }

    @Root(name="Tables", strict=false)
    private static class ListTablesResponse {
        @ElementList(entry="Table", inline=true, required=false)
        private List<Table.TableModel> tables = new ArrayList<Table.TableModel>();
        @Element(name="Marker", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        private String marker;
        @Element(name="MaxItems", required=false)
        private Integer maxItems;

        private ListTablesResponse() {
        }
    }
}

