/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps;

import com.aliyun.odps.Function$AjcClosure1;
import com.aliyun.odps.Function$AjcClosure3;
import com.aliyun.odps.LazyLoad;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsDeprecatedLogger;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Resource;
import com.aliyun.odps.rest.ResourceBuilder;
import com.aliyun.odps.rest.RestClient;
import com.aliyun.odps.rest.SimpleXmlUtils;
import com.aliyun.odps.simpleframework.xml.Element;
import com.aliyun.odps.simpleframework.xml.ElementList;
import com.aliyun.odps.simpleframework.xml.Root;
import com.aliyun.odps.simpleframework.xml.convert.Convert;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class Function
extends LazyLoad {
    FunctionModel model;
    String project;
    RestClient client;
    Odps odps;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    public Function() {
        this.model = new FunctionModel();
    }

    Function(FunctionModel functionModel, String project, Odps odps) {
        this.model = functionModel;
        this.project = project;
        this.odps = odps;
        this.client = odps.getRestClient();
    }

    public String getName() {
        if (this.model.name == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.name;
    }

    public void setName(String name) {
        this.model.name = name;
    }

    public String getOwner() {
        if (this.model.owner == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.owner;
    }

    public Date getCreatedTime() {
        if (this.model.createdTime == null) {
            this.lazyLoad();
        }
        return this.model.createdTime;
    }

    @Deprecated
    public String getClassType() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)OdpsDeprecatedLogger.aspectOf().around(new Function$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String getClassPath() {
        if (this.model.classType == null && this.client != null) {
            this.lazyLoad();
        }
        return this.model.classType;
    }

    @Deprecated
    public void setClassType(String classType) {
        String string = classType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        OdpsDeprecatedLogger.aspectOf().around(new Function$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setClassPath(String classPath) {
        this.model.classType = classPath;
    }

    public List<Resource> getResources() {
        if (this.model.resources == null && this.client != null) {
            this.lazyLoad();
        }
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.model.resources != null) {
            Map<String, String> resourceNames = this.parseResourcesName(this.model.resources);
            for (Map.Entry<String, String> entry : resourceNames.entrySet()) {
                Resource.ResourceModel rm = new Resource.ResourceModel();
                rm.name = entry.getKey();
                Resource res = Resource.getResource(rm, entry.getValue(), this.odps);
                resources.add(res);
            }
        }
        return resources;
    }

    private Map<String, String> parseResourcesName(List<String> resources) {
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        for (String r : resources) {
            String[] splits = r.split("/resources/");
            String resourceProject = null;
            String resourceName = null;
            if (splits.length > 1) {
                resourceProject = splits[0];
                resourceName = splits[1];
            } else {
                resourceProject = this.project;
                resourceName = r;
            }
            resourceMap.put(resourceName, resourceProject);
        }
        return resourceMap;
    }

    public List<String> getResourceNames() {
        if (this.model.resources == null && this.client != null) {
            this.lazyLoad();
        }
        ArrayList<String> resourceNames = new ArrayList<String>();
        if (this.model.resources != null) {
            Map<String, String> resources = this.parseResourcesName(this.model.resources);
            for (Map.Entry<String, String> entry : resources.entrySet()) {
                if (entry.getValue().equals(this.project)) {
                    resourceNames.add(entry.getKey());
                    continue;
                }
                resourceNames.add(entry.getValue() + "/" + entry.getKey());
            }
        }
        return resourceNames;
    }

    public void setResources(List<String> resources) {
        this.model.resources = new ArrayList();
        this.model.resources.addAll(resources);
    }

    public String getProject() {
        return this.project;
    }

    public boolean isSqlFunction() {
        this.lazyLoad();
        if (this.model.isSqlFunction == null) {
            this.model.isSqlFunction = false;
        }
        return this.model.isSqlFunction;
    }

    public String getSqlDefinitionText() {
        this.lazyLoad();
        if (this.isSqlFunction()) {
            return this.model.sqlDefinitionText;
        }
        return null;
    }

    @Override
    public void reload() throws OdpsException {
        String resource = ResourceBuilder.buildFunctionResource(this.project, this.model.name);
        this.model = this.client.request(FunctionModel.class, resource, "GET", null);
    }

    public void updateOwner(String newOwner) throws OdpsException {
        String method = "PUT";
        String resource = ResourceBuilder.buildFunctionResource(this.project, this.model.name);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("updateowner", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-odps-owner", newOwner);
        FunctionModel model = new FunctionModel();
        this.client.request(resource, method, params, headers, null);
        this.model.owner = newOwner;
    }

    static {
        Function.ajc$preClinit();
    }

    static /* synthetic */ String getClassType_aroundBody0(Function ajc$this, JoinPoint joinPoint) {
        if (ajc$this.model.classType == null && ajc$this.client != null) {
            ajc$this.lazyLoad();
        }
        return ajc$this.model.classType;
    }

    static /* synthetic */ void setClassType_aroundBody2(Function ajc$this, String classType, JoinPoint joinPoint) {
        ajc$this.model.classType = classType;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("Function.java", Function.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getClassType", "com.aliyun.odps.Function", "", "", "", "java.lang.String"), 147);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setClassType", "com.aliyun.odps.Function", "java.lang.String", "classType", "", "void"), 170);
    }

    @Root(name="Function", strict=false)
    static class FunctionModel {
        @Element(name="Alias", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String name;
        @Element(name="Owner", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String owner;
        @Element(name="CreationTime", required=false)
        @Convert(value=SimpleXmlUtils.DateConverter.class)
        Date createdTime;
        @Element(name="ClassType", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String classType;
        @ElementList(name="Resources", entry="ResourceName", required=false)
        ArrayList<String> resources;
        @Element(name="IsSqlFunction", required=false)
        Boolean isSqlFunction;
        @Element(name="SqlDefinitionText", required=false)
        @Convert(value=SimpleXmlUtils.EmptyStringConverter.class)
        String sqlDefinitionText;

        FunctionModel() {
        }
    }
}

