/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.jdbc;

import java.sql.SQLFeatureNotSupportedException;
import java.util.Locale;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.jdbc.JdbcDialect;
import org.apache.spark.sql.jdbc.JdbcType;
import org.apache.spark.sql.jdbc.MsSqlServerDialect$SpecificTypes$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class MsSqlServerDialect$
extends JdbcDialect {
    public static MsSqlServerDialect$ MODULE$;

    static {
        new MsSqlServerDialect$();
    }

    @Override
    public boolean canHandle(String url) {
        return url.toLowerCase(Locale.ROOT).startsWith("jdbc:sqlserver");
    }

    @Override
    public Option<DataType> getCatalystType(int sqlType, String typeName, int size, MetadataBuilder md) {
        Option option;
        if (typeName.contains("datetimeoffset")) {
            option = Option$.MODULE$.apply((Object)StringType$.MODULE$);
        } else if (SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled()) {
            option = None$.MODULE$;
        } else {
            Object object;
            int n = sqlType;
            if (5 == n) {
                object = new Some((Object)ShortType$.MODULE$);
            } else if (7 == n) {
                object = new Some((Object)FloatType$.MODULE$);
            } else {
                boolean bl = MsSqlServerDialect$SpecificTypes$.MODULE$.GEOMETRY() == n ? true : MsSqlServerDialect$SpecificTypes$.MODULE$.GEOGRAPHY() == n;
                object = bl ? new Some((Object)BinaryType$.MODULE$) : None$.MODULE$;
            }
            option = object;
        }
        return option;
    }

    @Override
    public Option<JdbcType> getJDBCType(DataType dt) {
        DataType dataType = dt;
        Object object = TimestampType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("DATETIME", 93)) : (StringType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("NVARCHAR(MAX)", -9)) : (BooleanType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("BIT", -7)) : (BinaryType$.MODULE$.equals(dataType) ? new Some((Object)new JdbcType("VARBINARY(MAX)", -3)) : (ShortType$.MODULE$.equals(dataType) && !SQLConf$.MODULE$.get().legacyMsSqlServerNumericMappingEnabled() ? new Some((Object)new JdbcType("SMALLINT", 5)) : None$.MODULE$))));
        return object;
    }

    @Override
    public Option<Object> isCascadingTruncateTable() {
        return new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
    }

    @Override
    public String renameTable(String oldTable, String newTable) {
        return new StringBuilder(17).append("EXEC sp_rename ").append(oldTable).append(", ").append(newTable).toString();
    }

    @Override
    public String getAddColumnQuery(String tableName, String columnName, String dataType) {
        return new StringBuilder(18).append("ALTER TABLE ").append(tableName).append(" ADD ").append(this.quoteIdentifier(columnName)).append(" ").append(dataType).toString();
    }

    @Override
    public String getRenameColumnQuery(String tableName, String columnName, String newName, int dbMajorVersion) {
        return new StringBuilder(30).append("EXEC sp_rename '").append(tableName).append(".").append(this.quoteIdentifier(columnName)).append("',").append(" ").append(this.quoteIdentifier(newName)).append(", 'COLUMN'").toString();
    }

    @Override
    public String getUpdateColumnNullabilityQuery(String tableName, String columnName, boolean isNullable) {
        throw new SQLFeatureNotSupportedException("UpdateColumnNullability is not supported");
    }

    @Override
    public String getTableCommentQuery(String table, String comment) {
        throw new SQLFeatureNotSupportedException("comment on table is not supported");
    }

    private Object readResolve() {
        return MODULE$;
    }

    private MsSqlServerDialect$() {
        MODULE$ = this;
    }
}

