/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.vectorized;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.types.UTF8String;

public final class OnHeapColumnVector
extends WritableColumnVector {
    private static final boolean bigEndianPlatform = ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN);
    private byte[] nulls;
    private byte[] byteData;
    private short[] shortData;
    private int[] intData;
    private long[] longData;
    private float[] floatData;
    private double[] doubleData;
    private int[] arrayLengths;
    private int[] arrayOffsets;

    public static OnHeapColumnVector[] allocateColumns(int capacity, StructType schema) {
        return OnHeapColumnVector.allocateColumns(capacity, schema.fields());
    }

    public static OnHeapColumnVector[] allocateColumns(int capacity, StructField[] fields) {
        OnHeapColumnVector[] vectors = new OnHeapColumnVector[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            vectors[i] = new OnHeapColumnVector(capacity, fields[i].dataType());
        }
        return vectors;
    }

    public OnHeapColumnVector(int capacity, DataType type) {
        super(capacity, type);
        this.reserveInternal(capacity);
        this.reset();
    }

    @Override
    public void close() {
        super.close();
        this.nulls = null;
        this.byteData = null;
        this.shortData = null;
        this.intData = null;
        this.longData = null;
        this.floatData = null;
        this.doubleData = null;
        this.arrayLengths = null;
        this.arrayOffsets = null;
    }

    @Override
    public void putNotNull(int rowId) {
        this.nulls[rowId] = 0;
    }

    @Override
    public void putNull(int rowId) {
        this.nulls[rowId] = 1;
        ++this.numNulls;
    }

    @Override
    public void putNulls(int rowId, int count) {
        for (int i = 0; i < count; ++i) {
            this.nulls[rowId + i] = 1;
        }
        this.numNulls += count;
    }

    @Override
    public void putNotNulls(int rowId, int count) {
        if (!this.hasNull()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            this.nulls[rowId + i] = 0;
        }
    }

    public boolean isNullAt(int rowId) {
        return this.nulls[rowId] == 1;
    }

    @Override
    public void putBoolean(int rowId, boolean value) {
        this.byteData[rowId] = (byte)(value ? 1 : 0);
    }

    @Override
    public void putBooleans(int rowId, int count, boolean value) {
        byte v = (byte)(value ? 1 : 0);
        for (int i = 0; i < count; ++i) {
            this.byteData[i + rowId] = v;
        }
    }

    public boolean getBoolean(int rowId) {
        return this.byteData[rowId] == 1;
    }

    public boolean[] getBooleans(int rowId, int count) {
        assert (this.dictionary == null);
        boolean[] array = new boolean[count];
        for (int i = 0; i < count; ++i) {
            array[i] = this.byteData[rowId + i] == 1;
        }
        return array;
    }

    @Override
    public void putByte(int rowId, byte value) {
        this.byteData[rowId] = value;
    }

    @Override
    public void putBytes(int rowId, int count, byte value) {
        for (int i = 0; i < count; ++i) {
            this.byteData[i + rowId] = value;
        }
    }

    @Override
    public void putBytes(int rowId, int count, byte[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.byteData, rowId, count);
    }

    public byte getByte(int rowId) {
        if (this.dictionary == null) {
            return this.byteData[rowId];
        }
        return (byte)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    public byte[] getBytes(int rowId, int count) {
        assert (this.dictionary == null);
        byte[] array = new byte[count];
        System.arraycopy(this.byteData, rowId, array, 0, count);
        return array;
    }

    @Override
    protected UTF8String getBytesAsUTF8String(int rowId, int count) {
        return UTF8String.fromBytes((byte[])this.byteData, (int)rowId, (int)count);
    }

    @Override
    public void putShort(int rowId, short value) {
        this.shortData[rowId] = value;
    }

    @Override
    public void putShorts(int rowId, int count, short value) {
        for (int i = 0; i < count; ++i) {
            this.shortData[i + rowId] = value;
        }
    }

    @Override
    public void putShorts(int rowId, int count, short[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.shortData, rowId, count);
    }

    @Override
    public void putShorts(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.shortData, (long)((long)Platform.SHORT_ARRAY_OFFSET + (long)rowId * 2L), (long)((long)count * 2L));
    }

    public short getShort(int rowId) {
        if (this.dictionary == null) {
            return this.shortData[rowId];
        }
        return (short)this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    public short[] getShorts(int rowId, int count) {
        assert (this.dictionary == null);
        short[] array = new short[count];
        System.arraycopy(this.shortData, rowId, array, 0, count);
        return array;
    }

    @Override
    public void putInt(int rowId, int value) {
        this.intData[rowId] = value;
    }

    @Override
    public void putInts(int rowId, int count, int value) {
        for (int i = 0; i < count; ++i) {
            this.intData[i + rowId] = value;
        }
    }

    @Override
    public void putInts(int rowId, int count, int[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.intData, rowId, count);
    }

    @Override
    public void putInts(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.intData, (long)((long)Platform.INT_ARRAY_OFFSET + (long)rowId * 4L), (long)((long)count * 4L));
    }

    @Override
    public void putIntsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
        int i = 0;
        while (i < count) {
            this.intData[i + rowId] = Platform.getInt((Object)src, (long)srcOffset);
            if (bigEndianPlatform) {
                this.intData[i + rowId] = Integer.reverseBytes(this.intData[i + rowId]);
            }
            ++i;
            srcOffset += 4;
        }
    }

    public int getInt(int rowId) {
        if (this.dictionary == null) {
            return this.intData[rowId];
        }
        return this.dictionary.decodeToInt(this.dictionaryIds.getDictId(rowId));
    }

    public int[] getInts(int rowId, int count) {
        assert (this.dictionary == null);
        int[] array = new int[count];
        System.arraycopy(this.intData, rowId, array, 0, count);
        return array;
    }

    @Override
    public int getDictId(int rowId) {
        assert (this.dictionary == null) : "A ColumnVector dictionary should not have a dictionary for itself.";
        return this.intData[rowId];
    }

    @Override
    public void putLong(int rowId, long value) {
        this.longData[rowId] = value;
    }

    @Override
    public void putLongs(int rowId, int count, long value) {
        for (int i = 0; i < count; ++i) {
            this.longData[i + rowId] = value;
        }
    }

    @Override
    public void putLongs(int rowId, int count, long[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.longData, rowId, count);
    }

    @Override
    public void putLongs(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.longData, (long)((long)Platform.LONG_ARRAY_OFFSET + (long)rowId * 8L), (long)((long)count * 8L));
    }

    @Override
    public void putLongsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        int srcOffset = srcIndex + Platform.BYTE_ARRAY_OFFSET;
        int i = 0;
        while (i < count) {
            this.longData[i + rowId] = Platform.getLong((Object)src, (long)srcOffset);
            if (bigEndianPlatform) {
                this.longData[i + rowId] = Long.reverseBytes(this.longData[i + rowId]);
            }
            ++i;
            srcOffset += 8;
        }
    }

    public long getLong(int rowId) {
        if (this.dictionary == null) {
            return this.longData[rowId];
        }
        return this.dictionary.decodeToLong(this.dictionaryIds.getDictId(rowId));
    }

    public long[] getLongs(int rowId, int count) {
        assert (this.dictionary == null);
        long[] array = new long[count];
        System.arraycopy(this.longData, rowId, array, 0, count);
        return array;
    }

    @Override
    public void putFloat(int rowId, float value) {
        this.floatData[rowId] = value;
    }

    @Override
    public void putFloats(int rowId, int count, float value) {
        Arrays.fill(this.floatData, rowId, rowId + count, value);
    }

    @Override
    public void putFloats(int rowId, int count, float[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.floatData, rowId, count);
    }

    @Override
    public void putFloats(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.floatData, (long)((long)Platform.FLOAT_ARRAY_OFFSET + (long)rowId * 4L), (long)((long)count * 4L));
    }

    @Override
    public void putFloatsLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            this.putFloats(rowId, count, src, srcIndex);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < count; ++i) {
                this.floatData[i + rowId] = bb.getFloat(srcIndex + 4 * i);
            }
        }
    }

    public float getFloat(int rowId) {
        if (this.dictionary == null) {
            return this.floatData[rowId];
        }
        return this.dictionary.decodeToFloat(this.dictionaryIds.getDictId(rowId));
    }

    public float[] getFloats(int rowId, int count) {
        assert (this.dictionary == null);
        float[] array = new float[count];
        System.arraycopy(this.floatData, rowId, array, 0, count);
        return array;
    }

    @Override
    public void putDouble(int rowId, double value) {
        this.doubleData[rowId] = value;
    }

    @Override
    public void putDoubles(int rowId, int count, double value) {
        Arrays.fill(this.doubleData, rowId, rowId + count, value);
    }

    @Override
    public void putDoubles(int rowId, int count, double[] src, int srcIndex) {
        System.arraycopy(src, srcIndex, this.doubleData, rowId, count);
    }

    @Override
    public void putDoubles(int rowId, int count, byte[] src, int srcIndex) {
        Platform.copyMemory((Object)src, (long)(Platform.BYTE_ARRAY_OFFSET + srcIndex), (Object)this.doubleData, (long)((long)Platform.DOUBLE_ARRAY_OFFSET + (long)rowId * 8L), (long)((long)count * 8L));
    }

    @Override
    public void putDoublesLittleEndian(int rowId, int count, byte[] src, int srcIndex) {
        if (!bigEndianPlatform) {
            this.putDoubles(rowId, count, src, srcIndex);
        } else {
            ByteBuffer bb = ByteBuffer.wrap(src).order(ByteOrder.LITTLE_ENDIAN);
            for (int i = 0; i < count; ++i) {
                this.doubleData[i + rowId] = bb.getDouble(srcIndex + 8 * i);
            }
        }
    }

    public double getDouble(int rowId) {
        if (this.dictionary == null) {
            return this.doubleData[rowId];
        }
        return this.dictionary.decodeToDouble(this.dictionaryIds.getDictId(rowId));
    }

    public double[] getDoubles(int rowId, int count) {
        assert (this.dictionary == null);
        double[] array = new double[count];
        System.arraycopy(this.doubleData, rowId, array, 0, count);
        return array;
    }

    @Override
    public int getArrayLength(int rowId) {
        return this.arrayLengths[rowId];
    }

    @Override
    public int getArrayOffset(int rowId) {
        return this.arrayOffsets[rowId];
    }

    @Override
    public void putArray(int rowId, int offset, int length) {
        this.arrayOffsets[rowId] = offset;
        this.arrayLengths[rowId] = length;
    }

    @Override
    public int putByteArray(int rowId, byte[] value, int offset, int length) {
        int result;
        this.arrayOffsets[rowId] = result = this.arrayData().appendBytes(length, value, offset);
        this.arrayLengths[rowId] = length;
        return result;
    }

    @Override
    protected void reserveInternal(int newCapacity) {
        Object[] newData;
        if (this.isArray() || this.type instanceof MapType) {
            int[] newLengths = new int[newCapacity];
            int[] newOffsets = new int[newCapacity];
            if (this.arrayLengths != null) {
                System.arraycopy(this.arrayLengths, 0, newLengths, 0, this.capacity);
                System.arraycopy(this.arrayOffsets, 0, newOffsets, 0, this.capacity);
            }
            this.arrayLengths = newLengths;
            this.arrayOffsets = newOffsets;
        } else if (this.type instanceof BooleanType) {
            if (this.byteData == null || this.byteData.length < newCapacity) {
                newData = new byte[newCapacity];
                if (this.byteData != null) {
                    System.arraycopy(this.byteData, 0, newData, 0, this.capacity);
                }
                this.byteData = newData;
            }
        } else if (this.type instanceof ByteType) {
            if (this.byteData == null || this.byteData.length < newCapacity) {
                newData = new byte[newCapacity];
                if (this.byteData != null) {
                    System.arraycopy(this.byteData, 0, newData, 0, this.capacity);
                }
                this.byteData = newData;
            }
        } else if (this.type instanceof ShortType) {
            if (this.shortData == null || this.shortData.length < newCapacity) {
                newData = new short[newCapacity];
                if (this.shortData != null) {
                    System.arraycopy(this.shortData, 0, newData, 0, this.capacity);
                }
                this.shortData = newData;
            }
        } else if (this.type instanceof IntegerType || this.type instanceof DateType || DecimalType.is32BitDecimalType((DataType)this.type)) {
            if (this.intData == null || this.intData.length < newCapacity) {
                newData = new int[newCapacity];
                if (this.intData != null) {
                    System.arraycopy(this.intData, 0, newData, 0, this.capacity);
                }
                this.intData = newData;
            }
        } else if (this.type instanceof LongType || this.type instanceof TimestampType || DecimalType.is64BitDecimalType((DataType)this.type)) {
            if (this.longData == null || this.longData.length < newCapacity) {
                newData = new long[newCapacity];
                if (this.longData != null) {
                    System.arraycopy(this.longData, 0, newData, 0, this.capacity);
                }
                this.longData = newData;
            }
        } else if (this.type instanceof FloatType) {
            if (this.floatData == null || this.floatData.length < newCapacity) {
                newData = new float[newCapacity];
                if (this.floatData != null) {
                    System.arraycopy(this.floatData, 0, newData, 0, this.capacity);
                }
                this.floatData = newData;
            }
        } else if (this.type instanceof DoubleType) {
            if (this.doubleData == null || this.doubleData.length < newCapacity) {
                newData = new double[newCapacity];
                if (this.doubleData != null) {
                    System.arraycopy(this.doubleData, 0, newData, 0, this.capacity);
                }
                this.doubleData = newData;
            }
        } else if (this.childColumns == null) {
            throw new RuntimeException("Unhandled " + this.type);
        }
        byte[] newNulls = new byte[newCapacity];
        if (this.nulls != null) {
            System.arraycopy(this.nulls, 0, newNulls, 0, this.capacity);
        }
        this.nulls = newNulls;
        this.capacity = newCapacity;
    }

    @Override
    protected OnHeapColumnVector reserveNewColumn(int capacity, DataType type) {
        return new OnHeapColumnVector(capacity, type);
    }
}

