/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ContextUtil;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.DecimalMetadata;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.execution.datasources.FileStats;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetRowConverter$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t-g!\u0002\u00192\u0001Mz\u0004\u0002\u0003&\u0001\u0005\u000b\u0007I\u0011\u0001'\t\u0011i\u0003!\u0011!Q\u0001\n5C\u0001b\u0017\u0001\u0003\u0002\u0003\u0006I\u0001\u0018\u0005\u0006I\u0002!\t!\u001a\u0005\bU\u0002\u0011\r\u0011\"\u0003l\u0011\u0019\t\b\u0001)A\u0005Y\"9!\u000f\u0001b\u0001\n\u0013\u0019\bB\u0002=\u0001A\u0003%A\u000fC\u0004z\u0001\t\u0007I\u0011\u0002>\t\u000f\u0005\u0015\u0001\u0001)A\u0005w\"I\u0011q\u0001\u0001C\u0002\u0013%\u0011\u0011\u0002\u0005\t\u0003;\u0001\u0001\u0015!\u0003\u0002\f!I\u0011q\u0004\u0001C\u0002\u0013%\u0011\u0011\u0005\u0005\t\u0003o\u0001\u0001\u0015!\u0003\u0002$!Q\u0011\u0011\b\u0001\t\u0006\u0004%I!a\u000f\t\u000f\u0005U\u0003\u0001\"\u0011\u0002X!9\u00111\r\u0001\u0005B\u0005\u0015\u0004bBA4\u0001\u0011\u0005\u0011\u0011\u000e\u0005\b\u0003g\u0002A\u0011BA;\u0011\u001d\t\u0019\n\u0001C\u0005\u0003+Cq!a,\u0001\t\u0013\t\t\fC\u0004\u0002N\u0002!I!a4\b\u0011\u0005e\u0017\u0007#\u00012\u000374q\u0001M\u0019\t\u0002E\ni\u000e\u0003\u0004e1\u0011\u0005\u0011Q\u001d\u0004\b\u0003OD\u0002!MAu\u0011)\u0011YB\u0007B\u0001B\u0003%!Q\u0004\u0005\u0007Ij!\tA!\u000b\t\u000f\t5\"\u0004\"\u0015\u00030!9!\u0011\u0007\u000e\u0005R\tMba\u0002B\"1\u0001\t$Q\t\u0005\tU~\u0011\t\u0011)A\u0005Y\"I!qI\u0010\u0003\u0002\u0003\u0006I\u0001\u001e\u0005\u0007I~!\tA!\u0013\t\u0011\tEsD1A\u0005\nMDqAa\u0015 A\u0003%A\u000f\u0003\u0005\u0003V}\u0011\r\u0011\"\u0003t\u0011\u001d\u00119f\bQ\u0001\nQD\u0001B!\u0017 \u0005\u0004%Ia\u001d\u0005\b\u00057z\u0002\u0015!\u0003u\u0011%\u0011if\bb\u0001\n\u0013\u0011y\u0006\u0003\u0005\u0003l}\u0001\u000b\u0011\u0002B1\u0011\u001d\u0011ig\bC\u0001\u0005_BqAa! \t\u0003\u0011)\tC\u0004\u0003\"~!\tAa)\t\u000f\tUv\u0004\"\u0001\u00038\"9!1Y\u0010\u0005\u0002\t\u0015'a\u0005)beF,X\r^(viB,Ho\u0016:ji\u0016\u0014(B\u0001\u001a4\u0003\u001d\u0001\u0018M]9vKRT!\u0001N\u001b\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u0003m]\n\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005aJ\u0014aA:rY*\u0011!hO\u0001\u0006gB\f'o\u001b\u0006\u0003yu\na!\u00199bG\",'\"\u0001 \u0002\u0007=\u0014xmE\u0002\u0001\u0001\u0012\u0003\"!\u0011\"\u000e\u0003MJ!aQ\u001a\u0003\u0019=+H\u000f];u/JLG/\u001a:\u0011\u0005\u0015CU\"\u0001$\u000b\u0005\u001dK\u0014\u0001C5oi\u0016\u0014h.\u00197\n\u0005%3%a\u0002'pO\u001eLgnZ\u0001\u0005a\u0006$\bn\u0001\u0001\u0016\u00035\u0003\"AT,\u000f\u0005=+\u0006C\u0001)T\u001b\u0005\t&B\u0001*L\u0003\u0019a$o\\8u})\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\u00061\u0001K]3eK\u001aL!\u0001W-\u0003\rM#(/\u001b8h\u0015\t16+A\u0003qCRD\u0007%A\u0004d_:$X\r\u001f;\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017!C7baJ,G-^2f\u0015\t\t7(\u0001\u0004iC\u0012|w\u000e]\u0005\u0003Gz\u0013!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2A\u001a5j!\t9\u0007!D\u00012\u0011\u0015QE\u00011\u0001N\u0011\u0015YF\u00011\u0001]\u0003\u0011\u0019wN\u001c4\u0016\u00031\u0004\"!\\8\u000e\u00039T!A\u001b1\n\u0005At'!D\"p]\u001aLw-\u001e:bi&|g.A\u0003d_:4\u0007%\u0001\u0007d_2dWm\u0019;Ti\u0006$8/F\u0001u!\t)h/D\u0001T\u0013\t98KA\u0004C_>dW-\u00198\u0002\u001b\r|G\u000e\\3diN#\u0018\r^:!\u00031\u00198\r[3nCN#(/\u001b8h+\u0005Y\bc\u0001?\u0002\u00045\tQP\u0003\u0002\u007f\u007f\u0006!A.\u00198h\u0015\t\t\t!\u0001\u0003kCZ\f\u0017B\u0001-~\u00035\u00198\r[3nCN#(/\u001b8hA\u000511o\u00195f[\u0006,\"!a\u0003\u0011\u000bU\fi!!\u0005\n\u0007\u0005=1K\u0001\u0004PaRLwN\u001c\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC\u001c\u0002\u000bQL\b/Z:\n\t\u0005m\u0011Q\u0003\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017aB:dQ\u0016l\u0017\rI\u0001\u0012Q\u0006\u001c(+Z2pe\u0012\u001cxK]5ui\u0016tWCAA\u0012!\u0011\t)#a\r\u000e\u0005\u0005\u001d\"\u0002BA\u0015\u0003W\ta!\u0019;p[&\u001c'\u0002BA\u0017\u0003_\t!bY8oGV\u0014(/\u001a8u\u0015\r\t\td`\u0001\u0005kRLG.\u0003\u0003\u00026\u0005\u001d\"!D!u_6L7MQ8pY\u0016\fg.\u0001\niCN\u0014VmY8sIN<&/\u001b;uK:\u0004\u0013\u0001\u0004:fG>\u0014Hm\u0016:ji\u0016\u0014XCAA\u001f!\u001di\u0016qHA\"\u0003\u0013J1!!\u0011_\u00051\u0011VmY8sI^\u0013\u0018\u000e^3s!\ra\u0018QI\u0005\u0004\u0003\u000fj(\u0001\u0002,pS\u0012\u0004B!a\u0013\u0002R5\u0011\u0011Q\n\u0006\u0004\u0003\u001f:\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\t\u0005M\u0013Q\n\u0002\f\u0013:$XM\u001d8bYJ{w/A\u0003xe&$X\r\u0006\u0003\u0002Z\u0005}\u0003cA;\u0002\\%\u0019\u0011QL*\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003C\u0002\u0002\u0019AA%\u0003\r\u0011xn^\u0001\u0006G2|7/\u001a\u000b\u0003\u00033\nAbZ3u\r&dWm\u0015;biN,\"!a\u001b\u0011\u000bU\fi!!\u001c\u0011\u0007\u0005\u000by'C\u0002\u0002rM\u0012\u0011BR5mKN#\u0018\r^:\u0002\u001bQ|\u0017J\u001c;fe:\fGNU8x)!\tI%a\u001e\u0002z\u0005u\u0004bBA\u0004'\u0001\u0007\u0011\u0011\u0003\u0005\u0007\u0003w\u001a\u0002\u0019A'\u0002\u001f\u0019LW\r\u001c3OC6,\u0007K]3gSbDq!a \u0014\u0001\u0004\t\t)\u0001\u0004wC2,Xm\u001d\t\u0007\u001d\u0006\rU*a\"\n\u0007\u0005\u0015\u0015LA\u0002NCB\u0004B!!#\u0002\u00106\u0011\u00111\u0012\u0006\u0005\u0003\u001b\u000bi%A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BAI\u0003\u0017\u0013q\u0001T5uKJ\fG.A\u0006u_\u0006\u0013(/Y=ECR\fG\u0003CAL\u0003C\u000bY+!,\u0011\t\u0005e\u0015QT\u0007\u0003\u00037SA!!\r\u0002N%!\u0011qTAN\u0005%\t%O]1z\t\u0006$\u0018\rC\u0004\u0002$R\u0001\r!!*\u0002\u000b\u0005\u0014(/Y=\u0011\t\u0005M\u0011qU\u0005\u0005\u0003S\u000b)BA\u0005BeJ\f\u0017\u0010V=qK\"1\u00111\u0010\u000bA\u00025Cq!a \u0015\u0001\u0004\t\t)A\tva\u0012\fG/\u001a'po\u0016\u0014(i\\;oIN$\u0002\"!\u0017\u00024\u0006\u0015\u0017\u0011\u001a\u0005\b\u0003k+\u0002\u0019AA\\\u0003\ri\u0017\r\u001d\t\b\u0003s\u000b\u0019-TAD\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0003\u001c\u0016AC2pY2,7\r^5p]&!\u0011QQA^\u0011\u0019\t9-\u0006a\u0001\u001b\u0006)a-[3mI\"9\u00111Z\u000bA\u0002\u0005\u001d\u0015aA7j]\u0006\tR\u000f\u001d3bi\u0016,\u0006\u000f]3s\u0005>,h\u000eZ:\u0015\u0011\u0005e\u0013\u0011[Aj\u0003+Dq!!.\u0017\u0001\u0004\t9\f\u0003\u0004\u0002HZ\u0001\r!\u0014\u0005\b\u0003/4\u0002\u0019AAD\u0003\ri\u0017\r_\u0001\u0014!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;Xe&$XM\u001d\t\u0003Ob\u00192\u0001GAp!\r)\u0018\u0011]\u0005\u0004\u0003G\u001c&AB!osJ+g\r\u0006\u0002\u0002\\\n\u0019\u0002+\u0019:rk\u0016$xK]5uK\n+\u0018\u000e\u001c3feV!\u00111\u001eB\u0003'\rQ\u0012Q\u001e\t\t\u0003_\fYP!\u0001\u0003\u00189!\u0011\u0011_A|\u001b\t\t\u0019PC\u0002b\u0003kT!AM\u001e\n\t\u0005e\u00181_\u0001\u000e!\u0006\u0014\u0018/^3u/JLG/\u001a:\n\t\u0005u\u0018q \u0002\b\u0005VLG\u000eZ3s\u0015\u0011\tI0a=\u0011\t\t\r!Q\u0001\u0007\u0001\t\u001d\u00119A\u0007b\u0001\u0005\u0013\u0011\u0011\u0001V\t\u0005\u0005\u0017\u0011\t\u0002E\u0002v\u0005\u001bI1Aa\u0004T\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!\u001eB\n\u0013\r\u0011)b\u0015\u0002\u0004\u0003:L\b#\u0002B\r5\t\u0005Q\"\u0001\r\u0002\t\u0019LG.\u001a\t\u0005\u0005?\u0011)#\u0004\u0002\u0003\")!!1EA{\u0003\tIw.\u0003\u0003\u0003(\t\u0005\"AC(viB,HOR5mKR!!q\u0003B\u0016\u0011\u001d\u0011Y\u0002\ba\u0001\u0005;\tAa]3mMR\u0011!qC\u0001\u0010O\u0016$xK]5uKN+\b\u000f]8siR!!Q\u0007B!!\u0019\u00119D!\u0010\u0003\u00025\u0011!\u0011\b\u0006\u0005\u0005w\t\u00190A\u0002ba&LAAa\u0010\u0003:\taqK]5uKN+\b\u000f]8si\")!N\ba\u0001Y\nq\u0002+\u0019:rk\u0016$\bK]5nSRLg/\u001a,bYV,7i\u001c8wKJ$XM]\n\u0004?\u0005}\u0017AE2sK\u0006$X\r\u001a\"z!\u0006\u0014\u0018/^3u\u001bJ$bAa\u0013\u0003N\t=\u0003c\u0001B\r?!)!N\ta\u0001Y\"1!q\t\u0012A\u0002Q\fA#Y:tk6,')\u001b8befL5o\u0015;sS:<\u0017!F1tgVlWMQ5oCJL\u0018j]*ue&tw\rI\u0001\u0017CN\u001cX/\\3J]RLd'S:US6,7\u000f^1na\u00069\u0012m]:v[\u0016Le\u000e^\u001d7\u0013N$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u0014i&lWm\u001d;b[B\u001cuN\u001c<feNLwN\\\u0001\u0015i&lWm\u001d;b[B\u001cuN\u001c<feNLwN\u001c\u0011\u0002\u0013\r|gN^3siRSXC\u0001B1!\u0015)\u0018Q\u0002B2!\u0011\u0011)Ga\u001a\u000e\u0005\u0005=\u0012\u0002\u0002B5\u0003_\u0011\u0001\u0002V5nKj{g.Z\u0001\u000bG>tg/\u001a:u)j\u0004\u0013\u0001E2p]Z,'\u000f\u001e)sS6LG/\u001b<f)\u0019\t9I!\u001d\u0003\u0000!9!1O\u0016A\u0002\tU\u0014!\u00049sS6LG/\u001b<f)f\u0004X\r\u0005\u0003\u0003x\tmTB\u0001B=\u0015\u0011\t9!!>\n\t\tu$\u0011\u0010\u0002\u000e!JLW.\u001b;jm\u0016$\u0016\u0010]3\t\u000f\t\u00055\u00061\u0001\u0003\u0012\u0005)a/\u00197vK\u0006QQ.Y6f'R\u0014\u0018N\\4\u0015\t\t\u001d%Q\u0013\t\u0005\u0005\u0013\u0013\t*\u0004\u0002\u0003\f*!\u0011q\u0003BG\u0015\r\u0011y)O\u0001\u0007k:\u001c\u0018MZ3\n\t\tM%1\u0012\u0002\u000b+R3\u0005h\u0015;sS:<\u0007b\u0002BAY\u0001\u0007!q\u0013\t\u0005\u00053\u0013i*\u0004\u0002\u0003\u001c*!!1\bB\u0011\u0013\u0011\u0011yJa'\u0003\r\tKg.\u0019:z\u0003I!WmY5nC24%o\\7J]R,w-\u001a:\u0015\r\t\u0015&1\u0016BW!\u0011\t\u0019Ba*\n\t\t%\u0016Q\u0003\u0002\b\t\u0016\u001c\u0017.\\1m\u0011\u001d\u0011\u0019(\fa\u0001\u0005kBqA!!.\u0001\u0004\u0011y\u000bE\u0002}\u0005cK1Aa-~\u0005\u001dIe\u000e^3hKJ\fq\u0002Z3dS6\fGN\u0012:p[2{gn\u001a\u000b\u0007\u0005K\u0013ILa/\t\u000f\tMd\u00061\u0001\u0003v!9!\u0011\u0011\u0018A\u0002\tu\u0006cA;\u0003@&\u0019!\u0011Y*\u0003\t1{gnZ\u0001\u0012I\u0016\u001c\u0017.\\1m\rJ|WNQ5oCJLHC\u0002BS\u0005\u000f\u0014I\rC\u0004\u0003t=\u0002\rA!\u001e\t\u000f\t\u0005u\u00061\u0001\u0003\u0018\u0002")
public class ParquetOutputWriter
extends OutputWriter
implements Logging {
    private RecordWriter<Void, InternalRow> recordWriter;
    private final String path;
    private final TaskAttemptContext context;
    private final Configuration conf;
    private final boolean collectStats;
    private final String schemaString;
    private final Option<StructType> schema;
    private final AtomicBoolean hasRecordsWritten;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String path() {
        return this.path;
    }

    private Configuration conf() {
        return this.conf;
    }

    private boolean collectStats() {
        return this.collectStats;
    }

    private String schemaString() {
        return this.schemaString;
    }

    private Option<StructType> schema() {
        return this.schema;
    }

    private AtomicBoolean hasRecordsWritten() {
        return this.hasRecordsWritten;
    }

    private RecordWriter<Void, InternalRow> recordWriter$lzycompute() {
        ParquetOutputWriter parquetOutputWriter = this;
        synchronized (parquetOutputWriter) {
            if (!this.bitmap$0) {
                this.recordWriter = new ParquetOutputFormat<InternalRow>(this){
                    private final /* synthetic */ ParquetOutputWriter $outer;

                    public Path getDefaultWorkFile(TaskAttemptContext context, String extension) {
                        return new Path(this.$outer.path());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }.getRecordWriter(this.context);
                this.bitmap$0 = true;
            }
        }
        return this.recordWriter;
    }

    private RecordWriter<Void, InternalRow> recordWriter() {
        return !this.bitmap$0 ? this.recordWriter$lzycompute() : this.recordWriter;
    }

    @Override
    public void write(InternalRow row) {
        this.hasRecordsWritten().compareAndSet(false, true);
        this.recordWriter().write(null, (Object)row);
    }

    @Override
    public void close() {
        this.recordWriter().close(this.context);
    }

    public Option<FileStats> getFileStats() {
        None$ none$;
        if (this.collectStats() && this.schema().isDefined()) {
            LongRef rowCount = LongRef.create((long)0L);
            Map lowerBounds = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            Map upperBounds = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
            Set missingStats = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
            ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)this.conf(), (Path)new Path(this.path()), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            List blocks = metadata.getBlocks();
            ParquetPrimitiveValueConverter converter = new ParquetPrimitiveValueConverter(this.conf(), metadata.getFileMetaData().getCreatedBy().startsWith("parquet-mr"));
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(blocks).asScala()).foreach((Function1 & Serializable & scala.Serializable)block -> {
                ParquetOutputWriter.$anonfun$getFileStats$1(this, rowCount, missingStats, converter, lowerBounds, upperBounds, block);
                return BoxedUnit.UNIT;
            });
            missingStats.foreach((Function1 & Serializable & scala.Serializable)field -> {
                lowerBounds.remove(field);
                return upperBounds.remove(field);
            });
            String timeZoneId = this.conf().get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key());
            none$ = new Some((Object)new FileStats((StructType)this.schema().get(), timeZoneId, rowCount.elem, this.toInternalRow((StructType)this.schema().get(), "", (scala.collection.immutable.Map<String, Literal>)lowerBounds.toMap(Predef$.MODULE$.$conforms())), this.toInternalRow((StructType)this.schema().get(), "", (scala.collection.immutable.Map<String, Literal>)upperBounds.toMap(Predef$.MODULE$.$conforms()))));
        } else if (!this.hasRecordsWritten().get()) {
            String timeZoneId = this.conf().get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key());
            none$ = new Some((Object)new FileStats((StructType)this.schema().get(), timeZoneId, 0L, InternalRow$.MODULE$.apply((Seq)Nil$.MODULE$), InternalRow$.MODULE$.apply((Seq)Nil$.MODULE$)));
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private InternalRow toInternalRow(StructType schema, String fieldNamePrefix, scala.collection.immutable.Map<String, Literal> values) {
        GenericInternalRow row = new GenericInternalRow(schema.size());
        ((IterableLike)schema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)field -> {
            ParquetOutputWriter.$anonfun$toInternalRow$1(this, fieldNamePrefix, values, row, field);
            return BoxedUnit.UNIT;
        });
        return row;
    }

    private ArrayData toArrayData(ArrayType array, String fieldNamePrefix, scala.collection.immutable.Map<String, Literal> values) {
        Object[] objectArray;
        String filedName = fieldNamePrefix.isEmpty() ? "list.element" : new StringBuilder(13).append(fieldNamePrefix).append(".").append("list.element").toString();
        Object value = values.get((Object)filedName).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.value()).orNull(Predef$.MODULE$.$conforms());
        DataType dataType = array.elementType();
        if (NullType$.MODULE$.equals(dataType)) {
            objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Null$[]{null}), ClassTag$.MODULE$.Null());
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
        } else if (ByteType$.MODULE$.equals(dataType)) {
            objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
        } else if (ShortType$.MODULE$.equals(dataType)) {
            objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
        } else {
            boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
            if (bl) {
                objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
            } else {
                boolean bl2 = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                if (bl2) {
                    objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                } else if (StringType$.MODULE$.equals(dataType)) {
                    objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                } else if (BinaryType$.MODULE$.equals(dataType)) {
                    objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                } else if (dataType instanceof DecimalType) {
                    objectArray = Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                } else if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value}), ClassTag$.MODULE$.Any());
                    objectArray = new InternalRow[]{this.toInternalRow(structType, new StringBuilder(13).append(fieldNamePrefix).append(".").append("list.element").toString(), values)};
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    objectArray = (Object[])new ArrayData[][]{(ArrayData[])((Object[])new ArrayData[]{this.toArrayData(arrayType, new StringBuilder(13).append(fieldNamePrefix).append(".").append("list.element").toString(), values)})};
                } else {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Ignore non-supported type: ").append(dataType).toString());
                    objectArray = Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Nothing());
                }
            }
        }
        Object[] arrayData = objectArray;
        return new GenericArrayData((Object)arrayData);
    }

    /*
     * Unable to fully structure code
     */
    private void updateLowerBounds(Map<String, Literal> map, String field, Literal min) {
        block3: {
            block2: {
                var6_4 = min.dataType();
                if (!(var6_4 instanceof AtomicType)) break block2;
                var7_5 = (AtomicType)var6_4;
                var8_6 = map.get((Object)field);
                if (!(var8_6 instanceof Some)) ** GOTO lbl-1000
                var9_7 = (Some)var8_6;
                value = (Literal)var9_7.value();
                if (var7_5.ordering().compare(min.value(), value.value()) > 0) {
                    var5_9 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    map.update((Object)field, (Object)min);
                    var5_10 = BoxedUnit.UNIT;
                }
                var4_11 = BoxedUnit.UNIT;
                break block3;
            }
            var4_12 = BoxedUnit.UNIT;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void updateUpperBounds(Map<String, Literal> map, String field, Literal max) {
        block3: {
            block2: {
                var6_4 = max.dataType();
                if (!(var6_4 instanceof AtomicType)) break block2;
                var7_5 = (AtomicType)var6_4;
                var8_6 = map.get((Object)field);
                if (!(var8_6 instanceof Some)) ** GOTO lbl-1000
                var9_7 = (Some)var8_6;
                value = (Literal)var9_7.value();
                if (var7_5.ordering().compare(max.value(), value.value()) < 0) {
                    var5_9 = BoxedUnit.UNIT;
                } else lbl-1000:
                // 2 sources

                {
                    map.update((Object)field, (Object)max);
                    var5_10 = BoxedUnit.UNIT;
                }
                var4_11 = BoxedUnit.UNIT;
                break block3;
            }
            var4_12 = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$getFileStats$1(ParquetOutputWriter $this, LongRef rowCount$1, Set missingStats$1, ParquetPrimitiveValueConverter converter$1, Map lowerBounds$1, Map upperBounds$1, BlockMetaData block) {
        rowCount$1.elem += block.getRowCount();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(block.getColumns()).asScala()).foreach((Function1 & Serializable & scala.Serializable)column -> {
            Boolean bl;
            ColumnPath columnPath = column.getPath();
            String fieldName = columnPath.toDotString();
            Statistics stats = column.getStatistics();
            if (stats == null) {
                bl = BoxesRunTime.boxToBoolean((boolean)missingStats$1.add((Object)fieldName));
            } else if (stats.getNumNulls() > 0L) {
                bl = BoxesRunTime.boxToBoolean((boolean)missingStats$1.add((Object)fieldName));
            } else if (!stats.isEmpty()) {
                try {
                    Literal min = converter$1.convertPrimitive(column.getPrimitiveType(), stats.genericGetMin());
                    $this.updateLowerBounds((Map<String, Literal>)lowerBounds$1, fieldName, min);
                    Literal max = converter$1.convertPrimitive(column.getPrimitiveType(), stats.genericGetMax());
                    $this.updateUpperBounds((Map<String, Literal>)upperBounds$1, fieldName, max);
                    bl = BoxedUnit.UNIT;
                }
                catch (RuntimeException e) {
                    bl = BoxesRunTime.boxToBoolean((boolean)missingStats$1.add((Object)fieldName));
                }
            } else {
                bl = BoxedUnit.UNIT;
            }
            return bl;
        });
    }

    public static final /* synthetic */ void $anonfun$toInternalRow$1(ParquetOutputWriter $this, String fieldNamePrefix$1, scala.collection.immutable.Map values$1, GenericInternalRow row$1, Tuple2 field) {
        String filedName = fieldNamePrefix$1.isEmpty() ? ((StructField)field._1()).name() : new StringBuilder(1).append(fieldNamePrefix$1).append(".").append(((StructField)field._1()).name()).toString();
        Object value = values$1.get((Object)filedName).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.value()).orNull(Predef$.MODULE$.$conforms());
        DataType dataType = ((StructField)field._1()).dataType();
        if (NullType$.MODULE$.equals(dataType)) {
            row$1.setNullAt(field._2$mcI$sp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (BooleanType$.MODULE$.equals(dataType)) {
            row$1.update(field._2$mcI$sp(), value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ByteType$.MODULE$.equals(dataType)) {
            row$1.update(field._2$mcI$sp(), value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (ShortType$.MODULE$.equals(dataType)) {
            row$1.update(field._2$mcI$sp(), value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
            if (bl) {
                row$1.update(field._2$mcI$sp(), value);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                if (bl2) {
                    row$1.update(field._2$mcI$sp(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (FloatType$.MODULE$.equals(dataType)) {
                    row$1.update(field._2$mcI$sp(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (DoubleType$.MODULE$.equals(dataType)) {
                    row$1.update(field._2$mcI$sp(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (StringType$.MODULE$.equals(dataType)) {
                    row$1.update(field._2$mcI$sp(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (BinaryType$.MODULE$.equals(dataType)) {
                    row$1.update(field._2$mcI$sp(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof DecimalType) {
                    row$1.update(field._2$mcI$sp(), value);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof StructType) {
                    StructType structType = (StructType)dataType;
                    row$1.update(field._2$mcI$sp(), (Object)$this.toInternalRow(structType, filedName, (scala.collection.immutable.Map<String, Literal>)values$1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType;
                    row$1.update(field._2$mcI$sp(), (Object)$this.toArrayData(arrayType, filedName, (scala.collection.immutable.Map<String, Literal>)values$1));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Ignore non-supported type: ").append(dataType).toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
    }

    public ParquetOutputWriter(String path, TaskAttemptContext context) {
        this.path = path;
        this.context = context;
        Logging.$init$((Logging)this);
        this.conf = ContextUtil.getConfiguration((JobContext)context);
        this.collectStats = this.conf().getBoolean("spark.databricks.delta.stats.collect", false);
        this.schemaString = this.conf().get(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA());
        this.schema = this.schemaString() != null ? new Some((Object)StructType$.MODULE$.fromString(this.schemaString())) : None$.MODULE$;
        this.hasRecordsWritten = new AtomicBoolean(false);
    }

    public static class ParquetPrimitiveValueConverter {
        private final boolean assumeBinaryIsString;
        private final boolean assumeInt96IsTimestamp;
        private final boolean timestampConversion;
        private final Option<TimeZone> convertTz;

        private boolean assumeBinaryIsString() {
            return this.assumeBinaryIsString;
        }

        private boolean assumeInt96IsTimestamp() {
            return this.assumeInt96IsTimestamp;
        }

        private boolean timestampConversion() {
            return this.timestampConversion;
        }

        private Option<TimeZone> convertTz() {
            return this.convertTz;
        }

        /*
         * Unable to fully structure code
         */
        public Literal convertPrimitive(PrimitiveType primitiveType, Object value) {
            block26: {
                block32: {
                    block34: {
                        block33: {
                            block31: {
                                block30: {
                                    block29: {
                                        block28: {
                                            block27: {
                                                block25: {
                                                    typeName = primitiveType.getPrimitiveTypeName();
                                                    originalType = primitiveType.getOriginalType();
                                                    var13_5 = typeName;
                                                    if (!PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(var13_5)) break block25;
                                                    var3_6 = Literal$.MODULE$.apply(value);
                                                    break block26;
                                                }
                                                if (!PrimitiveType.PrimitiveTypeName.FLOAT.equals(var13_5)) break block27;
                                                var3_6 = Literal$.MODULE$.apply(value);
                                                break block26;
                                            }
                                            if (!PrimitiveType.PrimitiveTypeName.DOUBLE.equals(var13_5)) break block28;
                                            var3_6 = Literal$.MODULE$.apply(value);
                                            break block26;
                                        }
                                        if (!PrimitiveType.PrimitiveTypeName.INT32.equals(var13_5)) break block29;
                                        var14_7 = originalType;
                                        if (OriginalType.INT_8.equals(var14_7)) {
                                            var9_8 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte((Object)value)));
                                        } else if (OriginalType.INT_16.equals(var14_7)) {
                                            var9_8 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort((Object)value)));
                                        } else {
                                            var10_9 = OriginalType.INT_32.equals(var14_7) != false ? true : var14_7 == null;
                                            if (var10_9) {
                                                var9_8 = Literal$.MODULE$.apply(value);
                                            } else if (OriginalType.DATE.equals(var14_7)) {
                                                var9_8 = new Literal((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)value)), (DataType)DateType$.MODULE$);
                                            } else if (OriginalType.DECIMAL.equals(var14_7)) {
                                                var9_8 = Literal$.MODULE$.apply((Object)this.decimalFromInteger(primitiveType, (Integer)value));
                                            } else {
                                                throw new RuntimeException(new StringBuilder(58).append("Cannot convert parquet value with typeName ").append(typeName).append(", originalType ").append(originalType).toString());
                                            }
                                        }
                                        var3_6 = var9_8;
                                        break block26;
                                    }
                                    if (!PrimitiveType.PrimitiveTypeName.INT64.equals(var13_5)) break block30;
                                    var15_10 = originalType;
                                    var8_11 = OriginalType.INT_64.equals(var15_10) != false ? true : var15_10 == null;
                                    if (var8_11) {
                                        var7_12 = Literal$.MODULE$.apply(value);
                                    } else if (OriginalType.DECIMAL.equals(var15_10)) {
                                        var7_12 = Literal$.MODULE$.apply((Object)this.decimalFromLong(primitiveType, BoxesRunTime.unboxToLong((Object)value)));
                                    } else {
                                        throw new RuntimeException(new StringBuilder(58).append("Cannot convert parquet value with typeName ").append(typeName).append(", originalType ").append(originalType).toString());
                                    }
                                    var3_6 = var7_12;
                                    break block26;
                                }
                                if (!PrimitiveType.PrimitiveTypeName.INT96.equals(var13_5)) break block31;
                                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Z, $anonfun$convertPrimitive$1(org.apache.spark.sql.execution.datasources.parquet.ParquetOutputWriter$ParquetPrimitiveValueConverter ), ()Z)((ParquetPrimitiveValueConverter)this), new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
                                buf = ((Binary)value).toByteBuffer().order(ByteOrder.LITTLE_ENDIAN);
                                timeOfDayNanos = buf.getLong();
                                julianDay = buf.getInt();
                                rawTime = DateTimeUtils$.MODULE$.fromJulianDay(julianDay, timeOfDayNanos);
                                adjTime = BoxesRunTime.unboxToLong((Object)this.convertTz().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$convertPrimitive$2$adapted(long java.util.TimeZone ), (Ljava/util/TimeZone;)Ljava/lang/Object;)((long)rawTime)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()J, $anonfun$convertPrimitive$3(long ), ()J)((long)rawTime)));
                                var3_6 = new Literal((Object)BoxesRunTime.boxToLong((long)adjTime), (DataType)TimestampType$.MODULE$);
                                break block26;
                            }
                            if (!PrimitiveType.PrimitiveTypeName.BINARY.equals(var13_5)) break block32;
                            var24_18 = false;
                            var25_19 = null;
                            var26_20 = originalType;
                            var6_21 = OriginalType.UTF8.equals(var26_20) != false ? true : (OriginalType.ENUM.equals(var26_20) != false ? true : OriginalType.JSON.equals(var26_20) != false);
                            if (!var6_21) break block33;
                            var5_22 = new Literal((Object)this.makeString((Binary)value), (DataType)StringType$.MODULE$);
                            break block34;
                        }
                        if (var26_20 != null) ** GOTO lbl-1000
                        var24_18 = true;
                        var25_19 = var26_20;
                        if (this.assumeBinaryIsString()) {
                            var5_22 = new Literal((Object)this.makeString((Binary)value), (DataType)StringType$.MODULE$);
                        } else if (var24_18) {
                            var5_22 = new Literal(value, (DataType)BinaryType$.MODULE$);
                        } else if (OriginalType.BSON.equals(var26_20)) {
                            var5_22 = new Literal(value, (DataType)BinaryType$.MODULE$);
                        } else if (OriginalType.DECIMAL.equals(var26_20)) {
                            var5_22 = Literal$.MODULE$.apply((Object)this.decimalFromBinary(primitiveType, (Binary)value));
                        } else {
                            throw new RuntimeException(new StringBuilder(58).append("Cannot convert parquet value with typeName ").append(typeName).append(", originalType ").append(originalType).toString());
                        }
                    }
                    var3_6 = var5_22;
                    break block26;
                }
                if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(var13_5)) {
                    var27_23 = originalType;
                    if (!OriginalType.DECIMAL.equals(var27_23)) {
                        throw new RuntimeException(new StringBuilder(58).append("Cannot convert parquet value with typeName ").append(typeName).append(", originalType ").append(originalType).toString());
                    }
                    var4_24 = Literal$.MODULE$.apply((Object)this.decimalFromBinary(primitiveType, (Binary)value));
                    var3_6 = var4_24;
                } else {
                    throw new RuntimeException(new StringBuilder(43).append("Cannot convert parquet value with typeName ").append(typeName).toString());
                }
            }
            return var3_6;
        }

        public UTF8String makeString(Binary value) {
            ByteBuffer buffer = value.toByteBuffer();
            int offset = buffer.arrayOffset() + buffer.position();
            int numBytes = buffer.remaining();
            return UTF8String.fromBytes((byte[])buffer.array(), (int)offset, (int)numBytes);
        }

        public Decimal decimalFromInteger(PrimitiveType primitiveType, Integer value) {
            return this.decimalFromLong(primitiveType, Predef$.MODULE$.Integer2int(value));
        }

        public Decimal decimalFromLong(PrimitiveType primitiveType, long value) {
            DecimalMetadata decimalMeta = primitiveType.getDecimalMetadata();
            Predef$.MODULE$.assert(decimalMeta != null);
            return Decimal$.MODULE$.apply(value, decimalMeta.getPrecision(), decimalMeta.getScale());
        }

        public Decimal decimalFromBinary(PrimitiveType primitiveType, Binary value) {
            Decimal decimal;
            DecimalMetadata decimalMeta = primitiveType.getDecimalMetadata();
            Predef$.MODULE$.assert(decimalMeta != null);
            int precision = decimalMeta.getPrecision();
            int scale = decimalMeta.getScale();
            if (precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
                long unscaled = ParquetRowConverter$.MODULE$.binaryToUnscaledLong(value);
                decimal = Decimal$.MODULE$.apply(unscaled, precision, scale);
            } else {
                decimal = Decimal$.MODULE$.apply(new BigDecimal(new BigInteger(value.getBytes()), scale), precision, scale);
            }
            return decimal;
        }

        public static final /* synthetic */ boolean $anonfun$convertPrimitive$1(ParquetPrimitiveValueConverter $this) {
            return $this.assumeInt96IsTimestamp();
        }

        public static final /* synthetic */ long $anonfun$convertPrimitive$3(long rawTime$1) {
            return rawTime$1;
        }

        public ParquetPrimitiveValueConverter(Configuration conf, boolean createdByParquetMr) {
            this.assumeBinaryIsString = conf.getBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), false);
            this.assumeInt96IsTimestamp = conf.getBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), true);
            this.timestampConversion = conf.getBoolean(SQLConf$.MODULE$.PARQUET_INT96_TIMESTAMP_CONVERSION().key(), false);
            this.convertTz = this.timestampConversion() && !createdByParquetMr ? new Some((Object)DateTimeUtils$.MODULE$.getTimeZone(conf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
        }

        public static final /* synthetic */ Object $anonfun$convertPrimitive$2$adapted(long rawTime$1, TimeZone fromZone) {
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.convertTz(rawTime$1, fromZone.toZoneId(), DateTimeUtils$.MODULE$.TimeZoneUTC().toZoneId()));
        }
    }

    public static class ParquetWriteBuilder<T>
    extends ParquetWriter.Builder<T, ParquetWriteBuilder<T>> {
        public ParquetWriteBuilder<T> self() {
            return this;
        }

        public WriteSupport<T> getWriteSupport(Configuration conf) {
            WriteSupport writeSupport;
            Class writeSupportClass = ParquetOutputFormat.getWriteSupportClass((Configuration)conf);
            try {
                writeSupport = (WriteSupport)((Class)Preconditions.checkNotNull((Object)writeSupportClass, (String)"writeSupportClass")).newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(new StringBuilder(37).append("Cannot instance write support class ").append(writeSupportClass).append(".").toString(), e);
            }
            return writeSupport;
        }

        public ParquetWriteBuilder(OutputFile file) {
            super(file);
        }
    }
}

