/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BinaryComparison;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.InSet;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Not;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.PrePruningMarker;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.expressions.StringPredicate;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.LeftSemi$;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.Join;
import org.apache.spark.sql.catalyst.plans.logical.JoinHint;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation;
import org.apache.spark.sql.catalyst.plans.logical.LocalRelation$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Subquery;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.QueryExecution$;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.PrePruning$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.BaseRelation;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;

public final class PrePruning$
extends Rule<LogicalPlan>
implements PredicateHelper {
    public static PrePruning$ MODULE$;

    static {
        new PrePruning$();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap2);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap2) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap2);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Option<LogicalRelation> getPartitionTableScan(Expression a, LogicalPlan plan) {
        Option option;
        Object object = new Object();
        try {
            Option<Tuple2<Expression, LogicalPlan>> srcInfo = this.findExpressionAndTrackLineageDown(a, plan);
            option = srcInfo.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                None$ none$;
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) return None$.MODULE$;
                Expression resExp = (Expression)tuple2._1();
                LogicalPlan l = (LogicalPlan)tuple2._2();
                if (!(l instanceof LogicalRelation)) return None$.MODULE$;
                LogicalRelation logicalRelation = (LogicalRelation)l;
                BaseRelation baseRelation = logicalRelation.relation();
                if (baseRelation instanceof HadoopFsRelation) {
                    HadoopFsRelation hadoopFsRelation = (HadoopFsRelation)baseRelation;
                    AttributeSet partitionColumns = AttributeSet$.MODULE$.apply((Iterable)logicalRelation.resolve(hadoopFsRelation.partitionSchema(), hadoopFsRelation.sparkSession().sessionState().analyzer().resolver()));
                    if (resExp.references().subsetOf(partitionColumns)) {
                        throw new NonLocalReturnControl(object, (Object)new Some((Object)logicalRelation));
                    }
                    none$ = None$.MODULE$;
                    return none$;
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public Tuple2<LogicalPlan, LogicalPlan> org$apache$spark$sql$execution$datasources$PrePruning$$prePruning(Expression pruningKey, LogicalPlan pruningPlan, Expression filteringKey, LogicalPlan filteringPlan) {
        Tuple2 tuple2;
        Attribute filteringAttr = (Attribute)filteringPlan.output().find((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)filteringKey.semanticEquals(other))).orNull(Predef$.MODULE$.$conforms());
        if (SQLConf$.MODULE$.get().preExecuteDppSubquery() && (filteringPlan.output().length() == 1 || filteringPlan.stats().sizeInBytes().$less$eq((Object)SQLConf$.MODULE$.get().preExecuteDppSubQuerySizeThreshold()) || SQLConf$.MODULE$.get().forcePreExecuteDppSubQuery())) {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> "Execute pre-pruning...");
            InternalRow[] filteringValues = new QueryExecution(SparkSession$.MODULE$.builder().getOrCreate(), filteringPlan, QueryExecution$.MODULE$.$lessinit$greater$default$3()).executedPlan().executeCollect();
            try {
                boolean bl;
                Literal[] distinctFilteringValues = (Literal[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteringValues)).map((Function1 & Serializable & scala.Serializable)row -> Literal$.MODULE$.apply(row.get(filteringPlan.output().indexOf((Object)filteringAttr), filteringKey.dataType())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class))))).distinct();
                if (filteringKey.dataType().sameType(pruningKey.dataType()) && filteringKey.dataType().safeTypeInSparkHiveConversion()) {
                    bl = true;
                } else {
                    this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(160).append("Unsafe datatype for fetch [").append(filteringValues.length).append("] partition stats:").append(" [filterKey: ").append(filteringKey.dataType()).append(", pruningKey: ").append(pruningKey.dataType()).append("]. Please").append(" consider to set spark.sql.dynamicPartitionPruning.preExecuteSubQuery to false.").toString());
                    bl = false;
                }
                boolean safeComparison = bl;
                In inExpr = new In(pruningKey, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])distinctFilteringValues)).toSeq());
                inExpr.setSafeComparison(safeComparison);
                inExpr.setInDpp();
                tuple2 = new Tuple2((Object)new Filter((Expression)new PrePruningMarker((Expression)inExpr), pruningPlan), (Object)new LocalRelation(filteringPlan.output(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])filteringValues), (Option)new Some((Object)filteringPlan.stats()), LocalRelation$.MODULE$.apply$default$4()));
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(154).append("Pre-pruning is failed with OOM usually due to number of partitions").append("[").append(filteringValues.length).append("] after pruning is too large which means pre-pruning ").append("has low benefit so fallback to DPP").toString());
                tuple2 = new Tuple2((Object)pruningPlan, (Object)filteringPlan);
            }
        } else {
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(97).append("Don't execute pre-pruning because the execution conditions are not met ").append("with filteringPlan.stats: ").append(filteringPlan.stats()).toString());
            tuple2 = new Tuple2((Object)pruningPlan, (Object)filteringPlan);
        }
        return tuple2;
    }

    private boolean isLikelySelective(Expression e) {
        boolean bl;
        block4: {
            boolean bl2;
            Expression expression;
            block5: {
                while (true) {
                    if ((expression = e) instanceof Not) {
                        Expression expr;
                        Not not = (Not)expression;
                        e = expr = not.child();
                        continue;
                    }
                    if (expression instanceof And) {
                        And and = (And)expression;
                        Expression l = and.left();
                        Expression r = and.right();
                        if (!this.isLikelySelective(l)) {
                            e = r;
                            continue;
                        }
                        bl = true;
                        break block4;
                    }
                    if (!(expression instanceof Or)) break block5;
                    Or or = (Or)expression;
                    Expression l = or.left();
                    Expression r = or.right();
                    if (!this.isLikelySelective(l)) break;
                    e = r;
                }
                bl = false;
                break block4;
            }
            bl = expression instanceof Like ? true : (expression instanceof BinaryComparison ? true : ((bl2 = expression instanceof In ? true : expression instanceof InSet) ? true : expression instanceof StringPredicate));
        }
        return bl;
    }

    private boolean hasSelectivePredicate(LogicalPlan plan) {
        return plan.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PrePruning$.$anonfun$hasSelectivePredicate$1(x0$1))).isDefined();
    }

    public boolean org$apache$spark$sql$execution$datasources$PrePruning$$hasPartitionPruningFilter(LogicalPlan plan) {
        return !plan.isStreaming() && this.hasSelectivePredicate(plan);
    }

    public boolean org$apache$spark$sql$execution$datasources$PrePruning$$canPruneLeft(JoinType joinType) {
        JoinType joinType2 = joinType;
        boolean bl = Inner$.MODULE$.equals(joinType2) ? true : (LeftSemi$.MODULE$.equals(joinType2) ? true : RightOuter$.MODULE$.equals(joinType2));
        boolean bl2 = bl;
        return bl2;
    }

    public boolean org$apache$spark$sql$execution$datasources$PrePruning$$canPruneRight(JoinType joinType) {
        JoinType joinType2 = joinType;
        boolean bl = Inner$.MODULE$.equals(joinType2) ? true : (LeftSemi$.MODULE$.equals(joinType2) ? true : LeftOuter$.MODULE$.equals(joinType2));
        boolean bl2 = bl;
        return bl2;
    }

    private LogicalPlan prune(LogicalPlan plan) {
        return plan.transformUp((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Filter filter;
                LogicalPlan logicalPlan2;
                Object object;
                boolean bl = false;
                Join join2 = null;
                A1 A1 = x1;
                if (A1 instanceof Join) {
                    Filter filter2;
                    bl = true;
                    join2 = (Join)A1;
                    LogicalPlan logicalPlan3 = join2.left();
                    if (logicalPlan3 instanceof Filter && (filter2 = (Filter)logicalPlan3).condition() instanceof PrePruningMarker) {
                        object = join2;
                        return (B1)object;
                    }
                }
                if (bl && (logicalPlan2 = join2.right()) instanceof Filter && (filter = (Filter)logicalPlan2).condition() instanceof PrePruningMarker) {
                    object = join2;
                    return (B1)object;
                }
                if (bl) {
                    LogicalPlan left = join2.left();
                    LogicalPlan right = join2.right();
                    JoinType joinType = join2.joinType();
                    Option option = join2.condition();
                    JoinHint hint = join2.hint();
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Expression condition = (Expression)some.value();
                        ObjectRef newLeft = ObjectRef.create((Object)left);
                        ObjectRef newRight = ObjectRef.create((Object)right);
                        PrePruning$.MODULE$.splitConjunctivePredicates(condition).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                            anonfun.prune.1.$anonfun$applyOrElse$1(left, right, joinType, newLeft, newRight, x0$1);
                            return BoxedUnit.UNIT;
                        });
                        object = new Join((LogicalPlan)newLeft.elem, (LogicalPlan)newRight.elem, joinType, (Option)new Some((Object)condition), hint);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                Filter filter;
                LogicalPlan logicalPlan2;
                boolean bl = false;
                Join join2 = null;
                LogicalPlan logicalPlan3 = x1;
                if (logicalPlan3 instanceof Join) {
                    Filter filter2;
                    bl = true;
                    join2 = (Join)logicalPlan3;
                    LogicalPlan logicalPlan4 = join2.left();
                    if (logicalPlan4 instanceof Filter && (filter2 = (Filter)logicalPlan4).condition() instanceof PrePruningMarker) {
                        return true;
                    }
                }
                if (bl && (logicalPlan2 = join2.right()) instanceof Filter && (filter = (Filter)logicalPlan2).condition() instanceof PrePruningMarker) {
                    return true;
                }
                if (!bl) return false;
                Option option = join2.condition();
                if (!(option instanceof Some)) return false;
                return true;
            }

            private static final boolean fromLeftRight$1(Expression x, Expression y, LogicalPlan left$1, LogicalPlan right$1) {
                return !x.references().isEmpty() && x.references().subsetOf(left$1.outputSet()) && !y.references().isEmpty() && y.references().subsetOf(right$1.outputSet());
            }

            private static final boolean fromDifferentSides$1(Expression x, Expression y, LogicalPlan left$1, LogicalPlan right$1) {
                return anonfun.prune.1.fromLeftRight$1(x, y, left$1, right$1) || anonfun.prune.1.fromLeftRight$1(y, x, left$1, right$1);
            }

            /*
             * Enabled aggressive block sorting
             */
            public static final /* synthetic */ void $anonfun$applyOrElse$1(LogicalPlan left$1, LogicalPlan right$1, JoinType joinType$1, ObjectRef newLeft$1, ObjectRef newRight$1, Expression x0$1) {
                Expression expression = x0$1;
                if (expression instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)expression;
                    Expression a = equalTo.left();
                    Expression b = equalTo.right();
                    if (a != null) {
                        Expression expression2;
                        Expression expression3 = a;
                        if (b != null && anonfun.prune.1.fromDifferentSides$1(expression3, expression2 = b, left$1, right$1)) {
                            BoxedUnit boxedUnit;
                            Tuple2 tuple2 = expression3.references().subsetOf(left$1.outputSet()) && expression2.references().subsetOf(right$1.outputSet()) ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)expression3), (Object)expression2) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)expression2), (Object)expression3);
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            Expression l = (Expression)tuple2._1();
                            Expression r = (Expression)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)l, (Object)r);
                            Tuple2 tuple23 = tuple22;
                            Expression l2 = (Expression)tuple23._1();
                            Expression r2 = (Expression)tuple23._2();
                            Option<LogicalRelation> partScan = PrePruning$.MODULE$.getPartitionTableScan(l2, left$1);
                            if (partScan.isDefined() && PrePruning$.MODULE$.org$apache$spark$sql$execution$datasources$PrePruning$$canPruneLeft(joinType$1) && PrePruning$.MODULE$.org$apache$spark$sql$execution$datasources$PrePruning$$hasPartitionPruningFilter(right$1)) {
                                Tuple2<LogicalPlan, LogicalPlan> plans = PrePruning$.MODULE$.org$apache$spark$sql$execution$datasources$PrePruning$$prePruning(l2, (LogicalPlan)newLeft$1.elem, r2, right$1);
                                newLeft$1.elem = (LogicalPlan)plans._1();
                                newRight$1.elem = (LogicalPlan)plans._2();
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                partScan = PrePruning$.MODULE$.getPartitionTableScan(r2, right$1);
                                if (partScan.isDefined() && PrePruning$.MODULE$.org$apache$spark$sql$execution$datasources$PrePruning$$canPruneRight(joinType$1) && PrePruning$.MODULE$.org$apache$spark$sql$execution$datasources$PrePruning$$hasPartitionPruningFilter(left$1)) {
                                    Tuple2<LogicalPlan, LogicalPlan> plans = PrePruning$.MODULE$.org$apache$spark$sql$execution$datasources$PrePruning$$prePruning(r2, (LogicalPlan)newRight$1.elem, l2, left$1);
                                    newRight$1.elem = (LogicalPlan)plans._1();
                                    newLeft$1.elem = (LogicalPlan)plans._2();
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit = BoxedUnit.UNIT;
                                }
                            }
                            BoxedUnit boxedUnit2 = boxedUnit;
                            return;
                        }
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.spark.sql.catalyst.plans.JoinType scala.runtime.ObjectRef scala.runtime.ObjectRef org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
            }
        });
    }

    public LogicalPlan apply(LogicalPlan plan) {
        LogicalPlan logicalPlan2;
        Subquery subquery;
        LogicalPlan logicalPlan3 = plan;
        if (logicalPlan3 instanceof Subquery && (subquery = (Subquery)logicalPlan3).correlated()) {
            logicalPlan2 = plan;
        } else if (!SQLConf$.MODULE$.get().dynamicPartitionPruningEnabled() || !SQLConf$.MODULE$.get().preExecuteDppSubquery()) {
            logicalPlan2 = plan;
        } else {
            long start = System.currentTimeMillis();
            LogicalPlan newPlan = this.prune(plan);
            newPlan = newPlan.transformDown((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    Filter filter;
                    Expression expression;
                    A1 A1 = x1;
                    if (A1 instanceof Filter && (expression = (filter = (Filter)A1).condition()) instanceof PrePruningMarker) {
                        PrePruningMarker prePruningMarker = (PrePruningMarker)expression;
                        Expression exp = prePruningMarker.child();
                        object = filter.copy(exp, filter.copy$default$2());
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(LogicalPlan x1) {
                    Filter filter;
                    Expression expression;
                    LogicalPlan logicalPlan2 = x1;
                    boolean bl = logicalPlan2 instanceof Filter && (expression = (filter = (Filter)logicalPlan2).condition()) instanceof PrePruningMarker;
                    return bl;
                }
            });
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Time elapsed for pre-pruning: ").append("[").append(System.currentTimeMillis() - start).append(" ms]").toString());
            logicalPlan2 = newPlan;
        }
        return logicalPlan2;
    }

    public static final /* synthetic */ boolean $anonfun$hasSelectivePredicate$1(LogicalPlan x0$1) {
        boolean bl;
        LogicalPlan logicalPlan2 = x0$1;
        if (logicalPlan2 instanceof Filter) {
            Filter filter = (Filter)logicalPlan2;
            bl = MODULE$.isLikelySelective(filter.condition());
        } else {
            bl = false;
        }
        return bl;
    }

    private PrePruning$() {
        MODULE$ = this;
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
    }
}

