/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources;

import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.execution.datasources.FileIndex;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.execution.datasources.FileStatusCache$;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex;
import org.apache.spark.sql.execution.datasources.InMemoryFileIndex$;
import org.apache.spark.sql.execution.datasources.PartitionDirectory;
import org.apache.spark.sql.execution.datasources.PartitionPath;
import org.apache.spark.sql.execution.datasources.PartitionSpec;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005Mf\u0001\u0002\f\u0018\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011)\u0019!C\u0001k!Aa\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0011A\u0011!!\u0005A!A!\u0002\u0013\t\u0005\"B#\u0001\t\u00031\u0005bB&\u0001\u0005\u0004%\t\u0002\u0014\u0005\u0007+\u0002\u0001\u000b\u0011B'\t\u000fY\u0003!\u0019!C\u0005/\"11\f\u0001Q\u0001\naCq\u0001\u0018\u0001C\u0002\u0013%Q\f\u0003\u0004j\u0001\u0001\u0006IA\u0018\u0005\u0006U\u0002!\te\u001b\u0005\u0006e\u0002!\te\u001d\u0005\b\u0003\u001b\u0001A\u0011IA\b\u0011\u001d\ty\u0003\u0001C!\u0003cAq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002H\u0001!\t!!\u0013\t\u000f\u0005m\u0004\u0001\"\u0011\u0002~!9\u0011Q\u0013\u0001\u0005B\u0005]\u0005bBAU\u0001\u0011\u0005\u00131\u0016\u0002\u0011\u0007\u0006$\u0018\r\\8h\r&dW-\u00138eKbT!\u0001G\r\u0002\u0017\u0011\fG/Y:pkJ\u001cWm\u001d\u0006\u00035m\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005qi\u0012aA:rY*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)3\u0006\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsE\u0001\u0004B]f\u0014VM\u001a\t\u0003Y5j\u0011aF\u0005\u0003]]\u0011\u0011BR5mK&sG-\u001a=\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005E\u0012T\"A\u000e\n\u0005MZ\"\u0001D*qCJ\\7+Z:tS>t\u0017!\u0002;bE2,W#\u0001\u001c\u0011\u0005]bT\"\u0001\u001d\u000b\u0005eR\u0014aB2bi\u0006dwn\u001a\u0006\u0003wm\t\u0001bY1uC2L8\u000f^\u0005\u0003{a\u0012AbQ1uC2|w\rV1cY\u0016\fa\u0001^1cY\u0016\u0004\u0013aC:ju\u0016LeNQ=uKN,\u0012!\u0011\t\u0003M\tK!aQ\u0014\u0003\t1{gnZ\u0001\rg&TX-\u00138CsR,7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dC\u0015J\u0013\t\u0003Y\u0001AQa\f\u0004A\u0002ABQ\u0001\u000e\u0004A\u0002YBQa\u0010\u0004A\u0002\u0005\u000b!\u0002[1e_>\u00048i\u001c8g+\u0005i\u0005C\u0001(T\u001b\u0005y%B\u0001)R\u0003\u0011\u0019wN\u001c4\u000b\u0005I{\u0012A\u00025bI>|\u0007/\u0003\u0002U\u001f\ni1i\u001c8gS\u001e,(/\u0019;j_:\f1\u0002[1e_>\u00048i\u001c8gA\u0005ya-\u001b7f'R\fG/^:DC\u000eDW-F\u0001Y!\ta\u0013,\u0003\u0002[/\tya)\u001b7f'R\fG/^:DC\u000eDW-\u0001\tgS2,7\u000b^1ukN\u001c\u0015m\u00195fA\u0005a!-Y:f\u0019>\u001c\u0017\r^5p]V\ta\fE\u0002'?\u0006L!\u0001Y\u0014\u0003\r=\u0003H/[8o!\t\u0011w-D\u0001d\u0015\t!W-A\u0002oKRT\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iG\n\u0019QKU%\u0002\u001b\t\f7/\u001a'pG\u0006$\u0018n\u001c8!\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\fW#\u00017\u0011\u00055\u0004X\"\u00018\u000b\u0005=\\\u0012!\u0002;za\u0016\u001c\u0018BA9o\u0005)\u0019FO];diRK\b/Z\u0001\ne>|G\u000fU1uQN,\u0012\u0001\u001e\t\u0005kv\f\tA\u0004\u0002ww:\u0011qO_\u0007\u0002q*\u0011\u0011pI\u0001\u0007yI|w\u000e\u001e \n\u0003!J!\u0001`\u0014\u0002\u000fA\f7m[1hK&\u0011ap \u0002\u0004'\u0016\f(B\u0001?(!\u0011\t\u0019!!\u0003\u000e\u0005\u0005\u0015!bAA\u0004#\u0006\u0011am]\u0005\u0005\u0003\u0017\t)A\u0001\u0003QCRD\u0017!\u00037jgR4\u0015\u000e\\3t)\u0019\t\t\"!\u0007\u0002,A!Q/`A\n!\ra\u0013QC\u0005\u0004\u0003/9\"A\u0005)beRLG/[8o\t&\u0014Xm\u0019;pefDq!a\u0007\u0010\u0001\u0004\ti\"\u0001\tqCJ$\u0018\u000e^5p]\u001aKG\u000e^3sgB!Q/`A\u0010!\u0011\t\t#a\n\u000e\u0005\u0005\r\"bAA\u0013u\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\tI#a\t\u0003\u0015\u0015C\bO]3tg&|g\u000eC\u0004\u0002.=\u0001\r!!\b\u0002\u0017\u0011\fG/\u0019$jYR,'o]\u0001\be\u00164'/Z:i)\t\t\u0019\u0004E\u0002'\u0003kI1!a\u000e(\u0005\u0011)f.\u001b;\u0002!\u0019LG\u000e^3s!\u0006\u0014H/\u001b;j_:\u001cH\u0003BA\u001f\u0003\u0007\u00022\u0001LA \u0013\r\t\te\u0006\u0002\u0012\u0013:lU-\\8ss\u001aKG.Z%oI\u0016D\bbBA##\u0001\u0007\u0011QD\u0001\bM&dG/\u001a:t\u0003e1\u0017\u000e\u001c;feB\u000b'\u000f^5uS>t7OQ=GS2$XM]:\u0015\t\u0005-\u0013\u0011\u0010\t\bM\u00055\u0013QHA)\u0013\r\tye\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\tUl\u00181\u000b\t\u0005\u0003+\n\u0019H\u0004\u0003\u0002X\u0005=d\u0002BA-\u0003[rA!a\u0017\u0002l9!\u0011QLA5\u001d\u0011\ty&a\u001a\u000f\t\u0005\u0005\u0014Q\r\b\u0004o\u0006\r\u0014\"\u0001\u0012\n\u0005\u0001\n\u0013B\u0001\u0010 \u0013\taR$\u0003\u0002<7%\u0011\u0011HO\u0005\u0004\u0003cB\u0014\u0001D\"bi\u0006dwn\u001a+za\u0016\u001c\u0018\u0002BA;\u0003o\u0012!\u0003V1cY\u0016\u0004\u0016M\u001d;ji&|gn\u00159fG*\u0019\u0011\u0011\u000f\u001d\t\u000f\u0005\u0015#\u00031\u0001\u0002\u001e\u0005Q\u0011N\u001c9vi\u001aKG.Z:\u0016\u0005\u0005}\u0004#\u0002\u0014\u0002\u0002\u0006\u0015\u0015bAABO\t)\u0011I\u001d:bsB!\u0011qQAH\u001d\u0011\tI)a#\u0011\u0005]<\u0013bAAGO\u00051\u0001K]3eK\u001aLA!!%\u0002\u0014\n11\u000b\u001e:j]\u001eT1!!$(\u0003\u0019)\u0017/^1mgR!\u0011\u0011TAP!\r1\u00131T\u0005\u0004\u0003;;#a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003C#\u0002\u0019AAR\u0003\u0005y\u0007c\u0001\u0014\u0002&&\u0019\u0011qU\u0014\u0003\u0007\u0005s\u00170\u0001\u0005iCND7i\u001c3f)\t\ti\u000bE\u0002'\u0003_K1!!-(\u0005\rIe\u000e\u001e")
public class CatalogFileIndex
implements FileIndex {
    private final SparkSession sparkSession;
    private final CatalogTable table;
    private final long sizeInBytes;
    private final Configuration hadoopConf;
    private final FileStatusCache fileStatusCache;
    private final Option<URI> baseLocation;

    @Override
    public Option<Object> metadataOpsTimeNs() {
        return FileIndex.metadataOpsTimeNs$(this);
    }

    public CatalogTable table() {
        return this.table;
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    private FileStatusCache fileStatusCache() {
        return this.fileStatusCache;
    }

    private Option<URI> baseLocation() {
        return this.baseLocation;
    }

    @Override
    public StructType partitionSchema() {
        return this.table().partitionSchema();
    }

    @Override
    public Seq<Path> rootPaths() {
        return Option$.MODULE$.option2Iterable(this.baseLocation().map((Function1 & Serializable & scala.Serializable)x$1 -> new Path(x$1))).toSeq();
    }

    @Override
    public Seq<PartitionDirectory> listFiles(Seq<Expression> partitionFilters, Seq<Expression> dataFilters) {
        return this.filterPartitions(partitionFilters).listFiles((Seq<Expression>)Nil$.MODULE$, dataFilters);
    }

    @Override
    public void refresh() {
        this.fileStatusCache().invalidateAll();
    }

    public InMemoryFileIndex filterPartitions(Seq<Expression> filters) {
        return (InMemoryFileIndex)this.filterPartitionsByFilters(filters)._1();
    }

    public Tuple2<InMemoryFileIndex, Seq<Map<String, String>>> filterPartitionsByFilters(Seq<Expression> filters) {
        Tuple2 tuple2;
        if (this.table().partitionColumnNames().nonEmpty()) {
            ObjectRef partSpec = ObjectRef.create((Object)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)));
            long startTime = System.nanoTime();
            Seq selectedPartitions = this.sparkSession.sessionState().catalog().listPartitionsByFilter(this.table().identifier(), filters);
            Seq partitions = (Seq)selectedPartitions.map((Function1 & Serializable & scala.Serializable)p -> {
                Path path = new Path(p.location());
                FileSystem fs = path.getFileSystem(this.hadoopConf());
                partSpec$1.elem = (Seq)((Seq)partSpec$1.elem).$colon$plus((Object)p.spec(), Seq$.MODULE$.canBuildFrom());
                return new PartitionPath(p.toRow(this.partitionSchema(), $this.sparkSession.sessionState().conf().sessionLocalTimeZone()), path.makeQualified(fs.getUri(), fs.getWorkingDirectory()));
            }, Seq$.MODULE$.canBuildFrom());
            PartitionSpec partitionSpec = new PartitionSpec(this.partitionSchema(), (Seq<PartitionPath>)partitions);
            long timeNs = System.nanoTime() - startTime;
            tuple2 = new Tuple2((Object)new InMemoryFileIndex(this.sparkSession, (Seq<Path>)((Seq)partitionSpec.partitions().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.path(), Seq$.MODULE$.canBuildFrom())), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<StructType>)new Some((Object)partitionSpec.partitionColumns()), this.fileStatusCache(), (Option<PartitionSpec>)new Some((Object)partitionSpec), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)timeNs))), (Object)((Seq)partSpec.elem));
        } else {
            tuple2 = new Tuple2((Object)new InMemoryFileIndex(this.sparkSession, this.rootPaths(), (Map<String, String>)this.table().storage().properties(), (Option<StructType>)None$.MODULE$, this.fileStatusCache(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$6(), InMemoryFileIndex$.MODULE$.$lessinit$greater$default$7()), (Object)Seq$.MODULE$.empty());
        }
        return tuple2;
    }

    @Override
    public String[] inputFiles() {
        return this.filterPartitions((Seq<Expression>)Nil$.MODULE$).inputFiles();
    }

    public boolean equals(Object o) {
        boolean bl;
        Object object = o;
        if (object instanceof CatalogFileIndex) {
            CatalogFileIndex catalogFileIndex = (CatalogFileIndex)object;
            TableIdentifier tableIdentifier = this.table().identifier();
            TableIdentifier tableIdentifier2 = catalogFileIndex.table().identifier();
            bl = !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.table().identifier().hashCode();
    }

    public CatalogFileIndex(SparkSession sparkSession, CatalogTable table, long sizeInBytes) {
        this.sparkSession = sparkSession;
        this.table = table;
        this.sizeInBytes = sizeInBytes;
        FileIndex.$init$(this);
        this.hadoopConf = sparkSession.sessionState().newHadoopConf();
        this.fileStatusCache = FileStatusCache$.MODULE$.getOrCreate(sparkSession);
        Predef$.MODULE$.assert(table.identifier().database().isDefined(), (Function0 & Serializable & scala.Serializable)() -> "The table identifier must be qualified in CatalogFileIndex");
        this.baseLocation = table.storage().locationUri();
    }
}

