/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;

public final class UnsafeRowToTopKValuesMap {
    private final Comparator<Long> comparator;
    private final int k;
    private final int maxCardinality;
    private boolean skipTopKFiltering = false;
    private final Map<UnsafeRow, TreeSet<Long>> unsafeRowToTopKValuesMap = new HashMap<UnsafeRow, TreeSet<Long>>();

    public UnsafeRowToTopKValuesMap(PrefixComparator prefixComparator, int k, int maxCardinality) {
        this.comparator = (arg_0, arg_1) -> ((PrefixComparator)prefixComparator).compare(arg_0, arg_1);
        this.k = k;
        this.maxCardinality = maxCardinality;
    }

    public boolean insertIntoMap(UnsafeRow key, long value) {
        TreeSet<Long> topKValues;
        if (this.skipTopKFiltering) {
            return true;
        }
        if (!this.unsafeRowToTopKValuesMap.containsKey(key)) {
            this.unsafeRowToTopKValuesMap.put(key, new TreeSet<Long>(this.comparator));
            if (this.unsafeRowToTopKValuesMap.keySet().size() > this.maxCardinality) {
                this.skipTopKFiltering = true;
                this.unsafeRowToTopKValuesMap.clear();
                return true;
            }
        }
        if ((topKValues = this.unsafeRowToTopKValuesMap.get(key)).add(value) && topKValues.size() > this.k) {
            return topKValues.pollLast() != value;
        }
        return true;
    }
}

