/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.net.URI;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.TimeZone;
import javax.ws.rs.core.UriBuilder;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat$;
import org.apache.spark.sql.catalyst.catalog.CatalogUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.parser.AstBuilder;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.parser.ParserUtils$;
import org.apache.spark.sql.catalyst.parser.SqlBaseParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionByExpression;
import org.apache.spark.sql.catalyst.plans.logical.RepartitionZOrder;
import org.apache.spark.sql.catalyst.plans.logical.ScriptInputOutputSchema;
import org.apache.spark.sql.catalyst.plans.logical.SerdeInfo;
import org.apache.spark.sql.connector.catalog.CatalogV2Implicits$;
import org.apache.spark.sql.execution.CodegenMode$;
import org.apache.spark.sql.execution.CostMode$;
import org.apache.spark.sql.execution.ExtendedMode$;
import org.apache.spark.sql.execution.FormattedMode$;
import org.apache.spark.sql.execution.SimpleMode$;
import org.apache.spark.sql.execution.command.AddFileCommand;
import org.apache.spark.sql.execution.command.AddJarCommand;
import org.apache.spark.sql.execution.command.CacheTableCommand;
import org.apache.spark.sql.execution.command.ClearCacheCommand$;
import org.apache.spark.sql.execution.command.CreateTableLikeCommand;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.DescribeQueryCommand;
import org.apache.spark.sql.execution.command.ExplainCommand;
import org.apache.spark.sql.execution.command.ListFilesCommand;
import org.apache.spark.sql.execution.command.ListFilesCommand$;
import org.apache.spark.sql.execution.command.ListJarsCommand;
import org.apache.spark.sql.execution.command.ListJarsCommand$;
import org.apache.spark.sql.execution.command.ResetCommand;
import org.apache.spark.sql.execution.command.SetCommand;
import org.apache.spark.sql.execution.command.UncacheTableCommand;
import org.apache.spark.sql.execution.datasources.CreateTempViewUsing;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.RefreshResource;
import org.apache.spark.sql.internal.HiveSerDe;
import org.apache.spark.sql.internal.HiveSerDe$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple8;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\tMf\u0001B\u0012%\u0001=BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004I\u0001\u0001\u0006IA\u0010\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003>\u0011\u0019Q\u0005\u0001)A\u0005}!91\n\u0001b\u0001\n\u0013i\u0004B\u0002'\u0001A\u0003%a\bC\u0003N\u0001\u0011\u0005c\nC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003v\u0001\u0011\u0005c\u000fC\u0003|\u0001\u0011\u0005C\u0010C\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005=\u0001\u0001\"\u0011\u0002\u0012!9\u00111\u0004\u0001\u0005\n\u0005u\u0001bBA\u0019\u0001\u0011\u0005\u00131\u0007\u0005\b\u0003{\u0001A\u0011IA \u0011\u001d\tI\u0005\u0001C!\u0003\u0017Bq!!\u0016\u0001\t\u0003\n9\u0006C\u0004\u0002b\u0001!\t%a\u0019\t\u000f\u00055\u0004\u0001\"\u0001\u0002p!9\u0011\u0011\u0016\u0001\u0005B\u0005-\u0006bBA[\u0001\u0011\u0005\u0013q\u0017\u0005\b\u0003\u0003\u0004A\u0011IAb\u0011\u001d\ty\r\u0001C!\u0003#Dq!a7\u0001\t\u0003\ni\u000eC\u0004\u0002h\u0002!\t%!;\t\u000f\u0005M\b\u0001\"\u0003\u0002v\"9!Q\u0004\u0001\u0005B\t}\u0001b\u0002B\u0015\u0001\u0011E#1\u0006\u0005\b\u00057\u0002A\u0011\u000bB/\u0011\u001d\u0011Y\b\u0001C)\u0005{BqAa#\u0001\t\u0003\u0012i\tC\u0004\u0003 \u0002!\tE!)\t\u001d\t-\u0006\u0001%A\u0002\u0002\u0003%IA!,\u00032\n\u00112\u000b]1sWN\u000bH.Q:u\u0005VLG\u000eZ3s\u0015\t)c%A\u0005fq\u0016\u001cW\u000f^5p]*\u0011q\u0005K\u0001\u0004gFd'BA\u0015+\u0003\u0015\u0019\b/\u0019:l\u0015\tYC&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002[\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\r\t\u0003cYj\u0011A\r\u0006\u0003gQ\na\u0001]1sg\u0016\u0014(BA\u001b'\u0003!\u0019\u0017\r^1msN$\u0018BA\u001c3\u0005)\t5\u000f\u001e\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0002\"a\u000f\u0001\u000e\u0003\u0011\n\u0011cY8oM&<7*Z=WC2,X\rR3g+\u0005q\u0004CA G\u001b\u0005\u0001%BA!C\u0003!i\u0017\r^2iS:<'BA\"E\u0003\u0011)H/\u001b7\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012!\u0003\u000bI+w-\u001a=\u0002%\r|gNZ5h\u0017\u0016Lh+\u00197vK\u0012+g\rI\u0001\rG>tg-[4LKf$UMZ\u0001\u000eG>tg-[4LKf$UM\u001a\u0011\u0002\u001d\r|gNZ5h-\u0006dW/\u001a#fM\u0006y1m\u001c8gS\u001e4\u0016\r\\;f\t\u00164\u0007%A\u000bwSNLGoU3u\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0015\u0005=;\u0006C\u0001)V\u001b\u0005\t&B\u0001*T\u0003\u001dawnZ5dC2T!\u0001\u0016\u001b\u0002\u000bAd\u0017M\\:\n\u0005Y\u000b&a\u0003'pO&\u001c\u0017\r\u001c)mC:DQ\u0001\u0017\u0005A\u0002e\u000b1a\u0019;y!\tQFN\u0004\u0002\\U:\u0011A,\u001b\b\u0003;\"t!AX4\u000f\u0005}3gB\u00011f\u001d\t\tG-D\u0001c\u0015\t\u0019g&\u0001\u0004=e>|GOP\u0005\u0002[%\u00111\u0006L\u0005\u0003S)J!a\n\u0015\n\u0005U2\u0013BA\u001a5\u0013\tY''A\u0007Tc2\u0014\u0015m]3QCJ\u001cXM]\u0005\u0003[:\u0014qcU3u\u0007>tg-[4ve\u0006$\u0018n\u001c8D_:$X\r\u001f;\u000b\u0005-\u0014\u0014a\u0007<jg&$8+\u001a;Rk>$X\rZ\"p]\u001aLw-\u001e:bi&|g\u000e\u0006\u0002Pc\")\u0001,\u0003a\u0001eB\u0011!l]\u0005\u0003i:\u0014QdU3u#V|G/\u001a3D_:4\u0017nZ;sCRLwN\\\"p]R,\u0007\u0010^\u0001\u0018m&\u001c\u0018\u000e\u001e*fg\u0016$8i\u001c8gS\u001e,(/\u0019;j_:$\"aT<\t\u000baS\u0001\u0019\u0001=\u0011\u0005iK\u0018B\u0001>o\u0005e\u0011Vm]3u\u0007>tg-[4ve\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002;YL7/\u001b;SKN,G/U;pi\u0016$7i\u001c8gS\u001e,(/\u0019;j_:$\"aT?\t\u000ba[\u0001\u0019\u0001@\u0011\u0005i{\u0018bAA\u0001]\ny\"+Z:fiF+x\u000e^3e\u0007>tg-[4ve\u0006$\u0018n\u001c8D_:$X\r\u001f;\u0002!YL7/\u001b;TKR$\u0016.\\3[_:,GcA(\u0002\b!1\u0001\f\u0004a\u0001\u0003\u0013\u00012AWA\u0006\u0013\r\tiA\u001c\u0002\u0013'\u0016$H+[7f5>tWmQ8oi\u0016DH/\u0001\u000bwSNLGOU3ge\u0016\u001c\bNU3t_V\u00148-\u001a\u000b\u0004\u001f\u0006M\u0001B\u0002-\u000e\u0001\u0004\t)\u0002E\u0002[\u0003/I1!!\u0007o\u0005Y\u0011VM\u001a:fg\"\u0014Vm]8ve\u000e,7i\u001c8uKb$\u0018aG3yiJ\f7\r^+ocV|G/\u001a3SKN|WO]2f!\u0006$\b\u000e\u0006\u0003\u0002 \u0005=\u0002\u0003BA\u0011\u0003SqA!a\t\u0002&A\u0011\u0011\rR\u0005\u0004\u0003O!\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002,\u00055\"AB*ue&twMC\u0002\u0002(\u0011Ca\u0001\u0017\bA\u0002\u0005U\u0011a\u0004<jg&$8)Y2iKR\u000b'\r\\3\u0015\u0007=\u000b)\u0004\u0003\u0004Y\u001f\u0001\u0007\u0011q\u0007\t\u00045\u0006e\u0012bAA\u001e]\n\t2)Y2iKR\u000b'\r\\3D_:$X\r\u001f;\u0002#YL7/\u001b;V]\u000e\f7\r[3UC\ndW\rF\u0002P\u0003\u0003Ba\u0001\u0017\tA\u0002\u0005\r\u0003c\u0001.\u0002F%\u0019\u0011q\t8\u0003'Us7-Y2iKR\u000b'\r\\3D_:$X\r\u001f;\u0002\u001fYL7/\u001b;DY\u0016\f'oQ1dQ\u0016$2aTA'\u0011\u0019A\u0016\u00031\u0001\u0002PA\u0019!,!\u0015\n\u0007\u0005McNA\tDY\u0016\f'oQ1dQ\u0016\u001cuN\u001c;fqR\fAB^5tSR,\u0005\u0010\u001d7bS:$2aTA-\u0011\u0019A&\u00031\u0001\u0002\\A\u0019!,!\u0018\n\u0007\u0005}cN\u0001\bFqBd\u0017-\u001b8D_:$X\r\u001f;\u0002%YL7/\u001b;EKN\u001c'/\u001b2f#V,'/\u001f\u000b\u0004\u001f\u0006\u0015\u0004B\u0002-\u0014\u0001\u0004\t9\u0007E\u0002[\u0003SJ1!a\u001bo\u0005Q!Um]2sS\n,\u0017+^3ss\u000e{g\u000e^3yi\u0006yA/\u00192mK&#WM\u001c;jM&,'\u000f\u0006\u0005\u0002r\u0005e\u0014qRAJ!\u0011\t\u0019(!\u001e\u000e\u0003QJ1!a\u001e5\u0005=!\u0016M\u00197f\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBA>)\u0001\u0007\u0011QP\u0001\n[VdG/\u001b9beR\u0004b!a \u0002\n\u0006}a\u0002BAA\u0003\u000bs1!YAB\u0013\u0005)\u0015bAAD\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BAF\u0003\u001b\u00131aU3r\u0015\r\t9\t\u0012\u0005\b\u0003##\u0002\u0019AA\u0010\u0003\u001d\u0019w.\\7b]\u0012Da\u0001\u0017\u000bA\u0002\u0005U\u0005\u0003BAL\u0003Kk!!!'\u000b\t\u0005m\u0015QT\u0001\beVtG/[7f\u0015\u0011\ty*!)\u0002\u0005Y$$bAARY\u0005)\u0011M\u001c;me&!\u0011qUAM\u0005E\u0001\u0016M]:feJ+H.Z\"p]R,\u0007\u0010^\u0001\u0011m&\u001c\u0018\u000e^\"sK\u0006$X\rV1cY\u0016$2aTAW\u0011\u0019AV\u00031\u0001\u00020B\u0019!,!-\n\u0007\u0005MfN\u0001\nDe\u0016\fG/\u001a+bE2,7i\u001c8uKb$\u0018\u0001\u0007<jg&$8I]3bi\u0016$V-\u001c9WS\u0016<Xk]5oOR\u0019q*!/\t\ra3\u0002\u0019AA^!\rQ\u0016QX\u0005\u0004\u0003\u007fs'AG\"sK\u0006$X\rV3naZKWm^+tS:<7i\u001c8uKb$\u0018a\u0006<jg&$h*Z:uK\u0012\u001cuN\\:uC:$H*[:u)\u0011\t)-a2\u0011\r\u0005}\u0014\u0011RA?\u0011\u0019Av\u00031\u0001\u0002JB\u0019!,a3\n\u0007\u00055gNA\rOKN$X\rZ\"p]N$\u0018M\u001c;MSN$8i\u001c8uKb$\u0018!\u0005<jg&$8i\u001c8ti\u0006tG\u000fT5tiR!\u0011QPAj\u0011\u0019A\u0006\u00041\u0001\u0002VB\u0019!,a6\n\u0007\u0005egNA\nD_:\u001cH/\u00198u\u0019&\u001cHoQ8oi\u0016DH/\u0001\fwSNLGOR1jY:\u000bG/\u001b<f\u0007>lW.\u00198e)\ry\u0015q\u001c\u0005\u00071f\u0001\r!!9\u0011\u0007i\u000b\u0019/C\u0002\u0002f:\u0014\u0001DR1jY:\u000bG/\u001b<f\u0007>lW.\u00198e\u0007>tG/\u001a=u\u0003M1\u0018n]5u\u001b\u0006t\u0017mZ3SKN|WO]2f)\ry\u00151\u001e\u0005\u00071j\u0001\r!!<\u0011\u0007i\u000by/C\u0002\u0002r:\u0014Q#T1oC\u001e,'+Z:pkJ\u001cWmQ8oi\u0016DH/A\bu_N#xN]1hK\u001a{'/\\1u)!\t9Pa\u0001\u0003\u0010\tm\u0001\u0003BA}\u0003\u007fl!!a?\u000b\u0007\u0005uH'A\u0004dCR\fGn\\4\n\t\t\u0005\u00111 \u0002\u0015\u0007\u0006$\u0018\r\\8h'R|'/Y4f\r>\u0014X.\u0019;\t\u000f\t\u00151\u00041\u0001\u0003\b\u0005AAn\\2bi&|g\u000e\u0005\u0004\u0003\n\t-\u0011qD\u0007\u0002\t&\u0019!Q\u0002#\u0003\r=\u0003H/[8o\u0011\u001d\u0011\tb\u0007a\u0001\u0005'\ta\"\\1zE\u0016\u001cVM\u001d3f\u0013:4w\u000e\u0005\u0004\u0003\n\t-!Q\u0003\t\u0004!\n]\u0011b\u0001B\r#\nI1+\u001a:eK&sgm\u001c\u0005\u00071n\u0001\r!!&\u0002)YL7/\u001b;De\u0016\fG/\u001a+bE2,G*[6f)\ry%\u0011\u0005\u0005\u00071r\u0001\rAa\t\u0011\u0007i\u0013)#C\u0002\u0003(9\u0014ac\u0011:fCR,G+\u00192mK2K7.Z\"p]R,\u0007\u0010^\u0001\u0013o&$\bnU2sSB$\u0018jT*dQ\u0016l\u0017\r\u0006\b\u0003.\tM\"Q\u0007B \u0005\u0013\u0012iE!\u0015\u0011\u0007A\u0013y#C\u0002\u00032E\u0013qcU2sSB$\u0018J\u001c9vi>+H\u000f];u'\u000eDW-\\1\t\rak\u0002\u0019AAK\u0011\u001d\u00119$\ba\u0001\u0005s\t1\"\u001b8S_^4uN]7biB\u0019!La\u000f\n\u0007\tubN\u0001\tS_^4uN]7bi\u000e{g\u000e^3yi\"9!\u0011I\u000fA\u0002\t\r\u0013\u0001\u0004:fG>\u0014Hm\u0016:ji\u0016\u0014\b\u0003BAL\u0005\u000bJAAa\u0012\u0002\u001a\n)Ak\\6f]\"9!1J\u000fA\u0002\te\u0012\u0001D8viJ{wOR8s[\u0006$\bb\u0002B(;\u0001\u0007!1I\u0001\re\u0016\u001cwN\u001d3SK\u0006$WM\u001d\u0005\b\u0005'j\u0002\u0019\u0001B+\u0003)\u00198\r[3nC2+7o\u001d\t\u0005\u0005\u0013\u00119&C\u0002\u0003Z\u0011\u0013qAQ8pY\u0016\fg.A\u000exSRD'+\u001a9beRLG/[8o\u0005f,\u0005\u0010\u001d:fgNLwN\u001c\u000b\b\u001f\n}#q\rB<\u0011\u0019Af\u00041\u0001\u0003bA\u0019!La\u0019\n\u0007\t\u0015dN\u0001\rRk\u0016\u0014\u0018p\u0014:hC:L'0\u0019;j_:\u001cuN\u001c;fqRDqA!\u001b\u001f\u0001\u0004\u0011Y'A\u0006fqB\u0014Xm]:j_:\u001c\bCBA@\u0003\u0013\u0013i\u0007\u0005\u0003\u0003p\tMTB\u0001B9\u0015\r\u0011I\u0007N\u0005\u0005\u0005k\u0012\tH\u0001\u0006FqB\u0014Xm]:j_:DaA!\u001f\u001f\u0001\u0004y\u0015!B9vKJL\u0018aH<ji\"\u0014V\r]1si&$\u0018n\u001c8[\u001fJ$WM]#yaJ,7o]5p]RIqJa \u0003\u0002\n\u0015%\u0011\u0012\u0005\u00071~\u0001\rA!\u0019\t\u000f\t\ru\u00041\u0001\u0003l\u0005I\u0001/\u0019:u\u000bb\u0004(o\u001d\u0005\b\u0005\u000f{\u0002\u0019\u0001B6\u0003\u0019QX\t\u001f9sg\"1!\u0011P\u0010A\u0002=\u000bqC^5tSRLen]3si>3XM]<sSR,G)\u001b:\u0015\t\t=%q\u0013\t\u0005\u0005#\u0013\u0019*D\u0001\u0001\u0013\r\u0011)J\u000e\u0002\u0010\u0013:\u001cXM\u001d;ESJ\u0004\u0016M]1ng\"1\u0001\f\ta\u0001\u00053\u00032A\u0017BN\u0013\r\u0011iJ\u001c\u0002\u001a\u0013:\u001cXM\u001d;Pm\u0016\u0014xO]5uK\u0012K'oQ8oi\u0016DH/A\u000ewSNLG/\u00138tKJ$xJ^3soJLG/\u001a%jm\u0016$\u0015N\u001d\u000b\u0005\u0005\u001f\u0013\u0019\u000b\u0003\u0004YC\u0001\u0007!Q\u0015\t\u00045\n\u001d\u0016b\u0001BU]\ni\u0012J\\:feR|e/\u001a:xe&$X\rS5wK\u0012K'oQ8oi\u0016DH/\u0001\ftkB,'\u000f\n<jg&$8I]3bi\u0016$\u0016M\u00197f)\ry%q\u0016\u0005\u00071\n\u0002\r!a,\n\u0007\u0005%f\u0007")
public class SparkSqlAstBuilder
extends AstBuilder {
    private final Regex configKeyValueDef = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z_\\d\\\\.:]+)\\s*=([^;]*);*")).r();
    private final Regex configKeyDef = new StringOps(Predef$.MODULE$.augmentString("([a-zA-Z_\\d\\\\.:]+)$")).r();
    private final Regex configValueDef = new StringOps(Predef$.MODULE$.augmentString("([^;]*);*")).r();

    private /* synthetic */ LogicalPlan super$visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        return super.visitCreateTable(ctx);
    }

    private Regex configKeyValueDef() {
        return this.configKeyValueDef;
    }

    private Regex configKeyDef() {
        return this.configKeyDef;
    }

    private Regex configValueDef() {
        return this.configValueDef;
    }

    public LogicalPlan visitSetConfiguration(SqlBaseParser.SetConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            String string = ParserUtils$.MODULE$.remainder(ctx.SET().getSymbol()).trim();
            Option option = this.configKeyValueDef().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Option$.MODULE$.apply((Object)value.trim()))));
            } else {
                Option option2 = this.configKeyDef().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    String key = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)None$.MODULE$)));
                } else {
                    String string2 = string;
                    String string3 = "-v";
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"-v"), (Object)None$.MODULE$)));
                    } else if (string.isEmpty()) {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)None$.MODULE$);
                    } else {
                        throw new ParseException("Expected format is 'SET', 'SET key', or 'SET key=value'. If you want to include special characters in key, or include semicolon in value, please use quotes, e.g., SET `ke y`=`v;alue`.", (ParserRuleContext)ctx);
                    }
                }
            }
            return setCommand;
        });
    }

    public LogicalPlan visitSetQuotedConfiguration(SqlBaseParser.SetQuotedConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            if (ctx.configValue() != null && ctx.configKey() != null) {
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ctx.configKey().getText()), (Object)Option$.MODULE$.apply((Object)ctx.configValue().getText()))));
            } else if (ctx.configValue() != null) {
                String keyCandidate;
                String valueStr = ctx.configValue().getText();
                String string = keyCandidate = ParserUtils$.MODULE$.interval(ctx.SET().getSymbol(), ctx.EQ().getSymbol()).trim();
                Option option = this.configKeyDef().unapplySeq((CharSequence)string);
                if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                    throw new ParseException(new StringBuilder(64).append("'").append(keyCandidate).append("' is an invalid property key, please ").append("use quotes, e.g. SET `").append(keyCandidate).append("`=`").append(valueStr).append("`").toString(), (ParserRuleContext)ctx);
                }
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                SetCommand setCommand2 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)Option$.MODULE$.apply((Object)valueStr))));
                setCommand = setCommand2;
            } else {
                String keyStr = ctx.configKey().getText();
                if (ctx.EQ() != null) {
                    String string = ParserUtils$.MODULE$.remainder(ctx.EQ().getSymbol()).trim();
                    Option option = this.configValueDef().unapplySeq((CharSequence)string);
                    if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) {
                        throw new ParseException(new StringBuilder(66).append("'").append(string).append("' is an invalid property value, please ").append("use quotes, e.g. SET `").append(keyStr).append("`=`").append(string).append("`").toString(), (ParserRuleContext)ctx);
                    }
                    String valueStr = (String)((LinearSeqOptimized)option.get()).apply(0);
                    SetCommand setCommand3 = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyStr), (Object)Option$.MODULE$.apply((Object)valueStr))));
                    setCommand = setCommand3;
                } else {
                    setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)keyStr), (Object)None$.MODULE$)));
                }
            }
            return setCommand;
        });
    }

    public LogicalPlan visitResetConfiguration(SqlBaseParser.ResetConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            ResetCommand resetCommand;
            String string = ParserUtils$.MODULE$.remainder(ctx.RESET().getSymbol()).trim();
            Option option = this.configKeyDef().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                resetCommand = new ResetCommand((Option<String>)new Some((Object)key));
            } else if (string.trim().isEmpty()) {
                resetCommand = new ResetCommand((Option<String>)None$.MODULE$);
            } else {
                throw new ParseException("Expected format is 'RESET' or 'RESET key'. If you want to include special characters in key, please use quotes, e.g., RESET `ke y`.", (ParserRuleContext)ctx);
            }
            return resetCommand;
        });
    }

    public LogicalPlan visitResetQuotedConfiguration(SqlBaseParser.ResetQuotedConfigurationContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new ResetCommand((Option<String>)new Some((Object)ctx.configKey().getText())));
    }

    public LogicalPlan visitSetTimeZone(SqlBaseParser.SetTimeZoneContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            SetCommand setCommand;
            String key = SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key();
            if (ctx.interval() != null) {
                CalendarInterval interval = this.parseIntervalLiteral(ctx.interval());
                if (interval.months != 0 || interval.days != 0 || package$.MODULE$.abs(interval.microseconds) > 64800000000L || interval.microseconds % 1000000L != 0L) {
                    throw new ParseException("The interval value must be in the range of [-18, +18] hours with second precision", (ParserRuleContext)ctx.interval());
                }
                int seconds = (int)(interval.microseconds / 1000000L);
                setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)ZoneOffset.ofTotalSeconds(seconds).toString()))));
            } else if (ctx$5.timezone != null) {
                int n = ctx$5.timezone.getType();
                switch (n) {
                    case 136: {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)TimeZone.getDefault().getID()))));
                        break;
                    }
                    default: {
                        setCommand = new SetCommand((Option<Tuple2<String, Option<String>>>)new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new Some((Object)ParserUtils$.MODULE$.string(ctx.STRING())))));
                        break;
                    }
                }
            } else {
                throw new ParseException("Invalid time zone displacement value", (ParserRuleContext)ctx);
            }
            return setCommand;
        });
    }

    public LogicalPlan visitRefreshResource(SqlBaseParser.RefreshResourceContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            String path = ctx.STRING() != null ? ParserUtils$.MODULE$.string(ctx.STRING()) : this.extractUnquotedResourcePath(ctx);
            return new RefreshResource(path);
        });
    }

    private String extractUnquotedResourcePath(SqlBaseParser.RefreshResourceContext ctx) {
        return (String)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            String unquotedPath = ParserUtils$.MODULE$.remainder(ctx.REFRESH().getSymbol()).trim();
            ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> unquotedPath != null && !unquotedPath.isEmpty(), "Resource paths cannot be empty in REFRESH statements. Use / to match everything", (ParserRuleContext)ctx);
            Seq forbiddenSymbols = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", "\n", "\r", "\t"}));
            ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !forbiddenSymbols.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)unquotedPath.contains(x$1))), "REFRESH statements cannot contain ' ', '\\n', '\\r', '\\t' inside unquoted resource paths", (ParserRuleContext)ctx);
            return var1_1;
        });
    }

    public LogicalPlan visitCacheTable(SqlBaseParser.CacheTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Option query = Option$.MODULE$.apply((Object)ctx.query()).map((Function1 & Serializable & scala.Serializable)tree -> this.plan((ParserRuleContext)tree));
            Seq tableName = this.visitMultipartIdentifier(ctx.multipartIdentifier());
            if (query.isDefined() && tableName.length() > 1) {
                Seq catalogAndNamespace = (Seq)tableName.init();
                throw new ParseException(new StringBuilder(93).append("It is not allowed to add catalog/namespace ").append("prefix ").append(CatalogV2Implicits$.MODULE$.MultipartIdentifierHelper(catalogAndNamespace).quoted()).append(" to ").append("the table name in CACHE TABLE AS SELECT").toString(), (ParserRuleContext)ctx);
            }
            Option queryText = Option$.MODULE$.apply((Object)ctx.query()).map((Function1 & Serializable & scala.Serializable)x$2 -> ParserUtils$.MODULE$.source((ParserRuleContext)x$2));
            Map options = (Map)Option$.MODULE$.apply((Object)ctx$8.options).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            return new CacheTableCommand((Seq<String>)tableName, (Option<LogicalPlan>)query, (Option<String>)queryText, ctx.LAZY() != null, (Map<String, String>)options);
        });
    }

    public LogicalPlan visitUncacheTable(SqlBaseParser.UncacheTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new UncacheTableCommand((Seq<String>)this.visitMultipartIdentifier(ctx.multipartIdentifier()), ctx.EXISTS() != null));
    }

    public LogicalPlan visitClearCache(SqlBaseParser.ClearCacheContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ClearCacheCommand$.MODULE$);
    }

    public LogicalPlan visitExplain(SqlBaseParser.ExplainContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            if (ctx.LOGICAL() != null) {
                throw ParserUtils$.MODULE$.operationNotAllowed("EXPLAIN LOGICAL", (ParserRuleContext)ctx);
            }
            LogicalPlan statement = this.plan((ParserRuleContext)ctx.statement());
            return statement == null ? null : new ExplainCommand(statement, ctx.EXTENDED() != null ? ExtendedMode$.MODULE$ : (ctx.CODEGEN() != null ? CodegenMode$.MODULE$ : (ctx.COST() != null ? CostMode$.MODULE$ : (ctx.FORMATTED() != null ? FormattedMode$.MODULE$ : SimpleMode$.MODULE$))));
        });
    }

    public LogicalPlan visitDescribeQuery(SqlBaseParser.DescribeQueryContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new DescribeQueryCommand(ParserUtils$.MODULE$.source((ParserRuleContext)ctx.query()), this.visitQuery(ctx.query())));
    }

    public TableIdentifier tableIdentifier(Seq<String> multipart, String command, ParserRuleContext ctx) {
        TableIdentifier tableIdentifier;
        Seq<String> seq = multipart;
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            String tableName = (String)((SeqLike)some.get()).apply(0);
            tableIdentifier = TableIdentifier$.MODULE$.apply(tableName);
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(2) == 0) {
                String database = (String)((SeqLike)some2.get()).apply(0);
                String tableName = (String)((SeqLike)some2.get()).apply(1);
                tableIdentifier = new TableIdentifier(tableName, (Option)new Some((Object)database));
            } else {
                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(40).append(command).append(" does not support multi-part identifiers").toString(), ctx);
            }
        }
        return tableIdentifier;
    }

    public LogicalPlan visitCreateTable(SqlBaseParser.CreateTableContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan logicalPlan2;
            Tuple4 tuple4 = this.visitCreateTableHeader(ctx.createTableHeader());
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Seq ident = (Seq)tuple4._1();
            boolean temp = BoxesRunTime.unboxToBoolean((Object)tuple4._2());
            boolean ifNotExists = BoxesRunTime.unboxToBoolean((Object)tuple4._3());
            boolean external = BoxesRunTime.unboxToBoolean((Object)tuple4._4());
            Tuple4 tuple42 = new Tuple4((Object)ident, (Object)BoxesRunTime.boxToBoolean((boolean)temp), (Object)BoxesRunTime.boxToBoolean((boolean)ifNotExists), (Object)BoxesRunTime.boxToBoolean((boolean)external));
            Tuple4 tuple43 = tuple42;
            Seq ident2 = (Seq)tuple43._1();
            boolean temp2 = BoxesRunTime.unboxToBoolean((Object)tuple43._2());
            boolean ifNotExists2 = BoxesRunTime.unboxToBoolean((Object)tuple43._3());
            boolean external2 = BoxesRunTime.unboxToBoolean((Object)tuple43._4());
            if (!temp2 || ctx.query() != null) {
                logicalPlan2 = this.super$visitCreateTable(ctx);
            } else {
                if (external2) {
                    throw ParserUtils$.MODULE$.operationNotAllowed("CREATE EXTERNAL TABLE ... USING", (ParserRuleContext)ctx);
                }
                if (ifNotExists2) {
                    throw ParserUtils$.MODULE$.operationNotAllowed("CREATE TEMPORARY TABLE IF NOT EXISTS", (ParserRuleContext)ctx);
                }
                Tuple8 tuple8 = this.visitCreateTableClauses(ctx.createTableClauses());
                if (tuple8 == null) {
                    throw new MatchError((Object)tuple8);
                }
                Map options = (Map)tuple8._5();
                Option location = (Option)tuple8._6();
                Tuple2 tuple2 = new Tuple2((Object)options, (Object)location);
                Tuple2 tuple22 = tuple2;
                Map options2 = (Map)tuple22._1();
                Option location2 = (Option)tuple22._2();
                String provider = (String)Option$.MODULE$.apply((Object)ctx.tableProvider()).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.multipartIdentifier().getText()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new ParseException("CREATE TEMPORARY TABLE without a provider is not allowed.", (ParserRuleContext)ctx);
                });
                Option schema = Option$.MODULE$.apply((Object)ctx.colTypeList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.createSchema((SqlBaseParser.ColTypeListContext)ctx));
                this.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(106).append("CREATE TEMPORARY TABLE ... USING ... is deprecated, please use ").append("CREATE TEMPORARY VIEW ... USING ... instead").toString());
                TableIdentifier table = this.tableIdentifier((Seq<String>)ident2, "CREATE TEMPORARY VIEW", (ParserRuleContext)ctx);
                Map optionsWithLocation = (Map)location2.map((Function1 & Serializable & scala.Serializable)l -> options2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), l))).getOrElse((Function0 & Serializable & scala.Serializable)() -> options2);
                logicalPlan2 = new CreateTempViewUsing(table, (Option<StructType>)schema, false, false, provider, (Map<String, String>)optionsWithLocation);
            }
            return logicalPlan2;
        });
    }

    public LogicalPlan visitCreateTempViewUsing(SqlBaseParser.CreateTempViewUsingContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> new CreateTempViewUsing(this.visitTableIdentifier(ctx.tableIdentifier()), (Option<StructType>)Option$.MODULE$.apply((Object)ctx.colTypeList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.createSchema((SqlBaseParser.ColTypeListContext)ctx)), ctx.REPLACE() != null, ctx.GLOBAL() != null, ctx.tableProvider().multipartIdentifier().getText(), (Map<String, String>)((Map)Option$.MODULE$.apply((Object)ctx.tablePropertyList()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()))));
    }

    public Seq<Seq<String>> visitNestedConstantList(SqlBaseParser.NestedConstantListContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.constantList()).asScala()).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitConstantList((SqlBaseParser.ConstantListContext)ctx), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public Seq<String> visitConstantList(SqlBaseParser.ConstantListContext ctx) {
        return (Seq)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.constant()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> this.visitStringConstant((SqlBaseParser.ConstantContext)v, false), Buffer$.MODULE$.canBuildFrom())).toSeq());
    }

    public LogicalPlan visitFailNativeCommand(SqlBaseParser.FailNativeCommandContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            String keywords = ctx.unsupportedHiveNativeCommands() != null ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx$16.unsupportedHiveNativeCommands().children).asScala()).collect((PartialFunction)new scala.Serializable(null){
                public static final long serialVersionUID = 0L;

                public final <A1 extends ParseTree, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof TerminalNode) {
                        TerminalNode terminalNode = (TerminalNode)A1;
                        object = terminalNode.getText();
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(ParseTree x1) {
                    ParseTree parseTree = x1;
                    boolean bl = parseTree instanceof TerminalNode;
                    return bl;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(" ") : "SET ROLE";
            return ParserUtils$.MODULE$.operationNotAllowed(keywords, (ParserRuleContext)ctx);
        });
    }

    public LogicalPlan visitManageResource(SqlBaseParser.ManageResourceContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            LogicalPlan logicalPlan2;
            String maybePaths = ctx.STRING() != null ? ParserUtils$.MODULE$.string(ctx.STRING()) : ParserUtils$.MODULE$.remainder((ParserRuleContext)ctx.identifier()).trim();
            int n = ctx$17.op.getType();
            switch (n) {
                case 12: {
                    LogicalPlan logicalPlan3;
                    String string = ctx.identifier().getText().toLowerCase(Locale.ROOT);
                    if ("file".equals(string)) {
                        logicalPlan3 = new AddFileCommand(maybePaths);
                    } else if ("jar".equals(string)) {
                        logicalPlan3 = new AddJarCommand(maybePaths);
                    } else {
                        throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(25).append("ADD with resource type '").append(string).append("'").toString(), (ParserRuleContext)ctx);
                    }
                    logicalPlan2 = logicalPlan3;
                    break;
                }
                case 134: {
                    LogicalPlan logicalPlan4;
                    String string = ctx.identifier().getText().toLowerCase(Locale.ROOT);
                    boolean bl = "files".equals(string) ? true : "file".equals(string);
                    if (bl) {
                        logicalPlan4 = maybePaths.length() > 0 ? new ListFilesCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])maybePaths.split("\\s+"))) : new ListFilesCommand(ListFilesCommand$.MODULE$.apply$default$1());
                    } else {
                        boolean bl2 = "jars".equals(string) ? true : "jar".equals(string);
                        if (bl2) {
                            logicalPlan4 = maybePaths.length() > 0 ? new ListJarsCommand((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])maybePaths.split("\\s+"))) : new ListJarsCommand(ListJarsCommand$.MODULE$.apply$default$1());
                        } else {
                            throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(26).append("LIST with resource type '").append(string).append("'").toString(), (ParserRuleContext)ctx);
                        }
                    }
                    logicalPlan2 = logicalPlan4;
                    break;
                }
                default: {
                    throw ParserUtils$.MODULE$.operationNotAllowed("Other types of operation on resources", (ParserRuleContext)ctx);
                }
            }
            return logicalPlan2;
        });
    }

    private CatalogStorageFormat toStorageFormat(Option<String> location, Option<SerdeInfo> maybeSerdeInfo, ParserRuleContext ctx) {
        CatalogStorageFormat catalogStorageFormat;
        if (maybeSerdeInfo.isEmpty()) {
            catalogStorageFormat = CatalogStorageFormat$.MODULE$.empty().copy(location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str)), CatalogStorageFormat$.MODULE$.empty().copy$default$2(), CatalogStorageFormat$.MODULE$.empty().copy$default$3(), CatalogStorageFormat$.MODULE$.empty().copy$default$4(), CatalogStorageFormat$.MODULE$.empty().copy$default$5(), CatalogStorageFormat$.MODULE$.empty().copy$default$6());
        } else {
            SerdeInfo serdeInfo = (SerdeInfo)maybeSerdeInfo.get();
            if (serdeInfo.storedAs().isEmpty()) {
                Option x$1 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
                Option x$2 = serdeInfo.formatClasses().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.input());
                Option x$3 = serdeInfo.formatClasses().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.output());
                Option x$4 = serdeInfo.serde();
                Map x$5 = serdeInfo.serdeProperties();
                boolean x$62 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
                catalogStorageFormat = CatalogStorageFormat$.MODULE$.empty().copy(x$1, x$2, x$3, x$4, x$62, x$5);
            } else {
                Option<HiveSerDe> option = HiveSerDe$.MODULE$.sourceToSerDe((String)serdeInfo.storedAs().get());
                if (!(option instanceof Some)) {
                    throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(29).append("STORED AS with file format '").append(serdeInfo.storedAs().get()).append("'").toString(), ctx);
                }
                Some some = (Some)option;
                HiveSerDe hiveSerde = (HiveSerDe)some.value();
                Option x$72 = location.map((Function1 & Serializable & scala.Serializable)str -> CatalogUtils$.MODULE$.stringToURI(str));
                Option<String> x$8 = hiveSerde.inputFormat();
                Option<String> x$9 = hiveSerde.outputFormat();
                Option x$10 = serdeInfo.serde().orElse((Function0 & Serializable & scala.Serializable)() -> hiveSerde.serde());
                Map x$11 = serdeInfo.serdeProperties();
                boolean x$12 = CatalogStorageFormat$.MODULE$.empty().copy$default$5();
                CatalogStorageFormat catalogStorageFormat2 = CatalogStorageFormat$.MODULE$.empty().copy(x$72, x$8, x$9, x$10, x$12, x$11);
                catalogStorageFormat = catalogStorageFormat2;
            }
        }
        return catalogStorageFormat;
    }

    public LogicalPlan visitCreateTableLike(SqlBaseParser.CreateTableLikeContext ctx) {
        return (LogicalPlan)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Some some;
            SerdeInfo serdeInfo;
            TableIdentifier targetTable = this.visitTableIdentifier(ctx$18.target);
            TableIdentifier sourceTable = this.visitTableIdentifier(ctx$18.source);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.tableProvider(), "PROVIDER", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.createFileFormat(), "STORED AS/BY", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.rowFormat(), "ROW FORMAT", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.locationSpec(), "LOCATION", (ParserRuleContext)ctx);
            ParserUtils$.MODULE$.checkDuplicateClauses(ctx.TBLPROPERTIES(), "TBLPROPERTIES", (ParserRuleContext)ctx);
            Option provider = ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.tableProvider()).asScala()).headOption().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.multipartIdentifier().getText());
            Option location = this.visitLocationSpecList(ctx.locationSpec());
            Option serdeInfo2 = this.getSerdeInfo(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.rowFormat()).asScala()).toSeq(), ((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(ctx.createFileFormat()).asScala()).toSeq(), (ParserRuleContext)ctx, true);
            if (provider.isDefined() && serdeInfo2.isDefined()) {
                throw ParserUtils$.MODULE$.operationNotAllowed(new StringBuilder(32).append("CREATE TABLE LIKE ... USING ... ").append(((SerdeInfo)serdeInfo2.get()).describe()).toString(), (ParserRuleContext)ctx);
            }
            Option option = serdeInfo2;
            if (option instanceof Some && (serdeInfo = (SerdeInfo)(some = (Some)option).value()) != null) {
                Option storedAs = serdeInfo.storedAs();
                Option formatClasses = serdeInfo.formatClasses();
                Option serde = serdeInfo.serde();
                if (storedAs.isEmpty() && formatClasses.isEmpty() && serde.isDefined()) {
                    throw new ParseException("'ROW FORMAT' must be used with 'STORED AS'", (ParserRuleContext)ctx);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            CatalogStorageFormat storage = this.toStorageFormat((Option<String>)location, (Option<SerdeInfo>)serdeInfo2, (ParserRuleContext)ctx);
            Map properties = (Map)Option$.MODULE$.apply((Object)ctx$18.tableProps).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            return new CreateTableLikeCommand(targetTable, sourceTable, storage, (Option<String>)provider, (Map<String, String>)properties, ctx.EXISTS() != null);
        });
    }

    public ScriptInputOutputSchema withScriptIOSchema(ParserRuleContext ctx, SqlBaseParser.RowFormatContext inRowFormat, Token recordWriter, SqlBaseParser.RowFormatContext outRowFormat, Token recordReader, boolean schemaLess) {
        if (recordWriter != null || recordReader != null) {
            throw new ParseException("Unsupported operation: Used defined record reader/writer classes.", ctx);
        }
        Tuple4 tuple4 = this.format$1(inRowFormat, "hive.script.recordreader", "org.apache.hadoop.hive.ql.exec.TextRecordReader");
        if (tuple4 == null) {
            throw new MatchError((Object)tuple4);
        }
        Seq inFormat = (Seq)tuple4._1();
        Option inSerdeClass = (Option)tuple4._2();
        Seq inSerdeProps = (Seq)tuple4._3();
        Option reader = (Option)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)inFormat, (Object)inSerdeClass, (Object)inSerdeProps, (Object)reader);
        Tuple4 tuple43 = tuple42;
        Seq inFormat2 = (Seq)tuple43._1();
        Option inSerdeClass2 = (Option)tuple43._2();
        Seq inSerdeProps2 = (Seq)tuple43._3();
        Option reader2 = (Option)tuple43._4();
        Tuple4 tuple44 = this.format$1(outRowFormat, "hive.script.recordwriter", "org.apache.hadoop.hive.ql.exec.TextRecordWriter");
        if (tuple44 == null) {
            throw new MatchError((Object)tuple44);
        }
        Seq outFormat = (Seq)tuple44._1();
        Option outSerdeClass = (Option)tuple44._2();
        Seq outSerdeProps = (Seq)tuple44._3();
        Option writer = (Option)tuple44._4();
        Tuple4 tuple45 = new Tuple4((Object)outFormat, (Object)outSerdeClass, (Object)outSerdeProps, (Object)writer);
        Tuple4 tuple46 = tuple45;
        Seq outFormat2 = (Seq)tuple46._1();
        Option outSerdeClass2 = (Option)tuple46._2();
        Seq outSerdeProps2 = (Seq)tuple46._3();
        Option writer2 = (Option)tuple46._4();
        return new ScriptInputOutputSchema(inFormat2, outFormat2, inSerdeClass2, outSerdeClass2, inSerdeProps2, outSerdeProps2, reader2, writer2, schemaLess);
    }

    public LogicalPlan withRepartitionByExpression(SqlBaseParser.QueryOrganizationContext ctx, Seq<Expression> expressions, LogicalPlan query) {
        return new RepartitionByExpression(expressions, query, (Option)None$.MODULE$);
    }

    public LogicalPlan withRepartitionZOrderExpression(SqlBaseParser.QueryOrganizationContext ctx, Seq<Expression> partExprs, Seq<Expression> zExprs, LogicalPlan query) {
        return new RepartitionZOrder(partExprs, zExprs, query, this.conf().numShufflePartitions(), (Option)None$.MODULE$);
    }

    public Tuple3<Object, CatalogStorageFormat, Option<String>> visitInsertOverwriteDir(SqlBaseParser.InsertOverwriteDirContext ctx) {
        return (Tuple3)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Map options = (Map)Option$.MODULE$.apply((Object)ctx$19.options).map((Function1 & Serializable & scala.Serializable)ctx -> this.visitPropertyKeyValues((SqlBaseParser.TablePropertyListContext)ctx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
            CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((Map<String, String>)options);
            String path = (String)Option$.MODULE$.apply((Object)ctx$19.path).map((Function1 & Serializable & scala.Serializable)token -> ParserUtils$.MODULE$.string(token)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            if (!(path.isEmpty() ^ storage.locationUri().isEmpty())) {
                throw new ParseException("Directory path and 'path' in OPTIONS should be specified one, but not both", (ParserRuleContext)ctx);
            }
            if (!path.isEmpty()) {
                Some customLocation = new Some((Object)CatalogUtils$.MODULE$.stringToURI(path));
                CatalogStorageFormat qual$1 = storage;
                Some x$1 = customLocation;
                Option x$2 = qual$1.copy$default$2();
                Option x$3 = qual$1.copy$default$3();
                Option x$4 = qual$1.copy$default$4();
                boolean x$5 = qual$1.copy$default$5();
                Map x$6 = qual$1.copy$default$6();
                storage = qual$1.copy((Option)x$1, x$2, x$3, x$4, x$5, x$6);
            }
            if (ctx.LOCAL() != null) {
                Some some;
                String pathScheme;
                Option scheme = Option$.MODULE$.apply((Object)((URI)storage.locationUri().get()).getScheme());
                Option option = scheme;
                if (option instanceof Some && !(pathScheme = (String)(some = (Some)option).value()).equals("file")) {
                    throw new ParseException("LOCAL is supported only with file: scheme", (ParserRuleContext)ctx);
                }
                Some loc = new Some((Object)UriBuilder.fromUri((URI)CatalogUtils$.MODULE$.stringToURI(path)).scheme("file").build(new Object[0]));
                CatalogStorageFormat qual$2 = storage;
                Some x$7 = loc;
                Option x$8 = qual$2.copy$default$2();
                Option x$9 = qual$2.copy$default$3();
                Option x$10 = qual$2.copy$default$4();
                boolean x$11 = qual$2.copy$default$5();
                Map x$12 = qual$2.copy$default$6();
                storage = qual$2.copy((Option)x$7, x$8, x$9, x$10, x$11, x$12);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            String provider = ctx.tableProvider().multipartIdentifier().getText();
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)storage, (Object)new Some((Object)provider));
        });
    }

    public Tuple3<Object, CatalogStorageFormat, Option<String>> visitInsertOverwriteHiveDir(SqlBaseParser.InsertOverwriteHiveDirContext ctx) {
        return (Tuple3)ParserUtils$.MODULE$.withOrigin((ParserRuleContext)ctx, (Function0 & Serializable & scala.Serializable)() -> {
            Option serdeInfo = this.getSerdeInfo(Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)ctx.rowFormat())).toSeq(), Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)ctx.createFileFormat())).toSeq(), (ParserRuleContext)ctx, this.getSerdeInfo$default$4());
            String path = ParserUtils$.MODULE$.string(ctx$20.path);
            if (path.isEmpty()) {
                throw ParserUtils$.MODULE$.operationNotAllowed("INSERT OVERWRITE DIRECTORY must be accompanied by path", (ParserRuleContext)ctx);
            }
            CatalogStorageFormat catalogStorageFormat = HiveSerDe$.MODULE$.getDefaultStorage(this.conf());
            CatalogStorageFormat storage = this.toStorageFormat((Option<String>)new Some((Object)path), (Option<SerdeInfo>)serdeInfo, (ParserRuleContext)ctx);
            Option x$1 = storage.inputFormat().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.inputFormat());
            Option x$2 = storage.outputFormat().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.outputFormat());
            Option x$3 = storage.serde().orElse((Function0 & Serializable & scala.Serializable)() -> catalogStorageFormat.serde());
            Option x$4 = storage.copy$default$1();
            boolean x$5 = storage.copy$default$5();
            Map x$6 = storage.copy$default$6();
            CatalogStorageFormat finalStorage = storage.copy(x$4, x$1, x$2, x$3, x$5, x$6);
            return new Tuple3((Object)BoxesRunTime.boxToBoolean((ctx.LOCAL() != null ? 1 : 0) != 0), (Object)finalStorage, (Object)new Some((Object)DDLUtils$.MODULE$.HIVE_PROVIDER()));
        });
    }

    private final Tuple4 format$1(SqlBaseParser.RowFormatContext fmt, String configKey, String defaultConfigValue) {
        Tuple4 tuple4;
        block6: {
            SqlBaseParser.RowFormatContext rowFormatContext;
            block7: {
                Map props;
                Option option;
                block9: {
                    SerdeInfo serdeInfo;
                    block8: {
                        block5: {
                            rowFormatContext = fmt;
                            if (!(rowFormatContext instanceof SqlBaseParser.RowFormatDelimitedContext)) break block5;
                            SqlBaseParser.RowFormatDelimitedContext rowFormatDelimitedContext = (SqlBaseParser.RowFormatDelimitedContext)rowFormatContext;
                            Seq entries = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATFIELD", rowFormatDelimitedContext.fieldsTerminatedBy).$plus$plus((GenTraversableOnce)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATCOLLITEMS", rowFormatDelimitedContext.collectionItemsTerminatedBy), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATMAPKEYS", rowFormatDelimitedContext.keysTerminatedBy), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)ParserUtils$.MODULE$.entry("TOK_TABLEROWFORMATNULL", rowFormatDelimitedContext.nullDefinedAs), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)rowFormatDelimitedContext.linesSeparatedBy)).toSeq().map((Function1 & Serializable & scala.Serializable)token -> {
                                String value = ParserUtils$.MODULE$.string(token);
                                ParserUtils$.MODULE$.validate((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
                                    String string = value;
                                    String string2 = "\n";
                                    return !(string != null ? !string.equals(string2) : string2 != null);
                                }, new StringBuilder(58).append("LINES TERMINATED BY only supports newline '\\n' right now: ").append(value).toString(), (ParserRuleContext)rowFormatDelimitedContext);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"TOK_TABLEROWFORMATLINES"), (Object)value);
                            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                            tuple4 = new Tuple4((Object)entries, (Object)None$.MODULE$, (Object)Seq$.MODULE$.empty(), (Object)None$.MODULE$);
                            break block6;
                        }
                        if (!(rowFormatContext instanceof SqlBaseParser.RowFormatSerdeContext)) break block7;
                        SqlBaseParser.RowFormatSerdeContext rowFormatSerdeContext = (SqlBaseParser.RowFormatSerdeContext)rowFormatContext;
                        serdeInfo = this.visitRowFormatSerde(rowFormatSerdeContext);
                        if (serdeInfo == null) break block8;
                        Option option2 = serdeInfo.storedAs();
                        Option option3 = serdeInfo.formatClasses();
                        option = serdeInfo.serde();
                        props = serdeInfo.serdeProperties();
                        if (None$.MODULE$.equals(option2) && None$.MODULE$.equals(option3) && option instanceof Some) break block9;
                    }
                    throw new MatchError((Object)serdeInfo);
                }
                Some some = (Some)option;
                String name = (String)some.value();
                Tuple2 tuple2 = new Tuple2((Object)name, (Object)props);
                Tuple2 tuple22 = tuple2;
                String name2 = (String)tuple22._1();
                Map props2 = (Map)tuple22._2();
                String string = name2;
                String string2 = "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe";
                None$ recordHandler = !(string != null ? !string.equals(string2) : string2 != null) ? Option$.MODULE$.apply((Object)this.conf().getConfString(configKey, defaultConfigValue)) : None$.MODULE$;
                tuple4 = new Tuple4((Object)Seq$.MODULE$.empty(), (Object)Option$.MODULE$.apply((Object)name2), (Object)props2.toSeq(), (Object)recordHandler);
                break block6;
            }
            if (rowFormatContext == null) {
                String name = this.conf().getConfString("hive.script.serde", "org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe");
                Seq props = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"field.delim"), (Object)"\t"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"serialization.last.column.takes.rest"), (Object)"true")}));
                Option recordHandler = Option$.MODULE$.apply((Object)this.conf().getConfString(configKey, defaultConfigValue));
                tuple4 = new Tuple4((Object)Nil$.MODULE$, (Object)Option$.MODULE$.apply((Object)name), (Object)props, (Object)recordHandler);
            } else {
                throw new MatchError((Object)rowFormatContext);
            }
        }
        return tuple4;
    }
}

