/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.hive.ql.plan.DDLDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.PrincipalDesc;

@Explain(displayName="Create Database", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
public class AlterDatabaseDesc
extends DDLDesc
implements Serializable {
    private static final long serialVersionUID = 1L;
    ALTER_DB_TYPES alterType;
    String databaseName;
    Map<String, String> dbProperties;
    PrincipalDesc ownerPrincipal;
    String location;

    public AlterDatabaseDesc() {
    }

    public AlterDatabaseDesc(String databaseName, Map<String, String> dbProps) {
        this.databaseName = databaseName;
        this.dbProperties = dbProps;
        this.setDatabaseProperties(dbProps);
        this.setAlterType(ALTER_DB_TYPES.ALTER_PROPERTY);
    }

    public AlterDatabaseDesc(String databaseName, PrincipalDesc ownerPrincipal) {
        this.databaseName = databaseName;
        this.setOwnerPrincipal(ownerPrincipal);
        this.setAlterType(ALTER_DB_TYPES.ALTER_OWNER);
    }

    public AlterDatabaseDesc(String databaseName, String newLocation) {
        this.databaseName = databaseName;
        this.setLocation(newLocation);
        this.setAlterType(ALTER_DB_TYPES.ALTER_LOCATION);
    }

    @Explain(displayName="properties")
    public Map<String, String> getDatabaseProperties() {
        return this.dbProperties;
    }

    public void setDatabaseProperties(Map<String, String> dbProps) {
        this.dbProperties = dbProps;
    }

    @Explain(displayName="name", explainLevels={Explain.Level.USER, Explain.Level.DEFAULT, Explain.Level.EXTENDED})
    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Explain(displayName="owner")
    public PrincipalDesc getOwnerPrincipal() {
        return this.ownerPrincipal;
    }

    public void setOwnerPrincipal(PrincipalDesc ownerPrincipal) {
        this.ownerPrincipal = ownerPrincipal;
    }

    @Explain(displayName="location")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public ALTER_DB_TYPES getAlterType() {
        return this.alterType;
    }

    public void setAlterType(ALTER_DB_TYPES alterType) {
        this.alterType = alterType;
    }

    public static enum ALTER_DB_TYPES {
        ALTER_PROPERTY,
        ALTER_OWNER,
        ALTER_LOCATION;

    }
}

