/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.HashMap;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ColumnStatsSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.DDLSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSQRewriteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.FunctionSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ImportSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.LoadSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.MacroSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.UpdateDeleteSemanticAnalyzer;
import org.apache.hadoop.hive.ql.plan.HiveOperation;

public final class SemanticAnalyzerFactory {
    static HashMap<Integer, HiveOperation> commandType = new HashMap();
    static HashMap<Integer, HiveOperation[]> tablePartitionCommandType = new HashMap();

    public static BaseSemanticAnalyzer get(QueryState queryState, ASTNode tree) throws SemanticException {
        if (tree.getToken() == null) {
            throw new RuntimeException("Empty Syntax Tree");
        }
        HiveOperation opType = commandType.get(tree.getType());
        queryState.setCommandType(opType);
        switch (tree.getType()) {
            case 752: {
                return new ExplainSemanticAnalyzer(queryState);
            }
            case 753: {
                return new ExplainSQRewriteSemanticAnalyzer(queryState);
            }
            case 812: {
                return new LoadSemanticAnalyzer(queryState);
            }
            case 755: {
                return new ExportSemanticAnalyzer(queryState);
            }
            case 779: {
                return new ImportSemanticAnalyzer(queryState);
            }
            case 884: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 885: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 886: {
                return new ReplicationSemanticAnalyzer(queryState);
            }
            case 657: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 658: 
                    case 659: 
                    case 660: 
                    case 661: 
                    case 666: 
                    case 667: 
                    case 668: 
                    case 669: 
                    case 673: 
                    case 674: 
                    case 675: 
                    case 676: 
                    case 678: 
                    case 681: 
                    case 683: 
                    case 684: {
                        queryState.setCommandType(commandType.get(child.getType()));
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                opType = tablePartitionCommandType.get(child.getType())[tree.getChildCount() > 2 ? 1 : 0];
                queryState.setCommandType(opType);
                return new DDLSemanticAnalyzer(queryState);
            }
            case 687: {
                Tree child = tree.getChild(1);
                switch (child.getType()) {
                    case 688: 
                    case 689: 
                    case 690: 
                    case 691: 
                    case 692: {
                        opType = commandType.get(child.getType());
                        queryState.setCommandType(opType);
                        return new DDLSemanticAnalyzer(queryState);
                    }
                }
                assert (child.getType() == 877);
                queryState.setCommandType(HiveOperation.ALTERVIEW_AS);
                return new SemanticAnalyzer(queryState);
            }
            case 648: 
            case 652: 
            case 653: 
            case 654: 
            case 655: 
            case 656: 
            case 664: 
            case 700: 
            case 708: 
            case 710: 
            case 713: 
            case 732: 
            case 733: 
            case 734: 
            case 741: 
            case 743: 
            case 745: 
            case 746: 
            case 747: 
            case 748: 
            case 767: 
            case 769: 
            case 813: 
            case 814: 
            case 819: 
            case 891: 
            case 892: 
            case 910: 
            case 911: 
            case 912: 
            case 913: 
            case 914: 
            case 915: 
            case 916: 
            case 917: 
            case 918: 
            case 919: 
            case 920: 
            case 921: 
            case 922: 
            case 923: 
            case 924: 
            case 925: 
            case 926: 
            case 927: 
            case 928: 
            case 929: 
            case 930: 
            case 948: 
            case 991: 
            case 999: 
            case 1000: {
                return new DDLSemanticAnalyzer(queryState);
            }
            case 709: 
            case 742: 
            case 881: {
                return new FunctionSemanticAnalyzer(queryState);
            }
            case 693: {
                return new ColumnStatsSemanticAnalyzer(queryState);
            }
            case 712: 
            case 744: {
                return new MacroSemanticAnalyzer(queryState);
            }
            case 731: 
            case 817: 
            case 1002: {
                return new UpdateDeleteSemanticAnalyzer(queryState);
            }
        }
        SemanticAnalyzer semAnalyzer = HiveConf.getBoolVar((Configuration)queryState.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_CBO_ENABLED) ? new CalcitePlanner(queryState) : new SemanticAnalyzer(queryState);
        return semAnalyzer;
    }

    private SemanticAnalyzerFactory() {
    }

    static HiveOperation getOperation(int hiveParserToken) {
        return commandType.get(hiveParserToken);
    }

    static {
        commandType.put(752, HiveOperation.EXPLAIN);
        commandType.put(812, HiveOperation.LOAD);
        commandType.put(755, HiveOperation.EXPORT);
        commandType.put(779, HiveOperation.IMPORT);
        commandType.put(708, HiveOperation.CREATEDATABASE);
        commandType.put(741, HiveOperation.DROPDATABASE);
        commandType.put(948, HiveOperation.SWITCHDATABASE);
        commandType.put(714, HiveOperation.CREATETABLE);
        commandType.put(991, HiveOperation.TRUNCATETABLE);
        commandType.put(746, HiveOperation.DROPTABLE);
        commandType.put(734, HiveOperation.DESCTABLE);
        commandType.put(733, HiveOperation.DESCFUNCTION);
        commandType.put(819, HiveOperation.MSCK);
        commandType.put(658, HiveOperation.ALTERTABLE_ADDCOLS);
        commandType.put(678, HiveOperation.ALTERTABLE_REPLACECOLS);
        commandType.put(676, HiveOperation.ALTERTABLE_RENAMECOL);
        commandType.put(675, HiveOperation.ALTERTABLE_RENAME);
        commandType.put(667, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(660, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(683, HiveOperation.ALTERTABLE_TOUCH);
        commandType.put(661, HiveOperation.ALTERTABLE_ARCHIVE);
        commandType.put(684, HiveOperation.ALTERTABLE_UNARCHIVE);
        commandType.put(674, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(668, HiveOperation.ALTERTABLE_PROPERTIES);
        commandType.put(669, HiveOperation.ALTERTABLE_EXCHANGEPARTITION);
        commandType.put(666, HiveOperation.ALTERTABLE_DROPCONSTRAINT);
        commandType.put(659, HiveOperation.ALTERTABLE_ADDCONSTRAINT);
        commandType.put(912, HiveOperation.SHOWDATABASES);
        commandType.put(918, HiveOperation.SHOWTABLES);
        commandType.put(910, HiveOperation.SHOWCOLUMNS);
        commandType.put(928, HiveOperation.SHOW_TABLESTATUS);
        commandType.put(929, HiveOperation.SHOW_TBLPROPERTIES);
        commandType.put(921, HiveOperation.SHOW_CREATEDATABASE);
        commandType.put(922, HiveOperation.SHOW_CREATETABLE);
        commandType.put(914, HiveOperation.SHOWFUNCTIONS);
        commandType.put(915, HiveOperation.SHOWINDEXES);
        commandType.put(917, HiveOperation.SHOWPARTITIONS);
        commandType.put(916, HiveOperation.SHOWLOCKS);
        commandType.put(913, HiveOperation.SHOWLOCKS);
        commandType.put(911, HiveOperation.SHOWCONF);
        commandType.put(919, HiveOperation.SHOWVIEWS);
        commandType.put(709, HiveOperation.CREATEFUNCTION);
        commandType.put(742, HiveOperation.DROPFUNCTION);
        commandType.put(881, HiveOperation.RELOADFUNCTION);
        commandType.put(712, HiveOperation.CREATEMACRO);
        commandType.put(744, HiveOperation.DROPMACRO);
        commandType.put(715, HiveOperation.CREATEVIEW);
        commandType.put(716, HiveOperation.CREATE_MATERIALIZED_VIEW);
        commandType.put(747, HiveOperation.DROPVIEW);
        commandType.put(748, HiveOperation.DROP_MATERIALIZED_VIEW);
        commandType.put(710, HiveOperation.CREATEINDEX);
        commandType.put(743, HiveOperation.DROPINDEX);
        commandType.put(656, HiveOperation.ALTERINDEX_REBUILD);
        commandType.put(655, HiveOperation.ALTERINDEX_PROPS);
        commandType.put(691, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(690, HiveOperation.ALTERVIEW_PROPERTIES);
        commandType.put(688, HiveOperation.ALTERTABLE_ADDPARTS);
        commandType.put(689, HiveOperation.ALTERTABLE_DROPPARTS);
        commandType.put(692, HiveOperation.ALTERVIEW_RENAME);
        commandType.put(687, HiveOperation.ALTERVIEW_AS);
        commandType.put(877, HiveOperation.QUERY);
        commandType.put(814, HiveOperation.LOCKTABLE);
        commandType.put(1000, HiveOperation.UNLOCKTABLE);
        commandType.put(813, HiveOperation.LOCKDB);
        commandType.put(999, HiveOperation.UNLOCKDB);
        commandType.put(713, HiveOperation.CREATEROLE);
        commandType.put(745, HiveOperation.DROPROLE);
        commandType.put(767, HiveOperation.GRANT_PRIVILEGE);
        commandType.put(891, HiveOperation.REVOKE_PRIVILEGE);
        commandType.put(923, HiveOperation.SHOW_GRANT);
        commandType.put(769, HiveOperation.GRANT_ROLE);
        commandType.put(892, HiveOperation.REVOKE_ROLE);
        commandType.put(924, HiveOperation.SHOW_ROLES);
        commandType.put(927, HiveOperation.SHOW_ROLES);
        commandType.put(926, HiveOperation.SHOW_ROLE_PRINCIPALS);
        commandType.put(925, HiveOperation.SHOW_ROLE_GRANT);
        commandType.put(654, HiveOperation.ALTERDATABASE);
        commandType.put(653, HiveOperation.ALTERDATABASE_OWNER);
        commandType.put(652, HiveOperation.ALTERDATABASE_LOCATION);
        commandType.put(732, HiveOperation.DESCDATABASE);
        commandType.put(681, HiveOperation.ALTERTABLE_SKEWED);
        commandType.put(693, HiveOperation.ANALYZE_TABLE);
        commandType.put(700, HiveOperation.CACHE_METADATA);
        commandType.put(673, HiveOperation.ALTERTABLE_PARTCOLTYPE);
        commandType.put(920, HiveOperation.SHOW_COMPACTIONS);
        commandType.put(930, HiveOperation.SHOW_TRANSACTIONS);
        commandType.put(648, HiveOperation.ABORT_TRANSACTIONS);
        commandType.put(936, HiveOperation.START_TRANSACTION);
        commandType.put(707, HiveOperation.COMMIT);
        commandType.put(897, HiveOperation.ROLLBACK);
        commandType.put(908, HiveOperation.SET_AUTOCOMMIT);
        commandType.put(884, HiveOperation.EXPORT);
        commandType.put(885, HiveOperation.IMPORT);
        commandType.put(886, HiveOperation.SHOW_TBLPROPERTIES);
        tablePartitionCommandType.put(670, new HiveOperation[]{HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT});
        tablePartitionCommandType.put(671, new HiveOperation[]{HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION});
        tablePartitionCommandType.put(672, new HiveOperation[]{HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES});
        tablePartitionCommandType.put(680, new HiveOperation[]{HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER});
        tablePartitionCommandType.put(679, new HiveOperation[]{HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES});
        tablePartitionCommandType.put(677, new HiveOperation[]{null, HiveOperation.ALTERTABLE_RENAMEPART});
        tablePartitionCommandType.put(665, new HiveOperation[]{HiveOperation.ALTERTABLE_COMPACT, HiveOperation.ALTERTABLE_COMPACT});
        tablePartitionCommandType.put(682, new HiveOperation[]{HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTBLPART_SKEWED_LOCATION});
        tablePartitionCommandType.put(662, new HiveOperation[]{HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM});
        tablePartitionCommandType.put(664, new HiveOperation[]{HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ALTERTABLE_CLUSTER_SORT});
        tablePartitionCommandType.put(685, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
        tablePartitionCommandType.put(686, new HiveOperation[]{HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_UPDATEPARTSTATS});
    }
}

