/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.PTFUtils;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.ASTBuilder;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.CalcitePlanner;
import org.apache.hadoop.hive.ql.parse.ParseDriver;
import org.apache.hadoop.hive.ql.parse.ParseException;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ParseUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ParseUtils.class);

    public static ASTNode parse(String command) throws ParseException {
        return ParseUtils.parse(command, null);
    }

    public static ASTNode parse(String command, Context ctx) throws ParseException {
        return ParseUtils.parse(command, ctx, null);
    }

    public static ASTNode parse(String command, Context ctx, String viewFullyQualifiedName) throws ParseException {
        ParseDriver pd = new ParseDriver();
        ASTNode tree = pd.parse(command, ctx, viewFullyQualifiedName);
        tree = ParseUtils.findRootNonNullToken(tree);
        ParseUtils.handleSetColRefs(tree);
        return tree;
    }

    public static boolean isJoinToken(ASTNode node) {
        switch (node.getToken().getType()) {
            case 763: 
            case 803: 
            case 806: 
            case 895: {
                return true;
            }
        }
        return false;
    }

    private static ASTNode findRootNonNullToken(ASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        return tree;
    }

    private ParseUtils() {
    }

    public static List<String> validateColumnNameUniqueness(List<FieldSchema> fieldSchemas) throws SemanticException {
        Iterator<FieldSchema> iterCols = fieldSchemas.iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg(oldColName));
            }
            colNames.add(colName);
        }
        return colNames;
    }

    public static ExprNodeDesc createConversionCast(ExprNodeDesc column, PrimitiveTypeInfo tableFieldTypeInfo) throws SemanticException {
        String baseType = TypeInfoUtils.getBaseName((String)tableFieldTypeInfo.getTypeName());
        return TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDescWithUdfData(baseType, (TypeInfo)tableFieldTypeInfo, column);
    }

    public static VarcharTypeInfo getVarcharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type varchar");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getVarcharTypeInfo((int)Integer.parseInt(lengthStr));
    }

    public static CharTypeInfo getCharTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type char");
        }
        String lengthStr = node.getChild(0).getText();
        return TypeInfoFactory.getCharTypeInfo((int)Integer.parseInt(lengthStr));
    }

    static int getIndex(String[] list, String elem) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] == null || !list[i].toLowerCase().equals(elem)) continue;
            return i;
        }
        return -1;
    }

    static int checkJoinFilterRefersOneAlias(String[] tabAliases, ASTNode filterCondn) {
        int i;
        switch (filterCondn.getType()) {
            case 974: {
                String tableOrCol = SemanticAnalyzer.unescapeIdentifier(filterCondn.getChild(0).getText().toLowerCase());
                return ParseUtils.getIndex(tabAliases, tableOrCol);
            }
            case 24: 
            case 25: 
            case 117: 
            case 295: 
            case 340: 
            case 341: 
            case 352: 
            case 703: 
            case 724: 
            case 826: 
            case 940: {
                return -1;
            }
        }
        int idx = -1;
        int n = i = filterCondn.getType() == 764 ? 1 : 0;
        while (i < filterCondn.getChildCount()) {
            int cIdx = ParseUtils.checkJoinFilterRefersOneAlias(tabAliases, (ASTNode)filterCondn.getChild(i));
            if (cIdx != idx) {
                if (idx != -1 && cIdx != -1) {
                    return -1;
                }
                idx = idx == -1 ? cIdx : idx;
            }
            ++i;
        }
        return idx;
    }

    public static DecimalTypeInfo getDecimalTypeTypeInfo(ASTNode node) throws SemanticException {
        if (node.getChildCount() > 2) {
            throw new SemanticException("Bad params for type decimal");
        }
        int precision = 10;
        int scale = 0;
        if (node.getChildCount() >= 1) {
            String precStr = node.getChild(0).getText();
            precision = Integer.parseInt(precStr);
        }
        if (node.getChildCount() == 2) {
            String scaleStr = node.getChild(1).getText();
            scale = Integer.parseInt(scaleStr);
        }
        return TypeInfoFactory.getDecimalTypeInfo((int)precision, (int)scale);
    }

    public static String ensureClassExists(String className) throws SemanticException {
        if (className == null) {
            return null;
        }
        try {
            Class.forName(className, true, Utilities.getSessionSpecifiedClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException("Cannot find class '" + className + "'", e);
        }
        return className;
    }

    public static boolean containsTokenOfType(ASTNode root, Integer ... tokens) {
        final HashSet<Integer> tokensToMatch = new HashSet<Integer>();
        for (Integer tokenTypeToMatch : tokens) {
            tokensToMatch.add(tokenTypeToMatch);
        }
        return ParseUtils.containsTokenOfType(root, new PTFUtils.Predicate<ASTNode>(){

            @Override
            public boolean apply(ASTNode node) {
                return tokensToMatch.contains(node.getType());
            }
        });
    }

    public static boolean containsTokenOfType(ASTNode root, PTFUtils.Predicate<ASTNode> predicate) {
        ArrayDeque<ASTNode> queue = new ArrayDeque<ASTNode>();
        queue.add(root);
        while (!queue.isEmpty()) {
            ASTNode current = (ASTNode)queue.remove();
            if (predicate.apply(current)) {
                return true;
            }
            if (current.getChildCount() <= 0) continue;
            for (Node child : current.getChildren()) {
                queue.add((ASTNode)child);
            }
        }
        return false;
    }

    public static boolean sameTree(ASTNode node, ASTNode otherNode) {
        if (node == null && otherNode == null) {
            return true;
        }
        if (node == null && otherNode != null || node != null && otherNode == null) {
            return false;
        }
        Stack<ASTNode> stack = new Stack<ASTNode>();
        stack.push(node);
        Stack<ASTNode> otherStack = new Stack<ASTNode>();
        otherStack.push(otherNode);
        while (!stack.empty() && !otherStack.empty()) {
            Tree p = (Tree)stack.pop();
            Tree otherP = (Tree)otherStack.pop();
            if (p.isNil() != otherP.isNil()) {
                return false;
            }
            if (!p.isNil() && !p.toString().equals(otherP.toString())) {
                return false;
            }
            if (p.getChildCount() != otherP.getChildCount()) {
                return false;
            }
            for (int i = p.getChildCount() - 1; i >= 0; --i) {
                Tree t = p.getChild(i);
                stack.push((ASTNode)t);
                Tree otherT = otherP.getChild(i);
                otherStack.push((ASTNode)otherT);
            }
        }
        return stack.empty() && otherStack.empty();
    }

    private static void handleSetColRefs(ASTNode tree) {
        CalcitePlanner.ASTSearcher astSearcher = new CalcitePlanner.ASTSearcher();
        while (true) {
            astSearcher.reset();
            ASTNode setCols = astSearcher.depthFirstSearch(tree, 907);
            if (setCols == null) break;
            ParseUtils.processSetColsNode(setCols, astSearcher);
        }
    }

    private static void processSetColsNode(ASTNode setCols, CalcitePlanner.ASTSearcher searcher) {
        ASTNode select;
        Tree child;
        Tree fromWhat;
        searcher.reset();
        ASTNode rootNode = setCols;
        while (rootNode != null && rootNode.getType() != 783) {
            rootNode = rootNode.parent;
        }
        if (rootNode == null || rootNode.parent == null) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the root INSERT");
            setCols.token.setType(651);
            return;
        }
        rootNode = rootNode.parent;
        Tree fromNode = null;
        for (int j = 0; j < rootNode.getChildCount(); ++j) {
            Tree child2 = rootNode.getChild(j);
            if (child2.getType() != 762) continue;
            fromNode = child2;
            break;
        }
        if (!(fromNode instanceof ASTNode)) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the FROM");
            setCols.token.setType(651);
            return;
        }
        String alias = null;
        if (fromNode.getChildCount() > 0 && (fromWhat = fromNode.getChild(0)).getType() == 942 && fromWhat.getChildCount() > 1 && (child = fromWhat.getChild(fromWhat.getChildCount() - 1)).getType() == 24) {
            alias = child.getText();
        }
        if ((select = searcher.simpleBreadthFirstSearchAny((ASTNode)fromNode, 900, 901)) == null) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the SELECT");
            setCols.token.setType(651);
            return;
        }
        while (true) {
            CommonTree queryOfSelect = select.parent;
            while (queryOfSelect != null && queryOfSelect.getType() != 877) {
                queryOfSelect = queryOfSelect.parent;
            }
            if (queryOfSelect == null || queryOfSelect.parent == null) {
                LOG.debug("Replacing SETCOLREF with ALLCOLREF because we couldn't find the QUERY");
                setCols.token.setType(651);
                return;
            }
            if (queryOfSelect.childIndex == 0) break;
            Tree moreToTheLeft = queryOfSelect.parent.getChild(0);
            Preconditions.checkState((moreToTheLeft != queryOfSelect ? 1 : 0) != 0);
            ASTNode newSelect = searcher.simpleBreadthFirstSearchAny((ASTNode)moreToTheLeft, 900, 901);
            Preconditions.checkState((newSelect != select ? 1 : 0) != 0);
            select = newSelect;
        }
        ArrayList<ASTNode> newChildren = new ArrayList<ASTNode>(select.getChildCount());
        HashSet<String> aliases = new HashSet<String>();
        block11: for (int i = 0; i < select.getChildCount(); ++i) {
            Tree selExpr = select.getChild(i);
            assert (selExpr.getType() == 902);
            assert (selExpr.getChildCount() > 0);
            Tree child3 = selExpr.getChild(selExpr.getChildCount() - 1);
            switch (child3.getType()) {
                case 907: {
                    ParseUtils.processSetColsNode((ASTNode)child3, searcher);
                    ParseUtils.processSetColsNode(setCols, searcher);
                    return;
                }
                case 651: {
                    LOG.debug("Replacing SETCOLREF with ALLCOLREF because of nested ALLCOLREF");
                    setCols.token.setType(651);
                    return;
                }
                case 974: {
                    Tree idChild = child3.getChild(0);
                    assert (idChild.getType() == 24) : idChild;
                    if (ParseUtils.createChildColumnRef(idChild, alias, newChildren, aliases)) continue block11;
                    setCols.token.setType(651);
                    return;
                }
                case 24: {
                    if (ParseUtils.createChildColumnRef(child3, alias, newChildren, aliases)) continue block11;
                    setCols.token.setType(651);
                    return;
                }
                case 16: {
                    Tree colChild = child3.getChild(child3.getChildCount() - 1);
                    assert (colChild.getType() == 24) : colChild;
                    if (ParseUtils.createChildColumnRef(colChild, alias, newChildren, aliases)) continue block11;
                    setCols.token.setType(651);
                    return;
                }
                default: {
                    LOG.debug("Replacing SETCOLREF with ALLCOLREF because of the nested node " + child3.getType() + " " + child3.getText());
                    setCols.token.setType(651);
                    return;
                }
            }
        }
        ASTNode parent = (ASTNode)setCols.parent.parent;
        int t = parent.getType();
        assert (t == 900 || t == 901) : t;
        int ix = setCols.parent.childIndex;
        parent.deleteChild(ix);
        for (ASTNode node : newChildren) {
            parent.insertChild(ix++, node);
        }
    }

    private static boolean createChildColumnRef(Tree child, String alias, List<ASTNode> newChildren, HashSet<String> aliases) {
        String colAlias = child.getText();
        if (!aliases.add(colAlias)) {
            LOG.debug("Replacing SETCOLREF with ALLCOLREF because of duplicate alias " + colAlias);
            return false;
        }
        ASTBuilder selExpr = ASTBuilder.construct(902, "TOK_SELEXPR");
        ASTBuilder toc = ASTBuilder.construct(974, "TOK_TABLE_OR_COL");
        ASTBuilder id = ASTBuilder.construct(24, colAlias);
        if (alias == null) {
            selExpr = selExpr.add(toc.add(id));
        } else {
            ASTBuilder dot = ASTBuilder.construct(16, ".");
            ASTBuilder aliasNode = ASTBuilder.construct(24, alias);
            selExpr = selExpr.add(dot.add(toc.add(aliasNode)).add(id));
        }
        newChildren.add(selExpr.node());
        return true;
    }
}

