/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptMaterializations;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.MaterializedViewSubstitutionVisitor;

public class HiveMaterializedViewFilterScanRule
extends RelOptRule {
    public static final HiveMaterializedViewFilterScanRule INSTANCE = new HiveMaterializedViewFilterScanRule(HiveRelFactories.HIVE_BUILDER);

    protected HiveMaterializedViewFilterScanRule(RelBuilderFactory relBuilderFactory) {
        super(HiveMaterializedViewFilterScanRule.operand(Project.class, (RelOptRuleOperand)HiveMaterializedViewFilterScanRule.operand(Filter.class, (RelOptRuleOperand)HiveMaterializedViewFilterScanRule.operand(TableScan.class, null, (RelOptRuleOperandChildren)HiveMaterializedViewFilterScanRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "MaterializedViewFilterScanRule");
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        Filter filter = (Filter)call.rel(1);
        TableScan scan = (TableScan)call.rel(2);
        this.apply(call, project, filter, scan);
    }

    protected void apply(RelOptRuleCall call, Project project, Filter filter, TableScan scan) {
        ImmutableList materializations;
        RelOptPlanner planner = call.getPlanner();
        ImmutableList immutableList = materializations = planner instanceof VolcanoPlanner ? ((VolcanoPlanner)planner).getMaterializations() : ImmutableList.of();
        if (!materializations.isEmpty()) {
            RelNode root = project.copy(project.getTraitSet(), Collections.singletonList(filter.copy(filter.getTraitSet(), Collections.singletonList(scan))));
            List applicableMaterializations = RelOptMaterializations.getApplicableMaterializations((RelNode)root, (List)materializations);
            for (RelOptMaterialization materialization : applicableMaterializations) {
                List<RelNode> subs = new MaterializedViewSubstitutionVisitor(materialization.queryRel, root, this.relBuilderFactory).go(materialization.tableRel);
                for (RelNode s : subs) {
                    call.transformTo(s);
                }
            }
        }
    }
}

