/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.ListSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.io.ContentSummaryInputFormat;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.InputEstimator;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.SplitSample;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.ListSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToBinary;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUtcTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFetchOptimizer
extends Transform {
    private final Logger LOG = LoggerFactory.getLogger((String)SimpleFetchOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        HashMap<String, TableScanOperator> topOps = pctx.getTopOps();
        if (pctx.getQueryProperties().isQuery() && !pctx.getQueryProperties().isAnalyzeCommand() && topOps.size() == 1) {
            String alias = (String)pctx.getTopOps().keySet().toArray()[0];
            TableScanOperator topOp = pctx.getTopOps().values().iterator().next();
            try {
                FetchTask fetchTask = this.optimize(pctx, alias, topOp);
                if (fetchTask != null) {
                    pctx.setFetchTask(fetchTask);
                }
            }
            catch (Exception e) {
                this.LOG.error(StringUtils.stringifyException((Throwable)e));
                if (e instanceof SemanticException) {
                    throw (SemanticException)e;
                }
                throw new SemanticException(e.getMessage(), e);
            }
        }
        return pctx;
    }

    private FetchTask optimize(ParseContext pctx, String alias, TableScanOperator source) throws Exception {
        String mode = HiveConf.getVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEFETCHTASKCONVERSION);
        boolean aggressive = "more".equals(mode);
        int limit = pctx.getQueryProperties().getOuterQueryLimit();
        if (limit == 0) {
            return null;
        }
        FetchData fetch = this.checkTree(aggressive, pctx, alias, source);
        if (fetch != null && this.checkThreshold(fetch, limit, pctx)) {
            FetchWork fetchWork = fetch.convertToWork();
            FetchTask fetchTask = (FetchTask)TaskFactory.get(fetchWork, pctx.getConf(), new Task[0]);
            fetchWork.setSink(fetch.completed(pctx, fetchWork));
            fetchWork.setSource(source);
            fetchWork.setLimit(limit);
            return fetchTask;
        }
        return null;
    }

    private boolean checkThreshold(FetchData data, int limit, ParseContext pctx) throws Exception {
        long threshold;
        if (limit > 0) {
            if (data.hasOnlyPruningFilter()) {
                return true;
            }
            if (!data.isPartitioned() && !data.isFiltered()) {
                return true;
            }
        }
        if ((threshold = HiveConf.getLongVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEFETCHTASKCONVERSIONTHRESHOLD)) < 0L) {
            return true;
        }
        Operator<OperatorDesc> child = data.scanOp.getChildOperators().get(0);
        if (child instanceof SelectOperator && this.checkExpressions((SelectOperator)child)) {
            return true;
        }
        return data.isDataLengthWithInThreshold(pctx, threshold);
    }

    private FetchData checkTree(boolean aggressive, ParseContext pctx, String alias, TableScanOperator ts) throws HiveException {
        ExprNodeDesc pruner;
        SplitSample splitSample = pctx.getNameToSplitSample().get(alias);
        if (!aggressive && splitSample != null) {
            return null;
        }
        if (!aggressive && ((TableScanDesc)ts.getConf()).getTableSample() != null) {
            return null;
        }
        Table table = ((TableScanDesc)ts.getConf()).getTableMetadata();
        if (table == null) {
            return null;
        }
        ReadEntity parent = PlanUtils.getParentViewInfo(alias, pctx.getViewAliasToInput());
        if (!table.isPartitioned()) {
            FetchData fetch = new FetchData(ts, parent, table, splitSample);
            return this.checkOperators(fetch, aggressive, false);
        }
        boolean bypassFilter = false;
        if (HiveConf.getBoolVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEOPTPPD) && PartitionPruner.onlyContainsPartnCols(table, pruner = pctx.getOpToPartPruner().get(ts))) {
            bypassFilter = !pctx.getPrunedPartitions(alias, ts).hasUnknownPartitions();
        }
        boolean onlyPruningFilter = bypassFilter;
        Operator op = ts;
        while (onlyPruningFilter && !(op instanceof FileSinkOperator) && op.getChildOperators() != null) {
            ExprNodeDesc predicate;
            if (op.getChildOperators().size() != 1) {
                onlyPruningFilter = false;
                break;
            }
            if (!((op = op.getChildOperators().get(0)) instanceof FilterOperator) || (predicate = ((FilterDesc)((FilterOperator)op).getConf()).getPredicate()) instanceof ExprNodeConstantDesc && "boolean".equals(predicate.getTypeInfo().getTypeName()) || PartitionPruner.onlyContainsPartnCols(table, predicate)) continue;
            onlyPruningFilter = false;
        }
        if (!aggressive && !onlyPruningFilter) {
            return null;
        }
        PrunedPartitionList partitions = pctx.getPrunedPartitions(alias, ts);
        FetchData fetch = new FetchData(ts, parent, table, partitions, splitSample, onlyPruningFilter);
        return this.checkOperators(fetch, aggressive, bypassFilter);
    }

    private FetchData checkOperators(FetchData fetch, boolean aggressive, boolean bypassFilter) {
        if (aggressive) {
            return this.isConvertible(fetch) ? fetch : null;
        }
        return this.checkOperators(fetch, fetch.scanOp, bypassFilter);
    }

    private FetchData checkOperators(FetchData fetch, TableScanOperator ts, boolean bypassFilter) {
        if (ts.getChildOperators().size() != 1) {
            return null;
        }
        Operator<OperatorDesc> op = ts.getChildOperators().get(0);
        while (true) {
            if (op instanceof SelectOperator) {
                if (!this.checkExpressions((SelectOperator)op)) {
                    return null;
                }
            } else {
                if (!(op instanceof LimitOperator) && (!(op instanceof FilterOperator) || !bypassFilter)) break;
                if (op.getChildOperators() == null || op.getChildOperators().size() != 1) {
                    return null;
                }
                if (op instanceof FilterOperator) {
                    fetch.setFiltered(true);
                }
            }
            op = op.getChildOperators().get(0);
        }
        if (op instanceof FileSinkOperator) {
            fetch.fileSink = op;
            return fetch;
        }
        return null;
    }

    private boolean checkExpressions(SelectOperator op) {
        SelectDesc desc = (SelectDesc)op.getConf();
        if (desc.isSelectStar() || desc.isSelStarNoCompute()) {
            return true;
        }
        for (ExprNodeDesc expr : desc.getColList()) {
            if (this.checkExpression(expr)) continue;
            return false;
        }
        return true;
    }

    private boolean checkExpression(ExprNodeDesc expr) {
        GenericUDF udf;
        if (expr instanceof ExprNodeConstantDesc || expr instanceof ExprNodeColumnDesc) {
            return true;
        }
        if (expr instanceof ExprNodeGenericFuncDesc && ((udf = ((ExprNodeGenericFuncDesc)expr).getGenericUDF()) instanceof GenericUDFToBinary || udf instanceof GenericUDFToChar || udf instanceof GenericUDFToDate || udf instanceof GenericUDFToDecimal || udf instanceof GenericUDFToUnixTimeStamp || udf instanceof GenericUDFToUtcTimestamp || udf instanceof GenericUDFToVarchar)) {
            return expr.getChildren().size() == 1 && this.checkExpression(expr.getChildren().get(0));
        }
        return false;
    }

    private boolean isConvertible(FetchData fetch) {
        return this.isConvertible(fetch, fetch.scanOp, new HashSet());
    }

    private boolean isConvertible(FetchData fetch, Operator<?> operator, Set<Operator<?>> traversed) {
        if (operator instanceof ReduceSinkOperator || operator instanceof CommonJoinOperator || operator instanceof ScriptOperator) {
            return false;
        }
        if (operator instanceof FilterOperator) {
            fetch.setFiltered(true);
        }
        if (!traversed.add(operator)) {
            return true;
        }
        if (operator.getNumChild() == 0) {
            if (operator instanceof FileSinkOperator) {
                fetch.fileSink = operator;
                return true;
            }
            return false;
        }
        for (Operator<OperatorDesc> child : operator.getChildOperators()) {
            if (!traversed.containsAll(child.getParentOperators()) || this.isConvertible(fetch, child, traversed)) continue;
            return false;
        }
        return true;
    }

    public static ListSinkOperator replaceFSwithLS(Operator<?> fileSink, String nullFormat) {
        ListSinkDesc desc = new ListSinkDesc(nullFormat);
        ListSinkOperator sink = (ListSinkOperator)OperatorFactory.get(fileSink.getCompilationOpContext(), desc);
        sink.setParentOperators(new ArrayList<Operator<? extends OperatorDesc>>());
        Operator<OperatorDesc> parent = fileSink.getParentOperators().get(0);
        sink.getParentOperators().add(parent);
        parent.replaceChild(fileSink, sink);
        fileSink.setParentOperators(null);
        return sink;
    }

    private class FetchData {
        private final TableScanOperator scanOp;
        private final ReadEntity parent;
        private final Table table;
        private final SplitSample splitSample;
        private final PrunedPartitionList partsList;
        private final Set<ReadEntity> inputs = new LinkedHashSet<ReadEntity>();
        private final boolean onlyPruningFilter;
        private Operator<?> fileSink;
        private boolean filtered;

        private FetchData(TableScanOperator scanOp, ReadEntity parent, Table table, SplitSample splitSample) {
            this.scanOp = scanOp;
            this.parent = parent;
            this.table = table;
            this.partsList = null;
            this.splitSample = splitSample;
            this.onlyPruningFilter = false;
        }

        private FetchData(TableScanOperator scanOp, ReadEntity parent, Table table, PrunedPartitionList partsList, SplitSample splitSample, boolean bypassFilter) {
            this.scanOp = scanOp;
            this.parent = parent;
            this.table = table;
            this.partsList = partsList;
            this.splitSample = splitSample;
            this.onlyPruningFilter = bypassFilter;
        }

        public final boolean hasOnlyPruningFilter() {
            return this.onlyPruningFilter;
        }

        public final boolean isPartitioned() {
            return this.table.isPartitioned();
        }

        public final boolean isFiltered() {
            return this.filtered;
        }

        public final void setFiltered(boolean filtered) {
            this.filtered = filtered;
        }

        private FetchWork convertToWork() throws HiveException {
            this.inputs.clear();
            Utilities.addSchemaEvolutionToTableScanOperator(this.table, this.scanOp);
            TableDesc tableDesc = Utilities.getTableDesc(this.table);
            if (!this.table.isPartitioned()) {
                this.inputs.add(new ReadEntity(this.table, this.parent, !this.table.isView() && this.parent == null));
                FetchWork work = new FetchWork(this.table.getPath(), tableDesc);
                PlanUtils.configureInputJobPropertiesForStorageHandler(work.getTblDesc());
                work.setSplitSample(this.splitSample);
                return work;
            }
            ArrayList<Path> listP = new ArrayList<Path>();
            ArrayList<PartitionDesc> partP = new ArrayList<PartitionDesc>();
            for (Partition partition : this.partsList.getNotDeniedPartns()) {
                this.inputs.add(new ReadEntity(partition, this.parent, this.parent == null));
                listP.add(partition.getDataLocation());
                partP.add(Utilities.getPartitionDescFromTableDesc(tableDesc, partition, true));
            }
            Table sourceTable = this.partsList.getSourceTable();
            this.inputs.add(new ReadEntity(sourceTable, this.parent, this.parent == null));
            TableDesc table = Utilities.getTableDesc(sourceTable);
            FetchWork work = new FetchWork(listP, partP, table);
            if (!work.getPartDesc().isEmpty()) {
                PartitionDesc part0 = work.getPartDesc().get(0);
                PlanUtils.configureInputJobPropertiesForStorageHandler(part0.getTableDesc());
                work.setSplitSample(this.splitSample);
            }
            return work;
        }

        private ListSinkOperator completed(ParseContext pctx, FetchWork work) {
            for (ReadEntity input : this.inputs) {
                PlanUtils.addInput(pctx.getSemanticInputs(), input);
            }
            return SimpleFetchOptimizer.replaceFSwithLS(this.fileSink, work.getSerializationNullFormat());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isDataLengthWithInThreshold(ParseContext pctx, final long threshold) throws Exception {
            if (this.splitSample != null && this.splitSample.getTotalLength() != null) {
                if (SimpleFetchOptimizer.this.LOG.isDebugEnabled()) {
                    SimpleFetchOptimizer.this.LOG.debug("Threshold " + this.splitSample.getTotalLength() + " exceeded for pseudoMR mode");
                }
                return threshold - this.splitSample.getTotalLength() > 0L;
            }
            Status status = this.checkThresholdWithMetastoreStats(this.table, this.partsList, threshold);
            if (status.equals((Object)Status.PASS)) {
                return true;
            }
            if (status.equals((Object)Status.FAIL)) {
                return false;
            }
            SimpleFetchOptimizer.this.LOG.info("Cannot fetch stats from metastore for table: {}. Falling back to filesystem scan..", (Object)this.table.getCompleteName());
            final JobConf jobConf = new JobConf((Configuration)pctx.getConf());
            Utilities.setColumnNameList(jobConf, this.scanOp, true);
            Utilities.setColumnTypeList(jobConf, this.scanOp, true);
            HiveStorageHandler handler = this.table.getStorageHandler();
            if (handler instanceof InputEstimator) {
                InputEstimator estimator = (InputEstimator)((Object)handler);
                TableDesc tableDesc = Utilities.getTableDesc(this.table);
                PlanUtils.configureInputJobPropertiesForStorageHandler(tableDesc);
                Utilities.copyTableJobPropertiesToConf(tableDesc, (Configuration)jobConf);
                long len = estimator.estimate(jobConf, this.scanOp, threshold).getTotalLength();
                if (SimpleFetchOptimizer.this.LOG.isDebugEnabled()) {
                    SimpleFetchOptimizer.this.LOG.debug("Threshold " + len + " exceeded for pseudoMR mode");
                }
                return threshold - len > 0L;
            }
            if (this.table.isNonNative()) {
                return true;
            }
            if (!this.table.isPartitioned()) {
                long len = this.getPathLength(jobConf, this.table.getPath(), this.table.getInputFormatClass(), threshold);
                if (SimpleFetchOptimizer.this.LOG.isDebugEnabled()) {
                    SimpleFetchOptimizer.this.LOG.debug("Threshold " + len + " exceeded for pseudoMR mode");
                }
                return threshold - len > 0L;
            }
            final AtomicLong total = new AtomicLong(0L);
            int threadCount = HiveConf.getIntVar((Configuration)pctx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_GATHER_NUM_THREADS);
            ExecutorService pool = threadCount > 0 ? Executors.newFixedThreadPool(threadCount, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("SimpleFetchOptimizer-FileLength-%d").build()) : null;
            try {
                LinkedList futures = Lists.newLinkedList();
                for (final Partition partition : this.partsList.getNotDeniedPartns()) {
                    final Path path = partition.getDataLocation();
                    if (pool != null) {
                        futures.add(pool.submit(new Callable<Long>(){

                            @Override
                            public Long call() throws Exception {
                                long len = FetchData.this.getPathLength(jobConf, path, partition.getInputFormatClass(), threshold);
                                SimpleFetchOptimizer.this.LOG.trace(path + ", length=" + len);
                                return total.addAndGet(len);
                            }
                        }));
                        continue;
                    }
                    total.addAndGet(this.getPathLength(jobConf, path, partition.getInputFormatClass(), threshold));
                }
                if (pool != null) {
                    pool.shutdown();
                    for (Future future : futures) {
                        long totalLen = (Long)future.get();
                        if (threshold - totalLen > 0L) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = threshold - total.get() >= 0L;
                return bl;
            }
            finally {
                SimpleFetchOptimizer.this.LOG.info("Data set size=" + total.get() + ", threshold=" + threshold);
                if (pool != null) {
                    pool.shutdownNow();
                }
            }
        }

        private Status checkThresholdWithMetastoreStats(Table table, PrunedPartitionList partsList, long threshold) {
            if (table != null && !table.isPartitioned()) {
                long dataSize = StatsUtils.getTotalSize(table);
                if (dataSize <= 0L) {
                    SimpleFetchOptimizer.this.LOG.warn("Cannot determine basic stats for table: {} from metastore. Falling back.", (Object)table.getCompleteName());
                    return Status.UNAVAILABLE;
                }
                return threshold - dataSize >= 0L ? Status.PASS : Status.FAIL;
            }
            if (table != null && table.isPartitioned() && partsList != null) {
                List<Long> dataSizes = StatsUtils.getBasicStatForPartitions(table, partsList.getNotDeniedPartns(), "totalSize");
                long totalDataSize = StatsUtils.getSumIgnoreNegatives(dataSizes);
                if (totalDataSize <= 0L) {
                    SimpleFetchOptimizer.this.LOG.warn("Cannot determine basic stats for partitioned table: {} from metastore. Falling back.", (Object)table.getCompleteName());
                    return Status.UNAVAILABLE;
                }
                return threshold - totalDataSize >= 0L ? Status.PASS : Status.FAIL;
            }
            return Status.UNAVAILABLE;
        }

        private long getPathLength(JobConf conf, Path path, Class<? extends InputFormat> clazz, long threshold) throws IOException {
            if (ContentSummaryInputFormat.class.isAssignableFrom(clazz)) {
                InputFormat<WritableComparable, Writable> input = HiveInputFormat.getInputFormatFromCache(clazz, conf);
                return ((ContentSummaryInputFormat)input).getContentSummary(path, conf).getLength();
            }
            FileSystem fs = path.getFileSystem((Configuration)conf);
            try {
                long length;
                RemoteIterator results = fs.listFiles(path, true);
                for (length = 0L; length <= threshold && results.hasNext(); length += ((LocatedFileStatus)results.next()).getLen()) {
                }
                SimpleFetchOptimizer.this.LOG.trace("length=" + length + ", threshold=" + threshold);
                return length;
            }
            catch (FileNotFoundException e) {
                return 0L;
            }
        }
    }

    static enum Status {
        PASS,
        FAIL,
        UNAVAILABLE;

    }
}

