/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hive.metastore.api.SQLPrimaryKey;
import org.apache.hadoop.hive.ql.metadata.ConstraintStat;

public class PrimaryKeyInfo
implements Serializable {
    Map<Integer, String> colNames;
    String constraintName;
    String tableName;
    String databaseName;
    ConstraintStat stat;

    public PrimaryKeyInfo() {
    }

    public PrimaryKeyInfo(List<SQLPrimaryKey> pks, String tableName, String databaseName) {
        this.tableName = tableName;
        this.databaseName = databaseName;
        this.colNames = new TreeMap<Integer, String>();
        if (pks == null) {
            return;
        }
        boolean enable = false;
        boolean validate = false;
        boolean rely = false;
        for (SQLPrimaryKey pk : pks) {
            if (!pk.getTable_db().equalsIgnoreCase(databaseName) || !pk.getTable_name().equalsIgnoreCase(tableName)) continue;
            this.colNames.put(pk.getKey_seq(), pk.getColumn_name());
            this.constraintName = pk.getPk_name();
            enable = pk.isEnable_cstr();
            validate = pk.isValidate_cstr();
            rely = pk.isRely_cstr();
        }
        this.stat = new ConstraintStat(enable, validate, rely);
    }

    public ConstraintStat getStat() {
        return this.stat;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public Map<Integer, String> getColNames() {
        return this.colNames;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public void setColNames(Map<Integer, String> colNames) {
        this.colNames = colNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Primary Key for " + this.databaseName + "." + this.tableName + ":");
        sb.append("[");
        if (this.colNames != null && this.colNames.size() > 0) {
            for (Map.Entry<Integer, String> me : this.colNames.entrySet()) {
                sb.append(me.getValue() + ",");
            }
            sb.setLength(sb.length() - 1);
        }
        sb.append("], Constraint Name: " + this.constraintName);
        return sb.toString();
    }
}

