/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedInputFormatInterface;
import org.apache.hadoop.hive.ql.io.parquet.VectorizedParquetInputFormat;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.read.ParquetRecordReaderWrapper;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapredParquetInputFormat
extends FileInputFormat<NullWritable, ArrayWritable>
implements VectorizedInputFormatInterface {
    private static final Logger LOG = LoggerFactory.getLogger(MapredParquetInputFormat.class);
    private ParquetInputFormat<ArrayWritable> realInput;
    private final ParquetInputFormat<ArrayWritable> fallbackRealInput;
    private transient VectorizedParquetInputFormat vectorizedSelf;
    private final transient VectorizedParquetInputFormat fallbackVectorizedSelf;

    public MapredParquetInputFormat() {
        this((ParquetInputFormat<ArrayWritable>)new ParquetInputFormat(DataWritableReadSupport.class));
    }

    protected MapredParquetInputFormat(ParquetInputFormat<ArrayWritable> inputFormat) {
        try {
            this.realInput = (ParquetInputFormat)Class.forName("com.aliyun.emr.table.hive.acc.JindoSimpleParquetInputFormat").newInstance();
            this.vectorizedSelf = (VectorizedParquetInputFormat)((Object)Class.forName("com.aliyun.emr.table.hive.acc.JindoVectorizedParquetInputFormat").newInstance());
        }
        catch (Exception e) {
            this.realInput = null;
            this.vectorizedSelf = null;
        }
        this.fallbackRealInput = inputFormat;
        this.fallbackVectorizedSelf = new VectorizedParquetInputFormat();
        LOG.info("Construct MapredParquetInputFormat2");
    }

    public RecordReader<NullWritable, ArrayWritable> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        try {
            if (job.getBoolean(HiveConf.ConfVars.JINDOTABLE_NATIVE.varname, false) && this.jindoSupport(split, job)) {
                LOG.info("Jindotable acc loaded");
                if (Utilities.getUseVectorizedInputFileFormat((Configuration)job) && this.vectorizedSelf != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using vectorized record reader");
                    }
                    LOG.info("JindoParquetInputFormat getRecordReader vectorized");
                    return this.vectorizedSelf.getRecordReader(split, job, reporter);
                }
                if (!Utilities.getUseVectorizedInputFileFormat((Configuration)job) && this.realInput != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Using row-mode record reader");
                    }
                    LOG.info("JindoParquetInputFormat getRecordReader non-vectorized");
                    return new ParquetRecordReaderWrapper(this.realInput, split, job, reporter);
                }
            }
            LOG.info("Jindotable fallback to stock parquet reader.");
            if (Utilities.getUseVectorizedInputFileFormat((Configuration)job)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using vectorized record reader");
                }
                LOG.info("MapredParquetInputFormat getRecordReader vectorized");
                return this.fallbackVectorizedSelf.getRecordReader(split, job, reporter);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using row-mode record reader");
            }
            LOG.info("MapredParquetInputFormat getRecordReader non-vectorized");
            return new ParquetRecordReaderWrapper(this.fallbackRealInput, split, job, reporter);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Cannot create a RecordReaderWrapper", e);
        }
    }

    private boolean jindoSupport(InputSplit split, JobConf job) throws IOException {
        Path file = null;
        if (split instanceof org.apache.hadoop.mapred.FileSplit) {
            file = ((org.apache.hadoop.mapred.FileSplit)split).getPath();
        } else if (split instanceof FileSplit) {
            file = ((FileSplit)split).getPath();
        }
        return file != null && file.getFileSystem((Configuration)job).getClass().getName().contains("Jindo");
    }
}

