/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.login.LoginException;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.coordinator.LlapCoordinator;
import org.apache.hadoop.hive.llap.impl.LlapProtocolClientImpl;
import org.apache.hadoop.hive.llap.security.LlapTokenClient;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.tez.LlapProtocolClientProxy;
import org.apache.hadoop.hive.llap.tezplugins.LlapContainerLauncher;
import org.apache.hadoop.hive.llap.tezplugins.LlapTaskCommunicator;
import org.apache.hadoop.hive.llap.tezplugins.LlapTaskSchedulerService;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.DagUtils;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezJobMonitor;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.tez.client.TezClient;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.PreWarmVertex;
import org.apache.tez.dag.api.SessionNotRunning;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.mapreduce.hadoop.MRHelpers;
import org.apache.tez.serviceplugins.api.ContainerLauncherDescriptor;
import org.apache.tez.serviceplugins.api.ServicePluginsDescriptor;
import org.apache.tez.serviceplugins.api.TaskCommunicatorDescriptor;
import org.apache.tez.serviceplugins.api.TaskSchedulerDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezSessionState {
    private static final Logger LOG = LoggerFactory.getLogger((String)TezSessionState.class.getName());
    private static final String TEZ_DIR = "_tez_session_dir";
    public static final String LLAP_SERVICE = "LLAP";
    private static final String LLAP_SCHEDULER = LlapTaskSchedulerService.class.getName();
    private static final String LLAP_LAUNCHER = LlapContainerLauncher.class.getName();
    private static final String LLAP_TASK_COMMUNICATOR = LlapTaskCommunicator.class.getName();
    private HiveConf conf;
    private Path tezScratchDir;
    private LocalResource appJarLr;
    private TezClient session;
    private Future<TezClient> sessionFuture;
    private SessionState.LogHelper console;
    private String sessionId;
    private final DagUtils utils;
    private String queueName;
    private boolean defaultQueue = false;
    private String user;
    private AtomicReference<String> ownerThread = new AtomicReference<Object>(null);
    private final Set<String> additionalFilesNotFromConf = new HashSet<String>();
    private final Set<LocalResource> localizedResources = new HashSet<LocalResource>();
    private boolean doAsEnabled;

    public TezSessionState(DagUtils utils) {
        this.utils = utils;
    }

    public String toString() {
        return "sessionId=" + this.sessionId + ", queueName=" + this.queueName + ", user=" + this.user + ", doAs=" + this.doAsEnabled + ", isOpen=" + this.isOpen() + ", isDefault=" + this.defaultQueue;
    }

    public TezSessionState(String sessionId) {
        this(DagUtils.getInstance());
        this.sessionId = sessionId;
    }

    public boolean isOpening() {
        if (this.session != null || this.sessionFuture == null) {
            return false;
        }
        try {
            this.session = this.sessionFuture.get(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException e) {
            return false;
        }
        catch (TimeoutException e) {
            return true;
        }
        return false;
    }

    public boolean isOpen() {
        if (this.session != null) {
            return true;
        }
        if (this.sessionFuture == null) {
            return false;
        }
        try {
            this.session = this.sessionFuture.get(0L, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (CancellationException | TimeoutException e) {
            return false;
        }
        return true;
    }

    public static String makeSessionId() {
        return UUID.randomUUID().toString();
    }

    public void open(HiveConf conf) throws IOException, LoginException, URISyntaxException, TezException {
        Collection<String> noFiles = null;
        this.open(conf, noFiles, null);
    }

    public void open(HiveConf conf, String[] additionalFiles) throws IOException, LoginException, IllegalArgumentException, URISyntaxException, TezException {
        this.openInternal(conf, TezSessionState.setFromArray(additionalFiles), false, null, null);
    }

    private static Set<String> setFromArray(String[] additionalFiles) {
        if (additionalFiles == null) {
            return null;
        }
        HashSet<String> files = new HashSet<String>();
        for (String originalFile : additionalFiles) {
            files.add(originalFile);
        }
        return files;
    }

    public void beginOpen(HiveConf conf, String[] additionalFiles, SessionState.LogHelper console) throws IOException, LoginException, IllegalArgumentException, URISyntaxException, TezException {
        this.openInternal(conf, TezSessionState.setFromArray(additionalFiles), true, console, null);
    }

    public void open(HiveConf conf, Collection<String> additionalFiles, Path scratchDir) throws LoginException, IOException, URISyntaxException, TezException {
        this.openInternal(conf, additionalFiles, false, null, scratchDir);
    }

    protected void openInternal(final HiveConf conf, Collection<String> additionalFiles, boolean isAsync, SessionState.LogHelper console, Path scratchDir) throws IOException, LoginException, IllegalArgumentException, URISyntaxException, TezException {
        ServicePluginsDescriptor servicePluginsDescriptor;
        this.conf = conf;
        String confQueueName = conf.get("tez.queue.name");
        if (this.queueName != null && !this.queueName.equals(confQueueName)) {
            LOG.warn("Resetting a queue name that was already set: was " + this.queueName + ", now " + confQueueName);
        }
        this.queueName = confQueueName;
        this.doAsEnabled = conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_ENABLE_DOAS);
        boolean llapMode = "llap".equalsIgnoreCase(HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_MODE));
        UserGroupInformation ugi = Utils.getUGI();
        this.user = ugi.getShortUserName();
        LOG.info("User of session id " + this.sessionId + " is " + this.user);
        this.tezScratchDir = scratchDir == null ? this.createTezDir(this.sessionId) : scratchDir;
        this.additionalFilesNotFromConf.clear();
        if (additionalFiles != null) {
            this.additionalFilesNotFromConf.addAll(additionalFiles);
        }
        this.refreshLocalResourcesFromConf(conf);
        this.appJarLr = this.createJarLocalResource(this.utils.getExecJarPathLocal());
        final HashMap<String, LocalResource> commonLocalResources = new HashMap<String, LocalResource>();
        commonLocalResources.put(this.utils.getBaseName(this.appJarLr), this.appJarLr);
        for (LocalResource lr : this.localizedResources) {
            commonLocalResources.put(this.utils.getBaseName(lr), lr);
        }
        if (llapMode) {
            this.addJarLRByClass(LlapTaskSchedulerService.class, commonLocalResources);
            this.addJarLRByClass(LlapProtocolClientImpl.class, commonLocalResources);
            this.addJarLRByClass(LlapProtocolClientProxy.class, commonLocalResources);
            this.addJarLRByClassName("org.apache.hadoop.registry.client.api.RegistryOperations", commonLocalResources);
        }
        HashMap amEnv = new HashMap();
        MRHelpers.updateEnvBasedOnMRAMEnv((Configuration)conf, amEnv);
        final TezConfiguration tezConfig = new TezConfiguration((Configuration)conf);
        tezConfig.set("tez.staging-dir", this.tezScratchDir.toUri().toString());
        conf.stripHiddenConfigurations((Configuration)tezConfig);
        Credentials llapCredentials = null;
        if (llapMode) {
            if (UserGroupInformation.isSecurityEnabled()) {
                llapCredentials = new Credentials();
                llapCredentials.addToken(LlapTokenIdentifier.KIND_NAME, TezSessionState.getLlapToken(this.user, (Configuration)tezConfig));
            }
            UserPayload servicePluginPayload = TezUtils.createUserPayloadFromConf((Configuration)tezConfig);
            servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)true, (TaskSchedulerDescriptor[])new TaskSchedulerDescriptor[]{(TaskSchedulerDescriptor)TaskSchedulerDescriptor.create((String)LLAP_SERVICE, (String)LLAP_SCHEDULER).setUserPayload(servicePluginPayload)}, (ContainerLauncherDescriptor[])new ContainerLauncherDescriptor[]{ContainerLauncherDescriptor.create((String)LLAP_SERVICE, (String)LLAP_LAUNCHER)}, (TaskCommunicatorDescriptor[])new TaskCommunicatorDescriptor[]{(TaskCommunicatorDescriptor)TaskCommunicatorDescriptor.create((String)LLAP_SERVICE, (String)LLAP_TASK_COMMUNICATOR).setUserPayload(servicePluginPayload)});
        } else {
            servicePluginsDescriptor = ServicePluginsDescriptor.create((boolean)true);
        }
        if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_ENABLED)) {
            int n = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS);
            n = Math.max(tezConfig.getInt("tez.am.session.min.held-containers", 0), n);
            tezConfig.setInt("tez.am.session.min.held-containers", n);
        }
        this.setupSessionAcls((Configuration)tezConfig, conf);
        String tezJobNameFormat = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZJOBNAME);
        final TezClient session = TezClient.newBuilder((String)String.format(tezJobNameFormat, this.sessionId), (TezConfiguration)tezConfig).setIsSession(true).setLocalResources(commonLocalResources).setCredentials(llapCredentials).setServicePluginDescriptor(servicePluginsDescriptor).build();
        LOG.info("Opening new Tez Session (id: " + this.sessionId + ", scratch dir: " + this.tezScratchDir + ")");
        TezJobMonitor.initShutdownHook();
        if (!isAsync) {
            this.startSessionAndContainers(session, conf, commonLocalResources, tezConfig, false);
            this.session = session;
        } else {
            FutureTask<TezClient> sessionFuture = new FutureTask<TezClient>(new Callable<TezClient>(){

                @Override
                public TezClient call() throws Exception {
                    try {
                        return TezSessionState.this.startSessionAndContainers(session, conf, commonLocalResources, tezConfig, true);
                    }
                    catch (Throwable t) {
                        LOG.error("Failed to start Tez session", t);
                        throw t instanceof Exception ? (Exception)t : new Exception(t);
                    }
                }
            });
            new Thread(sessionFuture, "Tez session start thread").start();
            this.console = console;
            this.sessionFuture = sessionFuture;
        }
    }

    private static Token<LlapTokenIdentifier> getLlapToken(String user, Configuration conf) throws IOException {
        SessionState session = SessionState.get();
        boolean isInHs2 = session != null && session.isHiveServerQuery();
        Token token = null;
        LlapCoordinator coordinator = null;
        if (isInHs2) {
            coordinator = LlapCoordinator.getInstance();
            if (coordinator == null) {
                throw new IOException("LLAP coordinator not initialized; cannot get LLAP tokens");
            }
            token = coordinator.getLocalTokenClient(conf, user).createToken(null, null, false);
        } else {
            token = new LlapTokenClient(conf).getDelegationToken(null);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("Obtained a LLAP token: " + token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TezClient startSessionAndContainers(TezClient session, HiveConf conf, Map<String, LocalResource> commonLocalResources, TezConfiguration tezConfig, boolean isOnThread) throws TezException, IOException {
        session.start();
        boolean isSuccessful = false;
        try {
            block10: {
                if (HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_ENABLED)) {
                    int n = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_PREWARM_NUM_CONTAINERS);
                    LOG.info("Prewarming " + n + " containers  (id: " + this.sessionId + ", scratch dir: " + this.tezScratchDir + ")");
                    PreWarmVertex prewarmVertex = this.utils.createPreWarmVertex(tezConfig, n, commonLocalResources);
                    try {
                        session.preWarm(prewarmVertex);
                    }
                    catch (IOException ie) {
                        if (!isOnThread && ie.getMessage().contains("Interrupted while waiting")) {
                            LOG.warn("Hive Prewarm threw an exception ", (Throwable)ie);
                        }
                        throw ie;
                    }
                }
                try {
                    session.waitTillReady();
                }
                catch (InterruptedException ie) {
                    if (!isOnThread) break block10;
                    throw new IOException(ie);
                }
            }
            isSuccessful = true;
            conf.unset("tez.queue.name");
            TezClient tezClient = session;
            return tezClient;
        }
        finally {
            if (isOnThread && !isSuccessful) {
                TezSessionState.closeAndIgnoreExceptions(session);
            }
        }
    }

    private static void closeAndIgnoreExceptions(TezClient session) {
        try {
            session.stop();
        }
        catch (SessionNotRunning sessionNotRunning) {
        }
        catch (IOException | TezException ex) {
            LOG.info("Failed to close Tez session after failure to initialize: " + ex.getMessage());
        }
    }

    public void endOpen() throws InterruptedException, CancellationException {
        if (this.session != null || this.sessionFuture == null) {
            return;
        }
        try {
            this.session = this.sessionFuture.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void setupSessionAcls(Configuration tezConf, HiveConf hiveConf) throws IOException {
        String user = SessionState.getUserFromAuthenticator();
        UserGroupInformation loginUserUgi = UserGroupInformation.getLoginUser();
        String loginUser = loginUserUgi == null ? null : loginUserUgi.getShortUserName();
        boolean addHs2User = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVETEZHS2USERACCESS);
        String viewStr = Utilities.getAclStringWithHiveModification(tezConf, "tez.am.view-acls", addHs2User, user, loginUser);
        String modifyStr = Utilities.getAclStringWithHiveModification(tezConf, "tez.am.modify-acls", addHs2User, user, loginUser);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting Tez Session access for sessionId={} with viewAclString={}, modifyStr={}", new Object[]{SessionState.get().getSessionId(), viewStr, modifyStr});
        }
        tezConf.set("tez.am.view-acls", viewStr);
        tezConf.set("tez.am.modify-acls", modifyStr);
    }

    public void refreshLocalResourcesFromConf(HiveConf conf) throws IOException, LoginException, IllegalArgumentException, URISyntaxException, TezException {
        List<LocalResource> handlerLr;
        String dir = this.tezScratchDir.toString();
        this.localizedResources.clear();
        List<LocalResource> lrs = this.utils.localizeTempFilesFromConf(dir, (Configuration)conf);
        if (lrs != null) {
            this.localizedResources.addAll(lrs);
        }
        if ((handlerLr = this.utils.localizeTempFiles(dir, (Configuration)conf, this.additionalFilesNotFromConf.toArray(new String[this.additionalFilesNotFromConf.size()]))) != null) {
            this.localizedResources.addAll(handlerLr);
        }
    }

    public boolean hasResources(String[] localAmResources) {
        if (localAmResources == null || localAmResources.length == 0) {
            return true;
        }
        if (this.additionalFilesNotFromConf.isEmpty()) {
            return false;
        }
        for (String s : localAmResources) {
            if (this.additionalFilesNotFromConf.contains(s)) continue;
            return false;
        }
        return true;
    }

    public void close(boolean keepTmpDir) throws Exception {
        if (this.session != null) {
            LOG.info("Closing Tez Session");
            this.closeClient(this.session);
        } else if (this.sessionFuture != null) {
            this.sessionFuture.cancel(true);
            TezClient asyncSession = null;
            try {
                asyncSession = this.sessionFuture.get();
            }
            catch (CancellationException | ExecutionException exception) {
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            if (asyncSession != null) {
                LOG.info("Closing Tez Session");
                this.closeClient(asyncSession);
            }
        }
        if (!keepTmpDir) {
            this.cleanupScratchDir();
        }
        this.session = null;
        this.sessionFuture = null;
        this.console = null;
        this.tezScratchDir = null;
        this.conf = null;
        this.appJarLr = null;
        this.additionalFilesNotFromConf.clear();
        this.localizedResources.clear();
    }

    public Set<String> getAdditionalFilesNotFromConf() {
        return this.additionalFilesNotFromConf;
    }

    private void closeClient(TezClient client) throws TezException, IOException {
        try {
            client.stop();
        }
        catch (SessionNotRunning sessionNotRunning) {
            // empty catch block
        }
    }

    public void cleanupScratchDir() throws IOException {
        FileSystem fs = this.tezScratchDir.getFileSystem((Configuration)this.conf);
        fs.delete(this.tezScratchDir, true);
        this.tezScratchDir = null;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public TezClient getSession() {
        if (this.session == null && this.sessionFuture != null) {
            if (!this.sessionFuture.isDone()) {
                this.console.printInfo("Waiting for Tez session and AM to be ready...");
            }
            try {
                this.session = this.sessionFuture.get();
            }
            catch (InterruptedException e) {
                this.console.printInfo("Interrupted while waiting for the session");
                Thread.currentThread().interrupt();
                return null;
            }
            catch (ExecutionException e) {
                this.console.printInfo("Failed to get session");
                throw new RuntimeException(e);
            }
            catch (CancellationException e) {
                this.console.printInfo("Cancelled while waiting for the session");
                return null;
            }
        }
        return this.session;
    }

    public Path getTezScratchDir() {
        return this.tezScratchDir;
    }

    public LocalResource getAppJarLr() {
        return this.appJarLr;
    }

    private Path createTezDir(String sessionId) throws IOException {
        Path tezDir = new Path(SessionState.get().getHdfsScratchDirURIString(), TEZ_DIR);
        tezDir = new Path(tezDir, sessionId);
        FileSystem fs = tezDir.getFileSystem((Configuration)this.conf);
        FsPermission fsPermission = new FsPermission(HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.SCRATCHDIRPERMISSION));
        fs.mkdirs(tezDir, fsPermission);
        tezDir = DagUtils.validateTargetDir(tezDir, (Configuration)this.conf).getPath();
        return tezDir;
    }

    private LocalResource createJarLocalResource(String localJarPath) throws IOException, LoginException, IllegalArgumentException, FileNotFoundException {
        FileStatus destDirStatus = this.utils.getHiveJarDirectory((Configuration)this.conf);
        assert (destDirStatus != null);
        Path destDirPath = destDirStatus.getPath();
        Path localFile = new Path(localJarPath);
        String sha = this.getSha(localFile);
        String destFileName = localFile.getName();
        destFileName = FilenameUtils.removeExtension((String)destFileName) + "-" + sha + '.' + FilenameUtils.getExtension((String)destFileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The destination file name for [" + localJarPath + "] is " + destFileName);
        }
        Path destFile = new Path(destDirPath.toString() + "/" + destFileName);
        return this.utils.localizeResource(localFile, destFile, LocalResourceType.FILE, (Configuration)this.conf);
    }

    private void addJarLRByClassName(String className, Map<String, LocalResource> lrMap) throws IOException, LoginException {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Cannot find " + className + " in classpath", e);
        }
        this.addJarLRByClass(clazz, lrMap);
    }

    private void addJarLRByClass(Class<?> clazz, Map<String, LocalResource> lrMap) throws IOException, LoginException {
        File jar = new File(Utilities.jarFinderGetJar(clazz));
        LocalResource jarLr = this.createJarLocalResource(jar.toURI().toURL().toExternalForm());
        lrMap.put(this.utils.getBaseName(jarLr), jarLr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSha(Path localFile) throws IOException, IllegalArgumentException {
        try (InputStream is = null;){
            LocalFileSystem localFs = FileSystem.getLocal((Configuration)this.conf);
            is = localFs.open(localFile);
            String string = DigestUtils.sha256Hex((InputStream)is);
            return string;
        }
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setDefault() {
        this.defaultQueue = true;
    }

    public boolean isDefault() {
        return this.defaultQueue;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public List<LocalResource> getLocalizedResources() {
        return new ArrayList<LocalResource>(this.localizedResources);
    }

    public String getUser() {
        return this.user;
    }

    public boolean getDoAsEnabled() {
        return this.doAsEnabled;
    }

    public void markFree() {
        if (this.ownerThread.getAndSet(null) == null) {
            throw new AssertionError((Object)"Not in use");
        }
    }

    public void markInUse() {
        String newName = Thread.currentThread().getName();
        do {
            String oldName;
            if ((oldName = this.ownerThread.get()) != null) {
                throw new AssertionError((Object)("Tez session is already in use from " + oldName + "; cannot use from " + newName));
            }
        } while (!this.ownerThread.compareAndSet(null, newName));
    }
}

