/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import apsara.odps.cupid.protocol.CupidTaskParamProtos;
import apsara.odps.cupid.protocol.YarnClientProtos;
import com.aliyun.odps.Instance;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.cupid.CupidConf;
import com.aliyun.odps.cupid.CupidSession;
import com.aliyun.odps.cupid.InstanceRecycledException;
import com.aliyun.odps.cupid.requestcupid.ApplicationMetaUtil;
import com.aliyun.odps.cupid.requestcupid.YarnClientImplUtil;
import com.aliyun.odps.cupid.utils.JTuple;
import com.aliyun.odps.request.cupid.CupidRequestProxy;
import com.aliyun.odps.request.cupid.CupidRequestType;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.client.YarnCupidUtil;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class YarnClientImpl
extends YarnClient {
    protected ApplicationClientProtocol rmClient;
    private static final Log LOG = LogFactory.getLog(YarnClientImpl.class);
    private CupidConf cupidConf = new CupidConf();
    private CupidSession cupidSession = null;
    private ConcurrentHashMap<String, CupidTaskParamProtos.ApplicationMeta> appMetaCache = null;
    private boolean updateAppMetaViaClient = false;

    public YarnClientImpl() {
        super(YarnClientImpl.class.getName());
    }

    public void init(Configuration conf) {
        this.init(conf, null);
    }

    @Override
    public void init(Configuration conf, CupidSession cupidSession) {
        super.init(conf);
        for (Map.Entry confItem : conf) {
            if (!((String)confItem.getKey()).startsWith("odps.") && !((String)confItem.getKey()).contains("com.aliyun.biz_id")) continue;
            this.cupidConf.set((String)confItem.getKey(), (String)confItem.getValue());
        }
        this.cupidSession = cupidSession == null ? new CupidSession(this.cupidConf) : cupidSession;
        CupidSession.setConf((CupidConf)this.cupidConf);
        this.appMetaCache = new ConcurrentHashMap();
        this.updateAppMetaViaClient = this.cupidConf.getBoolean("odps.cupid.client.meta.update", false);
    }

    private GetNewApplicationResponse getNewApplication() {
        YarnClientProtos.GetNewApplicationResponseProto getNewApplicationResponseProto = YarnClientImplUtil.getNewApplicationResponse();
        YarnClientProtos.ApplicationIdProto applicationIdProto = getNewApplicationResponseProto.getApplicationId();
        ApplicationId applicationId = ApplicationId.newInstance((long)applicationIdProto.getClusterTimestamp(), (int)applicationIdProto.getId());
        YarnClientProtos.ResourceProto resourceProto = getNewApplicationResponseProto.getMaximumCapability();
        Resource maxCapability = Resource.newInstance((int)resourceProto.getMemory(), (int)resourceProto.getVirtualCores());
        Resource minCapability = Resource.newInstance((int)0, (int)0);
        return GetNewApplicationResponse.newInstance((ApplicationId)applicationId, (Resource)minCapability, (Resource)maxCapability);
    }

    @Override
    public YarnClientApplication createApplication() throws YarnException, IOException {
        ApplicationSubmissionContext context = (ApplicationSubmissionContext)Records.newRecord(ApplicationSubmissionContext.class);
        GetNewApplicationResponse newApp = this.getNewApplication();
        ApplicationId appId = newApp.getApplicationId();
        context.setApplicationId(appId);
        return new YarnClientApplication(newApp, context);
    }

    private HashMap<String, String> getStartFuxiAMParam(ApplicationSubmissionContext appContext, CupidTaskParamProtos.OdpsLocalResource.Builder odpsLocalResourceBuilder) throws Exception {
        HashMap<String, String> startFuxiAMParamMap = new HashMap<String, String>();
        Resource resource = appContext.getResource();
        if (resource == null) {
            resource = appContext.getAMContainerResourceRequest().getCapability();
        }
        startFuxiAMParamMap.put("odps.moye.am.cores", String.valueOf(resource.getVirtualCores() * 100));
        startFuxiAMParamMap.put("odps.moye.am.memory", String.valueOf(resource.getMemory()));
        startFuxiAMParamMap.put("odps.cupid.applicationid", appContext.getApplicationId().toString());
        startFuxiAMParamMap.put("odps.cupid.applicationtags", StringUtils.join((CharSequence)",", (Iterable)appContext.getApplicationTags()));
        startFuxiAMParamMap.put("odps.cupid.applicationtype", appContext.getApplicationType());
        ContainerLaunchContext amContainerSpec = appContext.getAMContainerSpec();
        JTuple.JTuple2[] sessionConf = this.cupidSession.conf.getAll();
        for (JTuple.JTuple2 confEntry : sessionConf) {
            startFuxiAMParamMap.put((String)confEntry._1(), (String)confEntry._2());
        }
        YarnCupidUtil.transformTempResource(amContainerSpec);
        for (LocalResource localResource : amContainerSpec.getLocalResources().values()) {
            URL url = localResource.getResource();
            String scheme = url.getScheme();
            String path = url.getFile();
            CupidTaskParamProtos.OdpsLocalResourceItem.Builder odpsLocalResourceItemBuilder = CupidTaskParamProtos.OdpsLocalResourceItem.newBuilder();
            LOG.info((Object)("post: local resource scheme: " + scheme + ", path: " + path));
            if ("tempresource".equals(scheme)) {
                if ((path = path.substring(1)).startsWith("public-__spark_libs__") || path.startsWith("public-flink-dist_") || path.startsWith("public-blink-dist_") || path.startsWith("public-pyspark-") || path.startsWith("public-py4j-")) {
                    LOG.info((Object)("find public resource: " + path));
                    odpsLocalResourceItemBuilder.setProjectname("public");
                    odpsLocalResourceItemBuilder.setType(CupidTaskParamProtos.LocalResourceType.Resource);
                } else {
                    odpsLocalResourceItemBuilder.setType(CupidTaskParamProtos.LocalResourceType.TempResource);
                }
            } else {
                odpsLocalResourceItemBuilder.setType(CupidTaskParamProtos.LocalResourceType.Volume);
            }
            odpsLocalResourceItemBuilder.setRelativefilepath(path);
            odpsLocalResourceBuilder.addLocalresourceitem(odpsLocalResourceItemBuilder.build());
        }
        startFuxiAMParamMap.put("odps.cupid.am.applicationsubmissioncontext", Base64.encodeBase64String((byte[])((ApplicationSubmissionContextPBImpl)appContext).getProto().toByteArray()));
        return startFuxiAMParamMap;
    }

    @Override
    public ApplicationId submitApplication(ApplicationSubmissionContext appContext) throws YarnException, IOException {
        ApplicationId applicationId = appContext.getApplicationId();
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1), (long)0L);
        appContext.getAMContainerSpec().getEnvironment().put(ApplicationConstants.Environment.CONTAINER_ID.name(), containerId.toString());
        String containerIdPBStr = Base64.encodeBase64String((byte[])((ContainerIdPBImpl)containerId).getProto().toByteArray());
        appContext.getAMContainerSpec().getEnvironment().put(ApplicationConstants.Environment.CONTAINER_ID.name() + "_PB", containerIdPBStr);
        CupidTaskParamProtos.OdpsLocalResource.Builder odpsLocalResourceBuilder = CupidTaskParamProtos.OdpsLocalResource.newBuilder();
        boolean isDryRun = "true".equals(System.getenv("CUPID_DRY_RUN_MODE_ENABLE"));
        this.cupidSession.setDryRunMode(isDryRun);
        Instance currentInstance = null;
        try {
            HashMap<String, String> startFuxiAMParamMap = this.getStartFuxiAMParam(appContext, odpsLocalResourceBuilder);
            currentInstance = YarnClientImplUtil.transformAppCtxAndStartAM(startFuxiAMParamMap, (CupidTaskParamProtos.OdpsLocalResource)odpsLocalResourceBuilder.build(), (CupidSession)this.cupidSession);
        }
        catch (Exception ex) {
            throw new YarnException((Throwable)ex);
        }
        if (isDryRun) {
            LOG.info((Object)"Cupid dry run mode finished, only upload resources and generate cupid plan.");
            System.exit(0);
        }
        LOG.info((Object)("Submitted applicationType " + appContext.getApplicationType() + " application " + applicationId + " to ResourceManager at instanceId " + currentInstance.getId()));
        System.out.println("InstanceId: " + currentInstance.getId());
        if (this.updateAppMetaViaClient) {
            try {
                ApplicationMetaUtil.createApplicationMeta((String)appContext.getApplicationType(), (String)applicationId.toString(), (String)currentInstance.getId(), (String)StringUtils.join((CharSequence)",", (Iterable)appContext.getApplicationTags()), (String)appContext.getApplicationName(), (CupidSession)this.cupidSession);
            }
            catch (Exception ex) {
                throw new YarnException(ex.getMessage(), ex.getCause());
            }
        }
        return applicationId;
    }

    @Override
    public void killApplication(ApplicationId applicationId) throws YarnException, IOException {
        if (!this.appMetaCache.containsKey(applicationId.toString())) {
            CupidTaskParamProtos.ApplicationMeta applicationMeta = null;
            try {
                applicationMeta = ApplicationMetaUtil.getApplicationMeta((String)applicationId.toString(), (CupidSession)this.cupidSession);
            }
            catch (Exception ex) {
                throw new YarnException((Throwable)ex);
            }
            this.appMetaCache.put(applicationId.toString(), applicationMeta);
        }
        LOG.info((Object)("now stop the application " + applicationId + " instanceId " + this.appMetaCache.get(applicationId.toString()).getInstanceId()));
        try {
            this.cupidSession.odps().instances().get(this.appMetaCache.get(applicationId.toString()).getInstanceId()).stop();
        }
        catch (OdpsException ex) {
            throw new YarnException(ex.getMessage(), ex.getCause());
        }
        CupidTaskParamProtos.ApplicationMeta.Builder updateMeta = CupidTaskParamProtos.ApplicationMeta.newBuilder();
        updateMeta.setYarnApplicationState((long)YarnApplicationState.KILLED.ordinal());
        updateMeta.setFinalApplicationStatus((long)FinalApplicationStatus.FAILED.ordinal());
        updateMeta.setFinishedTime(System.currentTimeMillis());
        if (this.updateAppMetaViaClient) {
            try {
                ApplicationMetaUtil.updateApplicationMeta((String)applicationId.toString(), (CupidTaskParamProtos.ApplicationMeta)updateMeta.build(), (CupidSession)this.cupidSession);
            }
            catch (Exception ex) {
                throw new YarnException(ex.getMessage(), ex.getCause());
            }
        }
        CupidTaskParamProtos.ApplicationMeta updateLocalMeta = this.appMetaCache.get(applicationId.toString()).toBuilder().setYarnApplicationState((long)YarnApplicationState.KILLED.ordinal()).setFinalApplicationStatus((long)FinalApplicationStatus.FAILED.ordinal()).build();
        this.appMetaCache.put(applicationId.toString(), updateLocalMeta);
    }

    private ApplicationReport applicationReportStaticTransform(CupidTaskParamProtos.ApplicationMeta applicationMeta) throws YarnException, IOException {
        ApplicationId appId = ApplicationId.newInstance((long)Long.parseLong(applicationMeta.getApplicationId().split("_")[1]), (int)Integer.parseInt(applicationMeta.getApplicationId().split("_")[2]));
        String host = "127.0.0.1";
        int port = 0;
        ApplicationReport applicationReport = ApplicationReport.newInstance((ApplicationId)appId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (String)"user", (String)"queue", (String)applicationMeta.getApplicationName(), (String)host, (int)port, null, (YarnApplicationState)YarnApplicationState.values()[(int)applicationMeta.getYarnApplicationState()], (String)applicationMeta.getDiagnostics(), (String)applicationMeta.getTrackingUrl(), (long)applicationMeta.getStartedTime(), (long)applicationMeta.getFinishedTime(), (FinalApplicationStatus)FinalApplicationStatus.values()[(int)applicationMeta.getFinalApplicationStatus()], (ApplicationResourceUsageReport)ApplicationResourceUsageReport.newInstance((int)0, (int)0, (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)0, (int)0), (long)0L, (long)0L), (String)applicationMeta.getOriginalTrackingUrl(), (float)0.0f, (String)applicationMeta.getApplicationType(), (org.apache.hadoop.yarn.api.records.Token)org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])"".getBytes(), (String)"", (byte[])"".getBytes(), (String)"token"));
        applicationReport.setApplicationTags(new HashSet<String>(Arrays.asList(applicationMeta.getApplicationTags().split(","))));
        return applicationReport;
    }

    private ApplicationReport applicationReportTransform(CupidTaskParamProtos.ApplicationMeta applicationMeta) throws YarnException, IOException {
        String msg;
        Instance currentInstance = this.cupidSession.odps().instances().get(applicationMeta.getInstanceId());
        ApplicationId appId = ApplicationId.newInstance((long)Long.parseLong(applicationMeta.getApplicationId().split("_")[1]), (int)Integer.parseInt(applicationMeta.getApplicationId().split("_")[2]));
        YarnApplicationState yarnApplicationState = YarnApplicationState.NEW;
        FinalApplicationStatus finalApplicationStatus = FinalApplicationStatus.UNDEFINED;
        String diagnostics = applicationMeta.getDiagnostics().isEmpty() ? "diagnostics" : applicationMeta.getDiagnostics();
        String cupidTrackUrl = applicationMeta.getTrackingUrl().isEmpty() ? "url" : applicationMeta.getTrackingUrl();
        String origTrackingUrl = applicationMeta.getOriginalTrackingUrl().isEmpty() ? "origTrackingUrl" : applicationMeta.getOriginalTrackingUrl();
        String host = "127.0.0.1";
        int port = 0;
        if (!applicationMeta.getOriginalTrackingUrl().isEmpty()) {
            try {
                host = new URI(applicationMeta.getOriginalTrackingUrl()).getHost();
                port = new URI(applicationMeta.getOriginalTrackingUrl()).getPort();
            }
            catch (Exception ex) {
                LOG.error((Object)ex.getStackTrace());
            }
        }
        CupidTaskParamProtos.CupidTaskDetailResultParam amStatus = null;
        try {
            amStatus = YarnClientImplUtil.pollAMStatus((Instance)currentInstance);
        }
        catch (Exception ex) {
            if (ex instanceof InstanceRecycledException) {
                LOG.warn((Object)("application: " + appId.toString() + " " + ex.getMessage()));
                ApplicationReport defaultApplicationReport = ApplicationReport.newInstance((ApplicationId)appId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (String)"user", (String)"queue", (String)applicationMeta.getApplicationName(), (String)host, (int)port, null, (YarnApplicationState)YarnApplicationState.FINISHED, (String)ex.getMessage(), (String)cupidTrackUrl, (long)applicationMeta.getStartedTime(), (long)applicationMeta.getFinishedTime(), (FinalApplicationStatus)FinalApplicationStatus.UNDEFINED, (ApplicationResourceUsageReport)ApplicationResourceUsageReport.newInstance((int)0, (int)0, (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)0, (int)0), (long)0L, (long)0L), (String)origTrackingUrl, (float)0.0f, (String)applicationMeta.getApplicationType(), (org.apache.hadoop.yarn.api.records.Token)org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])"".getBytes(), (String)"", (byte[])"".getBytes(), (String)"token"));
                return defaultApplicationReport;
            }
            throw new YarnException((Throwable)ex);
        }
        if (amStatus.hasRunning()) {
            msg = amStatus.getRunning().getRunningMsg();
            YarnServiceProtos.RegisterApplicationMasterRequestProto register = YarnServiceProtos.RegisterApplicationMasterRequestProto.parseFrom((byte[])Base64.decodeBase64((byte[])msg.getBytes()));
            yarnApplicationState = YarnApplicationState.RUNNING;
            finalApplicationStatus = FinalApplicationStatus.UNDEFINED;
            if (applicationMeta.getTrackingUrl().isEmpty()) {
                try {
                    cupidTrackUrl = YarnClientImplUtil.genCupidTrackUrl((Instance)currentInstance, (String)appId.toString(), (String)register.getTrackingUrl(), (CupidSession)this.cupidSession);
                }
                catch (Exception ex) {
                    throw new YarnException((Throwable)ex);
                }
                origTrackingUrl = register.getTrackingUrl();
                this.cupidSession.setJobRunning();
                LOG.debug((Object)("cupid Track url: " + cupidTrackUrl));
                String result = CupidRequestProxy.getInstance().cupidRequestRPC(cupidTrackUrl, this.cupidSession.odps(), applicationMeta.getInstanceId(), CupidRequestType.UPDATEAPPURLTOMETA);
                if (!result.equals("success")) {
                    throw new IOException("Can not update the url to cupidmeta");
                }
                CupidTaskParamProtos.ApplicationMeta.Builder updateMeta = CupidTaskParamProtos.ApplicationMeta.newBuilder();
                updateMeta.setOriginalTrackingUrl(origTrackingUrl);
                updateMeta.setTrackingUrl(cupidTrackUrl);
                try {
                    host = new URI(origTrackingUrl).getHost();
                    port = new URI(origTrackingUrl).getPort();
                }
                catch (Exception ex) {
                    LOG.error((Object)ex.getStackTrace());
                }
                if (this.updateAppMetaViaClient) {
                    try {
                        ApplicationMetaUtil.updateApplicationMeta((String)appId.toString(), (CupidTaskParamProtos.ApplicationMeta)updateMeta.build(), (CupidSession)this.cupidSession);
                    }
                    catch (Exception ex) {
                        throw new YarnException(ex.getMessage(), ex.getCause());
                    }
                }
                CupidTaskParamProtos.ApplicationMeta updateLocalMeta = applicationMeta.toBuilder().setOriginalTrackingUrl(origTrackingUrl).setTrackingUrl(cupidTrackUrl).setYarnApplicationState((long)yarnApplicationState.ordinal()).setFinalApplicationStatus((long)finalApplicationStatus.ordinal()).build();
                this.appMetaCache.put(appId.toString(), updateLocalMeta);
            }
        } else if (amStatus.hasSuccess()) {
            msg = amStatus.getSuccess().getSuccessMsg();
            YarnServiceProtos.FinishApplicationMasterRequestProto finish = YarnServiceProtos.FinishApplicationMasterRequestProto.parseFrom((byte[])Base64.decodeBase64((byte[])msg.getBytes()));
            yarnApplicationState = YarnApplicationState.FINISHED;
            finalApplicationStatus = FinalApplicationStatus.SUCCEEDED;
            diagnostics = finish.getDiagnostics();
            CupidTaskParamProtos.ApplicationMeta.Builder updateMeta = CupidTaskParamProtos.ApplicationMeta.newBuilder();
            updateMeta.setDiagnostics(diagnostics);
            if (this.updateAppMetaViaClient) {
                try {
                    ApplicationMetaUtil.updateApplicationMeta((String)appId.toString(), (CupidTaskParamProtos.ApplicationMeta)updateMeta.build(), (CupidSession)this.cupidSession);
                }
                catch (Exception ex) {
                    throw new YarnException(ex.getMessage(), ex.getCause());
                }
            }
            CupidTaskParamProtos.ApplicationMeta updateLocalMeta = applicationMeta.toBuilder().setDiagnostics(diagnostics).setYarnApplicationState((long)yarnApplicationState.ordinal()).setFinalApplicationStatus((long)finalApplicationStatus.ordinal()).build();
            this.appMetaCache.put(appId.toString(), updateLocalMeta);
        } else if (amStatus.hasFailed()) {
            msg = amStatus.getFailed().getBizFailed().getBizFailedMsg();
            YarnServiceProtos.FinishApplicationMasterRequestProto finish = YarnServiceProtos.FinishApplicationMasterRequestProto.parseFrom((byte[])Base64.decodeBase64((byte[])msg.getBytes()));
            yarnApplicationState = YarnApplicationState.FAILED;
            finalApplicationStatus = FinalApplicationStatus.FAILED;
            diagnostics = finish.getDiagnostics();
            CupidTaskParamProtos.ApplicationMeta.Builder updateMeta = CupidTaskParamProtos.ApplicationMeta.newBuilder();
            updateMeta.setDiagnostics(diagnostics);
            if (this.updateAppMetaViaClient) {
                try {
                    ApplicationMetaUtil.updateApplicationMeta((String)appId.toString(), (CupidTaskParamProtos.ApplicationMeta)updateMeta.build(), (CupidSession)this.cupidSession);
                }
                catch (Exception ex) {
                    throw new YarnException(ex.getMessage(), ex.getCause());
                }
            }
            CupidTaskParamProtos.ApplicationMeta updateLocalMeta = applicationMeta.toBuilder().setDiagnostics(diagnostics).setYarnApplicationState((long)yarnApplicationState.ordinal()).setFinalApplicationStatus((long)finalApplicationStatus.ordinal()).build();
            this.appMetaCache.put(appId.toString(), updateLocalMeta);
        } else if (amStatus.hasCancelled()) {
            yarnApplicationState = YarnApplicationState.KILLED;
            finalApplicationStatus = FinalApplicationStatus.FAILED;
            LOG.debug((Object)("application: " + applicationMeta.getApplicationId() + " has been killed"));
            CupidTaskParamProtos.ApplicationMeta updateLocalMeta = applicationMeta.toBuilder().setYarnApplicationState((long)yarnApplicationState.ordinal()).setFinalApplicationStatus((long)finalApplicationStatus.ordinal()).build();
            this.appMetaCache.put(appId.toString(), updateLocalMeta);
        }
        ApplicationReport applicationReport = ApplicationReport.newInstance((ApplicationId)appId, (ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (String)"user", (String)"queue", (String)applicationMeta.getApplicationName(), (String)host, (int)port, null, (YarnApplicationState)yarnApplicationState, (String)diagnostics, (String)cupidTrackUrl, (long)applicationMeta.getStartedTime(), (long)applicationMeta.getFinishedTime(), (FinalApplicationStatus)finalApplicationStatus, (ApplicationResourceUsageReport)ApplicationResourceUsageReport.newInstance((int)0, (int)0, (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)0, (int)0), (Resource)Resource.newInstance((int)0, (int)0), (long)0L, (long)0L), (String)origTrackingUrl, (float)0.0f, (String)applicationMeta.getApplicationType(), (org.apache.hadoop.yarn.api.records.Token)org.apache.hadoop.yarn.api.records.Token.newInstance((byte[])"".getBytes(), (String)"", (byte[])"".getBytes(), (String)"token"));
        applicationReport.setApplicationTags(new HashSet<String>(Arrays.asList(applicationMeta.getApplicationTags().split(","))));
        return applicationReport;
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        if (!this.appMetaCache.containsKey(appId.toString())) {
            CupidTaskParamProtos.ApplicationMeta applicationMeta = null;
            try {
                applicationMeta = ApplicationMetaUtil.getApplicationMeta((String)appId.toString(), (CupidSession)this.cupidSession);
            }
            catch (Exception ex) {
                throw new YarnException((Throwable)ex);
            }
            LOG.debug((Object)("Fetch ApplicationMeta:\n" + applicationMeta));
            this.appMetaCache.put(appId.toString(), applicationMeta);
        }
        return this.applicationReportTransform(this.appMetaCache.get(appId.toString()));
    }

    @Override
    public Token<AMRMTokenIdentifier> getAMRMToken(ApplicationId appId) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getAMRMToken");
    }

    @Override
    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = null;
        try {
            applicationMetaList = ApplicationMetaUtil.listApplicationMeta(null, null, (CupidSession)this.cupidSession);
        }
        catch (Exception ex) {
            throw new YarnException((Throwable)ex);
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            try {
                reports.add(this.applicationReportStaticTransform(applicationMeta));
            }
            catch (Exception exception) {
                LOG.warn((Object)("getApplications ignore non-yarn application, instanceId: " + applicationMeta.getInstanceId() + ", applicationId: " + applicationMeta.getApplicationId() + ", errMsg: " + exception.getMessage()));
            }
        }
        return reports;
    }

    @Override
    public List<ApplicationReport> getApplications(Set<String> applicationTypes) throws YarnException, IOException {
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = null;
        try {
            applicationMetaList = ApplicationMetaUtil.listApplicationMeta((String)StringUtils.join((CharSequence)",", (String[])applicationTypes.toArray(new String[applicationTypes.size()])), null, (CupidSession)this.cupidSession);
        }
        catch (Exception ex) {
            throw new YarnException((Throwable)ex);
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            try {
                reports.add(this.applicationReportStaticTransform(applicationMeta));
            }
            catch (Exception exception) {
                LOG.warn((Object)("getApplications ignore non-yarn application, instanceId: " + applicationMeta.getInstanceId() + ", applicationId: " + applicationMeta.getApplicationId() + ", errMsg: " + exception.getMessage()));
            }
        }
        return reports;
    }

    @Override
    public List<ApplicationReport> getApplications(EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = null;
        try {
            applicationMetaList = ApplicationMetaUtil.listApplicationMeta(null, (String)this.getStateString(applicationStates), (CupidSession)this.cupidSession);
        }
        catch (Exception ex) {
            throw new YarnException((Throwable)ex);
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            try {
                reports.add(this.applicationReportStaticTransform(applicationMeta));
            }
            catch (Exception exception) {
                LOG.warn((Object)("getApplications ignore non-yarn application, instanceId: " + applicationMeta.getInstanceId() + ", applicationId: " + applicationMeta.getApplicationId() + ", errMsg: " + exception.getMessage()));
            }
        }
        return reports;
    }

    private String getStateString(EnumSet<YarnApplicationState> applicationStates) {
        ArrayList<String> states = new ArrayList<String>();
        for (YarnApplicationState state : applicationStates) {
            states.add(Integer.toString(state.ordinal()));
        }
        return StringUtils.join((CharSequence)",", states);
    }

    @Override
    public List<ApplicationReport> getApplications(Set<String> applicationTypes, EnumSet<YarnApplicationState> applicationStates) throws YarnException, IOException {
        CupidTaskParamProtos.ApplicationMetaList applicationMetaList = null;
        try {
            applicationMetaList = ApplicationMetaUtil.listApplicationMeta((String)StringUtils.join((CharSequence)",", (String[])applicationTypes.toArray(new String[applicationTypes.size()])), (String)this.getStateString(applicationStates), (CupidSession)this.cupidSession);
        }
        catch (Exception ex) {
            throw new YarnException((Throwable)ex);
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        for (CupidTaskParamProtos.ApplicationMeta applicationMeta : applicationMetaList.getApplicationMetaListList()) {
            try {
                reports.add(this.applicationReportStaticTransform(applicationMeta));
            }
            catch (Exception exception) {
                LOG.warn((Object)("getApplications ignore non-yarn application, instanceId: " + applicationMeta.getInstanceId() + ", applicationId: " + applicationMeta.getApplicationId() + ", errMsg: " + exception.getMessage()));
            }
        }
        return reports;
    }

    @Override
    public YarnClusterMetrics getYarnClusterMetrics() throws YarnException, IOException {
        int numNodeManagers = YarnClientImplUtil.getClusterTuboNum();
        return GetClusterMetricsResponse.newInstance((YarnClusterMetrics)YarnClusterMetrics.newInstance((int)numNodeManagers)).getClusterMetrics();
    }

    @Override
    public List<NodeReport> getNodeReports(NodeState ... states) throws YarnException, IOException {
        LOG.warn((Object)"Mock getNodeReports: return a NodeReport list, size 1000");
        ArrayList<NodeReport> reports = new ArrayList<NodeReport>();
        for (int i = 0; i < 1000; ++i) {
            NodeId id = NodeId.newInstance((String)("host" + i), (int)10101);
            NodeReport report = NodeReport.newInstance((NodeId)id, (NodeState)NodeState.RUNNING, (String)"http://127.0.0.1", (String)"rack_mock", (Resource)Resource.newInstance((int)0x20000000, (int)512), (Resource)Resource.newInstance((int)0x40000000, (int)1024), (int)0, (String)"None", (long)System.currentTimeMillis());
            reports.add(report);
        }
        return reports;
    }

    @Override
    public org.apache.hadoop.yarn.api.records.Token getRMDelegationToken(Text renewer) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getRMDelegationToken");
    }

    @Override
    public QueueInfo getQueueInfo(String queueName) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getQueueInfo");
    }

    @Override
    public List<QueueInfo> getAllQueues() throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getAllQueues");
    }

    @Override
    public List<QueueInfo> getRootQueueInfos() throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getRootQueueInfos");
    }

    @Override
    public List<QueueInfo> getChildQueueInfos(String parent) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getChildQueueInfos");
    }

    @Override
    public List<QueueUserACLInfo> getQueueAclsInfo() throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getQueueAclsInfo");
    }

    @Override
    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        return ApplicationAttemptReport.newInstance((ApplicationAttemptId)applicationAttemptId, (String)"127.0.0.1", (int)0, (String)"url", (String)"url", (String)"Diagnostics", (YarnApplicationAttemptState)YarnApplicationAttemptState.NEW, (ContainerId)ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)0L));
    }

    @Override
    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId applicationId) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getApplicationAttempts");
    }

    @Override
    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        ContainerReport containerReport = (ContainerReport)Records.newRecord(ContainerReport.class);
        containerReport.setContainerId(containerId);
        containerReport.setAllocatedResource(Resource.newInstance((int)0, (int)0));
        containerReport.setAssignedNode(NodeId.newInstance((String)"127.0.0.1", (int)0));
        containerReport.setPriority(Priority.UNDEFINED);
        containerReport.setCreationTime(0L);
        containerReport.setFinishTime(0L);
        containerReport.setDiagnosticsInfo("Diagnostics");
        containerReport.setLogUrl("http://Not_Support.com");
        containerReport.setContainerExitStatus(0);
        containerReport.setContainerState(ContainerState.RUNNING);
        return containerReport;
    }

    @Override
    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getContainers");
    }

    @Override
    public void moveApplicationAcrossQueues(ApplicationId appId, String queue) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method moveApplicationAcrossQueues");
    }

    @Override
    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method ReservationSubmissionResponse");
    }

    @Override
    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method updateReservation");
    }

    @Override
    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method ReservationDeleteResponse");
    }

    @Override
    public Map<NodeId, Set<String>> getNodeToLabels() throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getNodeToLabels");
    }

    @Override
    public Map<String, Set<NodeId>> getLabelsToNodes() throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getLabelsToNodes");
    }

    @Override
    public Map<String, Set<NodeId>> getLabelsToNodes(Set<String> labels) throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getLabelsToNodes");
    }

    @Override
    public Set<String> getClusterNodeLabels() throws YarnException, IOException {
        throw new MethodNotImplementedException("Method getClusterNodeLabels");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public void setRMClient(ApplicationClientProtocol rmClient) {
        this.rmClient = rmClient;
    }

    public static class MethodNotImplementedException
    extends RuntimeException {
        public MethodNotImplementedException(String msg) {
            super(msg);
        }
    }
}

