/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.aliyun.odps.fs.TempResourceMapper;
import com.aliyun.odps.proxy.fuxi.api.AppMasterLib;
import com.aliyun.odps.proxy.fuxi.api.WorkerId;
import com.aliyun.odps.proxy.fuxi.api.WorkerList;
import com.aliyun.odps.proxy.fuxi.api.WorkerProcessInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerLaunchContextPBImpl;
import org.apache.hadoop.yarn.client.YarnCupidUtil;
import org.apache.hadoop.yarn.client.api.NMClient;
import org.apache.hadoop.yarn.client.api.async.impl.AMRMClientAsyncImpl;
import org.apache.hadoop.yarn.client.api.impl.ContainerManagementProtocolProxy;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class NMClientImpl
extends NMClient {
    private static final Log LOG = LogFactory.getLog(NMClientImpl.class);
    protected ConcurrentMap<ContainerId, StartedContainer> startedContainers = new ConcurrentHashMap<ContainerId, StartedContainer>();
    private final AtomicBoolean cleanupRunningContainers = new AtomicBoolean(true);
    private int containerResLimitRatio = 10;
    private ContainerManagementProtocolProxy cmProxy;
    private boolean aliYarnModeEnable = System.getenv("CUPID_YARN_MODE") != null && System.getenv("CUPID_YARN_MODE").equals("ALIYARN");

    public NMClientImpl() {
        super(NMClientImpl.class.getName());
    }

    public NMClientImpl(String name) {
        super(name);
    }

    protected String containerIndex2Role(long index) {
        return System.getenv("APP_VERSION") + "-" + index;
    }

    protected void serviceStop() throws Exception {
        if (this.getCleanupRunningContainers().get()) {
            this.cleanupRunningContainers();
        }
        this.cmProxy.stopAllProxies();
        super.serviceStop();
    }

    protected synchronized void cleanupRunningContainers() {
        for (StartedContainer startedContainer : this.startedContainers.values()) {
            try {
                this.stopContainer(startedContainer.getContainerId(), startedContainer.getNodeId());
            }
            catch (YarnException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to stop Container " + startedContainer.getContainerId() + "when stopping NMClientImpl"));
            }
        }
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (this.aliYarnModeEnable) {
            conf.set("yarn.ipc.client.factory.class", "org.apache.hadoop.yarn.client.api.aliyarn.FuxiClientFactoryImpl");
        }
        super.serviceInit(conf);
        if (this.getNMTokenCache() == null) {
            throw new IllegalStateException("NMTokenCache has not been set");
        }
        this.cmProxy = new ContainerManagementProtocolProxy(conf, this.getNMTokenCache());
        this.containerResLimitRatio = conf.getInt("odps.cupid.yarn.container.hardlimit.ratio", 10);
        LOG.info((Object)("containerResLimitRatio: " + this.containerResLimitRatio));
        TempResourceMapper.load();
    }

    @Override
    public void cleanupRunningContainersOnStop(boolean enabled) {
        this.getCleanupRunningContainers().set(enabled);
    }

    private void addStartingContainer(StartedContainer startedContainer) throws YarnException {
        if (this.startedContainers.putIfAbsent(startedContainer.containerId, startedContainer) != null) {
            throw RPCUtil.getRemoteException((String)("Container " + startedContainer.containerId.toString() + " is already started"));
        }
        this.startedContainers.put(startedContainer.getContainerId(), startedContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, ByteBuffer> startContainer(Container container, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
        StartedContainer startingContainer;
        YarnCupidUtil.transformTempResource(containerLaunchContext);
        StartedContainer startedContainer = startingContainer = this.createStartedContainer(container);
        synchronized (startedContainer) {
            this.addStartingContainer(startingContainer);
            YarnConfiguration conf = new YarnConfiguration(this.getConfig());
            if (this.aliYarnModeEnable) {
                Map allServiceResponse;
                ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
                try {
                    containerLaunchContext.getEnvironment().put(ApplicationConstants.Environment.CONTAINER_ID.name(), container.getId().toString());
                    String containerIdPBStr = Base64.encodeBase64String((byte[])((ContainerIdPBImpl)container.getId()).getProto().toByteArray());
                    containerLaunchContext.getEnvironment().put(ApplicationConstants.Environment.CONTAINER_ID.name() + "_PB", containerIdPBStr);
                    proxy = this.cmProxy.getProxy(container.getNodeId().toString(), container.getId());
                    StartContainerRequest scRequest = StartContainerRequest.newInstance((ContainerLaunchContext)containerLaunchContext, (Token)container.getContainerToken());
                    ArrayList<StartContainerRequest> list = new ArrayList<StartContainerRequest>();
                    list.add(scRequest);
                    StartContainersRequest allRequests = StartContainersRequest.newInstance(list);
                    StartContainersResponse response = proxy.getContainerManagementProtocol().startContainers(allRequests);
                    if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(container.getId())) {
                        Throwable t = ((SerializedException)response.getFailedRequests().get(container.getId())).deSerialize();
                        this.parseAndThrowException(t);
                    }
                    allServiceResponse = response.getAllServicesMetaData();
                    startingContainer.state = ContainerState.RUNNING;
                    if (AMRMClientAsyncImpl.useSyncClient) {
                        AMRMClientAsyncImpl.syncProcessContainer.put(container.getId().toString());
                    }
                    if (proxy != null) {
                        this.cmProxy.mayBeCloseProxy(proxy);
                    }
                }
                catch (YarnException e) {
                    try {
                        startingContainer.state = ContainerState.COMPLETE;
                        this.removeStartedContainer(startingContainer);
                        throw e;
                        catch (IOException e2) {
                            startingContainer.state = ContainerState.COMPLETE;
                            this.removeStartedContainer(startingContainer);
                            throw e2;
                        }
                        catch (Throwable t) {
                            startingContainer.state = ContainerState.COMPLETE;
                            this.removeStartedContainer(startingContainer);
                            throw RPCUtil.getRemoteException((Throwable)t);
                        }
                    }
                    catch (Throwable throwable) {
                        if (proxy != null) {
                            this.cmProxy.mayBeCloseProxy(proxy);
                        }
                        throw throwable;
                    }
                }
                return allServiceResponse;
            }
            try {
                containerLaunchContext.getEnvironment().put(ApplicationConstants.Environment.CONTAINER_ID.name(), container.getId().toString());
                String containerIdPBStr = Base64.encodeBase64String((byte[])((ContainerIdPBImpl)container.getId()).getProto().toByteArray());
                containerLaunchContext.getEnvironment().put(ApplicationConstants.Environment.CONTAINER_ID.name() + "_PB", containerIdPBStr);
                HashMap<String, WorkerList> wlm = new HashMap<String, WorkerList>();
                AppMasterLib amlib = AppMasterLib.getInstance();
                WorkerList workerList = new WorkerList();
                long slotId = container.getId().getContainerId();
                String roleName = this.containerIndex2Role(slotId);
                WorkerProcessInfo procInfo = new WorkerProcessInfo();
                Resource resource = container.getResource();
                HashMap<String, Long> fuxiResource = new HashMap<String, Long>();
                fuxiResource.put("CPU", (long)resource.getVirtualCores() * 100L);
                fuxiResource.put("Memory", (long)resource.getMemory() * 1L);
                procInfo.setResource(fuxiResource);
                procInfo.setSlotId(slotId);
                procInfo.setResHardLimitRatio((double)this.containerResLimitRatio);
                HashMap<String, String> params = new HashMap<String, String>();
                YarnProtos.ContainerLaunchContextProto containerLaunchContextProto = ((ContainerLaunchContextPBImpl)containerLaunchContext).getProto();
                params.put("ContainerParam", Base64.encodeBase64String((byte[])containerLaunchContextProto.toByteArray()));
                params.put("TempFileGroupName", System.getenv("TempFileGroupName"));
                params.put("APP_VERSION", System.getenv("APP_VERSION"));
                procInfo.setParams(new HashMap(params));
                String workerName = this.generateWorkerName(container.getId().getContainerId(), container.getNodeId().getHost());
                workerList.start(workerName, procInfo);
                wlm.put(roleName, workerList);
                amlib.sendWorkerList(wlm);
                startingContainer.state = ContainerState.RUNNING;
            }
            catch (Throwable t) {
                startingContainer.state = ContainerState.COMPLETE;
                this.removeStartedContainer(startingContainer);
                throw RPCUtil.getRemoteException((Throwable)t);
            }
            return new HashMap<String, ByteBuffer>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopContainer(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        StartedContainer startedContainer = this.getStartedContainer(containerId);
        if (startedContainer != null) {
            StartedContainer startedContainer2 = startedContainer;
            synchronized (startedContainer2) {
                if (startedContainer.state != ContainerState.RUNNING) {
                    return;
                }
                this.stopContainerInternal(containerId, nodeId);
                startedContainer.state = ContainerState.COMPLETE;
                this.removeStartedContainer(startedContainer);
            }
        } else {
            this.stopContainerInternal(containerId, nodeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerStatus getContainerStatus(ContainerId containerId, NodeId nodeId) throws YarnException, IOException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            ContainerStatus containerStatus;
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            GetContainerStatusesResponse response = proxy.getContainerManagementProtocol().getContainerStatuses(GetContainerStatusesRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = ((SerializedException)response.getFailedRequests().get(containerId)).deSerialize();
                this.parseAndThrowException(t);
            }
            ContainerStatus containerStatus2 = containerStatus = (ContainerStatus)response.getContainerStatuses().get(0);
            return containerStatus2;
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopContainerInternal(ContainerId containerId, NodeId nodeId) throws IOException, YarnException {
        ContainerManagementProtocolProxy.ContainerManagementProtocolProxyData proxy = null;
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>();
        containerIds.add(containerId);
        try {
            proxy = this.cmProxy.getProxy(nodeId.toString(), containerId);
            StopContainersResponse response = proxy.getContainerManagementProtocol().stopContainers(StopContainersRequest.newInstance(containerIds));
            if (response.getFailedRequests() != null && response.getFailedRequests().containsKey(containerId)) {
                Throwable t = ((SerializedException)response.getFailedRequests().get(containerId)).deSerialize();
                this.parseAndThrowException(t);
            }
        }
        finally {
            if (proxy != null) {
                this.cmProxy.mayBeCloseProxy(proxy);
            }
        }
    }

    private String generateWorkerName(long containerId, String tuboHostName) throws IOException {
        String roleName = this.containerIndex2Role(containerId);
        long workerIndex = containerId;
        AppMasterLib amlib = AppMasterLib.getInstance();
        String userName = amlib.getUserName();
        String appName = amlib.getAppName();
        String workerName = new WorkerId(userName, appName, roleName, tuboHostName, workerIndex).toString();
        return workerName;
    }

    protected synchronized StartedContainer createStartedContainer(Container container) throws YarnException, IOException {
        StartedContainer startedContainer = new StartedContainer(container.getId(), container.getNodeId(), container.getContainerToken());
        return startedContainer;
    }

    protected synchronized void removeStartedContainer(StartedContainer container) {
        this.startedContainers.remove(container.containerId);
    }

    protected synchronized StartedContainer getStartedContainer(ContainerId containerId) {
        return (StartedContainer)this.startedContainers.get(containerId);
    }

    public AtomicBoolean getCleanupRunningContainers() {
        return this.cleanupRunningContainers;
    }

    private void parseAndThrowException(Throwable t) throws YarnException, IOException {
        if (t instanceof YarnException) {
            throw (YarnException)t;
        }
        if (t instanceof SecretManager.InvalidToken) {
            throw (SecretManager.InvalidToken)t;
        }
        throw (IOException)t;
    }

    protected static class StartedContainer {
        private ContainerId containerId;
        private NodeId nodeId;
        private ContainerState state;

        public StartedContainer(ContainerId containerId, NodeId nodeId, Token containerToken) {
            this.containerId = containerId;
            this.nodeId = nodeId;
            this.state = ContainerState.NEW;
        }

        public ContainerId getContainerId() {
            return this.containerId;
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }
    }
}

