/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import apsara.odps.cupid.protocol.ProxyAm;
import com.aliyun.odps.cupid.runtime.ContainerStatus;
import com.aliyun.odps.cupid.runtime.JobStatusUpdateClient;
import com.aliyun.odps.cupid.runtime.RuntimeContext;
import com.aliyun.odps.proxy.fuxi.api.AppMasterLib;
import com.aliyun.odps.proxy.fuxi.api.AssignedResourceChangeEventInfo;
import com.aliyun.odps.proxy.fuxi.api.EventCallback;
import com.aliyun.odps.proxy.fuxi.api.EventInfo;
import com.aliyun.odps.proxy.fuxi.api.EventName;
import com.aliyun.odps.proxy.fuxi.api.OverUsedWorkItem;
import com.aliyun.odps.proxy.fuxi.api.ResourceLocation;
import com.aliyun.odps.proxy.fuxi.api.RpcHandlerCallback;
import com.aliyun.odps.proxy.fuxi.api.RpcRequest;
import com.aliyun.odps.proxy.fuxi.api.SendWorkerListResponseEventInfo;
import com.aliyun.odps.proxy.fuxi.api.WorkItemProgress;
import com.aliyun.odps.proxy.fuxi.api.WorkerFailureEntry;
import com.aliyun.odps.proxy.fuxi.api.WorkerFailureEventInfo;
import com.aliyun.odps.proxy.fuxi.api.WorkerId;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.FinishApplicationMasterRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RegisterApplicationMasterRequestPBImpl;
import org.apache.hadoop.yarn.api.records.AMCommand;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ApplicationMasterAdapter
extends AbstractService
implements ApplicationMasterProtocol {
    private static final Log LOG = LogFactory.getLog(ApplicationMasterAdapter.class);
    public static Map<String, HashMap<String, Integer>> assign = new ConcurrentHashMap<String, HashMap<String, Integer>>();
    private Map<RequestKey, Integer> resourceAsk = new ConcurrentHashMap<RequestKey, Integer>();
    private Map<String, RequestKey> roleToRequestKey = new ConcurrentHashMap<String, RequestKey>();
    private Set<String> blackListNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, Container> roleToResource = new ConcurrentHashMap<String, Container>();
    private Map<ContainerId, String> containerIdToHost = new ConcurrentHashMap<ContainerId, String>();
    private List<org.apache.hadoop.yarn.api.records.ContainerStatus> justFinishedContainers = new ArrayList<org.apache.hadoop.yarn.api.records.ContainerStatus>();
    private Map<String, org.apache.hadoop.yarn.api.records.ContainerStatus> finishedContainers = new HashMap<String, org.apache.hadoop.yarn.api.records.ContainerStatus>();
    private Map<Long, String> historyContainerIndexRoleMap = new HashMap<Long, String>();
    public static int responseID = -1;
    public static AtomicLong currentContainerId = new AtomicLong(0L);
    public static ApplicationAttemptId appAttemptId;
    private long initTime = -1L;
    private AppMasterLib amLib = AppMasterLib.getInstance();
    private JobStatusUpdateClient jobStatusUpdateClient = JobStatusUpdateClient.getInstance();
    private String trackUrl = "";
    private String appVersion = System.getenv("APP_VERSION");

    private ApplicationMasterAdapter() {
        super(ApplicationMasterAdapter.class.getName());
        this.serviceStart();
    }

    public static ApplicationMasterAdapter getInstance() {
        return ApplicationMasterAdapterHolder.INSTANCE;
    }

    protected String containerIndex2Role(long index) {
        if (this.historyContainerIndexRoleMap.containsKey(index)) {
            String historyRoleName = this.historyContainerIndexRoleMap.get(index);
            LOG.info((Object)("Found history roleName: " + historyRoleName + " with index: " + index));
            return historyRoleName;
        }
        return this.appVersion + "-" + index;
    }

    protected long role2ContainerIndex(String role) {
        String[] ts = role.split("-");
        return Integer.parseInt(ts[1]);
    }

    protected void serviceStart() {
        this.amLib.registerEventCallback(EventName.EVENT_ASSIGNED_RESOURCE_CHANGE, (EventCallback)new AssignedResourceChangeEventCallback());
        LOG.info((Object)"register assigned resource change event OK!");
        this.amLib.registerEventCallback(EventName.EVENT_SEND_WORKER_LIST_RESPONSE, (EventCallback)new SendWorkerListResponseEventCallback());
        LOG.info((Object)"register EVENT_SEND_WORKER_LIST_RESPONSE ok!");
        this.amLib.registerEventCallback(EventName.EVENT_WORKER_FAILURE, (EventCallback)new WorkerFailureEventCallback());
        LOG.info((Object)"register EVENT_WORKER_FAILURE ok!");
        this.amLib.registerEventCallback(EventName.EVENT_FM_HEARTBEAT_TIMEOUT, (EventCallback)new FmHeartbeatTimeoutEventInfoCallback());
        LOG.info((Object)"register EVENT_FM_HEARTBEAT_TIMEOUT ok!");
        this.amLib.registerEventCallback(EventName.EVENT_DISABLE_OLD_APP_MASTER, (EventCallback)new DisableOldAppMasterEventInfoCallback());
        LOG.info((Object)"register EVENT_DISABLE_OLD_CHILD_MASTER ok!");
        this.amLib.registerRpcHandlerCallback((RpcHandlerCallback)new RpcEventHandlerCallback());
        LOG.info((Object)"register rpc callback ok!");
        this.initTime = System.currentTimeMillis();
        LOG.info((Object)("amlib initTime: " + this.initTime));
        try {
            RuntimeContext.get().reportContainerStatus(ContainerStatus.START, "ApplicationMaster started.");
        }
        catch (Exception e) {
            LOG.warn((Object)"report container status error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        Object containerId3;
        responseID = request.getResponseId() + 1;
        this.updateBlackList(request.getResourceBlacklistRequest());
        List ask = request.getAskList();
        ArrayList<ResourceRequest> anyAskNeedRequest = new ArrayList<ResourceRequest>();
        for (ResourceRequest rr : ask) {
            if (ResourceRequest.isAnyLocation((String)rr.getResourceName())) {
                LOG.info((Object)("ResourceRequest To Ask: " + rr.toString()));
                anyAskNeedRequest.add(ResourceRequest.newInstance((Priority)rr.getPriority(), (String)rr.getResourceName(), (Resource)rr.getCapability(), (int)rr.getNumContainers()));
                continue;
            }
            if (!rr.getResourceName().startsWith("/")) {
                LOG.info((Object)("ResourceRequest To Ask: " + rr.toString()));
                anyAskNeedRequest.add(ResourceRequest.newInstance((Priority)rr.getPriority(), (String)rr.getResourceName(), (Resource)rr.getCapability(), (int)rr.getNumContainers()));
                RequestKey requestKey = RequestKey.getKey(ResourceRequest.newInstance((Priority)rr.getPriority(), (String)"*", (Resource)rr.getCapability(), (int)rr.getNumContainers()));
                int numWaiting = rr.getNumContainers();
                if (this.resourceAsk.containsKey(requestKey)) {
                    numWaiting += this.resourceAsk.get(requestKey).intValue();
                }
                this.resourceAsk.put(requestKey, numWaiting);
                continue;
            }
            LOG.info((Object)("ingore:" + rr.toString()));
        }
        if (anyAskNeedRequest.size() != 0) {
            LOG.info((Object)("ResourceAsk in begin: " + this.getResourceRequestInfo(this.resourceAsk)));
        }
        HashMap<String, com.aliyun.odps.proxy.fuxi.api.ResourceRequest> resReq = new HashMap<String, com.aliyun.odps.proxy.fuxi.api.ResourceRequest>();
        ConcurrentHashMap<String, Container> newRoleToResource = new ConcurrentHashMap<String, Container>();
        for (ResourceRequest rr : anyAskNeedRequest) {
            int totalRequestContainers;
            RequestKey requestKey = RequestKey.getKey(rr);
            Integer numContainerWaiting = this.resourceAsk.get(requestKey);
            if (numContainerWaiting == null) {
                numContainerWaiting = 0;
            }
            if ((totalRequestContainers = rr.getNumContainers()) < numContainerWaiting) {
                LOG.warn((Object)("totalRequestContainers is " + totalRequestContainers + ", less than numContainerWaiting! Set numContainerWaiting to totalRequestContainers."));
                totalRequestContainers = numContainerWaiting;
            }
            this.resourceAsk.put(requestKey, totalRequestContainers);
            rr.setNumContainers(totalRequestContainers - numContainerWaiting);
            if (rr.getNumContainers() <= 0) continue;
            LOG.info((Object)("Need request containers: " + rr.getNumContainers() + ", Priority: " + rr.getPriority() + ", Capability: " + rr.getCapability()));
            for (int i = 0; i < rr.getNumContainers(); ++i) {
                long cid = currentContainerId.incrementAndGet();
                String role = this.containerIndex2Role(cid);
                ContainerId containerId2 = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)cid);
                Container container = Container.newInstance((ContainerId)containerId2, (NodeId)NodeId.newInstance((String)"", (int)0), (String)"", (Resource)rr.getCapability(), (Priority)rr.getPriority(), null);
                newRoleToResource.put(role, container);
                this.roleToRequestKey.put(role, requestKey);
                HashMap<String, Long> resource = new HashMap<String, Long>();
                Resource containerResource = rr.getCapability();
                resource.put("CPU", (long)containerResource.getVirtualCores() * 100L);
                resource.put("Memory", (long)containerResource.getMemory() * 1L);
                this.amLib.addRole(role, this.initTime + cid, false, resource);
                com.aliyun.odps.proxy.fuxi.api.ResourceRequest req = new com.aliyun.odps.proxy.fuxi.api.ResourceRequest();
                if (ResourceRequest.isAnyLocation((String)rr.getResourceName())) {
                    req.require(new ResourceLocation(4, "C"), 1);
                } else {
                    req.require(new ResourceLocation(1, rr.getResourceName()), 1);
                }
                req.setMaxSlotCount(1);
                for (String blackListNode : this.blackListNodes) {
                    req.refuse(new ResourceLocation(1, blackListNode), true);
                }
                resReq.put(role, req);
            }
        }
        if (anyAskNeedRequest.size() != 0) {
            LOG.info((Object)("ResourceAsk after refresh: " + this.getResourceRequestInfo(this.resourceAsk)));
        }
        List containerIdList = request.getReleaseList();
        for (Object containerId3 : containerIdList) {
            String role = this.containerIndex2Role(containerId3.getContainerId());
            LOG.info((Object)("release container: " + containerId3.toString() + ", remove role: " + role));
            this.processFinishedWorker(role, "container released by user.", 0);
        }
        if (resReq.size() > 0) {
            this.amLib.requireResource(resReq);
        }
        this.roleToResource.putAll(newRoleToResource);
        ArrayList<Container> allocatedContainers = new ArrayList<Container>();
        containerId3 = assign;
        synchronized (containerId3) {
            for (Map.Entry<String, HashMap<String, Integer>> entry : assign.entrySet()) {
                String role = entry.getKey();
                Container container = this.roleToResource.get(role);
                String tuboHostName = entry.getValue().keySet().iterator().next();
                container.setNodeId(NodeId.newInstance((String)tuboHostName, (int)0));
                container.setNodeHttpAddress(tuboHostName + ":7788");
                allocatedContainers.add(container);
                this.decResourceRequest(role, container);
                this.containerIdToHost.put(container.getId(), tuboHostName);
            }
            assign.clear();
        }
        ArrayList<org.apache.hadoop.yarn.api.records.ContainerStatus> completeContainers = new ArrayList<org.apache.hadoop.yarn.api.records.ContainerStatus>();
        List<org.apache.hadoop.yarn.api.records.ContainerStatus> list = this.justFinishedContainers;
        synchronized (list) {
            completeContainers.addAll(this.justFinishedContainers);
            this.justFinishedContainers.clear();
        }
        return AllocateResponse.newInstance((int)responseID, completeContainers, allocatedContainers, new ArrayList(), (Resource)Resource.newInstance((int)100000, (int)1000), (AMCommand)AMCommand.AM_RESYNC, (int)10000, null, new ArrayList());
    }

    private String getResourceRequestInfo(Map<RequestKey, Integer> resourceAsk) {
        StringBuilder resourceAskInfoBuilder = new StringBuilder();
        for (Map.Entry<RequestKey, Integer> or : resourceAsk.entrySet()) {
            RequestKey requestKey = or.getKey();
            resourceAskInfoBuilder.append("Priority: ").append(requestKey.getPriority()).append(", Capability: ").append(requestKey.getCapability()).append(", NumContainers: ").append(or.getValue()).append(" | ");
        }
        return resourceAskInfoBuilder.toString();
    }

    private void updateBlackList(ResourceBlacklistRequest blacklistRequest) {
        List additions = blacklistRequest.getBlacklistAdditions();
        List removals = blacklistRequest.getBlacklistRemovals();
        if (additions != null) {
            this.blackListNodes.addAll(additions);
        }
        if (removals != null) {
            this.blackListNodes.removeAll(removals);
        }
    }

    private void decResourceRequest(String role, Container container) {
        if (!this.roleToRequestKey.containsKey(role)) {
            throw new IllegalArgumentException("cannot find requestKey for role: " + role);
        }
        RequestKey requestKey = this.roleToRequestKey.remove(role);
        Integer numContainerWaiting = this.resourceAsk.get(requestKey);
        if (numContainerWaiting == null || numContainerWaiting == 0) {
            LOG.warn((Object)("decResourceRequest on " + numContainerWaiting + " container waiting, do NOTHING"));
            return;
        }
        if ((numContainerWaiting = Integer.valueOf(numContainerWaiting - 1)) == 0) {
            this.resourceAsk.remove(requestKey);
        } else {
            this.resourceAsk.put(requestKey, numContainerWaiting);
        }
        LOG.info((Object)("Container allocated, dec ResourceAsk. NumContainers set to " + numContainerWaiting + ", priority: " + requestKey.getPriority() + ", capability: " + requestKey.getCapability()));
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        YarnServiceProtos.RegisterApplicationMasterRequestProto proto = ((RegisterApplicationMasterRequestPBImpl)request).getProto();
        this.trackUrl = proto.getTrackingUrl();
        LOG.info((Object)("registerApplicationMaster:" + request.toString()));
        String registerApplicationMasterRequestPb = Base64.encodeBase64String((byte[])proto.toByteArray());
        try {
            RuntimeContext.get().reportContainerStatus(ContainerStatus.RUNNING, registerApplicationMasterRequestPb);
        }
        catch (Exception e) {
            LOG.error((Object)"reportContainerStatus fail", (Throwable)e);
            throw new IOException("reportContainerStatus fail", e);
        }
        HashMap acls = new HashMap();
        ByteBuffer key = ByteBuffer.allocate(1);
        ArrayList<Container> containersFromPreviousAttempt = new ArrayList<Container>();
        try {
            ProxyAm.ContainersFromPreviousAttemptAmLib containersFromPreviousAttemptAmLib = RuntimeContext.get().getContainersFromPreviousAttemptAmLib();
            for (ProxyAm.AmLibRoleInfo amLibRoleInfo : containersFromPreviousAttemptAmLib.getAmlibRoleInfosList()) {
                String roleName = amLibRoleInfo.getRoleName();
                LOG.info((Object)("containersFromPreviousAttemptAmLib roleName: " + roleName + ", containerId: " + this.role2ContainerIndex(roleName)));
                RequestKey requestKey = new RequestKey("*", Priority.newInstance((int)1), Resource.newInstance((int)amLibRoleInfo.getMemory(), (int)(amLibRoleInfo.getVCore() / 100)));
                Container recoverContainer = Container.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)this.role2ContainerIndex(roleName)), (NodeId)NodeId.newInstance((String)"", (int)0), (String)"", (Resource)Resource.newInstance((int)amLibRoleInfo.getMemory(), (int)amLibRoleInfo.getVCore()), (Priority)Priority.newInstance((int)1), null);
                String tuboHostName = amLibRoleInfo.getAssignMachine();
                recoverContainer.setNodeId(NodeId.newInstance((String)tuboHostName, (int)0));
                recoverContainer.setNodeHttpAddress(tuboHostName + ":7788");
                this.historyContainerIndexRoleMap.put(this.role2ContainerIndex(roleName), roleName);
                this.roleToRequestKey.put(roleName, requestKey);
                this.roleToResource.put(roleName, recoverContainer);
                this.containerIdToHost.put(recoverContainer.getId(), tuboHostName);
                if (this.role2ContainerIndex(roleName) > currentContainerId.get()) {
                    currentContainerId.set(this.role2ContainerIndex(roleName) + 1L);
                }
                containersFromPreviousAttempt.add(recoverContainer);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"ContainersFromPreviousAttemptAmLib fail", (Throwable)e);
            throw new IOException("ContainersFromPreviousAttemptAmLib fail", e);
        }
        ArrayList nmTokensFromPreviousAttempts = new ArrayList();
        return RegisterApplicationMasterResponse.newInstance((Resource)Resource.newInstance((int)1024, (int)1), (Resource)Resource.newInstance((int)40960, (int)100), acls, (ByteBuffer)key, containersFromPreviousAttempt, (String)"default", nmTokensFromPreviousAttempts);
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest re) throws YarnException, IOException {
        WorkItemProgress progress;
        LOG.info((Object)("finishApplicationMasterRequest:" + re.toString()));
        FinalApplicationStatus appStatus = re.getFinalApplicationStatus();
        switch (appStatus) {
            case SUCCEEDED: {
                progress = WorkItemProgress.WIP_TERMINATING;
                break;
            }
            case FAILED: {
                progress = WorkItemProgress.WIP_FAILED;
                break;
            }
            case KILLED: {
                progress = WorkItemProgress.WIP_FAILED;
                break;
            }
            case UNDEFINED: {
                progress = WorkItemProgress.WIP_FAILED;
                break;
            }
            default: {
                progress = WorkItemProgress.WIP_FAILED;
            }
        }
        LOG.info((Object)("finishApplicationMaster progress:" + progress));
        YarnServiceProtos.FinishApplicationMasterRequestProto proto = ((FinishApplicationMasterRequestPBImpl)re).getProto();
        String finishApplicationMasterRequestProtoPb = Base64.encodeBase64String((byte[])proto.toByteArray());
        try {
            RuntimeContext.get().reportApplicationMasterFinishStatus(progress.value(), finishApplicationMasterRequestProtoPb);
        }
        catch (Exception e) {
            LOG.error((Object)"RuntimeContext Report AppMaster Final Status Fail", (Throwable)e);
            throw new IOException(e);
        }
        return FinishApplicationMasterResponse.newInstance((boolean)true);
    }

    public static void sumMap(HashMap<String, Integer> result, HashMap<String, Integer> toMerge) {
        for (String key : toMerge.keySet()) {
            Integer left = result.get(key);
            if (left != null) {
                result.put(key, left + toMerge.get(key));
                continue;
            }
            result.put(key, toMerge.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processFinishedWorker(String role, String diagnostics, int exitCode) {
        if (this.roleToResource.containsKey(role)) {
            Container container = this.roleToResource.get(role);
            org.apache.hadoop.yarn.api.records.ContainerStatus status = org.apache.hadoop.yarn.api.records.ContainerStatus.newInstance((ContainerId)container.getId(), (ContainerState)ContainerState.COMPLETE, (String)container.getNodeId().getHost(), (int)exitCode);
            Object object = this.finishedContainers;
            synchronized (object) {
                if (this.finishedContainers.containsKey(role)) {
                    LOG.warn((Object)("worker has already been finished, just ignore it. role: " + role));
                    return;
                }
                this.finishedContainers.put(role, status);
                try {
                    this.jobStatusUpdateClient.updateWorkerFinishInfo(role, System.currentTimeMillis() / 1000L);
                    this.amLib.removeRole(role);
                }
                catch (IOException e) {
                    LOG.error((Object)"amlib remove role fail", (Throwable)e);
                }
                LOG.info((Object)("Removed: " + role));
            }
            object = this.justFinishedContainers;
            synchronized (object) {
                this.justFinishedContainers.add(status);
            }
            this.containerIdToHost.remove(container.getId());
        } else {
            LOG.warn((Object)("unknown role name to process, just ignore it. role: " + role));
        }
    }

    static {
        ContainerId containerId = ContainerId.fromString((String)System.getenv(ApplicationConstants.Environment.CONTAINER_ID.name()));
        appAttemptId = containerId.getApplicationAttemptId();
    }

    class RpcEventHandlerCallback
    extends RpcHandlerCallback {
        RpcEventHandlerCallback() {
        }

        public int handle(RpcRequest request, StringBuffer result) {
            if ("report_worker_finish".equals(request.getMethod())) {
                String param = request.getParameter();
                LOG.info((Object)("Got report_worker_finish request to process, parameter: " + param + ", remote address: " + request.getRemoteAddress()));
                Gson gson = new Gson();
                Map jsonMap = (Map)gson.fromJson(param, new TypeToken<Map<String, Object>>(){}.getType());
                String workerName = (String)jsonMap.get("workerName");
                int exitCode = Integer.parseInt((String)jsonMap.get("exitCode"));
                String finishMessage = (String)jsonMap.get("finishMessage");
                WorkerId id = WorkerId.fromString((String)workerName);
                ApplicationMasterAdapter.this.processFinishedWorker(id.roleName, finishMessage, exitCode);
                result.append("OK");
            } else if ("get_track_url".equals(request.getMethod())) {
                result.append(ApplicationMasterAdapter.this.trackUrl);
            } else {
                LOG.warn((Object)("unknown method to handle: " + request.getMethod()));
                result.append("unknown method to handle: " + request.getMethod());
                return 0;
            }
            return 1;
        }
    }

    class DisableOldAppMasterEventInfoCallback
    extends EventCallback {
        DisableOldAppMasterEventInfoCallback() {
        }

        public void handle(EventInfo eventInfo) {
            LOG.info((Object)("DisableOldAppMasterEventInfoCallback handle eventInfo: " + eventInfo));
        }
    }

    class FmHeartbeatTimeoutEventInfoCallback
    extends EventCallback {
        FmHeartbeatTimeoutEventInfoCallback() {
        }

        public void handle(EventInfo eventInfo) {
            LOG.info((Object)("FmHeartbeatTimeoutEventInfoCallback handle eventInfo: " + eventInfo));
        }
    }

    class WorkerFailureEventCallback
    extends EventCallback {
        WorkerFailureEventCallback() {
        }

        public void handle(EventInfo eventInfo) {
            String role;
            WorkerId workerId;
            String workerName;
            LOG.info((Object)("WorkerFailureEventCallback handle eventInfo: " + eventInfo));
            WorkerFailureEventInfo failEvents = (WorkerFailureEventInfo)eventInfo;
            for (WorkerFailureEntry workerFailureEntry : failEvents.getCrashedList()) {
                workerName = workerFailureEntry.getWorkerName();
                workerId = WorkerId.fromString((String)workerName);
                role = workerId.roleName;
                ApplicationMasterAdapter.this.processFinishedWorker(role, workerFailureEntry.getExtraMsg(), workerFailureEntry.getErrorCode());
            }
            for (WorkerFailureEntry workerFailureEntry : failEvents.getKilledByTuboList()) {
                workerName = workerFailureEntry.getWorkerName();
                workerId = WorkerId.fromString((String)workerName);
                role = workerId.roleName;
                ApplicationMasterAdapter.this.processFinishedWorker(role, workerFailureEntry.getExtraMsg(), workerFailureEntry.getErrorCode());
            }
            for (Map.Entry entry : failEvents.getKilledOverUsedList().entrySet()) {
                workerName = (String)entry.getKey();
                OverUsedWorkItem item = (OverUsedWorkItem)entry.getValue();
                WorkerId workerId2 = WorkerId.fromString((String)workerName);
                String role2 = workerId2.roleName;
                ApplicationMasterAdapter.this.processFinishedWorker(role2, item.toString(), -103);
            }
        }
    }

    class SendWorkerListResponseEventCallback
    extends EventCallback {
        SendWorkerListResponseEventCallback() {
        }

        public void handle(EventInfo eventInfo) {
            LOG.info((Object)("SendWorkerListResponseEventCallback handle eventInfo: " + eventInfo));
            SendWorkerListResponseEventInfo sinfo = (SendWorkerListResponseEventInfo)eventInfo;
            ArrayList stopWorkers = sinfo.getStopWorkerList();
            for (String id : stopWorkers) {
                WorkerId wid = WorkerId.fromString((String)id);
                ApplicationMasterAdapter.this.processFinishedWorker(wid.roleName, "SendWorkerListResponse", 0);
            }
        }
    }

    class AssignedResourceChangeEventCallback
    extends EventCallback {
        AssignedResourceChangeEventCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(EventInfo event) {
            AssignedResourceChangeEventInfo resChangeEventInfo = (AssignedResourceChangeEventInfo)event;
            HashMap newAssign = resChangeEventInfo.getAssignment();
            LOG.info((Object)("AssignedResourceChangeEventCallback with roles: " + StringUtils.join((CharSequence)"|", newAssign.keySet())));
            Map<String, HashMap<String, Integer>> map = assign;
            synchronized (map) {
                for (String role : newAssign.keySet()) {
                    HashMap changes = (HashMap)newAssign.get(role);
                    if (changes.size() == 0) {
                        LOG.warn((Object)("assign for role " + role + " is empty"));
                        continue;
                    }
                    boolean isFinish = false;
                    for (Map.Entry entry : changes.entrySet()) {
                        if ((Integer)entry.getValue() >= 0) continue;
                        LOG.warn((Object)("resource recycled by fuxi master, role: " + role + ", tubo host: " + (String)entry.getKey() + ", remove it, assign: " + changes));
                        ApplicationMasterAdapter.this.processFinishedWorker(role, "resource recycled by FuxiMaster", 0);
                        if (assign.containsKey(role)) {
                            assign.remove(role);
                        }
                        isFinish = true;
                        break;
                    }
                    if (isFinish) continue;
                    LOG.info((Object)("New container allocated, role: " + role + ", assign: " + changes));
                    if (assign.get(role) == null) {
                        assign.put(role, new HashMap());
                    }
                    ApplicationMasterAdapter.sumMap(assign.get(role), changes);
                }
            }
        }
    }

    private static class RequestKey {
        private Priority priority;
        private String resourceName;
        private Resource capability;

        public RequestKey(String resourceName, Priority priority, Resource capability) {
            this.resourceName = resourceName;
            this.priority = priority;
            this.capability = capability;
        }

        public RequestKey(ResourceRequest rr) {
            this(rr.getResourceName(), rr.getPriority(), rr.getCapability());
        }

        public static RequestKey getKey(ResourceRequest rr) {
            return new RequestKey(rr);
        }

        public Priority getPriority() {
            return this.priority;
        }

        public Resource getCapability() {
            return this.capability;
        }

        public String getResourceName() {
            return this.resourceName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RequestKey)) {
                return false;
            }
            RequestKey that = (RequestKey)o;
            if (!this.getPriority().equals((Object)that.getPriority())) {
                return false;
            }
            if (!this.getResourceName().equals(that.getResourceName())) {
                return false;
            }
            return this.getCapability().equals((Object)that.getCapability());
        }

        public int hashCode() {
            int result = this.getPriority().hashCode();
            result = 31 * result + this.getResourceName().hashCode();
            result = 31 * result + this.getCapability().hashCode();
            return result;
        }
    }

    private static class ApplicationMasterAdapterHolder {
        private static final ApplicationMasterAdapter INSTANCE = new ApplicationMasterAdapter();

        private ApplicationMasterAdapterHolder() {
        }
    }
}

